/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.isqlviewer.swing.AbstractItemAction;
import org.isqlviewer.swing.ActionManager;

public abstract class ActionMenuBar
extends JMenuBar {
    protected ActionManager manager;

    public ActionMenuBar(ActionManager manager) {
        this.manager = manager;
        this.configureMenu();
    }

    public void addMenuItem(JMenu menu, Action action) {
        if (action == null) {
            return;
        }
        JMenuItem menuItem = menu.add(action);
        this.configureMenuItem(menuItem, action);
    }

    public void addMenuItem(JPopupMenu menu, Action action) {
        JMenuItem menuItem = menu.add(action);
        this.configureMenuItem(menuItem, action);
    }

    protected abstract void configureMenu();

    protected ActionManager getManager() {
        return this.manager;
    }

    protected JMenu createMenu(String name, char mnemonic) {
        JMenu menu = new JMenu(name);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    protected void addCheckBoxMenuItem(JMenu menu, AbstractItemAction a) {
        this.addCheckBoxMenuItem(menu, a, false);
    }

    protected void addCheckBoxMenuItem(JMenu menu, AbstractItemAction a, boolean selected) {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(a);
        mi.setSelected(selected);
        menu.add(mi);
        this.configureMenuItem(mi, a);
        mi.addItemListener(a);
        mi.setIcon(null);
    }

    protected void addRadioButtonMenuItem(JMenu menu, ButtonGroup group, Action a) {
        this.addRadioButtonMenuItem(menu, group, a, false);
    }

    protected void addRadioButtonMenuItem(JMenu menu, ButtonGroup group, Action a, boolean selected) {
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem(a);
        mi.setSelected(selected);
        menu.add(mi);
        group.add(mi);
        this.configureMenuItem(mi, a);
        mi.setIcon(null);
    }

    protected void configureMenuItem(JMenuItem menuItem, Action action) {
        try {
            KeyStroke ks = (KeyStroke)action.getValue("AcceleratorKey");
            menuItem.setAccelerator(ks);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            menuItem.setName((String)action.getValue("Name"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

