/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.isqlviewer.util.BasicUtilities;

public class ByteArrayClob
implements Clob {
    protected StringWriter clobStorage = new StringWriter();
    protected StringBuffer buff = new StringBuffer("");

    public ByteArrayClob(String clobData) throws IOException {
        this(clobData.toCharArray());
    }

    public ByteArrayClob(char[] clobData) throws IOException {
        this.clobStorage.write(clobData);
        this.buff = this.clobStorage.getBuffer();
    }

    public ByteArrayClob(Reader reader) throws IOException {
        BasicUtilities.copyReader(reader, this.clobStorage);
        this.buff = this.clobStorage.getBuffer();
    }

    public long length() {
        return this.buff.length();
    }

    public String getSubString(long pos, int length) {
        return this.buff.substring((int)pos, (int)pos + length);
    }

    public Reader getCharacterStream() {
        return new InputStreamReader(this.getAsciiStream());
    }

    public InputStream getAsciiStream() {
        String buffer = this.buff.toString();
        return new ByteArrayInputStream(buffer.getBytes());
    }

    public long position(String searchstr, long start) {
        String x = this.clobStorage.toString();
        return x.indexOf(searchstr, (int)start);
    }

    public long position(Clob searchstr, long start) {
        return 0L;
    }

    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.buff.insert((int)pos, str.toCharArray(), offset, len);
        return len;
    }

    public OutputStream setAsciiStream(long pos) {
        return new ByteArrayOutputStream();
    }

    public Writer setCharacterStream(long pos) {
        return new StringWriter();
    }

    public void truncate(long len) throws SQLException {
        this.buff.setLength((int)len);
    }
}

