/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.renderers;

import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.renderers.AbstractDataRenderer;
import org.isqlviewer.util.BasicUtilities;

public class TextRenderer
extends AbstractDataRenderer {
    public String getName() {
        return BasicUtilities.getString("TxtViewer_Name");
    }

    public String getDescription() {
        return BasicUtilities.getString("TxtViewer_Desc");
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Html16");
    }

    public boolean isPrintable(JComponent view) {
        return false;
    }

    public JComponent getDataRenderer() {
        JEditorPane view = new JEditorPane();
        view.setDragEnabled(true);
        view.setEditable(false);
        view.setFont(SystemConfig.getInstance().getPreferences().getFont("editor.font"));
        BasicUtilities.localizeTextComponent(view, null);
        return view;
    }

    public Runnable renderContent(Object content, JComponent view) throws IllegalArgumentException {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        return new TextRendererProcess((JEditorPane)view, content);
    }

    public InputStream getBinaryStream(JComponent view) {
        JEditorPane txt = (JEditorPane)view;
        return new ByteArrayInputStream(txt.getText().getBytes());
    }

    private static class TextRendererProcess
    implements Runnable {
        private JEditorPane view = null;
        private Object data = null;

        public TextRendererProcess(JEditorPane componentView, Object content) {
            this.view = componentView;
            this.data = content;
        }

        public void run() {
            if (this.data == null || this.view == null) {
                return;
            }
            try {
                if (this.data instanceof String) {
                    String txt = (String)this.data;
                    this.view.setText(txt);
                } else if (this.data instanceof Clob) {
                    Clob c = (Clob)this.data;
                    long length = c.length();
                    String txt = null;
                    if (length > Integer.MAX_VALUE) {
                        System.out.println(BasicUtilities.getString("Clob_TooLarge"));
                        txt = c.getSubString(0L, 0x7FFFFFFE);
                    } else if (length < 0L) {
                        System.out.println(BasicUtilities.getString("Clob_LengthError"));
                        ByteArrayOutputStream out = new ByteArrayOutputStream(1);
                        InputStream in = c.getAsciiStream();
                        BasicUtilities.copyStream(in, out);
                        txt = out.toString();
                        in.close();
                        out.reset();
                        out.close();
                    } else {
                        txt = c.getSubString(0L, (int)length);
                    }
                    this.view.setText(txt);
                } else if (this.data instanceof Blob) {
                    Blob b = (Blob)this.data;
                    String txt = null;
                    long length = b.length();
                    if (length > Integer.MAX_VALUE) {
                        System.out.println(BasicUtilities.getString("Blob_TooLarge"));
                        txt = new String(b.getBytes(0L, 0x7FFFFFFE));
                    } else if (length < 0L) {
                        System.out.println(BasicUtilities.getString("Blob_LengthError"));
                        ByteArrayOutputStream out = new ByteArrayOutputStream(1);
                        InputStream in = b.getBinaryStream();
                        BasicUtilities.copyStream(in, out);
                        txt = new String(out.toByteArray());
                        in.close();
                        out.reset();
                        out.close();
                    } else {
                        txt = new String(b.getBytes(0L, (int)length));
                    }
                    this.view.setText(txt);
                } else {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
                    XMLEncoder enc = new XMLEncoder(bos);
                    enc.writeObject(this.data);
                    enc.flush();
                    bos.flush();
                    this.view.setText(new String(bos.toByteArray()));
                    enc.close();
                    bos.close();
                }
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "TextRenderer::run()");
            }
            this.updateContentType();
        }

        private void updateContentType() {
            String txt = this.view.getText();
            if (txt.regionMatches(true, 0, "<html>", 0, 6)) {
                this.view.setContentType("text/html");
            } else {
                this.view.setContentType("text/plain");
            }
        }
    }
}

