/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.renderers;

import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.isqlviewer.core.renderers.AbstractDataRenderer;
import org.isqlviewer.util.BasicUtilities;

public class ImageRenderer
extends AbstractDataRenderer {
    private static final String RAW_IMAGE_PROPERTY = "RAW_IMAGE";

    public Object getPrintableData(JComponent view) {
        return (ImageIcon)((JLabel)view).getIcon();
    }

    public JComponent getDataRenderer() {
        return new JLabel();
    }

    public Runnable renderContent(Object content, JComponent view) throws IllegalArgumentException {
        if (content == null || !(content instanceof String) && !(content instanceof Clob) && !(content instanceof Blob)) {
            throw new IllegalArgumentException();
        }
        return new ImageRendererProcess((JLabel)view, content);
    }

    public String getName() {
        return BasicUtilities.getString("ImgViewer_Name");
    }

    public String getDescription() {
        return BasicUtilities.getString("ImgViewer_Desc");
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Image16");
    }

    public boolean isPrintable(JComponent view) {
        return ((JLabel)view).getIcon() != null;
    }

    public InputStream getBinaryStream(JComponent view) {
        byte[] src = (byte[])((JLabel)view).getClientProperty(RAW_IMAGE_PROPERTY);
        if (src == null) {
            src = new byte[]{};
        }
        return new ByteArrayInputStream(src);
    }

    private static class ImageRendererProcess
    implements Runnable {
        private JLabel imageView = null;
        private Object data = null;

        public ImageRendererProcess(JLabel componentView, Object content) {
            this.imageView = componentView;
            this.data = content;
        }

        public void run() {
            byte[] image = null;
            if (this.data == null) {
                return;
            }
            try {
                ImageIcon ico = null;
                if (this.data instanceof String) {
                    String txt = (String)this.data;
                    image = txt.getBytes();
                    ico = new ImageIcon(image);
                    ico.setDescription("TEXT (" + ico.getIconWidth() + "x" + ico.getIconHeight() + ")");
                } else if (this.data instanceof Blob) {
                    Blob b = (Blob)this.data;
                    long length = b.length();
                    if (length > Integer.MAX_VALUE) {
                        System.out.println(BasicUtilities.getString("Blob_TooLarge"));
                        image = b.getBytes(0L, 0x7FFFFFFE);
                    } else if (length < 0L) {
                        System.out.println(BasicUtilities.getString("Blob_LengthError"));
                        ByteArrayOutputStream out = new ByteArrayOutputStream(1);
                        InputStream in = b.getBinaryStream();
                        BasicUtilities.copyStream(in, out);
                        image = out.toByteArray();
                        in.close();
                        out.reset();
                        out.close();
                    } else {
                        image = b.getBytes(0L, (int)length);
                    }
                    ico = new ImageIcon(image);
                    ico.setDescription("BLOB (" + ico.getIconWidth() + "x" + ico.getIconHeight() + ")");
                } else if (this.data instanceof Clob) {
                    Clob c = (Clob)this.data;
                    long length = c.length();
                    if (length > Integer.MAX_VALUE) {
                        System.out.println(BasicUtilities.getString("Clob_TooLarge"));
                        image = c.getSubString(0L, 0x7FFFFFFE).getBytes();
                    } else if (length < 0L) {
                        System.out.println(BasicUtilities.getString("Clob_LengthError"));
                        ByteArrayOutputStream out = new ByteArrayOutputStream(1);
                        InputStream in = c.getAsciiStream();
                        BasicUtilities.copyStream(in, out);
                        image = out.toByteArray();
                        in.close();
                        out.reset();
                        out.close();
                    } else {
                        image = c.getSubString(0L, (int)length).getBytes();
                    }
                    ico = new ImageIcon(image);
                    ico.setDescription("CLOB (" + ico.getIconWidth() + "x" + ico.getIconHeight() + ")");
                }
                this.imageView.setIcon(ico);
                this.imageView.putClientProperty(ImageRenderer.RAW_IMAGE_PROPERTY, image);
                this.imageView.setText(null);
                this.imageView.setToolTipText(ico.getDescription());
                this.imageView.setHorizontalAlignment(0);
                this.imageView.setPreferredSize(new Dimension(ico.getIconWidth(), ico.getIconHeight()));
            }
            finally {
                return;
            }
        }
    }
}

