/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.renderers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Date;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.isqlviewer.core.model.HexViewTableModel;
import org.isqlviewer.core.renderers.AbstractDataRenderer;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.util.BasicUtilities;

public class BinaryRenderer
extends AbstractDataRenderer {
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;

    public Object getPrintableData(JComponent view) {
        ITable copy = new ITable();
        HexTableCellRenderer cellRenderer = new HexTableCellRenderer();
        copy.setDefaultRenderer(class$java$lang$Number == null ? (class$java$lang$Number = BinaryRenderer.class$("java.lang.Number")) : class$java$lang$Number, cellRenderer);
        copy.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = BinaryRenderer.class$("java.lang.String")) : class$java$lang$String, cellRenderer);
        HexViewTableModel mdl = ((RendererView)view).mdlHexView;
        copy.setModel(mdl);
        return copy;
    }

    public Runnable renderContent(Object content, JComponent view) throws IllegalArgumentException {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        return new BinaryRendererProcess((RendererView)view, content);
    }

    public JComponent getDataRenderer() {
        return new RendererView();
    }

    public String getName() {
        return BasicUtilities.getString("HexViewer_Name");
    }

    public String getDescription() {
        return BasicUtilities.getString("HexViewer_Desc");
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Csv16");
    }

    public boolean isPrintable(JComponent view) {
        HexViewTableModel mdl = ((RendererView)view).mdlHexView;
        return mdl.toString().length() >= 1;
    }

    public InputStream getBinaryStream(JComponent view) {
        HexViewTableModel mdl = ((RendererView)view).mdlHexView;
        return new ByteArrayInputStream(mdl.toString().getBytes());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class HexTableCellRenderer
    extends DefaultTableCellRenderer {
        Font fnt = new Font("Monospaced", 0, 9);

        public HexTableCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable src, Object o, boolean sel, boolean f, int r, int c) {
            try {
                super.getTableCellRendererComponent(src, o, sel, f, r, c);
                this.setFont(this.fnt);
                if (o instanceof Number) {
                    try {
                        String txt = Integer.toHexString(((Number)o).intValue()).toUpperCase();
                        if (txt.length() == 1) {
                            txt = "0".concat(txt);
                        }
                        this.setText(txt);
                    }
                    catch (Throwable t) {}
                } else {
                    String s = c == src.getColumnCount() - 1 ? (String)o : ((String)o).toUpperCase();
                    this.setText(s);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            return this;
        }
    }

    private static class BinaryRendererProcess
    implements Runnable {
        private RendererView view = null;
        private HexViewTableModel mdl = null;
        private Object data = null;

        public BinaryRendererProcess(RendererView view, Object content) {
            this.mdl = view.mdlHexView;
            this.view = view;
            this.data = content;
        }

        public void run() {
            if (this.data == null || this.mdl == null) {
                return;
            }
            try {
                if (this.data instanceof String) {
                    this.view.original = (String)this.data;
                    this.mdl.setData(this.view.original, "UTF8");
                } else if (this.data instanceof Clob) {
                    Clob c = (Clob)this.data;
                    long length = c.length();
                    if (length > Integer.MAX_VALUE) {
                        System.out.println(BasicUtilities.getString("Clob_TooLarge"));
                        this.view.original = c.getSubString(0L, 0x7FFFFFFE);
                    } else if (length < 0L) {
                        System.out.println(BasicUtilities.getString("Clob_LengthError"));
                        ByteArrayOutputStream out = new ByteArrayOutputStream(1);
                        InputStream in = c.getAsciiStream();
                        BasicUtilities.copyStream(in, out);
                        this.view.original = out.toString();
                        in.close();
                        out.reset();
                        out.close();
                    } else {
                        this.view.original = c.getSubString(0L, (int)length);
                    }
                    this.mdl.setData(this.view.original, "UTF8");
                } else if (this.data instanceof Blob) {
                    Blob b = (Blob)this.data;
                    long length = b.length();
                    if (length > Integer.MAX_VALUE) {
                        System.out.println(BasicUtilities.getString("Blob_TooLarge"));
                        this.mdl.setData(b.getBytes(0L, 0x7FFFFFFE));
                    } else if (length < 0L) {
                        System.out.println(BasicUtilities.getString("Blob_LengthError"));
                        ByteArrayOutputStream out = new ByteArrayOutputStream(1);
                        InputStream in = b.getBinaryStream();
                        BasicUtilities.copyStream(in, out);
                        this.mdl.setData(out.toByteArray());
                        in.close();
                        out.reset();
                        out.close();
                    } else {
                        this.mdl.setData(b.getBytes(0L, (int)length));
                    }
                    this.view.original = this.mdl.toString();
                } else if (this.data instanceof Double) {
                    this.mdl.setData(HexViewTableModel.getDoubleBytes((Double)this.data));
                    this.view.original = this.mdl.toString();
                } else if (this.data instanceof Float) {
                    this.mdl.setData(HexViewTableModel.getFloatBytes((Float)this.data));
                    this.view.original = this.mdl.toString();
                } else if (this.data instanceof Long) {
                    this.mdl.setData(HexViewTableModel.getLongBytes((Long)this.data));
                    this.view.original = this.mdl.toString();
                } else if (this.data instanceof Integer) {
                    this.mdl.setData(HexViewTableModel.getIntBytes((Integer)this.data));
                    this.view.original = this.mdl.toString();
                } else if (this.data instanceof Short) {
                    this.mdl.setData(HexViewTableModel.getShortBytes((Short)this.data));
                } else if (this.data instanceof Date) {
                    this.mdl.setData(HexViewTableModel.getLongBytes(new Long(((Date)this.data).getTime())));
                    this.view.original = this.mdl.toString();
                } else {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
                    XMLEncoder enc = new XMLEncoder(bos);
                    enc.writeObject(this.data);
                    enc.flush();
                    bos.flush();
                    this.mdl.setData(bos.toByteArray());
                    this.view.original = this.mdl.toString();
                    enc.close();
                    bos.close();
                }
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "BinaryRendererProcess::run()");
                return;
            }
        }
    }

    private static class RendererView
    extends JPanel
    implements ActionListener {
        private HexViewTableModel mdlHexView = new HexViewTableModel("");
        private ITable tabHexView = new ITable(this.mdlHexView);
        private JComboBox cmbCharsets = new JComboBox<Object>(Charset.availableCharsets().keySet().toArray());
        private String original = null;

        public void actionPerformed(ActionEvent e) {
            try {
                this.mdlHexView.setData(this.original, this.cmbCharsets.getSelectedItem().toString());
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
            }
        }

        public RendererView() {
            try {
                this.initUI();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
            }
        }

        private void initUI() {
            this.setLayout(new BorderLayout());
            this.cmbCharsets.setSelectedItem(Charset.forName("UTF8").name());
            this.cmbCharsets.addActionListener(this);
            this.cmbCharsets.setMaximumRowCount(6);
            this.cmbCharsets.setLightWeightPopupEnabled(true);
            JPanel pnl = new JPanel(new GridLayout(1, 3));
            JLabel label = new JLabel(BasicUtilities.getString("Apply_Encoding"), 4);
            pnl.add(Box.createHorizontalGlue());
            pnl.add(label);
            pnl.add(this.cmbCharsets);
            this.add((Component)pnl, "North");
            this.add((Component)new JScrollPane(this.tabHexView), "Center");
            this.tabHexView.getTableHeader().setReorderingAllowed(false);
            this.tabHexView.getTableHeader().setResizingAllowed(true);
            HexTableCellRenderer cellRenderer = new HexTableCellRenderer();
            this.tabHexView.setDefaultRenderer(class$java$lang$Number == null ? (class$java$lang$Number = BinaryRenderer.class$("java.lang.Number")) : class$java$lang$Number, cellRenderer);
            this.tabHexView.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = BinaryRenderer.class$("java.lang.String")) : class$java$lang$String, cellRenderer);
        }
    }
}

