/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.HistoryItem;
import org.isqlviewer.core.HistoryManager;
import org.isqlviewer.core.model.AbstractTreeModel;

public class HistoryTreeModel
extends AbstractTreeModel
implements ChangeListener {
    private final Object ROOT = new Object();
    private Calendar calendar = Calendar.getInstance();
    private HashMap dayMapper = new HashMap();
    private ArrayList keyList = null;
    private HistoryManager mgrHistory = null;

    public HistoryTreeModel(HistoryManager mgr) {
        this.mgrHistory = mgr;
        this.mgrHistory.addChangeListener(this);
        this.reload();
    }

    public void reload() {
        this.setData(this.mgrHistory.getHistory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Cloneable cloneable;
        if (this.keyList != null) {
            cloneable = this.keyList;
            synchronized (cloneable) {
                this.keyList.clear();
            }
        }
        if (this.dayMapper != null) {
            cloneable = this.dayMapper;
            synchronized (cloneable) {
                this.dayMapper.clear();
            }
        }
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}, null, null));
    }

    public void setData(Collection items) {
        this.clear();
        if (items == null) {
            return;
        }
        Iterator itr = items.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof HistoryItem) || o == null) continue;
            HistoryItem hi = (HistoryItem)o;
            this.addHistoryItem(hi);
        }
        if (this.keyList != null) {
            Object[] arr = this.keyList.toArray();
            Arrays.sort(arr);
            this.keyList = new ArrayList<Object>(Arrays.asList(arr));
        }
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}, null, null));
    }

    public Object getRoot() {
        return this.ROOT;
    }

    public Object getChild(Object parent, int index) {
        if (parent == this.ROOT) {
            index = this.keyList.size() - 1 - index;
            return this.keyList.get(index);
        }
        ArrayList lst = (ArrayList)this.dayMapper.get(parent);
        return lst.get(index);
    }

    public int getChildCount(Object parent) {
        if (parent == this.ROOT) {
            return this.dayMapper.size();
        }
        ArrayList lst = (ArrayList)this.dayMapper.get(parent);
        if (lst == null) {
            return 0;
        }
        return lst.size();
    }

    public boolean isLeaf(Object node) {
        return node instanceof HistoryItem;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.ROOT) {
            int idx = this.keyList.indexOf(child);
            return this.keyList.size() - 1 - idx;
        }
        ArrayList lst = (ArrayList)this.dayMapper.get(parent);
        return lst.indexOf(child);
    }

    public void stateChanged(ChangeEvent event) {
        this.reload();
    }

    private boolean containsDayKey(Date dte) {
        if (this.dayMapper.isEmpty()) {
            return false;
        }
        Iterator itr = this.dayMapper.keySet().iterator();
        while (itr.hasNext()) {
            Date key = (Date)itr.next();
            this.calendar.setTime(key);
            int kDOY = this.calendar.get(6);
            this.calendar.setTime(dte);
            int dDOY = this.calendar.get(6);
            if (dDOY != kDOY) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDayBranch(Date day) {
        this.calendar.setTime(day);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        HashMap hashMap = this.dayMapper;
        synchronized (hashMap) {
            this.dayMapper.put(this.calendar.getTime(), new ArrayList());
            this.keyList = new ArrayList(this.dayMapper.keySet());
        }
    }

    private ArrayList getDayBrach(Date day) {
        this.calendar.setTime(day);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        return (ArrayList)this.dayMapper.get(this.calendar.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHistoryItem(HistoryItem item) {
        ArrayList lst;
        Date ts = item.getTimeStamp();
        if (!this.containsDayKey(ts)) {
            this.addDayBranch(ts);
        }
        ArrayList arrayList = lst = this.getDayBrach(ts);
        synchronized (arrayList) {
            lst.add(item);
        }
    }

    protected void finalize() throws Throwable {
        this.mgrHistory.removeChangeListener(this);
        super.finalize();
    }
}

