/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.io.UnsupportedEncodingException;
import javax.swing.table.AbstractTableModel;
import org.isqlviewer.util.BasicUtilities;

public class HexViewTableModel
extends AbstractTableModel {
    StringBuffer s = new StringBuffer("");
    Integer[][] data;
    String[] rowString;
    String byterefs;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static byte[] getLongBytes(Long l) {
        long data = l;
        byte[] buf = new byte[]{(byte)(data >>> 56), (byte)(data >>> 48), (byte)(data >>> 40), (byte)(data >>> 32), (byte)(data >>> 24), (byte)(data >>> 16), (byte)(data >>> 8), (byte)(data >>> 0)};
        return buf;
    }

    public static byte[] getShortBytes(Short s) {
        short data = s;
        byte[] buf = new byte[]{(byte)(data >>> 8), (byte)(data >>> 0)};
        return buf;
    }

    public static byte[] getBooleanBytes(Boolean b) {
        return new byte[]{b != false ? (byte)1 : 0};
    }

    public static byte[] getDoubleBytes(Double d) {
        return HexViewTableModel.getLongBytes(new Long(Double.doubleToRawLongBits(d)));
    }

    public static byte[] getFloatBytes(Float f) {
        return HexViewTableModel.getIntBytes(new Integer(Float.floatToIntBits(f.floatValue())));
    }

    public static byte[] getIntBytes(Integer i) {
        int data = i;
        byte[] buf = new byte[]{(byte)(data >>> 24), (byte)(data >>> 16), (byte)(data >>> 8), (byte)(data >>> 0)};
        return buf;
    }

    public HexViewTableModel(String s) {
        this(s.getBytes());
    }

    public void setData(String s) {
        this.setData(s, null);
    }

    public void setData(String s, String encoding) {
        if (encoding != null) {
            try {
                this.setData(s.getBytes(encoding));
            }
            catch (UnsupportedEncodingException e) {
                BasicUtilities.HandleException(e);
            }
        } else {
            this.setData(s.getBytes());
        }
    }

    public void clear() {
        this.setData("");
    }

    public void setData(byte[] data) {
        if (data.length == 0) {
            this.data = new Integer[0][0];
            this.byterefs = new String("");
            this.rowString = new String[0];
            return;
        }
        this.data = new Integer[data.length / 16 + 1][16];
        this.byterefs = new String(data);
        this.rowString = new String[this.getRowCount()];
        try {
            int max = this.getRowCount() == 1 ? data.length : 16;
            for (int r = 0; r < this.getRowCount(); ++r) {
                this.s.setLength(0);
                for (int c = 0; c < max; ++c) {
                    int b;
                    if (r == 0) {
                        b = data[(r == 0 ? 0 : r + 1) * c + c];
                    } else {
                        try {
                            b = data[r * 16 + c];
                        }
                        catch (Exception e) {
                            b = 0;
                        }
                    }
                    if (b < 32 || b > 127) {
                        this.s.append('.');
                    } else {
                        this.s.append((char)b);
                    }
                    this.s.append(' ');
                    this.data[r][c] = new Integer(b & 0xFF);
                }
                this.rowString[r] = this.s.toString().trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireTableDataChanged();
    }

    public HexViewTableModel(byte[] data) {
        this.setData(data);
    }

    public int getColumnCount() {
        return 19;
    }

    public String toString() {
        return this.byterefs;
    }

    public Object getValueAt(int parm1, int parm2) {
        if (parm2 == 18) {
            return this.rowString[parm1];
        }
        if (parm2 == 0) {
            this.s.setLength(0);
            this.s.replace(0, 7, "00000000");
            String x = Integer.toHexString(parm1 * 16);
            this.s.replace(this.s.length() - 1 - x.length(), 8, x);
            return this.s.toString().toUpperCase();
        }
        if (parm2 == 9) {
            return "-";
        }
        if (--parm2 > 8) {
            --parm2;
        }
        return this.data[parm1][parm2];
    }

    public int getRowCount() {
        return this.data.length;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 18) {
            return "Data";
        }
        if (columnIndex == 0) {
            return "Offset";
        }
        if (columnIndex == 9) {
            return " - ";
        }
        if (--columnIndex > 8) {
            --columnIndex;
        }
        return "" + columnIndex;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 9 || columnIndex == 18 || columnIndex == 0) {
            return class$java$lang$String == null ? (class$java$lang$String = HexViewTableModel.class$("java.lang.String")) : class$java$lang$String;
        }
        return class$java$lang$Integer == null ? (class$java$lang$Integer = HexViewTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

