/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.RowComparator;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.Sortable;
import org.isqlviewer.util.UserPreferences;

public class EnhancedTableModel
implements Cloneable,
Sortable,
TableModel,
Transferable {
    public static final DataFlavor FLAVOR_OBJECT = new DataFlavor(class$org$isqlviewer$core$model$EnhancedTableModel == null ? (class$org$isqlviewer$core$model$EnhancedTableModel = EnhancedTableModel.class$("org.isqlviewer.core.model.EnhancedTableModel")) : class$org$isqlviewer$core$model$EnhancedTableModel, "java/EnhancedTableModel");
    public static final DataFlavor FLAVOR_TAB_STRINGS = new DataFlavor(class$java$lang$String == null ? (class$java$lang$String = EnhancedTableModel.class$("java.lang.String")) : class$java$lang$String, "text/tab-separated-values");
    protected ArrayList dataStore = new ArrayList();
    protected ArrayList columns = new ArrayList();
    protected transient ArrayList listeners = null;
    protected int pageSize = 4096;
    protected int pageOffset = 0;
    protected HashMap classMappings = new HashMap();
    private ArrayList filteredRows = new ArrayList();
    private String lastFilterPattern = null;
    static /* synthetic */ Class class$org$isqlviewer$core$model$EnhancedTableModel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public EnhancedTableModel() {
        this(null);
    }

    public EnhancedTableModel(String[] columns) {
        this.setColumns(columns);
        UserPreferences prefs = SystemConfig.getInstance().getPreferences();
        this.setPageSize(prefs.getInt("general.tablepage-size"));
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (FLAVOR_OBJECT.equals(flavor)) {
            return this;
        }
        if (DataFlavor.stringFlavor.equals(flavor) || FLAVOR_TAB_STRINGS.equals(flavor)) {
            return this.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{FLAVOR_OBJECT, FLAVOR_TAB_STRINGS, DataFlavor.stringFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return FLAVOR_OBJECT.equals(flavor) || FLAVOR_TAB_STRINGS.equals(flavor) || DataFlavor.stringFlavor.equals(flavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int realRow = this.translateRow(rowIndex);
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            ArrayList row = (ArrayList)this.dataStore.get(realRow);
            row.set(columnIndex, aValue);
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getRowCount() {
        int rc;
        int n = rc = this.filteredRows.isEmpty() ? this.dataStore.size() : this.filteredRows.size();
        if (rc <= this.getPageSize()) {
            return rc;
        }
        if (this.getPageOffset() == this.getPageCount() - 1) {
            return rc - this.getPageOffset() * this.getPageSize();
        }
        return this.getPageSize();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            ArrayList row = this.getRow(rowIndex);
            return row.get(columnIndex);
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTableModelListener(TableModelListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        if (!this.listeners.contains(l)) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableModelListener(TableModelListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.remove(l);
            }
        }
    }

    public String getColumnName(int column) {
        try {
            return (String)this.columns.get(column);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Class getColumnClass(int columnIndex) {
        if (this.classMappings.containsKey(Integer.toString(columnIndex))) {
            return (Class)this.classMappings.get(Integer.toString(columnIndex));
        }
        try {
            ArrayList row = (ArrayList)this.dataStore.get(0);
            Class<?> clazz = row.get(columnIndex).getClass();
            return clazz;
        }
        catch (Throwable t) {
            return class$java$lang$Object == null ? (class$java$lang$Object = EnhancedTableModel.class$("java.lang.Object")) : class$java$lang$Object;
        }
    }

    public int getIndexOfColumnName(String name) {
        try {
            return this.columns.indexOf(name);
        }
        catch (Throwable t) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(int column, boolean asc) {
        if (column >= 0 && column < this.getColumnCount()) {
            try {
                ArrayList arrayList = this.dataStore;
                synchronized (arrayList) {
                    ArrayList[] arr = this.dataStore.toArray(new ArrayList[0]);
                    this.clearData();
                    ArrayList arrayList2 = this.dataStore;
                    synchronized (arrayList2) {
                        Arrays.sort(arr, new RowComparator(column, asc));
                        this.dataStore.addAll(Arrays.asList(arr));
                    }
                }
                this.applyFilter(this.lastFilterPattern);
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "EnhancedTableModel::sort(" + column + " , " + asc + ")");
            }
            finally {
                this.fireTableRowsUpdated(0, this.getRowCount() - 1);
            }
        }
    }

    public boolean canSort(int column, boolean ascending) {
        return column >= 0 && column < this.columns.size() && this.dataStore.size() >= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        EnhancedTableModel clone = new EnhancedTableModel(this.getColumns());
        clone.dataStore = new ArrayList();
        if (this.filteredRows.isEmpty()) {
            ArrayList arrayList = this.dataStore;
            synchronized (arrayList) {
                Iterator itr = this.dataStore.iterator();
                while (itr.hasNext()) {
                    ArrayList row = (ArrayList)itr.next();
                    clone.dataStore.add(row.clone());
                }
            }
        }
        ArrayList arrayList = this.filteredRows;
        synchronized (arrayList) {
            Iterator itr = this.filteredRows.iterator();
            while (itr.hasNext()) {
                int rowNumber = (Integer)itr.next();
                ArrayList arrayList2 = this.dataStore;
                synchronized (arrayList2) {
                    ArrayList row = (ArrayList)this.dataStore.get(rowNumber);
                    clone.dataStore.add(row.clone());
                }
            }
        }
        clone.classMappings = (HashMap)this.classMappings.clone();
        clone.pageOffset = this.pageOffset;
        clone.pageSize = this.pageSize;
        return clone;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("");
        StringBuffer row = new StringBuffer("");
        for (int r = 0; r < this.getRowCount(); ++r) {
            for (int c = 0; c < this.getColumnCount(); ++c) {
                row.append(this.getValueAt(r, c));
                row.append("\t");
            }
            if (row.toString().trim().length() >= 1) {
                buff.append(row);
                buff.append(System.getProperty("line.seperator", "\n"));
            }
            row.setLength(0);
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassforColumn(int column, Class clazz) {
        HashMap hashMap = this.classMappings;
        synchronized (hashMap) {
            this.classMappings.put(Integer.toString(column), clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRow(int rowIndex) {
        try {
            ArrayList arrayList = this.dataStore;
            synchronized (arrayList) {
                this.dataStore.remove(this.translateRow(rowIndex));
            }
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean pageUp() {
        if (this.pageOffset > 0) {
            --this.pageOffset;
            this.fireTableDataChanged();
            return true;
        }
        return false;
    }

    public boolean pageDown() {
        if (this.pageOffset < this.getPageCount() - 1) {
            ++this.pageOffset;
            this.fireTableDataChanged();
            return true;
        }
        return false;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageCount() {
        double total = this.getTrueRowCount();
        double page = this.getPageSize();
        return (int)Math.ceil(total / page);
    }

    public boolean setPageSize(int newSize) {
        if (newSize >= 0 && newSize != this.pageSize) {
            if (newSize <= this.getTrueRowCount()) {
                newSize = this.getTrueRowCount();
            }
            int old = this.pageSize;
            this.pageSize = newSize;
            if (this.pageSize < old) {
                this.fireTableRowsDeleted(this.pageSize, old - 1);
            } else {
                this.fireTableRowsInserted(old, this.pageSize - 1);
            }
            return true;
        }
        return false;
    }

    public int getTrueRowCount() {
        return this.dataStore.size();
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public EnhancedTableModel subModel(int[] rows, int[] columnidxs) {
        EnhancedTableModel sub = new EnhancedTableModel(new String[0]);
        String[] headers = new String[columnidxs.length];
        for (int r = 0; r < rows.length; ++r) {
            int row = rows[r];
            ArrayList data = this.getRow(row);
            ArrayList clone = new ArrayList(columnidxs.length);
            for (int c = 0; c < columnidxs.length; ++c) {
                int column = columnidxs[c];
                clone.add(data.get(column));
            }
            sub.addRow(clone);
        }
        for (int c = 0; c < columnidxs.length; ++c) {
            int column = columnidxs[c];
            headers[c] = this.getColumnName(column);
            Class clazz = (Class)this.classMappings.get(new Integer(column));
            if (clazz == null) continue;
            sub.setClassforColumn(c, clazz);
        }
        sub.setColumns(headers);
        return sub;
    }

    public void clear() {
        this.clearData();
        this.fireTableDataChanged();
    }

    public void clearAll() {
        this.clearAllData();
        this.fireTableStructureChanged();
    }

    public boolean isEmpty() {
        return this.dataStore.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(ArrayList lst) {
        if (lst == null) {
            return;
        }
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            this.dataStore.add(lst.clone());
        }
        this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRowCount(int size) {
        int current = this.getRowCount();
        if (size <= current) {
            for (int i = current; i > size; ++i) {
                ArrayList arrayList = this.dataStore;
                synchronized (arrayList) {
                    this.dataStore.remove(i);
                    continue;
                }
            }
        }
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            this.dataStore.ensureCapacity(size);
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnCount(int size) {
        Iterator itr = this.dataStore.iterator();
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            int i;
            ArrayList arrayList2 = this.columns;
            synchronized (arrayList2) {
                try {
                    if (this.columns.size() > size) {
                        for (i = this.columns.size(); i > size; --i) {
                            this.columns.remove(i);
                        }
                        this.columns.trimToSize();
                    } else {
                        for (i = this.columns.size(); i < size; ++i) {
                            this.columns.add(Integer.toString(i));
                        }
                    }
                }
                catch (Throwable t) {
                    return;
                }
            }
            while (itr.hasNext()) {
                try {
                    ArrayList lst = (ArrayList)itr.next();
                    if (lst.size() > size) {
                        for (i = this.columns.size(); i > size; --i) {
                            this.columns.remove(i);
                        }
                        lst.trimToSize();
                        continue;
                    }
                    Object o = new Object();
                    for (int i2 = lst.size(); i2 < size; ++i2) {
                        this.columns.add(o);
                    }
                }
                catch (Throwable t) {
                }
            }
        }
        this.fireTableStructureChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnName(int idx, String name) {
        ArrayList arrayList = this.columns;
        synchronized (arrayList) {
            try {
                this.columns.set(idx, name);
                this.fireTableStructureChanged();
            }
            catch (Throwable t) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getColumns() {
        ArrayList arrayList = this.columns;
        synchronized (arrayList) {
            return this.columns.toArray(new String[0]);
        }
    }

    public Map getRowMap(int rowIndex) {
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            rowMap.put(this.getColumnName(i), this.getValueAt(rowIndex, i));
        }
        return rowMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeColumn(int columnIndex) {
        Iterator itr = this.dataStore.iterator();
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            try {
                this.columns.remove(columnIndex);
            }
            catch (Throwable t) {
                return;
            }
            while (itr.hasNext()) {
                try {
                    ArrayList lst = (ArrayList)itr.next();
                    lst.remove(columnIndex);
                }
                catch (Throwable t) {}
            }
        }
        this.fireTableStructureChanged();
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    public void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    public void fireTableChanged(TableModelEvent e) {
        if (this.listeners != null) {
            Iterator itr = this.listeners.iterator();
            while (itr.hasNext()) {
                TableModelListener tml = (TableModelListener)itr.next();
                try {
                    tml.tableChanged(e);
                }
                catch (Throwable t) {}
            }
        }
    }

    public int findColumn(String columnName) {
        if (columnName != null) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (!columnName.equals(this.getColumnName(i))) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int applyFilter(String text) {
        if (text != null && text.length() != 0) {
            Pattern pattern = null;
            try {
                pattern = Pattern.compile(text, 66);
                this.filteredRows.clear();
                this.lastFilterPattern = text;
            }
            catch (PatternSyntaxException pse) {
                return -1;
            }
            block5: for (int r = 0; r < this.getTrueRowCount(); ++r) {
                ArrayList row = null;
                ArrayList arrayList = this.dataStore;
                synchronized (arrayList) {
                    row = (ArrayList)this.dataStore.get(r);
                }
                Iterator itr = row.iterator();
                int c = 0;
                while (itr.hasNext()) {
                    Object next;
                    if (!this.canSearchColumn(c++) || !this.doFilter(next = itr.next(), pattern)) continue;
                    this.filteredRows.add(new Integer(r));
                    this.fireTableDataChanged();
                    continue block5;
                }
            }
            if (this.filteredRows.isEmpty()) {
                this.fireTableDataChanged();
            }
            return this.filteredRows.size();
        }
        this.clearFilter();
        return -1;
    }

    public void clearFilter() {
        if (!this.filteredRows.isEmpty()) {
            this.filteredRows.clear();
            this.fireTableDataChanged();
        }
    }

    public int translateRow(int rowIndex) {
        if (this.filteredRows.isEmpty()) {
            return rowIndex + this.pageOffset * this.pageSize;
        }
        return (Integer)this.filteredRows.get(rowIndex);
    }

    protected boolean doFilter(Object data, Pattern pattern) {
        if (data != null) {
            return pattern.matcher(data.toString()).find();
        }
        return false;
    }

    protected boolean canSearchColumn(int column) {
        return column >= 0 && column < this.getColumnCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addColumn(String name, Collection c) {
        Iterator itr = this.dataStore.iterator();
        Iterator citr = c.iterator();
        Object x = new Object();
        ArrayList arrayList = this.columns;
        synchronized (arrayList) {
            this.columns.add(name == null ? "" : name);
        }
        arrayList = this.dataStore;
        synchronized (arrayList) {
            while (itr.hasNext()) {
                ArrayList lst = (ArrayList)itr.next();
                if (citr.hasNext()) {
                    lst.add(citr.next());
                    continue;
                }
                lst.add(x);
            }
        }
        this.fireTableStructureChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearData() {
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            this.dataStore.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAllData() {
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            this.dataStore.clear();
            ArrayList arrayList2 = this.columns;
            synchronized (arrayList2) {
                this.columns.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setData(Collection c) {
        int count = 0;
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            this.dataStore.clear();
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                Object o = itr.next();
                if (!(o instanceof ArrayList)) continue;
                ++count;
                ArrayList lst = (ArrayList)o;
                this.dataStore.add(lst);
            }
        }
        this.fireTableRowsInserted(-1, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getRow(int rowIndex) {
        try {
            rowIndex = this.translateRow(rowIndex);
            ArrayList arrayList = this.dataStore;
            synchronized (arrayList) {
                return (ArrayList)this.dataStore.get(rowIndex);
            }
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setColumns(String[] s) {
        ArrayList arrayList = this.columns;
        synchronized (arrayList) {
            this.columns.clear();
            if (s != null) {
                this.columns.addAll(Arrays.asList(s));
            }
        }
        this.fireTableStructureChanged();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

