/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.filters;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.filters.AbstractTableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.sql.ByteArrayBlob;
import org.isqlviewer.sql.ByteArrayClob;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.Base64Decoder;
import org.isqlviewer.util.Base64Encoder;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ExtensionFileFilter;
import org.isqlviewer.util.StringUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTableFilter
extends AbstractTableFilter {
    private static final String ROOT_TAG = "isql-resultset";
    private static final String COLUMN_TAG = "table-column";
    private static final String ROW_TAG = "table-row";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_ROWS = "rows";
    private static final String ATTR_ENCODING = "encoding";
    private static final String ATTR_COLUMNS = "columns";
    private static final String ATTR_WAS_NULL = "wasnull";
    private static final String ATTR_DATE_PATTERN = "pattern";
    private final String BASE64_ENCODING = "base64";
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;

    public boolean canFilter(int mode, Object o) {
        switch (mode) {
            case 1: {
                return o instanceof EnhancedTableModel;
            }
        }
        return false;
    }

    public FileFilter[] getSupportedFileTypes(int mode) {
        return new FileFilter[]{new ExtensionFileFilter(this.getString("XML_Extension"), this.getString("XML_Desc"))};
    }

    public boolean isModeSupported(int mode) {
        switch (mode) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public boolean isFileRequired(int mode) {
        return true;
    }

    public int filterIn(EnhancedTableModel model, File file, InputStream is) throws IOException, InterruptedException {
        Charset cs = this.getPreferredCharset(1);
        InputStreamReader reader = new InputStreamReader(is, cs);
        this.checkIfCancelled();
        this.readContent(reader, model);
        return 3;
    }

    public int filterOut(Object data, File file, OutputStream os) throws InterruptedException {
        if (!(data instanceof TableModel)) {
            return 0;
        }
        TableModel model = (TableModel)data;
        Charset cs = this.getPreferredCharset(1);
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(os, cs), true);
        SimpleDateFormat sdf = new SimpleDateFormat("");
        int rowCount = 0;
        rowCount = model instanceof EnhancedTableModel ? ((EnhancedTableModel)model).getTrueRowCount() : model.getRowCount();
        this.checkIfCancelled();
        pw.print("<?xml version=\"1.0\" encoding=\"");
        pw.print(cs.name());
        pw.println("\" ?>");
        pw.print("<");
        pw.print(ROOT_TAG);
        pw.print(" ");
        pw.print(ATTR_ROWS);
        pw.print("=\"");
        pw.print(Integer.toString(rowCount));
        pw.print("\" ");
        pw.print(ATTR_COLUMNS);
        pw.print("=\"");
        pw.print(Integer.toString(model.getColumnCount()));
        pw.println("\" >");
        for (int r = 0; r < rowCount; ++r) {
            this.checkIfCancelled();
            pw.print("\t<");
            pw.print(ROW_TAG);
            pw.println(">");
            for (int c = 0; c < model.getColumnCount(); ++c) {
                Base64Encoder codec;
                ByteArrayOutputStream out;
                String format;
                Object o = model.getValueAt(r, c);
                String name = model.getColumnName(c);
                String value = "";
                if (name == null) {
                    name = "null";
                }
                pw.print("\t\t<");
                pw.print(COLUMN_TAG);
                pw.print(" ");
                pw.print(ATTR_TYPE);
                pw.print("=\"");
                String type = StringUtilities.getTypeStringForObject(o);
                pw.print(StringUtilities.encodeXMLEntities(type));
                pw.print("\" ");
                pw.print(" ");
                pw.print(ATTR_NAME);
                pw.print("=\"");
                pw.print(StringUtilities.encodeXMLEntities(name));
                pw.print("\" ");
                if (o == null) {
                    pw.print(ATTR_WAS_NULL);
                    pw.print("=\"");
                    pw.print(Boolean.TRUE);
                    pw.print("\"");
                } else if (o instanceof Timestamp) {
                    format = this.sysConfig.getFormatForSQLType(93);
                    pw.print(" ");
                    pw.print(ATTR_DATE_PATTERN);
                    pw.print("=\"");
                    pw.print(StringUtilities.encodeXMLEntities(format));
                    pw.print("\"");
                    sdf.applyPattern(format);
                    value = sdf.format((Timestamp)o);
                } else if (o instanceof Time) {
                    format = this.sysConfig.getFormatForSQLType(92);
                    pw.print(" ");
                    pw.print(ATTR_DATE_PATTERN);
                    pw.print("=\"");
                    pw.print(StringUtilities.encodeXMLEntities(format));
                    pw.print("\"");
                    sdf.applyPattern(format);
                    value = sdf.format((Time)o);
                } else if (o instanceof Date) {
                    format = this.sysConfig.getFormatForSQLType(91);
                    pw.print(" ");
                    pw.print(ATTR_DATE_PATTERN);
                    pw.print("=\"");
                    pw.print(StringUtilities.encodeXMLEntities(format));
                    pw.print("\"");
                    sdf.applyPattern(format);
                    value = sdf.format((Date)o);
                } else if (o instanceof Blob) {
                    try {
                        Blob blob = (Blob)o;
                        out = new ByteArrayOutputStream((int)blob.length());
                        codec = new Base64Encoder(blob.getBinaryStream(), out);
                        codec.process();
                        value = out.toString();
                        pw.print(" ");
                        pw.print(ATTR_ENCODING);
                        pw.print("=\"");
                        pw.print(StringUtilities.encodeXMLEntities("base64"));
                        pw.print("\"");
                    }
                    catch (Throwable t) {
                        this.info(BasicUtilities.getString("Error_Encoding_Data", "base64"), t);
                        return 0;
                    }
                } else if (o instanceof Clob) {
                    try {
                        Clob clob = (Clob)o;
                        out = new ByteArrayOutputStream((int)clob.length());
                        codec = new Base64Encoder(clob.getAsciiStream(), out);
                        value = codec.processString();
                        pw.print(" ");
                        pw.print(ATTR_ENCODING);
                        pw.print("=\"");
                        pw.print(StringUtilities.encodeXMLEntities("base64"));
                        pw.print("\"");
                    }
                    catch (Throwable t) {
                        this.debug(BasicUtilities.getString("Error_Encoding_Data", "base64"), t);
                        return 0;
                    }
                } else {
                    value = o == null ? "" : o.toString();
                    value = StringUtilities.encodeXMLEntities(value);
                }
                if (value.indexOf(System.getProperty("line.seperator", "\n")) < 0) {
                    pw.print(">");
                    pw.print(value);
                    pw.print("</");
                    pw.print(COLUMN_TAG);
                    pw.println(">");
                    continue;
                }
                pw.println(">");
                pw.println(value);
                pw.print("\t\t</");
                pw.print(COLUMN_TAG);
                pw.println(">");
            }
            pw.print("\t</");
            pw.print(ROW_TAG);
            pw.println(">");
            this.fireProgressUpdated(r);
        }
        pw.print("</");
        pw.print(ROOT_TAG);
        pw.println(">");
        this.info(this.getString("XML_TableData_Written"));
        try {
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return 1;
    }

    public String getName() {
        return BasicUtilities.getString("XML_Handler_Name");
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Xml16");
    }

    protected void loadProperties(int mode) {
    }

    private void readContent(Reader is, EnhancedTableModel tm) throws IOException {
        try {
            XMLReader reader = SystemConfig.getInstance().getXMLReader();
            reader.setContentHandler(new XMLImporter(tm));
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.parse(new InputSource(is));
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class XMLImporter
    extends DefaultHandler {
        private EnhancedTableModel model = null;
        private SimpleDateFormat sdf = new SimpleDateFormat("");
        private ArrayList currentRow = null;
        private String currentType = null;
        private String currentEnc = null;
        private StringBuffer charBuffer = new StringBuffer("");

        public void characters(char[] ch, int start, int length) {
            if (this.currentRow != null) {
                this.charBuffer.append(ch, start, length);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String uri, String name, String qName) throws SAXException {
            if (name.equalsIgnoreCase(XMLTableFilter.ROOT_TAG)) {
                XMLTableFilter.this.info(BasicUtilities.getString("XMLFilter_ImportFinished"));
                return;
            } else if (name.equalsIgnoreCase(XMLTableFilter.COLUMN_TAG)) {
                int jdbcType = JDBCUtilities.getTypeforName(this.currentType);
                try {
                    String data = this.charBuffer.toString().trim();
                    switch (jdbcType) {
                        case 2004: 
                        case 2005: {
                            this.currentRow.add(this.createLOB(jdbcType));
                            return;
                        }
                        default: {
                            this.currentRow.add(JDBCUtilities.convertValue(data, jdbcType, this.sdf));
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    XMLTableFilter.this.info(BasicUtilities.getString("XMLFilter_ErrorConvertingValue", this.charBuffer.toString()), e);
                    throw new SAXException(e);
                }
                finally {
                    this.charBuffer.setLength(0);
                }
            } else {
                if (!name.equalsIgnoreCase(XMLTableFilter.ROW_TAG)) return;
                this.model.addRow(this.currentRow);
                this.model.setColumnCount(this.currentRow.size());
                this.currentRow = null;
            }
        }

        public void startElement(String uri, String name, String qName, Attributes attr) {
            if (name.equalsIgnoreCase(XMLTableFilter.ROOT_TAG)) {
                XMLTableFilter.this.info(BasicUtilities.getString("XMLFilter_StartMessage", new String[]{attr.getValue(XMLTableFilter.ATTR_ROWS), attr.getValue(XMLTableFilter.ATTR_COLUMNS)}));
                this.model.clearAll();
                this.model.setColumnCount(Integer.parseInt(attr.getValue(XMLTableFilter.ATTR_COLUMNS)));
            } else if (name.equalsIgnoreCase(XMLTableFilter.COLUMN_TAG)) {
                this.currentType = attr.getValue(XMLTableFilter.ATTR_TYPE);
                String columnName = attr.getValue(XMLTableFilter.ATTR_NAME);
                String format = attr.getValue(XMLTableFilter.ATTR_DATE_PATTERN);
                if (format != null) {
                    this.sdf.applyPattern(format);
                }
                if (this.model.findColumn(columnName) < 0) {
                    this.model.setColumnName(this.currentRow.size(), columnName);
                }
            } else if (name.equalsIgnoreCase(XMLTableFilter.ROW_TAG)) {
                XMLTableFilter.this.debug(BasicUtilities.getString("XMLFilter_ImportRowStart"));
                this.currentRow = new ArrayList();
            }
        }

        public XMLImporter(EnhancedTableModel mdl) {
            this.model = mdl;
        }

        private Object createLOB(int type) throws Exception {
            if ("base64".equalsIgnoreCase(this.currentEnc)) {
                Base64Decoder codec = new Base64Decoder(this.charBuffer.toString());
                this.charBuffer.setLength(0);
                this.charBuffer.append(codec.processString());
            }
            switch (type) {
                case 2004: {
                    this.model.setClassforColumn(this.currentRow.size(), class$java$sql$Blob == null ? (class$java$sql$Blob = XMLTableFilter.class$("java.sql.Blob")) : class$java$sql$Blob);
                    return new ByteArrayBlob(this.charBuffer.toString().getBytes());
                }
                case 2005: {
                    this.model.setClassforColumn(this.currentRow.size(), class$java$sql$Clob == null ? (class$java$sql$Clob = XMLTableFilter.class$("java.sql.Clob")) : class$java$sql$Clob);
                    return new ByteArrayClob(this.charBuffer.toString());
                }
            }
            return null;
        }
    }
}

