/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.filters;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.prefs.Preferences;
import java.util.zip.CRC32;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import org.isqlviewer.core.filters.AbstractTableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.sql.ByteArrayBlob;
import org.isqlviewer.sql.ByteArrayClob;
import org.isqlviewer.sql.FileBlob;
import org.isqlviewer.sql.FileClob;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class LOBTableFilter
extends AbstractTableFilter {
    private SimpleDateFormat sdf = new SimpleDateFormat("");
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;

    public String getName() {
        return this.getString("LOBFilter_Name");
    }

    public boolean isModeSupported(int mode) {
        switch (mode) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public boolean isFileRequired(int mode) {
        return true;
    }

    public int filterIn(EnhancedTableModel tm, File file, InputStream is) throws IOException, InterruptedException {
        File[] fileArray;
        Preferences prefs = this.getConfiguration(0);
        String key = null;
        if (file.isDirectory()) {
            fileArray = file.listFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        File[] files = fileArray;
        key = this.getString("LOBFilter_Cmp");
        String deflator = prefs.get(key, Boolean.FALSE.toString());
        key = this.getString("LOBFilter_LoadType");
        String detect = prefs.get(key, "BLOB");
        this.sdf.applyPattern(this.sysConfig.getPreferences().get("general.timestamp-format"));
        tm.setColumnCount(5);
        tm.setColumnName(0, detect);
        tm.setColumnName(1, this.getString("LOBFilter_FileLength"));
        tm.setColumnName(2, this.getString("LOBFilter_FileName"));
        tm.setColumnName(3, this.getString("LOBFilter_FileURL"));
        tm.setColumnName(4, this.getString("LOBFilter_FileTimestamp"));
        int type = JDBCUtilities.getTypeforName(detect);
        switch (type) {
            case 2004: {
                tm.setClassforColumn(0, class$java$sql$Blob == null ? (class$java$sql$Blob = LOBTableFilter.class$("java.sql.Blob")) : class$java$sql$Blob);
                break;
            }
            case 2005: {
                tm.setClassforColumn(0, class$java$sql$Clob == null ? (class$java$sql$Clob = LOBTableFilter.class$("java.sql.Clob")) : class$java$sql$Clob);
                break;
            }
            default: {
                this.info(this.getString("LOBFilter_TypeError"));
                return 0;
            }
        }
        block8: for (int i = 0; i < files.length; ++i) {
            this.checkIfCancelled();
            File f = files[i];
            Clob clob = null;
            Blob blob = null;
            if (f.isDirectory()) continue;
            ArrayList<Object> row = new ArrayList<Object>(1);
            Long length = new Long(f.length());
            switch (type) {
                case 2004: {
                    key = this.getString("LOBFilter_ZipLvl");
                    blob = this.getBlobforFile(f, deflator, prefs.getInt(key, -1));
                    break;
                }
                case 2005: {
                    clob = this.getClobforFile(f, deflator);
                    break;
                }
                default: {
                    continue block8;
                }
            }
            if (blob != null) {
                row.add(blob);
            } else {
                row.add(clob);
            }
            row.add(length);
            row.add(files[i].getName());
            row.add(f.toURL().toExternalForm());
            row.add(new Timestamp(f.lastModified()));
            tm.addRow(row);
        }
        return 3;
    }

    public int filterOut(Object data, File file, OutputStream os) {
        return 0;
    }

    public boolean accept(int mode, File f) {
        switch (mode) {
            case 0: {
                return f.isDirectory() && f.list().length >= 1 || f.isFile() && f.canRead();
            }
        }
        return false;
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Image16");
    }

    protected void loadProperties(int mode) {
        String[] dtc_options = new String[]{"BLOB", "CLOB"};
        switch (mode) {
            case 0: {
                String key = this.getString("LOBFilter_LoadType");
                String desc = this.getString("LOBFilter_LoadType_Help");
                this.addProperty(key, dtc_options, dtc_options[0], false, desc);
                String[] cmp_options = new String[]{Boolean.FALSE.toString(), BasicUtilities.getString("LOBFilter_Cmp_Zip"), BasicUtilities.getString("LOBFilter_Cmp_gZip")};
                key = this.getString("LOBFilter_Cmp");
                desc = this.getString("LOBFilter_Cmp_Help");
                this.addProperty(key, cmp_options, cmp_options[2], false, desc);
                key = this.getString("LOBFilter_ZipLvl");
                desc = this.getString("LOBFilter_ZipLvl_Help");
                this.addProperty(key, null, "3", false, desc);
            }
        }
    }

    protected Blob getBlobforFile(File f, String deflator, int level) throws IOException {
        Blob blob = null;
        if (deflator.equalsIgnoreCase(Boolean.FALSE.toString())) {
            blob = new FileBlob(f);
        } else {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(4096);
            FileInputStream fis = new FileInputStream(f);
            if (deflator.equals(BasicUtilities.getString("LOBFilter_Cmp_Zip"))) {
                BasicUtilities.copyStream(fis, bytes);
                fis.close();
                CRC32 crc = new CRC32();
                crc.update(bytes.toByteArray());
                bytes = new ByteArrayOutputStream(4096);
                ZipOutputStream zos = new ZipOutputStream(bytes);
                zos.setMethod(8);
                zos.setLevel(level);
                ZipEntry ze = new ZipEntry(f.getName());
                ze.setSize(f.length());
                ze.setCrc(crc.getValue());
                ze.setTime(System.currentTimeMillis());
                zos.putNextEntry(ze);
                String msg = null;
                msg = BasicUtilities.getString("Zip_Entry_Header", f.getName());
                this.info(msg);
                msg = BasicUtilities.getString("Zip_Entry_CRC", Long.toHexString(ze.getCrc()));
                this.info(msg);
                msg = BasicUtilities.getString("Zip_Entry_Time", this.sdf.format(new Date(ze.getTime())));
                this.info(msg);
                msg = BasicUtilities.getString("Zip_Entry_Size", StringUtilities.getHumanReadableSize(ze.getSize()));
                this.info(msg);
                fis = new FileInputStream(f);
                BasicUtilities.copyStream(fis, zos);
                zos.closeEntry();
                zos.close();
            } else {
                GZIPOutputStream zos = new GZIPOutputStream(bytes);
                BasicUtilities.copyStream(fis, zos);
                zos.close();
            }
            fis.close();
            blob = new ByteArrayBlob(bytes.toByteArray());
        }
        return blob;
    }

    protected Clob getClobforFile(File f, String deflator) throws IOException {
        Clob clob = null;
        if (deflator.equalsIgnoreCase(Boolean.FALSE.toString())) {
            clob = new FileClob(f);
        } else {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(4096);
            FileInputStream fis = new FileInputStream(f);
            if (deflator.equals(BasicUtilities.getString("LOBFilter_Cmp_Zip"))) {
                ZipOutputStream zos = new ZipOutputStream(bytes);
                ZipEntry ze = new ZipEntry(f.getName());
                ze.setComment(f.getAbsolutePath());
                ze.setMethod(8);
                ze.setTime(System.currentTimeMillis());
                ze.setSize(f.length());
                zos.putNextEntry(ze);
                BasicUtilities.copyStream(fis, zos);
                zos.closeEntry();
                zos.close();
            } else {
                GZIPOutputStream zos = new GZIPOutputStream(bytes);
                BasicUtilities.copyStream(fis, zos);
                zos.close();
            }
            fis.close();
            clob = new ByteArrayClob(bytes.toString());
        }
        return clob;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

