/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.filters;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.isqlviewer.core.filters.AbstractTableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.util.Base64Encoder;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ExtensionFileFilter;
import org.isqlviewer.util.StringUtilities;

public class HTMLTableFilter
extends AbstractTableFilter {
    public FileFilter[] getSupportedFileTypes(int mode) {
        return new FileFilter[]{new ExtensionFileFilter(this.getString("HTML_Extension"), this.getString("HTML_Desc")), new ExtensionFileFilter(this.getString("HTM_Extension"), this.getString("HTML_Desc"))};
    }

    public boolean isModeSupported(int mode) {
        switch (mode) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return BasicUtilities.getString("HTML_Handler_Name");
    }

    public boolean isFileRequired(int mode) {
        return true;
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Html16");
    }

    public int filterIn(EnhancedTableModel tm, File file, InputStream is) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int filterOut(Object data, File file, OutputStream os) throws IOException, InterruptedException {
        if (!(data instanceof TableModel)) {
            return 0;
        }
        TableModel model = (TableModel)data;
        int rowCount = 0;
        rowCount = model instanceof EnhancedTableModel ? ((EnhancedTableModel)model).getTrueRowCount() : model.getRowCount();
        Preferences prefs = this.getConfiguration(1);
        SimpleDateFormat sdf = new SimpleDateFormat("");
        String key = null;
        Charset cs = this.getPreferredCharset(1);
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(os, cs), true);
        this.setProgressMax(rowCount);
        key = BasicUtilities.getString("HTML_Include_CSS_Name");
        boolean inlineStyle = prefs.getBoolean(key, true);
        key = BasicUtilities.getString("HTML_EmbeddBlobs_Name");
        boolean embeedLobs = prefs.getBoolean(key, true);
        key = BasicUtilities.getString("HTML_Title_Name");
        String title = prefs.get(key, BasicUtilities.getString("HTML_Title_Value"));
        pw.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">");
        pw.println("<html lang=\"" + Locale.getDefault().getISO3Language() + "\" >");
        pw.println(" <head>");
        pw.println("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + cs.name() + "\"> ");
        pw.println("  <meta content=\"iSQL-Viewer-2.1.8 name=generator\">");
        pw.println("  <title>" + title + "</title>");
        if (inlineStyle) {
            pw.println("  <style type=\"text/css\" > ");
            pw.println("   BODY { ");
            pw.println("    background-color : #F3F3F3;");
            pw.println("    text-decoration : none;");
            pw.println("    margin : 0px 0px 0px 0px; ");
            pw.println("    font : 13px Verdana, Tahoma, Arial, Helvetica, sans-serif;");
            pw.println("   }");
            pw.println("   TH { ");
            pw.println("    font-family : Verdana, Tahoma, Arial, Helvetica, sans-serif;");
            pw.println("    font-size: 12px;");
            pw.println("    color : #FFFFFF;");
            pw.println("    text-decoration : none;");
            pw.println("    background-color  : #426794;");
            pw.println("   }");
            pw.println("   HR {");
            pw.println("    width: 95%;");
            pw.println("    color  : #426794;");
            pw.println("    background-color  : #426794;");
            pw.println("   }");
            pw.println("   TABLE { ");
            pw.println("    color : #FFFFFF;");
            pw.println("    text-decoration : none;");
            pw.println("    background-color  : #426794;");
            pw.println("    text-align : center;");
            pw.println("   }");
            pw.println("   TD { ");
            pw.println("    background-color : #FEFEFE;");
            pw.println("    text-align : inherit;");
            pw.println("    font-family : Verdana, Tahoma, Arial, Helvetica, sans-serif;");
            pw.println("    font-size: 11px;");
            pw.println("    color  : #000000;");
            pw.println("   }");
            pw.println("   .alt { ");
            pw.println("    background-color : #CFCFCF;");
            pw.println("    text-align : inherit;");
            pw.println("    font-family : Verdana, Tahoma, Arial, Helvetica, sans-serif;");
            pw.println("    font-size: 11px;");
            pw.println("    color  : #000000;");
            pw.println("   }");
            pw.println("   .footer { ");
            pw.println("    font-family : Verdana, Tahoma, Arial, Helvetica, sans-serif;");
            pw.println("    font-size: 8px;");
            pw.println("    text-align: center;");
            pw.println("    color  : #000000;");
            pw.println("   }");
            pw.println("  </style> ");
        }
        pw.println(" </head>");
        pw.println(" <body>");
        pw.println("  <div>");
        pw.println("   <table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        pw.println("    <tr>");
        pw.println("     <td style=\"background-color: #426794; color : #FFFFFF;\">");
        pw.println("      <table width=\"100%\" border=\"0\" cellspacing=\"2\" cellpadding=\"2\">");
        pw.println("       <tr>");
        pw.println("        <th>");
        pw.println("         " + BasicUtilities.getString("Number_Of_Records", "" + model.getRowCount()));
        pw.println("        </th>");
        pw.println("       </tr>");
        pw.println("       <tr>");
        pw.println("        <td style=\"background-color: #F3F3F3; color : #000000;\">");
        pw.println("         <table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"1\">");
        pw.println("          <tr>");
        for (int j = 0; j < model.getColumnCount(); ++j) {
            pw.print("           <th>");
            pw.print(StringUtilities.encodeXMLEntities(model.getColumnName(j)) + "&nbsp;");
            pw.println("</th>");
        }
        pw.println("          </tr>");
        for (int r = 0; r < model.getRowCount(); ++r) {
            pw.println("          <tr>");
            for (int c = 0; c < model.getColumnCount(); ++c) {
                pw.print("           <td" + (r % 2 == 0 ? "" : " class=\"alt\"") + ">");
                Object o = model.getValueAt(r, c);
                String value = null;
                if (o != null) {
                    FileOutputStream fos;
                    File outfile;
                    File subDir;
                    ByteArrayOutputStream out;
                    String format;
                    if (o instanceof Timestamp) {
                        format = this.sysConfig.getFormatForSQLType(93);
                        sdf.applyPattern(format);
                        value = sdf.format((Timestamp)o);
                    } else if (o instanceof Time) {
                        format = this.sysConfig.getFormatForSQLType(92);
                        sdf.applyPattern(format);
                        value = sdf.format((Time)o);
                    } else if (o instanceof Date) {
                        format = this.sysConfig.getFormatForSQLType(91);
                        sdf.applyPattern(format);
                        value = sdf.format((Date)o);
                    } else if (o instanceof Blob) {
                        Blob blob = (Blob)o;
                        try {
                            if (embeedLobs) {
                                out = new ByteArrayOutputStream(1024);
                                Base64Encoder codec = new Base64Encoder(blob.getBinaryStream(), out);
                                codec.process();
                                value = out.toString();
                                out.reset();
                                out.close();
                            }
                            subDir = new File(file.getParentFile(), file.getName() + "_files");
                            subDir.mkdirs();
                            outfile = new File(subDir, model.getColumnName(c) + "_" + Integer.toString(r) + ".bin");
                            if (outfile.exists()) {
                                outfile.delete();
                            }
                            this.debug(outfile.getAbsolutePath());
                            if (outfile.createNewFile()) {
                                fos = new FileOutputStream(outfile);
                                BasicUtilities.copyStream(blob.getBinaryStream(), fos);
                                pw.print("<a href=\"./" + file.getName() + "_files/" + outfile.getName() + "\">" + model.getColumnName(c) + "</a>");
                                fos.flush();
                                fos.close();
                            }
                            pw.print("<div style=\"width: 95%; border-width: medium; border-style:solid; border-color:#FF0000;\">&nbsp;</div>");
                        }
                        catch (Throwable t) {
                            this.debug("", t);
                            throw new IOException(t.getMessage());
                        }
                    } else if (o instanceof Clob) {
                        Clob clob = (Clob)o;
                        try {
                            if (embeedLobs) {
                                out = new ByteArrayOutputStream((int)clob.length());
                                BasicUtilities.copyStream(clob.getAsciiStream(), out);
                                value = out.toString();
                                out.reset();
                                out.close();
                            }
                            subDir = new File(file.getParentFile(), file.getName() + "_files");
                            subDir.mkdirs();
                            outfile = new File(subDir, model.getColumnName(c) + "_" + Integer.toString(r) + ".txt");
                            if (outfile.exists()) {
                                outfile.delete();
                            }
                            this.debug(outfile.getAbsolutePath());
                            if (outfile.createNewFile()) {
                                fos = new FileOutputStream(outfile);
                                BasicUtilities.copyStream(clob.getAsciiStream(), fos);
                                pw.print("<a href=\"./" + file.getName() + "_files/" + outfile.getName() + "\">" + model.getColumnName(c) + "</a>");
                                fos.flush();
                                fos.close();
                            }
                            pw.print("<div style=\"width: 95%; border-width: medium; border-style:solid; border-color:#FF0000;\">&nbsp;</div>");
                        }
                        catch (Throwable t) {
                            this.debug("", t);
                            throw new IOException(t.getMessage());
                        }
                    } else {
                        value = o.toString();
                    }
                    if (value != null) {
                        pw.print(StringUtilities.encodeXMLEntities(value) + "&nbsp;");
                    }
                } else {
                    pw.print("<div style=\"width: 95%; border-width: medium; border-style:solid; border-color:#FF0000;\">&nbsp;</div>");
                }
                pw.println("</td>");
            }
            pw.println("          </tr>");
            pw.flush();
            this.fireProgressUpdated(r);
            try {
                this.checkIfCancelled();
                continue;
            }
            catch (InterruptedException ie) {
                try {
                    pw.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw ie;
            }
        }
        pw.println("         </table>");
        pw.println("         <hr/>");
        pw.println("         <div class=\"footer\"><em>iSQL-Viewer 2.1.8</em></div>");
        pw.println("        </td>");
        pw.println("       </tr>");
        pw.println("      </table>");
        pw.println("     </td>");
        pw.println("    </tr>");
        pw.println("   </table>");
        pw.println("  </div>");
        pw.println(" </body>");
        pw.println("</html>");
        try {
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
        }
        finally {
            pw = null;
        }
        this.fireProgressUpdated(model.getRowCount());
        return 1;
    }

    protected void loadProperties(int mode) {
        switch (mode) {
            case 1: {
                String key = this.getString("HTML_Title_Name");
                String desc = this.getString("HTML_Title_Desc");
                this.addProperty(key, null, "", false, desc);
                key = this.getString("HTML_Include_CSS_Name");
                desc = this.getString("HTML_Include_CSS_Desc");
                this.addProperty(key, CHOICE_BOOLEAN, "true", false, desc);
                key = this.getString("HTML_Insert_Class_Name");
                desc = this.getString("HTML_Insert_Class_Desc");
                this.addProperty(key, CHOICE_BOOLEAN, "true", false, desc);
                key = this.getString("HTML_IncludeHeader_Name");
                desc = this.getString("HTML_IncludeHeader_Desc");
                this.addProperty(key, CHOICE_BOOLEAN, "true", false, desc);
                key = this.getString("HTML_EmbeddBlobs_Name");
                desc = this.getString("HTML_EmbeddBlobs_Desc");
                this.addProperty(key, CHOICE_BOOLEAN, "true", false, desc);
                break;
            }
        }
    }
}

