/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.filters;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.isqlviewer.core.filters.AbstractTableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ExtensionFileFilter;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;

public class CSVTableFilter
extends AbstractTableFilter {
    public FileFilter[] getSupportedFileTypes(int mode) {
        return new FileFilter[]{new ExtensionFileFilter(this.getString("TAB_Extension"), this.getString("TAB_Desc")), new ExtensionFileFilter(this.getString("CSV_Extension"), this.getString("CSV_Desc"))};
    }

    public boolean canFilter(int mode, Object o) {
        switch (mode) {
            case 0: {
                return true;
            }
        }
        return o instanceof TableModel;
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Csv16");
    }

    public boolean isModeSupported(int mode) {
        switch (mode) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int filterIn(EnhancedTableModel tm, File file, InputStream is) throws IOException {
        Preferences prefs = this.getConfiguration(0);
        String key = null;
        Charset cs = this.getPreferredCharset(0);
        BufferedReader br = new BufferedReader(new InputStreamReader(is, cs));
        int totalBytes = is.available();
        this.setProgressMax(totalBytes);
        int bytesRead = 0;
        key = BasicUtilities.getString("ASCII_Delimiter_Name");
        String delims = StringUtilities.decode(prefs.get(key, ","));
        key = BasicUtilities.getString("ASCII_DblTok_Name");
        boolean dTokens = prefs.getBoolean(key, true);
        key = BasicUtilities.getString("ASCII_1st_Row_Colums");
        boolean readCols = prefs.getBoolean(key, false);
        key = BasicUtilities.getString("ASCII_Skip_Name");
        int skipcnt = prefs.getInt(key, 0);
        key = BasicUtilities.getString("ASCII_Quote_Name");
        char textQualifier = prefs.get(key, "\"").charAt(0);
        key = BasicUtilities.getString("ASCII_Comment_Name");
        char commentQualifier = prefs.get(key, "#").charAt(0);
        StringTokenizer line = new StringTokenizer("", delims, false, !dTokens);
        StringBuffer buff = new StringBuffer("");
        for (int i = 0; i < skipcnt; ++i) {
            if (!br.ready()) {
                return 0;
            }
            this.fireProgressUpdated(bytesRead += br.readLine().getBytes().length);
        }
        if (skipcnt >= 1) {
            this.info(BasicUtilities.getString("ASCII_Line_Skip", Integer.toString(skipcnt)));
        }
        int lineNo = skipcnt;
        while (br.ready()) {
            try {
                this.checkIfCancelled();
            }
            catch (Throwable t) {
                try {
                    br.close();
                }
                catch (Throwable t2) {
                }
                finally {
                    br = null;
                }
                tm.clear();
                return 2;
            }
            buff.setLength(0);
            buff.append(br.readLine());
            ++lineNo;
            this.fireProgressUpdated(bytesRead += buff.toString().getBytes().length);
            if (buff.charAt(0) == commentQualifier) continue;
            line.setString(buff.toString());
            ArrayList<String> tableRow = new ArrayList<String>();
            if (!line.hasMoreTokens()) {
                this.info(BasicUtilities.getString("ASCII_NoTokens", Integer.toString(lineNo)));
                continue;
            }
            while (line.hasMoreTokens()) {
                String Token = line.nextToken(delims);
                if (Token.length() >= 1 && Token.charAt(0) == textQualifier && Token.charAt(Token.length() - 1) != textQualifier) {
                    String before = Token;
                    Token = before.concat(line.nextToken(textQualifier + System.getProperty("line.seperator", "\n")));
                    line.nextToken(delims);
                }
                if (Token.indexOf(textQualifier) >= 0) {
                    Token = Token.substring(Token.indexOf(textQualifier) + 1, Token.lastIndexOf(textQualifier)).trim();
                }
                String tok = StringUtilities.decode(Token);
                tableRow.add(tok);
            }
            if (tableRow.size() == 1 && tm.getColumnCount() != 1) {
                this.info(BasicUtilities.getString("ASCII_Empty_Line", Integer.toString(lineNo)));
                continue;
            }
            if (tm.getColumnCount() < tableRow.size()) {
                if (tm.getColumnCount() >= 1) {
                    String[] p = new String[]{Integer.toString(lineNo), Integer.toString(tableRow.size())};
                    this.info(BasicUtilities.getString("ASCII_Token_Warning", p));
                }
                tm.setColumnCount(tableRow.size());
            }
            if (readCols) {
                Iterator itr = tableRow.iterator();
                int idx = 0;
                while (itr.hasNext()) {
                    String column = (String)itr.next();
                    tm.setColumnName(idx++, StringUtilities.decode(column));
                }
                readCols = false;
                tableRow.clear();
                tableRow = null;
                continue;
            }
            tm.addRow(tableRow);
            tableRow.clear();
            tableRow = null;
        }
        try {
            br.close();
        }
        catch (Throwable t) {
        }
        finally {
            br = null;
        }
        this.fireProgressUpdated(totalBytes);
        String[] p = new String[]{Integer.toString(tm.getTrueRowCount()), Integer.toString(tm.getColumnCount())};
        this.info(BasicUtilities.getString("ASCII_Results", p));
        return tm.isEmpty() ? 1 : 3;
    }

    public int filterOut(Object data, File file, OutputStream os) throws InterruptedException {
        if (!(data instanceof TableModel)) {
            return 0;
        }
        TableModel model = (TableModel)data;
        Preferences prefs = this.getConfiguration(1);
        String key = null;
        StringBuffer buff = new StringBuffer("");
        Charset cs = this.getPreferredCharset(1);
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(os, cs), true);
        key = BasicUtilities.getString("ASCII_Delimiter_Name");
        String delim = StringUtilities.decode(prefs.get(key, ","));
        key = BasicUtilities.getString("ASCII_SmartQuotes_Name");
        boolean useSmartQuotes = prefs.getBoolean(key, false);
        key = BasicUtilities.getString("ASCII_IncludeHead_Name");
        boolean useHeader = prefs.getBoolean(key, false);
        key = BasicUtilities.getString("ASCII_Encode_NPC_Name");
        boolean doEncode = prefs.getBoolean(key, false);
        key = BasicUtilities.getString("ASCII_IncludeCols_Name");
        boolean includeColumNames = prefs.getBoolean(key, false);
        int rowCount = 0;
        rowCount = model instanceof EnhancedTableModel ? ((EnhancedTableModel)model).getTrueRowCount() : model.getRowCount();
        this.setProgressMax(rowCount + (useHeader ? 2 : 0) + (includeColumNames ? 1 : 0));
        if (useHeader) {
            this.fireProgressUpdated(1);
            key = BasicUtilities.getString("ASCII_Header_Name");
            String hdr = prefs.get(key, BasicUtilities.getString("ASCII_Header_Value"));
            pw.print("# ");
            pw.println(hdr);
            this.fireProgressUpdated(2);
            pw.print("# ");
            pw.println(new Date());
            this.info(BasicUtilities.getString("ASCII_Header_Written"));
        }
        if (includeColumNames) {
            buff.setLength(0);
            for (int j = 0; j < model.getColumnCount(); ++j) {
                String s = model.getColumnName(j);
                if (useSmartQuotes && s != null && (s.indexOf(delim) >= 0 || s.indexOf(32) >= 0)) {
                    s = "\"" + s + "\"";
                }
                if (doEncode) {
                    buff.append(StringUtilities.encode(s, false, false));
                } else {
                    buff.append(s);
                }
                buff.append(delim);
            }
            pw.println(buff);
            pw.flush();
            this.fireProgressUpdated((useHeader ? 2 : 0) + 1);
            this.info(BasicUtilities.getString("ASCII_ColumnHeader_Written"));
        }
        int offset = (useHeader ? 2 : 0) + (includeColumNames ? 1 : 0);
        for (int r = 0; r < rowCount; ++r) {
            buff.setLength(0);
            for (int c = 0; c < model.getColumnCount(); ++c) {
                Object o = model.getValueAt(r, c);
                String s = o instanceof String ? (String)o : (o != null ? o.toString() : "null");
                if (useSmartQuotes && s != null && (s.indexOf(delim) >= 0 || s.indexOf(32) >= 0)) {
                    s = "\"" + s + "\"";
                }
                if (doEncode) {
                    buff.append(StringUtilities.encode(s, false, false));
                } else {
                    buff.append(s);
                }
                buff.append(delim);
            }
            pw.println(buff);
            String[] p = new String[]{buff.toString(), Integer.toString(offset + (r + 1))};
            this.debug(BasicUtilities.getString("ASCII_Line_Written", p));
            pw.flush();
            this.fireProgressUpdated(offset + (r + 1));
            this.checkIfCancelled();
        }
        return 1;
    }

    public String getName() {
        return BasicUtilities.getString("ASCII_Handler_Name");
    }

    public boolean isFileRequired(int mode) {
        return true;
    }

    protected void loadProperties(int mode) {
        String key = null;
        String desc = null;
        switch (mode) {
            case 1: {
                key = this.getString("ASCII_Header_Name");
                desc = this.getString("ASCII_Header_Desc");
                this.addProperty(key, null, " ", true, desc);
                key = this.getString("ASCII_IncludeCols_Name");
                desc = this.getString("ASCII_IncludeCols_Desc");
                this.addProperty(key, CHOICE_BOOLEAN, "false", false, desc);
                key = this.getString("ASCII_IncludeHead_Name");
                desc = this.getString("ASCII_IncludeHead_Desc");
                this.addProperty(key, CHOICE_BOOLEAN, "false", false, desc);
                key = this.getString("ASCII_Encode_NPC_Name");
                desc = this.getString("ASCII_Encode_NPC_Desc");
                this.addProperty(key, CHOICE_BOOLEAN, "true", false, desc);
                key = this.getString("ASCII_SmartQuotes_Name");
                desc = this.getString("ASCII_SmartQuotes_Desc");
                this.addProperty(key, CHOICE_BOOLEAN, "true", false, desc);
                key = this.getString("ASCII_Delimiter_Name");
                desc = this.getString("ASCII_Delimiter_Desc");
                this.addProperty(key, null, ",", true, desc);
                break;
            }
            case 0: {
                key = this.getString("ASCII_Delimiter_Name");
                desc = this.getString("ASCII_Delimiter_Desc");
                this.addProperty(key, null, ",", true, desc);
                key = this.getString("ASCII_Skip_Name");
                desc = this.getString("ASCII_Skip_Desc");
                this.addProperty(key, null, "0", false, desc);
                key = this.getString("ASCII_Quote_Name");
                desc = this.getString("ASCII_Quote_Desc");
                this.addProperty(key, null, "\"", false, desc);
                key = this.getString("ASCII_Comment_Name");
                desc = this.getString("ASCII_Comment_Desc");
                this.addProperty(key, null, "#", false, desc);
                key = this.getString("ASCII_1st_Row_Colums");
                desc = this.getString("ASCII_1st_Row_Desc");
                this.addProperty(key, CHOICE_BOOLEAN, "false", false, desc);
                key = this.getString("ASCII_DblTok_Name");
                desc = this.getString("ASCII_DblTok_Desc");
                this.addProperty(key, CHOICE_BOOLEAN, "false", false, desc);
                break;
            }
        }
    }
}

