/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor.compressor;

import com.googlecode.htmlcompressor.compressor.Compressor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlCompressor
implements Compressor {
    private boolean enabled = true;
    private boolean removeComments = true;
    private boolean removeIntertagSpaces = true;
    private static final String tempCdataBlock = "%%%COMPRESS~CDATA~#%%%";
    private static final Pattern cdataPattern = Pattern.compile("<!\\[CDATA\\[.*?\\]\\]>", 34);
    private static final Pattern commentPattern = Pattern.compile("<!--.*?-->", 34);
    private static final Pattern intertagPattern = Pattern.compile(">\\s+<", 34);
    private static final Pattern tagEndSpacePattern = Pattern.compile("(<(?:[^>]+?))(?:\\s+?)(/?>)", 34);
    private static final Pattern multispacePattern = Pattern.compile("\\s{2,}(?=[^<]*?>)", 34);
    private static final Pattern tagPropertyPattern = Pattern.compile("(\\s\\w+)\\s=\\s(?=[^<]*?>)", 2);
    private static final Pattern tempCdataPattern = Pattern.compile("%%%COMPRESS~CDATA~(\\d+?)%%%", 34);

    @Override
    public String compress(String xml) throws Exception {
        if (!this.enabled || xml == null || xml.length() == 0) {
            return xml;
        }
        ArrayList<String> cdataBlocks = new ArrayList<String>();
        xml = this.preserveBlocks(xml, cdataBlocks);
        xml = this.processXml(xml);
        xml = this.returnBlocks(xml, cdataBlocks);
        return xml.trim();
    }

    private String preserveBlocks(String xml, List<String> cdataBlocks) {
        Matcher matcher = cdataPattern.matcher(xml);
        int index = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            cdataBlocks.add(matcher.group(0));
            matcher.appendReplacement(sb, tempCdataBlock.replaceFirst("#", Integer.toString(index++)));
        }
        matcher.appendTail(sb);
        xml = sb.toString();
        return xml;
    }

    private String returnBlocks(String xml, List<String> cdataBlocks) {
        Matcher matcher = tempCdataPattern.matcher(xml);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, Matcher.quoteReplacement(cdataBlocks.get(Integer.parseInt(matcher.group(1)))));
        }
        matcher.appendTail(sb);
        xml = sb.toString();
        return xml;
    }

    private String processXml(String xml) throws Exception {
        if (this.removeComments) {
            xml = commentPattern.matcher(xml).replaceAll("");
        }
        if (this.removeIntertagSpaces) {
            xml = intertagPattern.matcher(xml).replaceAll("><");
        }
        xml = multispacePattern.matcher(xml).replaceAll(" ");
        xml = tagPropertyPattern.matcher(xml).replaceAll("$1=");
        xml = tagEndSpacePattern.matcher(xml).replaceAll("$1$2");
        return xml;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isRemoveComments() {
        return this.removeComments;
    }

    public void setRemoveComments(boolean removeComments) {
        this.removeComments = removeComments;
    }

    public boolean isRemoveIntertagSpaces() {
        return this.removeIntertagSpaces;
    }

    public void setRemoveIntertagSpaces(boolean removeIntertagSpaces) {
        this.removeIntertagSpaces = removeIntertagSpaces;
    }
}

