/* Copyright (C) 1994  Alex Ramos
This file is part of the HP48 C Library.

The HP48 C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License
as published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The HP48 C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Library General Public License for more details. */

#include <rom.h>

	xdef	_initscr
	xdef	_exitscr
	xdef	_clrscr
	xdef	_setpixel
	xdef	_clrpixel
	xref	___fb
	xref	___fbdisp
	xref	___gx
	xref	__detect

_initscr
	jsr	__detect		; hp48 sx or gx ?
	;
	; Initialize screenpointers for __fb
	;
	move.1	#0,p
	exg.a	c,d1
	push			; save frame-pointer
	move.ao	#___fb,a.p	; get address of frame buffer
	inc.a	a
	lsr.a	#1,a
	lsl.a	#1,a		; align to byte boundary
	move.ao	#___fbdisp,d1
	move.a	a,(d1)		; set address to __fbdisp
	move.5	#$00120,d0	; set address of display dma
	move.a	a,(d0)
	clr.a	a
	move.2	#$25,d0
	move.x	a,(d0)		; set line offset to zero
	move.2	#$00,d0
	move.1	#8,a.p
	move.1	a,(d0)		; set display on, and bit offset to zero
	move.2	#$bf,a
	move.ao	#___gx,d1
	move.b	(d1),c
	beq.b	c,0,.t0		; no GX, use default linecount
	move.2	#$1b,d0
	move.a	(d0),c
	move.a	c,d1		; get base-nibble

	move.4	#$069a,d1	; LINECOUNTg, but class cannot handle
				; whitespace, e.g: move.4 #$069A  ,d1 !!!

	move.b	(d1),c		; read linecount
	bbs	#7,c,.t0	; is DA19 set?
	move.b	#$3f,a		; - no, so do not set it.
.t0
	move.2	#$28,d0
	move.b	a,(d0)		; set line count to 64
	pop
	move.a	c,d1		; restore frame-pointer
	move.1	#7,p
	rtn

_exitscr
	exg.a	c,d1
	push			; save frame-pointer
	jsr	INITDISP
	pop
	move.a	c,d1		; restore frame-pointer
	move.1	#7,p
	rtn

_clrscr
	;
	; Description:	Clear HP48 screen.
	; Inputs:	None.
	; Outputs:	None.
	;
	move.ao	#___fbdisp,d0
	move.a	(d0),a
	move.a	a,d0
	move.1	#0,p
	move.2	#135,c	   ; The size of the display in 64-bit chunks - 1.
	move.1	#7,p
	clr.w	a
.L0
	move.w	a,(d0)
	add.a	#16,d0
	dec.b	c
	bcc	.L0
	rtn


__findpix
	;
	; Description:	Find location and bitmask of pixel on screen.
	; Inputs:   	B.b = x-coordinate; R0.b = y-coordinate
	; Outputs:  	A.a = nibble address; B.1 = pixel bitmask
	;
	move.ao	#___fbdisp,d0
	move.a	(d0),a
	move.a	a,d0
	clr.a	c
	move.b	r0,c		; zero extend r0.b -> c.a
	move.a	c,d		; d = Y
	lsl.a	#1,c		; c = Y * 2
	lsl.a	#4,d
	lsl.a	#1,d		; d = Y * 32
	add.a	d,c		; c = 34 * Y
	add.a	c,a		; a = __fbdisp + 34 * Y
	clr.a	c
	move.b	b,c		; zero extend b.b -> c.a
	clr.b	b
	inc.b	b		; b = 0001
	clr.1	#2,hst
	lsr.b	#1,c
	beq	#2,hst,.bit0zero
	lsl.b	#1,b		; b = 0010
	clr.1	#2,hst
.bit0zero
	lsr.b	#1,c		; c = X / 4
	beq	#2,hst,.bit1zero
	lsl.b	#1,b
	lsl.b	#1,b		; b = 1000 or 0100
.bit1zero
	add.a	c,a		; a = __fbdisp + 34 * Y + X / 4
	move.a	a,d0
	rtn

_setpixel
	jsr 	__findpix
	move.b	(d0),a
	or.b	b,a
	move.b	a,(d0)	
	rtn

_clrpixel
	jsr	__findpix
	move.b	(d0),a
	not.b	b
	and.b	b,a
	move.b	a,(d0)
	rtn


