
/*
 *   Implicit functions for gcc-compiled C programs for HP48. (-*-asm-*-)
 *   Copyright (C) 1994 Alex T. Ramos
 *
 * This file is part of the HP48 C Library, which is part of hp48xgcc.
 *
 * hp48xgcc is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * hp48xgcc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with hp48xgcc; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *

 * Stack frame layout:
 * 	function arguments	<--- Incoming SP
 *	old frame pointer : 5
 *	return address : 5 	<--- Final FP
 *	local variables		<--- Final SP
 */
	
#	include "rom.h"

	xdef ___prologue
	xdef ___epilogue
	xdef ___main
	xdef ___makestack
	xdef _exit

___prologue
	/*  Incoming:	 D0 = size of local area */
	/* 		 C is expendable, but nothing else. */
	move.a	r1,c		/* c  = incoming stack ptr */
	exg.a	d0,a		/* a  = locals size plus 10, d0 = important */
	sub.a	a,c		/* c  = final stack pointer ('a' dies) */
	exg.a	r1,c		/* c  = incoming stack ptr again, r1 = final */
	exg.a	d1,c		/* c  = incoming frame ptr, d1 = incoming sp */
	sub.a	#5,d1
	move.a	c,(d1)		/* write old frame ptr */
	sub.a	#5,d1
	pop			/* pop address of callee */
	move.a	c,a		/* a = start of function code */
	pop
	move.a	c,(d1)		/* write return address (of real "C" caller) */
	move.1	#7,p		/* setup 32bit-mode move.wp */
	exg.a	d0,a		/*  a = important, d0 = function address */
	exg.a	d0,c		/*  c = function address */
	jmp	c

___epilogue
	move.a	c,a		/* save return value */
	move.a	(d1),c		/* get return address */
	push
	add.a	#5,d1
	move.a	(d1),c		/* c = old frame pointer */
	add.a	#5,d1
	exg.a	d1,c		/* c = incoming stack ptr */
	move.a	c,r1
	move.a	a,c		/* restore return value */
	rtn			/* return to caller of jumper */

___main				/* do any required processing on argc/argv */
	rtn
	
__out_of_memory
	pop			/* __makestack was called with jsr */
	jsr	restore_regs
	jmp	setmemerr

___makestack

	exg.a	d0,c
	move.a	c,r2		/*  save r2 = requested stack size */

	jsr	restore_regs
	move.a	r2,c
	add.a	#10,c		/*  space for object headers */
	jsr	CREATETEMP	/*  d0 = malloc(c) */
	bcs	__out_of_memory

	/*  This whole paragraph makes the object we just allocated
	 *  look like a string. Leaving it out seems to cause some
         *  pretty weird behaviour. */ 
	move.1	#0,p
_DOCSTR	equ	DOCSTR		/* class-bug workaround */	
	move.5	#_DOCSTR,c
	move.a	c,(d0)		/* set object prologue */
	add.a	#5,d0
	move.a	r2,a		/*  restore a = stack size */
	add.a	#5,a
	move.a	a,(d0)		/*  becomes object length */
	sub.a	#5,a		/*  dont corrupt the value in A */
	add.a	#5,d0		/*  d0 = ptr to object body */
	
	exg.a	d0,c		/*  c = bottom of stack area */
	add.a	a,c		/*  c = top boundary of stack area */
	move.a	c,r1		/*  r1 = start-up stack pointer */
	move.a  c,d1		/*  set frame pointer too */
		
	/* Default value throughout execution */
	sethex
	move.1	#7,p

	/* Set mains argc and argv here (not done yet): */
	clr.wp	a
	move.wp	a,r0
	clr.wp	b
	rtn

_exit
	pop
	move.w b,a		/* a = parameter for PUSHhxsLoop */
	jsr restore_regs	/* hopefully does not corrupt A. */
	move.1	#7,p		/* Push an 8-nibble HXS. */
	jmp PUSHhxsLoop

