
#ifndef ext_compare_h
#define ext_compare_h

// #pragma interface

// we define an extended compare function, which never returns 0 (= equal)
// This implementation assumes that the class already knows a "compare"
// function.

// MAKE SURE TO DECLARE THIS FUNCTIONS's INSTANTIATION BEFORE USAGE TO ALLOW
// FOR INLINING, e.g.: extern template int ext_compare(const c *, const c *);

template <class T>
inline int ext_compare(const T * lv, const T * rv) {
	int res = lv->compare(*rv);
	if (res == 0) {
		res = (lv < rv)? -1 : 1;
	}
	return res;
}

#endif ext_compare_h

