#ifndef output_h
#define output_h

/***************************************************/
/*                                                 */
/* output.h-                                       */
/*                                                 */
/* Header file associated with HLA code generation */
/*                                                 */
/***************************************************/

#include "enums.h"
#include "symbol.h"

extern enum AsmChoice assembler;
extern int OptimizeStrings;
extern int objFmt;


extern void asmPuts( char *s );
extern void asmPutc( char c );
extern void asmCpy( char *s, int len );
int asmPrintf( char *fmtstr, ...);


#define regCode(reg) (reg & 0x7)
#define regSize(reg) (1<<(reg>>3))
#define regDup(reg) (hlastrdup2( regStrs[reg] ))
#define r8(reg) (reg)
#define r16(reg) ( 0x8 | (reg) )
#define r32(reg) ( 0x10 | (reg) ); 


enum fpregnums
{
	reg_st0,
	reg_st1,
	reg_st2,
	reg_st3,
	reg_st4,
	reg_st5,
	reg_st6,
	reg_st7,
	numFPregs
};

enum mmxregnums
{
	reg_mm0,
	reg_mm1,
	reg_mm2,
	reg_mm3,
	reg_mm4,
	reg_mm5,
	reg_mm6,
	reg_mm7,
	numMMXregs
};

enum xmmregnums
{
	reg_xmm0,
	reg_xmm1,
	reg_xmm2,
	reg_xmm3,
	reg_xmm4,
	reg_xmm5,
	reg_xmm6,
	reg_xmm7,
	numXMMregs
};

enum ctrlregnums
{
	reg_cr0,
	reg_cr1,
	reg_cr2,
	reg_cr3,
	reg_cr4,
	reg_cr5,
	reg_cr6,
	reg_cr7,
	numCTRLregs
};

enum dbgregnums
{
	reg_dr0,
	reg_dr1,
	reg_dr2,
	reg_dr3,
	reg_dr4,
	reg_dr5,
	reg_dr6,
	reg_dr7,
	numDBGregs
};

enum segregnums
{
	reg_eseg,
	reg_cseg,
	reg_sseg,
	reg_dseg,
	reg_fseg,
	reg_gseg,
	numSEGregs
};


extern void cfasmMain
( 
	char *fName, 
	char *objName, 
	void *fileBuf, 
	int fileSize,
	int verbose 
);
	
extern void processCondJump
( 
	char *instr, 
	char *target, 
	int TrueLabel, 
	int FalseLabel 
);

extern int TrueLabel;
extern int FalseLabel;

extern void callUndefSym( char *undefSym );
extern void jmpTargetID( char *sym );
extern void jmpHere( int disp );
extern void callHere( int disp );
extern void condJumpHere( char *instr );	
extern void condJumpHere2( char *instr, union YYSTYPE *adrs );	
extern void EmitModRegRm( unsigned reg, union YYSTYPE *adrs );
extern void EmitShuffleOpcode( unsigned which );
extern void EmitXshiftOpcode( unsigned which );
extern void EmitXshiftImm
( 
	unsigned which, 
	unsigned reg 
);
extern char *rtnScale( union YYSTYPE *adrs );

	
extern void EncodeAdrs
(
	union YYSTYPE *adrs,
	unsigned *modRm,
	unsigned *hasSib,
	unsigned *sib,
	unsigned *dispType,
	int *disp,
	char *dispLabel
);

extern int CheckDisp( union YYSTYPE *disp );
extern void initAdrs
( 
	struct adrsYYS *adrs,
	int				baseReg, 
	int				indexReg,
	int				scale,
	int				disp
);

extern void mergeMem( struct memYYS *dest, struct memYYS *src );


extern void call_proc( struct SymNode *proc );
extern void call_thunk( union YYSTYPE *adrs );
extern void call_mem( union YYSTYPE *adrs );

extern void cld( void );

extern void lea_rm( int theReg, union YYSTYPE *adrs );
extern void mov_or( union YYSTYPE *adrs, int theReg );
extern void mov_cr( union YYSTYPE *adrs, int theReg );
extern void mov_ir( unsigned theConst, int theReg );
extern void mov_mr( union YYSTYPE *adrs, int theReg, int size );
extern void mov_rm( int theReg, union YYSTYPE *adrs, int size );
extern void mov_rr( int srcReg, int destReg );

extern void movd_r32_mmx( int r32, int mmx );
extern void movd_mmx_r32( int mmx, int r32 );
extern void movd_mmx_m( int mmx, union YYSTYPE *adrs );
extern void movd_m_mmx( union YYSTYPE *adrs, int mmx );

extern void movsb( void );
extern void movsd( void );
extern void movsw( void );

extern void movzx_mr( union YYSTYPE *adrs, int theReg );

extern void pop_r( int theReg );
extern void popfd( void );

extern void push_mem( union YYSTYPE *adrs, int forcedSize );
extern void push_const( union YYSTYPE *constant, int forcedSize );
extern void push_offset( union YYSTYPE *offset, int forcedSize );
extern void push_r( int theReg );
extern void Pushd( unsigned d );
extern void Pushw( unsigned d );
extern void pushfd( void );
extern void pushf( void );

extern void rep_movsb( void );
extern void rep_movsd( void );
extern void rep_movsw( void );

extern void sub_ir( int theConst, int theReg );

extern void xor_rr( int src, int dest );

extern void PassValpConst( struct SymNode *sym, union YYSTYPE *value );
extern enum regnums RegStrToReg( char *reg );

void PushActualValue( union YYSTYPE *actual, char *useReg );



extern void EmitLabelledString
( 
	char *theStr, 
	char *theLabel 
);

extern void EmitImmExtern( char *theSymbol, char *labelType );


extern void EmitByteString
(
	char	*theString,
	int		zeroTerminate
);

extern void EmitWordString( char *theString );

extern void EmitBooleanExpr
( 
	struct opnodeYYS *o, 
	char *target,
	int tfjmp 
);

void FreeOperand( struct opnodeYYS *o );

extern void ComparableNodes
( 
	struct operandYYS *left, 
	struct operandYYS *right,
	char *operator
);


extern void SkeletalOutput( void );


 /*
 ** Label Emission Functions
 */

extern void EmitLabel( char *theLabel, unsigned size );
extern void EmitTypedLabel( char *theLabel, char *labelType );
extern void EmitTypedLabelNum( char *theLabel, char *labelType, int num );
extern void EmitExtern( struct SymNode *sym, unsigned size );
extern void EmitTypedExtern
( 
	struct SymNode *sym, 
	char *theSymbol, 
	char* labelType 
);
extern void EmitVMTExtern( struct SymNode *sym, char *theSymbol );
extern void EmitPublic( char *theLabel );
extern void EmitAdrs( char *theLabel );
extern void extPubIterator( outputBuf *output );


 /*
 ** Data and other Emission Functions
 */

extern void EmitDwordConst( unsigned theConst, char *comment );
extern void EmitLWordConst( void *theConst );
extern void EmitQWordConst( void *theConst );
extern void EmitWordConst( unsigned theConst );
extern void EmitByteConst( unsigned theConst );
extern void EmitReal4Const( float theConst );
extern void EmitReal8Const( double theConst );
extern void EmitReal10Const( struct flt80 theConst );
extern void EmitArrayConst( char *aType, int elements, unsigned value );
extern void EmitData( char *label, char *pseudoOp, char* Operand );

extern void EmitLword( void );
extern void EmitQword( void );
extern void EmitTbyte( void );
extern void EmitDword( void );
extern void EmitWord( void );
extern void EmitByte( void );
extern void EmitArray( char *aType, int elements );
extern void ReserveTypedStorage( struct SymNode *theType );
extern void ReserveStorage( unsigned size );

extern void EmitByteStr( char *theStr, int ZeroTerminate );

extern void EmitString( char *theStr, int theLabel );
extern void EmitWString( char *theStr, int theLabel );
extern void EmitLabeledString( char *theStr, char *theLabel );


extern char* OutName( char *StaticName, struct SymNode *Type );
extern void OutNameAndType( char *StaticName, struct SymNode *Type );
extern void OutValue
( 
	char *Name, 
	struct SymNode *Type, 
	union YYSTYPE *Value 
);
extern void OutStaticConst( struct SymNode *sym, union YYSTYPE *val );
extern int StaticConstToStr
( 
	struct SymNode *type, 
	union YYSTYPE *value, 
	char *dest 
);


extern void EmitAlign( unsigned alignment );
extern void EmitCodeAlign( unsigned alignment );
extern void StartProc( char *procname );
extern void EndProc( char *procname );
extern void AlignStack( void );
extern void AllocateLocals( unsigned localSize );
extern void StdEntry( int RoundedOffset, int NoEntry );
extern void StdExit( int StkSize, int cdeclProc, int NoLeave );
extern void IteratorExit( int StkSize );
extern void ConstructDisplay( int lexlevel, int RoundedOffset, int NoEnter );
extern void EmitStmtLbl( char *label );
extern void EmitGlobalStmtLbl( char *label );
extern void EmitStmtLblNum( char *label, int num );
extern void NewLn( void );
extern void EmitSegment( char *SegName, char *align, char *className );
extern void EndSeg( char *SegName );


 /*
 ** Backpatching functions
 */

extern void IterateBP( void );
extern void EmitBackPatchss( char *sym, char *equals );
extern void EmitBackPatchds( char *sym, int symNum, char *equals );
extern void EmitBackPatchdsc
( 
	char *sym, 
	int symNum, 
	char *equals, 
	char *comment 
);

extern void EmitBackPatchddc
( 
	char	*sym, 
	int		symNum,
	char	*equals,
	int		eqNum,
	char	*comment
);




 /*
 ** Segment output related functions
 */

extern char* DsegName;
extern char* DsegAlign;
extern char* DsegClass;
extern int   DsegUsed;

extern char* CsegName;
extern char* CsegAlign;
extern char* CsegClass;
extern int   CsegUsed;

extern char* ROsegName;
extern char* ROsegAlign;
extern char* ROsegClass;
extern int   ROsegUsed;

extern char* StrSegName;
extern char* StrSegAlign;
extern char* StrSegClass;
extern int   StrSegUsed;

extern char* BssSegName;
extern char* BssSegAlign;
extern char* BssSegClass;
extern int   BssSegUsed;

extern char  extPubName[ 256 ];
extern char  csname[ 256 ];
extern char  dataname[ 256 ];
extern char  bssname[ 256 ];
extern char  roname[ 256 ];
extern char  constname[ 256 ];


enum SegTypes { segCode, segData, segBss, segRO, segConst };

extern void PushSeg( enum SegTypes s );
extern void PopSeg( void );

extern void startDseg( void );
extern void endDseg( void );

extern void startCseg( void );
extern void endCseg( void );

extern void startROseg( void );
extern void endROseg( void );

extern void startStrSeg( void );
extern void endStrSeg( void );

extern void startBssSeg( void );
extern void endBssSeg( void );

extern void EmitDataSegments( outputBuf *dest );
extern void EmitReadonlySegments( outputBuf *dest, int codeFirst );



 /*
 ** General code generation stuff:
 */


extern void PushStaticAdrs( char *theLabel );
extern void EmitExceptionCode( int FullExceptions );
extern void BeginMain( int CurOffset );
extern void EndMain( void );


/*
** Instruction Emission
*/

extern void EmitComment( char *comment );

extern void Emit0( char *Instr );
extern void EmitRep( char *Prefix, char *Instr );

extern void Emit1L( char *Instr, char *Operand );
extern void Emit1M( char *Instr, char *Operand );
extern void Emit1R( char *Instr, char *Operand );
extern void Emit1C( char *Instr, char *Operand );

extern void Emit2rr( char *Instr, char *Op1, char *Op2 );
extern void Emit2rm( char *Instr, char *Op1, char *Op2 );
extern void Emit2mr( char *Instr, char *Op1, char *Op2 );
extern void Emit2rc( char *Instr, char *Op1, char *Op2 );
extern void Emit2mc( char *Instr, char *Op1, char *Op2 );

extern void EmitIRC( char *Instr, char *reg, union YYSTYPE *theConst );
extern void EmitIMC( char *Instr, char *mem, union YYSTYPE *theConst );

extern void Emit2cc( char *Instr, char *Op1, char *Op2 );
extern void Emit2cr( char *Instr, char *Op1, char *Op2 );

extern void Emit3rrc
( 
	char *Instr, 
	char *Op1, 
	char *Op2, 
	char *Op3 
);

extern void Emit3mrc
( 
	char *Instr, 
	char *Op1, 
	char *Op2, 
	char *Op3 
);

extern void Emit3rmc
( 
	char *Instr, 
	char *Op1, 
	char *Op2, 
	char *Op3 
);

extern void Emit3rrr
( 
	char *Instr, 
	char *Op1, 
	char *Op2, 
	char *Op3 
);

extern void Emit3mrr
( 
	char *Instr, 
	char *Op1, 
	char *Op2, 
	char *Op3 
);

extern void EmitXmit( void );

#endif
