/*

HLA Modification History:

v1.22: Started maintaining this info here (was on Webster, previously).

7/5/2000-	Corrected a problem with pass by result & val/result parameters
			in a nested function.

7/12/2000-	Modified lookup so that it allocates the lower case ID on
			the stack rather than the heap.  This cleaned up some
			unrelated (though not found yet) problems.  Also added
			a kludge to the "Anyexpr:UndefID" production; removed a
			call to "FREE2" in order to solve a prgm crash defect.

7/13/2000-	Corrected a defect in the array.index macro.  It incorrectly
			checked for an array bounds violation in standard arrays.
			Added the ability to use TYPE names and anonymous variables
			in the array compile-time functions (e.g., @Arity, @NumElements,
			and @dim).

8/3/2000-	Added #includeOnce directive to the language.

10/3/2000-	Corrected a defect dealing with forward static constant references
			in class procedures, iterators, and methods.
			Also corrected a defect when "this." was followed by an undefined
			symbol (NULL pointer error).

10/5/2000-	Fixed a defect in CopySymbols.  It was not duplicating the 
			StaticName field and this created problems with overridden
			methods during assembly (changes to the StaticName field were
			reflected in all methods that overrode the original method since
			they all shared the same static name).
			
10/10/2000-	Fixed several defects related to dangling pointers.  The
			Class code assumed that the "hidden" local symbol table entry
			for a procedure/method name had a unique StaticName field and
			this wasn't the case.  Freeing this storage created problems.

10/13/2000-	Modified ClassifyLookup routine to handle references of the
			form "this.XXXX" in compile-time functions.  Also fixed a
			defect with FORWARD variable and type declarations
			(e.g., type XXX:FORWARD(YYY);).  Previous code mistakenly
			assigned text "YYY" to XXX rather than "XXX" to YYY.
			
10/28/2000-	Added support for MMX Instructions.

11/28/2000-	Modified Namespaces to allow an extension of an existing namespace
			by simply specifying the existing namespace identifier in a new
			NAMESPACE..END block.  Corrected a problem with the ALIGN directive
			in RECORD and UNION declarations.  Also enhanced ALIGN in RECORDs
			and UNIONs: if it appears at the end of the record or union
			declaration, then HLA pads the record/union size to the next
			boundary specified by the ALIGN operand.  Also corrected a defect
			dealing with the emission of record constants when the ALIGN
			directive was present in the record definition.	 Updated the
			time.timerec and date.daterec types in the datetime.hhf module
			to include aliases for the m/d/y and h:m:s fields (to make input
			a little easier). 
			
12/2/2000	Fixed a problem with code generation when passing an indexed 
			static variable by reference.  Added GET macro to fileio namespace.
			Added fileio.append, fileio.rewind, fileio.seek, fileio.rSeek, 
			fileio.Position, fileio.copy, fileio.move, fileio.truncate,
			fileio.size, fileio.delete, fileio.cd, and fileio.gwd
			functions to the standard library.
			
***** Version 1.22 Release Occurred Here ********
			
12/8/2000	Corrected a problem with the code generation for the
			external __imp__MessageBoxA@16 declaration (used for exception
			handling).  Changed "EXTERN" to "EXTERNDEF on output so you
			don't have to link with MS' library if you're writing a DLL
			or code that links with some other language (i.e., no HLA
			main program).
			
***** Version 1.23 Release Occurred Here ********
		

12/14/2000	Added the @trace pseudo-variable to emit trace code in the
			HLA output as a sort of "poor-man's" debugging facility.
			Also cleaned up several other internal things inside HLA.
			Tweaked the GET and PUT macros in fileio. stdout, and stdin
			so that they do not emit trace calls in the macro expansion.

12/24/2000	Completed BITS module in the standard library and added it
			to the build.

			
***** Version 1.24 Release Occurred Here ********

12/29/2000	Corrected problems with some MMX instructions (EMMS crashed
			and instrs did not support anonymous memory references).

12/30/2000	Added untyped pass by reference parameters (var x:var).  Moved
			?abstract exception handler out of main code (automatically
			generated by the compiler) and placed it in its own library
			routine (to allow user modification).  Modified the compiler
			so that it doesn't automatically emit exception handling
			code.  All the exception handling routines were added to the
			HLA Standard Library.  Added the @exceptions pseudo-variable
			to control the emission of the exception handling code (if
			@exceptions is true, HLA calls the full exception handling
			package in the library, if false, HLA calls a minimal, truncated
			version).  The work with exceptions was done to allow the user
			to write their own exception handling code.  Fixed a problem
			with memory corruption when executing CMP( anonmem, &pointerconst);
			Modified the PEA instruction to emit better code.

1/1/2001	Corrected a defect in the compilation of anonymous memory objects
			passed as VAR parameters to a procedure. Added SEGMENT declaration
			section.

1/2/2001	Added #code, #static, #readonly, #storage, and #const directives
			to let the user rename the HLA segments.  Modified the compiler
			to output ".link" files and modified HLA.C to use the .link files
			(they contain segment definitions).  Did some internal clean up
			of the code.

1/3/2001	Got rid of anonymous union fields in datetime.hhf records.
			Changed segment names to _TEXT, _DATA, _BSS, readonly, and
			CONST.  Mapped _TEXT to .text, _data to .data, _BSS to .bss,
			and CONST to .data during link.  Changed segment alignment
			to PARA.  Add "-m" option to HLA (create map file).

1/4/2001	Removed PEA and SET (extended syntax) instructions.


1/6/2001,
1/7/2001	Reorganized the HLAPARSE.BSN file, removing more than 30,000
			lines of code (without any significant feature loss).  Modified
			the build to allow more stack space at run-time. Modified the
			parsing of the string instructions.  Changed SETcc and Jcc
			instruction parsing.				

***** Version 1.25 Release Occurred Here ********

2/1/2001	
	*	Rewrote the boolean expression parser for HLA HLL statements.
	*	Added Conjunction (AND), Disjunction (OR), and NOT (!) operators.
	*	Modified the compiler to emit data and external/public declarations
		to separate files that the assembler can include during the
		assembly phase.  
	*	Changed the output segment declarations to use
		the "simplified segment directives" by default (to improve
			compatibility with other languages).  
	*	Began moving code generation statements from the Bison file to 
		the "output.c" file in hopes of localizing the code generation 
		to make it easier to emit code for other assemblers.  
	*	Added the TASM compatible output mode to HLA's code generator.  
	*	Corrected a defect dealing with duplicate symbols in the static 
		section that were declared to be arrays.
	*	Corrected several problems with passing parameters (especially
		constant array parameters).  
	*	Improved the efficiency of several parameter code generation 
		sequences.  
	*	Eliminated several code generation sequences that would yield 
		operands like "dword ptr (byte ptr xxxx)" in hopes of improving 
		portability to other assemblers.  
	*	Removed a pair of extraneous pops from the u16ToStr function.  
	*	Completely redid the command line processing for HLA.EXE and 
		HLAPARSE.EXE (many new command line options were added).  
	*	Modified the compiler to emit PUSHD and PUSHW instructions only 
		with constant operands.  
	*	Began modifying the compiler to emit "<type> ptr" before all 
		memory operands (even if not strictly necessary).  
	*	Corrected a defect that erroneously produced an error if a 
		local symbol was spelled the same as a global symbol except for 
		alphabetic case.
	*	Also corrected a defect dealing with errorneous errors if a
		record/union field was spelled the same as a global symbol
		except for case.
	*	Corrected a defect associated with local/global symbol name
		conflict (case neutrality) between the parameters of an
		externally declared procedure that was defined locally and
		a global symbol.  
	*	Corrected a defect associated with the output of string objects 
		in record constants.  
	*	Modified exception handler's call to MessageBox so that the window 
		is always topmost.  
	*	Added a "constant folding" optimization on strings: HLA now only 
		emits a single copy of each unique string to the *.consts.inc file.  
	*	Improved code generation when passing small array constants as 
		parameters.
	*	Started code generation for GAS and NASM assemblers.
	*	Added CDECL, PASCAL, and STDCALL options to procedures.
	*	Modified compile-time uns8, uns16, byte, and word
		functions to clear the H.O. bits of their operand.
	*	Modified the compile time int8 and int16 instructions to
		set the H.O. bits of their operand if they are negative or
		clear the H.O. bits if they are positive.
	*	Added anonymous records to unions.
	*	Added support for "readonly undefID: pointer to userType; external;"
	*	Added support for "readonly undefID: pointer to builtinType; external;"
	*	Eliminated the DATA declaration section (use NOSTORAGE option on
		declarations in the STATIC section instead).
	*	Replaced "long double" operations in C with calls to a real80 floating
		point package written in assembly to allow portability to other
		compilers (e.g., VC++ and GCC).
	*	Corrected a defect with the comparison of two static constants
		(e.g., " &xyz = &xyz ") that didn't take into account the fact
		that HLA generates different internal names for each instance
		of the same static constant.
	*	Changed "=" to "==" when checking for EOS in the @WSorEOS function.
		Ditto in @WSthenEOS.
	*	Corrected the fact that HLA v1.25 did not report an error when
		you used an expression like << if(strvar = "" ) then >>
		which should be illegal (string constants are memory objects).
	*	Corrected a defect in @peekWS - it was not returning the proper
		extracted string. Ditto for @EOS.
	*	Made several corrections in the program where the code assumed
		that "isdigit" returned 0 or 1 (it returns 0/not 0).
	*	Corrected a defect in counting lines in the #text..#endtext section.
	*	Eliminated a spurious "PRINTF" from matchmemfunc.
	*	Removed @memory pattern matching function (because it was never
		documented, it didn't work properly, and it was a lot of code).
	*	Removed *isexpr for the same reasons as above.
	*	Corrected a defect in the @IsMem function (it was erroneously
		calling FreeAdrs).
	*	Corrected a defect that caused a seg fault when attempting to
		call the thunk associated with a pass by name or lazy evaluation
		parameter.
	*	Corrected a problem when attempting to call an pass by name or
		pass by lazy parameter using an index after the name.
	*	Corrected the problem with calling procedure pointers within a
		class (was indexing off EDI rather than ESI).
	*	Fixed a defect that caused a seg fault when attempting to call
		a procedure pointer that was a class member with an index
		attached to it.
	*	Corrected a system crash that occurs when the code attempts to
		call certain non-procedure objects.
	*	Corrected a defect when calling a procedure indirectly through
		a variable declared with a type name.  The procedure type had
		a parameter list.  The code was not using the proper pointer to
		the procedure list in the symbol table.
	*	Fixed a crash that occurs when calling a class procedure when
		using instruction composition.
	*	Corrected a problem with the BOUND instruction complaining about
	    a range error when the range was fine.
	*	Moved BOUND instruction constant output from the ReadOnly segment
		to the constants segment.
	*	Corrected a problem with checking for the bounds of a character
		value in a character set constant with a range of characters.
	*	Corrected a defect with the addressing modes "[reg][const]",
		"[reg+reg*n][const]", and "[reg][reg*n][const]".
	*	Corrected a segment fault that occured when passing parameters
		to a class procedure that doesn't exist.
	*	Modified emitted labels to use a "$" prefix rather than a "?"
		prefix (to help with Gas compatibility).
	*	Corrected a defect in the @Class compile-time function (it was
		not returning the class of the correct symbol).
	*	Corrected a defect in the @size function when computing the size
		of an object involving type coercion.
	*	Corrected a crash that occurred when attempting to use @typename
		on a register.
	*	Fixed a type for tstralloc in the memory.hhf header file.
	*	Corrected a defect in fdlcw to allow anonymous memory operands.
	*	Corrected a problem with pat.zeroOrMorePat, pat.oneOrMorePat,
		and pat.pattern that prevented them from setting up EBX to properly
		extract their strings.
	*	Corrected pat.zeroOrMorePat, pat.oneOrMorePat, and pat.pattern
		so that they actually work (changed their syntax to use multi-part
		macros, too).
	*	Added bSize, wSize, dSize, and qSize functions to the standard
		library.
	*	Corrected a defect in u8ToStr that caused it to modify the value
		of EDX on return.
	*	Added -D (define) command line option.

***** Version 1.26 Release Occurred Here ********

***** Skipped Version 1.27 because I accidentally released version 1.26
		with the v1.27 version number ******


7/21/2001
	*	Corrected bad spelling of putcSize procedure (was putcsize).

7/22/2001
	*	Corrected problem with underscore output in conv.dToStr procedure.
	*	Corrected fputq to use the proper field width if underscores is true.
	*	Corrected problem with underscore output in conv.qToStr procedure.
	*	Added "fill" and "size" parameters to fputtb call.
	*	Corrected problem with underscore output in conv.tbToStr procedure.

7/24/2001

	*	Fixed a problem that caused a crash when attempting to use a
		pointer to a record type (rather than the record type) in
		a type coercion operation.

	*	Fixed the output of an array of pointers initialized with the 
		NULL constant.

	*	Corrected a code generation problem that occurred when passing a 
		pointer as a var parameter and the base type of the pointer did 
		not match the base type of the var parameter.

7/28/2001
	
	*	Modified error message for "missing colon" to suggest that the
		cause might be an undefined identifier.

9/12/2001

	*	Modified HLA.C to put quotes around user-supplied filenames in
		command line arguments to handle the case where the pathnames
		contained interior spaces.

***** Version 1.28 Release Occurred Here ********

9/28/2001

	*	Corrected a defect in fileio.pute80 (it was pushing too many
		parameters in the call to conv.e80ToStr).
	*	Added str.index2/str.rindex2 functions to the standard library.
	*	Added str.chpos2/str.rchpos2 functions to the standard library.
	*	Modified prototypes for string comparisons to use "AL" as the
		RETURNS value rather than EAX (for use in boolean expressions).
	*	Modified the compiler to handle filenames that contain paths to
		a file (removed the paths from the "include" directive emitted
		by the compiler).
	*	Added str.prefix/str.prefix2 functions to the standard library.

9/29/2001

	*	Added a check for NULL pointers to the cs.strToCset function.
	*	Added a cs.strToCset2 procedure to the standard library.
	*	Added a check for NULL pointers to the cs.removeStr function.
	*	Added a cs.removeStr2 function to the standard library.
	*	Added a check for NULL pointers to the cs.unionStr function.
	*	Added a cs.unionStr2 function to the standard library.
	*	Modified prototype for str.init to pass byte array as an
		untyped VAR parameter rather than BYTE.
	*	Added conv._bsize function and modified the conv.bsize function
		to take a BYTE parameter.
	*	Added conv._wsize function and modified the conv.wsize function
		to take a WORD parameter.
	*	Added conv._dsize function and modified the conv.dsize function
		to take a DWORD parameter.
	*	Added conv._i8size function and modified the conv.i8size function
		to take an int8 parameter.
	*	Added conv._i16size function and modified the conv.i16size function
		to take an int16 parameter.
	*	Added conv._i32size function and modified the conv.i32size function
		to take an int32 parameter.
	*	Added conv._u8size function and modified the conv.u8size function
		to take an uns8 parameter.
	*	Added conv._u16size function and modified the conv.u16size function
		to take an uns16 parameter.
	*	Added conv._u32size function and modified the conv.u32size function
		to take an uns32 parameter.
	*	Modified HLA.c to use only the ".link" file of the first ".HLA"
		source file appearing on the command line.

***** Version 1.29 Release Occurred Here ********

9/29/2001

	*	Corrected an error in the "USAGE" message output of hla.c.

11/03/2001

	*	Corrected a defect associated with using INHERITS in records and
		classes (couldn't refer to types outside the record during the
		record's declaration).  Corrected by duplicating inherited fields
		rather than just linking.
	*	Added the OVERRIDES keyword to override inherited field declarations
		in the current record or class.

***** Version 1.30 Release Occurred Here ********

11/04/2001

	* 	Corrected a defect dealing with nested anonymous records and unions.
	*	Allowed pointer constants as operands of user-defined pointer types
		in static and readonly sections, e.g.,

			ptrType  &ptrConst

12/04/2001
	*	Corrected a defect with Case Neutrality and updated several standard
		library and example program names that failed case neutrality.
		Probably reintroduced the defect the changes in HLA v1.25 attempted
		to correct, but that was a smaller problem.

	*	Implemented a different solution to catch case-neutrality errors.

12/05/2001
	*	Corrected an assertion fault that occurred when attempting to
		access a field of a symbol that doesn't have any fields.

12/07/2001
	*	Corrected a problem with the computation of field offsets in anonymous
		records and unions.

	*	Corrected a couple of defects with the way ALIGN worked in anonymous
		records and unions.

12/08/2001
         	*	Corrected a problem with operator precedence in memory index
		expressions.  Previously, [ebx-a+b] was calculated as [ebx-(a+b)].
		Modified it to correctly compute it as [ebx + (-a) + b].

	*	Corrected a major defect in the str.cat standard library procedure
		(it was copying too much data when concatenating strings).

02/12/2002

	*	Modified str.substr and str.a_substr so that they properly zero-
		terminated the strings they extract.

	*	Modified prototypes for str.tokenize and str.tokenize2 so that they
		use an untyped variable type for the destination array.

02/13/2002

	*	Corrected a defect that crashed HLA when passing an untyped VAR
		parameter as a parameter that is also an untyped var parameter.
		
02/16/2002

	*	Added "frame", "display", "alignstack", and "use" procedure options.
		Added #frame, #noframe, #display, #nodisplay, #alignstack, and
		#nostackalign directives.  Added code to support "use" option and
		optimize certain parameter passing code sequences.
		
	*	Modified "call <id>;" so that it allows undefined statement labels.
	
	*	Added "label" declaration section to support forward referenced
		statement labels.
		
	*	Changed "noalignstk" to "noalignstack"
		
02/17/2002

	*	Corrected a problem with macro parameter/local symbol lookup.
	
	*	Cleaned up parameters to hundreds of function calls to allow
		compilation with GCC (preparation for port to Linux).
		
02/20/2002

	*	Corrected a defect in the way the exception handler record
		was built on the stack (affected coroutine operation).

	*	PUSHD( &mem );  compiled incorrectly, fixed this.
	
02/21/2002

	*	Changed display, alignstack, frame, and use to @display,
		@alignstack, etc.  Added @noalignstack, @nodisplay, etc.
		(left original reserved words, though they are depreciated).
		Also added @cdecl, @pascal, and @stdcall.
		
	*	Added #openwrite, #write, #closewrite, #openread, and #closeread
		compile-time statements and the @read compile-time function.
		
	*	Added #enter, #noenter, #leave, and #noleave directives.  Also
		added @enter, @noenter, @leave, and @noleave procedure options.
		
03/07/2002

	*	Added "@{ numset }" numeric set for creating dword values
		as a set of bits.
		
	*	Certain static array declarations with initializers weren't
		checking to make sure the array constant had the same number
		of elements as the declaration.  Corrected this defect.
		
	*	When there was a previous (external/forward) array declaration,
		the code did not check to make sure the number of elements
		were the same in the declaration and the definition.
		
	*	Cleaned up the source code a little bit (merged common code).
	
03/08/2002

	*	Modified type checking to allow the assignment of an array
		of pointers to a dword array.
		
	*	Modified HLL.HHF's SWITCH definition to specify the proper
		number of array elements in the jump table for the SWITCH
		statement.
		
	*	Corrected a defect in _utoEvars.hla (numeric to English
		conversion tables).
		
	*	Modified type checking to allow pointers and dwords to be
		compatible.
		
	*	Corrected a type error in the str.strvar macro (strings.hhf).
	
	
03/09/2002

	*	Fixed a problem with compile time functions that allowed
		built-in type names as parameters (used to fail if inside
		a namespace).
		
	*	Corrected some problems with namespace symbol table searches.


***** Version 1.32 Release Occurred Here ********
(note that 1.31 was an interim release)

03/15/2002

	*	Fixed a size computation that produced the wrong value
		when computing the size of an array that had been previously
		declared as external.
		
	*	Modified definitions for NULL and NIL in memory.hhf so that
		they were of type DWORD rather than uns32 (to be compatible
		with pointer types).
		
	*	Corrected a defect in the code generation for the "elseif"
		statement (bad target label emission).

03/17/2002

	*	Fixed a code generation problem with "intmul( mem, reg);"
	
	
03/20/2002

	*	Corrected a bug that crashed HLA if you passed an intermediate
		variable by reference without a base register.  This fix
		also corrected a few other problems that occurred when there
		were errors passing a parameter to a procedure.
		
	*	Modified assertion macro to emit filename and line number
		when an assertion fails.
		
03/22/2002

	*	Changed macro->#macro, keyword->#keyword, terminator->#terminator,
		and endmacro->#endmacro.  Eliminated nodisplay, noframe, noenter,
		noleave, nostackalign, nostorage, use, display, etc. (must now 
		use the options @nodisplay, @nostorage, @noframe, etc.).
		
	*	Updated existing library and example code to eliminate references
		to the eliminated reserved words (above).
		
	*	Corrected a code generation problem in "elseif(#{ stmts }#) then..."
		(was generating a bad label).
		
	*	Corrected a bad external name (link problem) in the coroutines
		package.
		
	*	Corrected code generation for pointers in the BSS segment.
	
	*	Fixed a problem with LEA code generation.
	
	*	Corrected a problem with comment emmission to the output file.
	
03/23/2002

	*	Did a range check on the upper and lower bounds of boolean
		expressions of the form "reg in lower..upper" and
		"reg not in lower..upper"
		
03/27/2002

	*	HLA was not parsing MMX Shift instructions correctly.
		Corrected HLA so that it now handles immediate shift
		constants correctly and does not allow a memory
		operand as the shift count.
		
	*	Dropped the requirement of a semicolon (";") after
		the #endmacro to make #endmacro more in line with
		other compile-time statements (note that you can
		still put a semicolon there because semicolons are
		optional in the declaration section).
		
	*	Added "external" clause to label declarations.
	
03/28/2002

	*	Corrected a problem with the processing of procedure
		parameters (crashed when certain types weren't correct;
		also had problems dealing with anonymous procedure
		parameter declarations).
		
03/29/2002

	*	Added support for the following instructions:
			arpl, clts, cmpxchg8b, hlt, invd, invlpg, lar,
			lds/les/lfs/lgs/lss (32-bit versions only),
			lidt, lgdt, lldt, lock.add, lock.adc, lock.and,
			lock.btc, lock.btr, lock.bts, lock.cmpxchg,
			lock.dec, lock.inc, lock.neg, lock.not, lock.or,
			lock.sbb, lock.sub, lock.xor, lock.xadd, and lock.xchg
			
		Note: LMSW and SMSW are obsolete 286 instructions and
		were left out of the above set 'by design.'
		
03/30/2002

	*	Added support for the following instructions:
			lsl, mov w/segregs
			
03/31/2002
	
	*	Added support for the following instructions:
			push segregs, rdmsr, rdpmc, rsm, sgdt, sidt,
			sldt, str, ud2, verr, verw, and wbinvd. 
			
04/01/2002

	*	Added support for addressing modes of the forms:
			[reg32*scale], [reg32*scale+disp], and
			[reg32*scale][disp]  (these modes are mainly
		useful in conjunction with the LEA instruction.
			
04/06/2002

	*	Removed #display/#nodisplay, #alignstack/#noalignstack,
		#frame/#noframe, #enter/#noenter, and #leave/#noleave
		statements and replaced them by the use of the compile-
		time variables @display, @nodisplay, @alignstack,
		@noalignstack, @frame, @noframe, @enter, @noenter,
		@leave, and @noleave.


***** Version 1.33 Release Occurred Here ********

04/10/2002
	
	*	Corrected a problem with #ASM..#ENDASM not working properly
		in macros and #while loops.
		
04/11/2002

	*	Corrected a problem with the use of int32 values in array
		indexes in the compile-time language.
		
04/16/2002

	*	Corrected a defect in namespaces (wasn't properly checking
		for forward pointer references).
		
	*	Added @returns, @forward, @external, and @align as synonyms
		for returns, forward, external, and align in preparation
		for eliminating the non-@ identifiers later on.
		
	*	Added @locals function that returns fieldnames and local
		names for records, unions, and procedures/methods/iterators.

	*	Corrected a problem with forward referenced pointers spanning
		namespace declarations.	
		
	*	Added filename field to RefListType so HLA could print the
		filename along with the line number when a forward pointer
		isn't resolved (the line number can be in a different file
		when the error message is finally displayed).
		
	*	Removed support for ID`suffix symbols since "`" is used for
		a different purpose in HLA v2.0.
		
04/17/2002

	*	Added field alignment option to records.
	
04/19/2002

	*	Added lex level support to records and unions to eliminate
		a problem that occured when a nested record/union had a fieldname
		that was the same as the nesting record/union.
		
	*	Corrected a problem with the @locals function and records/unions
		(was listing fieldnames in the reverse order).
		
	*	Added '+=' and '-=' operators to compile-time language.


***** Version 1.34 Release Occurred Here ********

04/22/2002
	
	*	Record constant parsing wasn't correctly reporting some
		type errors.  Corrected this.
		
	*	#print was printing byte, word, dword, etc., as decimal.
		Corrected this.
		
	*	Added the ability to assign an arbitrary pointer constant
		to a string field of a record constant.
		
	*	Complete workover (just short of a complete rewrite) of
		the record and union code in the compiler.  HLA v1.34
		changes broke a few things and the 1.34 modifications also
		exposed a *ton* of problems in the prior code.  Hopefully,
		these changes have taken care of most of the problems.
		Major changes included handling negative starting offsets
		better, handling the alignment directives better, and
		properly counting fields better.
		
04/23/2002

	*	Added the ability to support record alignment and initial
		offset assignment in the same declaration ( e.g.,
		x:record[4:4] :=4;)
		
	*	Added the ability to specify record alignment option in
		an anonymous record nested within a union.
		
	*	Eliminated the ability to create bare enumeration objects
		inside a record (e.g., x:record e:enum{a,b,c}; endrecord;)
		This was problematic because the enum constants became fields
		of the record and this creates problems down the road. It would
		have been a *big* pain to move the enum constants out of the
		record's field list, so I decided to drop this feature since
		it *never* gets used anyway (one can always create the enum
		type external to the record and make the field that enum type).
		
	*	Added str.constant macro to the HLA Standard Library.
	
***** Version 1.35 Release Occurred Here ********

04/23/2002
	
	*	Added @string:0 token to allow the initialization of NULL strings.
	
04/24/2002

	*	Removed @string:0 and replaced it with the more generic NULL token
		(useful for all pointer types, not just strings).  Removed the
		declarations for NULL and NILL from the memory.hhf header file.
		Also cleaned up a lot of code to avoid printing "offset" or
		"offset32" (assembler-dependent) when specifying the NULL
		pointer as an operand (worked fine before, but just to be
		safe...).
		
	*	Added @parms compile-time function that returns the number
		of parameter bytes for it's procedure operand.
		
	*	Changed @locals to @localsyms (given @parms above, @locals
		suggests that it returns the number of bytes of local variables).
		
	*	Corrected a (serious) defect where HLA was miscalculating the
		offsets of less-than-dword typed parameters.
	
04/29/2002

	*	Corrected a bug in the CMOVcc( mem,reg) instruction (wasn't
		comparing operand sizes properly).
		
04/30/2002

	*	Floating point instructions of the form "fadd()", "fsub()",
		"fmul()" etc were broken (required "faddp()", "subp()", "fmulp()",
		etc.).  Corrected this problem.	
	
05/01/2002
	
	*	Corrected a problem with @matchIntConst, @matchRealConst, and
		@matchNumericConst dealing with strings that did not end with
		the numeric value being checked.
		
05/02/2002

	*	Procedure pointer types were not correctly storing
		parameter/local variable information in the symbol table.  This
		caused an assertion failure when creating instances of the
		procedure types.  Corrected this problem.
		
05/04/2002

	*	Modified trim, a_trim, delspace, and a_delspace to remove tabs
		as well as spaces.

	
	***** Version 1.37 Release Occurred Here ********

05/08/2002

	*	Eliminated "copyright" message from HLA.EXE (since this is a
		public domain program).
		
	*	Merged the ReadOnly and Const sections into the .text section
		in order to reduce EXE file size under Windows (this was
		already the case under Linux).
		
05/09/2002

	*	Corrected a defect with passing large parameters by value
		(calculated parameter size incorrectly).
		
05/10/2002

	*	Fixed several defects related to the declarations of
		labels in the label section.  Also corrected lots of
		problems with external labels.
		
	*	Corrected a defect concerning inherited fields in a record.
	
	*	A few memory,const instructions weren't checking the memory
		operand size to verify it was 8, 16, or 32 bits.  Corrected
		this.
		
05/14/2002

	*	Added the @basereg pseudo-variable that lets a programmer
		set the base register used for automatic (VAR) variables.
		(Default is EBP, only allows EBP and ESP.)
		
	*	Corrected a defect in the "var := expr;" declaration (offset
		seemed to get stuck on the value of expr).

	*	In record alignment syntax ("[max:min]") if the minimum value
		was greater than the maximum value, the code wasn't properly
		swapping the values.  Corrected this.
		
	*	In VAR section, a dcl of the form "p:pointer to procedure abc;"
		did not calculate the offset of the pointer variable properly.
		Corrected this.
		
	*	Completely reworked the alignment options in the VAR section.
		Now they match the syntax and semantics of the alignment/offset
		assignment for records.
		
	*	Corrected a problem with constant div and mod operators.  They
		were not allowing 64-bit or 128-bit operands.
		
	*	Corrected a defect in CoerceArrays that was overwriting symbol
		table information and causing type checking to fail.
		
05/15/2002

	*	Put in checks for decimal, binary, and hexadecimal overflow
		when processing numeric literal constants.
		
	*	HLA was using the wrong "size" field when determining how
		many dwords to push for a constant actual parameter.  Corrected
		this.
		
	*	HLA was computing the size of a constant array element incorrectly.
		Corrected this.
		
05/17/2002

	*	Corrected a problem concerning the linenumber maintanence
		in the #while loop.
		
	*	Allowed the use of any 16-byte or 8-byte value where
		LWord or QWord parameters are specified.
		
	*	Corrected code emission for initialized LWord objects
	
	*	Modified HLA to allow hex types to be passed as reference
		parameters as long as the formal parameter is the same
		size;  also allowed any parameter the same size as the
		formal parameter to be passed by reference as long as the
		formal parameter is a hex type (byte, word, dword, qword,
		lword).
		
	*	Corrected a defect whereby HLA was using the size of
		a reference parameter (four bytes) rather than the size
		of the base type to determine if it could pass a dword
		object in place of a four-byte object.
	
	*	Corrected a type checking defect (int64 == uns64 wasn't
		being handled correctly).
		
05/18/2002

	*	Added the (desparately needed) #FOR loop to the compile-time
		language. Provided three forms: #for( v := s to e ),
		#for( v := s downto e ), and #for( v in expr ).
		
05/20/2002

	*	Implemented union constants in HLA.
		

	
	***** Version 1.38 Release Occurred Here ********
	
06/03/2002

	*	Implemented a hash table lookup function when dealing
		with namespaces to speed up compilations involving
		huge namespaces (e.g., Windows and Linux dcls).
		
06/04/2002

	*	Radically reworked the symbol table search code to speed
		it up a little bit (overall performance gain in HLA was
		about 25%).
		
06/05/2002

	*	Improved diagnostic message when the user doesn't pass
		enough parameters to a macro.
		
06/21/2002

	*	Parameter type checking was computing the size of a 
		formal parameter incorrectly.  Corrected this.
		
	*	The -dID command line option didn't allow identifiers
		that contained digits.  Corrected this.
		
07/07/2002

	*	Added additional UNICODE support ( u'c' and u"sss" plus
		support for UNICODE in the constant expression evaluator).
		
	*	Added the use of the VAL keyword to specify that HLA should
		use an actual value of a reference parameter rather than
		taking the address of that actual parameter (e.g., for
		untyped reference parameters).
		
	*	Corrected a problem with code emission for floating point
		instructions involving integer operands (needed to output size).
		

		
	***** Version 1.39 Release Occurred Here ********
	
08/15/2002

	*	Added support for hash table lookup in namespaces to speed
		up the assembler when processing large header files (e.g.,
		Windows header files).
	
09/29/2002

	*	Corrected a problem with the WHILE statement when using the
		hybrid syntax (bad code generation because of illegal generated
		labels).
		
	*	Added the ability to use the '&' (static address-of) operator
		on class procedures, methods, and iterators.
		
10/20/2002

	*	Corrected yet another code generation problem due to the
		boolean expression "file backup" kludge in the compiler.
		
	*	Also fixed the str.eq and str.ne functions that didn't
		compute their values properly.
		

		
	***** Version 1.40 Release Occurred Here ********
	
11/28/2002

	*	Corrected a problem with bad offset computations in anonymous
		records appearing within anonymous unions.
		
	*	Corrected anonymous unions to respect the ALIGN directive
		appearing immediately before the anon union.
		
11/29/2002

	*	More work getting offsets in anonymous unions and records
		to work properly.
		
12/1/2002

	*	Took out the "@use eax;" options from the standard library
		include files (because if someone specified EAX as a parameter
		the code would break).
		
	*	Fixed _uns64Size function because it failed with 19 digit values.


		
	***** Version 1.41 Release Occurred Here ********
	
1/12/2003

	*	Fixed a minor problem with EmitExtern.  In one place in the
		code it was using a symbol's TrueName rather than its StaticName
		(generally worked fine, but...).  Also, redid the EmitExtern call
		to pass a symbol table entry rather than a string (now uses the
		StaticName field for the string).
		
	*	Added code to emit extern/externdef declarations only if there is
		a reference to the symbol in the code (because some assemblers, like
		FASM, will tell the linker to link in some code containing an extrn
		symbol, even if you never reference the symbol).
		
1/15/2003

	*	Eliminated a couple of references to the "strings" and "cseg"
		sections in the exception handling code that resulted in shaving
		8K off the size of the .EXE file.
		
2/1/2003

	*	Modified several standard library routines to correct defects.
		Allowed the use of EOF (as documented) to terminate numeric
		input values.  Corrected a bug in fileio.gwd (wasn't saving path
		length properly and didn't calculate string overflow properly).
	
	*	Incorporated corrections to frewind, fposition, fseek, frseek,
		and feoln in the Linux version of these library functions as
		as submitted by Mark de Wever.
		
2/4/2003

	*	Corrected a defect in @typename.  It was not outputting
		"pointer to <type>" for pointer types.

2/12/2003

	*	Fixed a type checking problem.  Previously, HLA allowed you to
		(incorrectly) call a procedure field of a record via a pointer
		variable to that record object.
		
	*	Corrected a problem with the LEA( reg, const <constant> ); stmt.
	
	*	Noted the following defect: pointer to a type in a namespace, e.g.,
		pointer to w.SomeType, fails because lookup isn't aware of the
		use of the w namespace.  Can't fix this in current design. Work-around
		is to create a pointer type within the namespace.
		
2/18/2003

	*	Modified VAL operator in actual parameter list to allow the passing
		of some constant for a STRING parameter (passed by value).  Modified
		the LoadIcon prototype in use32.hhf to specify a string name rather
		than a dword as the icon name parameter.
		
2/21/2003

	*	Corrected a defect with the output of a procedure pointer constant
		type (wasn't outputting anything).

	***** Version 1.41 Release Occurred Here ********
	
3/19/2003

	*	Corrected a problem with the hlatemp environment variable.
		Added a "\" to the end of the path if one wasn't supplied in
		the environment string.
		
	*	Modified hla.exe to create a ????._link_ file with all the linker
		command line options because under WinXP the linker wasn't executing
		properly (not an HLA problem, but a workaround to a bug in BC++ or
		in windows XP).
		
	*	Corrected a problem with some code that was (accidentally) taken
		out of HLA.FLX - wasn't handling end of _initialize_ and _finalize_
		strings properly.
		
	*	Corrected a code generation problem with thunks that must have slipped
		in during development of v1.42.
		
	**** Releases 1.42..1.46 occurred in quick succession here ****
	
4/02/2003

	*	Added support for SSE/SSE2 instruction set (not complete yet!)
	
4/12/2003

	*	Corrected a defect in the @offset operator.  Supplying an undefined
		symbol crashed the assembler with an assert failure.
		
	*	HLA had a defect where it would allow the emission of two VMTs
		for a class without reporting an error (though MASM would report
		a duplicate symbol error).  Added code to track the emission of
		VMTs and emit an error if the user attempted to emit two copies
		of the same VMT.
		
	*	Extended strings to allow labels upto 64 characters in length
		in the output code.
		
4/13/2003

	*	Added ~XXXX reserved word support to the lexer;  added "reservedWords"
		array to allow the user to redefine reserved words without the "~"
		prefix.  Added #ID(xxxx) and #RW(xxxx) items to the lexer.
		
	*	Added endconst, endval, endtype, endvar, and endlabel reserved words.
	
	*	Allowed the use of endlabel, endconst, endval, endtype, endvar,
		endstatic, endstorage, and endreadonly reserved words at the end
		of one of their declaration sections within an HLA declaration section.
		
4/15/2003

	*	Added compile speed statistics to HLAPARSE when operating in verbose
		mode
		
	*	Fixed another minor problem with @offset (and undefined symbols).
	
	*	Added support for Real128 (actually done earlier, but I forgot to
		mention it).
		
	*	Fixed a problem with #FOR if the condition was false the first
		time through the loop.
		
	*	Added support to emit WSTRING and WCHAR data to the output data
		files from the STATIC and READONLY sections.
		
4/18/2003

	*	Corrected a defect when calling an indirect pointer to a procedure
		that is a static field of some class.
		
4/23/2003

	*	Change macro local symbol construction to include the local symbol's
		name to make deciphering errors involving local symbols a little
		easier.
		
	*	Corrected a defect in the construction of a #terminator local symbol
		table (it was not properly zero terminated) that prevented the use
		of global (to the macro) symbols within the macro invocation.

4/24/2003

	*	Added open-ended array declarations to const, value, "?", static,
		and readonly declarations.	
		
	*	Corrected a code generation problem dealing with the emission
		of initialized static array objects (when the base type is an
		array and you're explicitly extending the number of dimensions
		in the declaration).
		
	*	Corrected a defect in #for( x in yyy ) -- it wasn't doing a deep
		copy on the values.	
		
	***** Version 1.47 Release Occurred Here ********
	
4/28/2003

	*	Corrected a defect in an indexed call to a class' static procedure.
	
4/29/2003

	*	Corrected several minor code generation defects in parameter passing.
	
4/30/2003

	*	Added productions for "movd( mmx, reg32 );" and "movd( reg32, mmx );"
		instructions.
		
	*	Corrected an unexpected case neutrality error when a class' field
		name is the same as some local name except for case.
		
	*	Discovered bug (but cannot correct) objectName.macroname where
		macroname expands to some other method names - crashes the compiler.
		
5/02/2003

	*	Fixed a problem with #include.  If the file didn't exist, didn't
		always report an error.
		
	*	Corrected a kludge in the fileclass.hhf header file that broke
		while correcting other defects in HLA.
 
		
	***** Version 1.48 Release Occurred Here ********
	
5/10/2003

	*	Allowed the use of the VAL keyword prefix on an actual parameter
		if the actual parameter is a dword and is passed by something
		other than by value.
		
5/15/2003

	*	Modified declarations for w.FillConsoleOutputCharacter and
		w.FillConsoleOutputAttribute in kernel32.hhf.
	
	*	Changed the definitions for w.STD_INPUT_HANDLE, w.STD_OUTPUT_HANDLE,
		and w.STD_ERROR_HANDLE (they were positive values and they needed
		to be negative).
		
5/24/2003

	*	Modified stdlib routines to use os.win32 and os.linux constants
		to determine the OS (used to use definition of _win32 or _linux
		for this purpose, but the os.xxx symbols are the proper way to
		do this).
		
	*	Re-wrote the console library module to make it portable between
		Windows and Linux.
		
5/26/2003

	*	Added a fileio.flush function to the standard library.
	
6/2/2003

	*	Fixed a code generation problem with while/continue.
	
	*	Eliminated a lot of extra symbols emitted by HLA for boolean
		expressions and control structures that use them.
		
	*	Fixed a code generation with EXIT and EXITIF.
	
6/3/2003

	*	Corrected a defect in the #text..#endtext block (wasn't entering
		VAL object into the symbol table properly).
		
	*	Added the ability to supply an array of strings to the @text
		function.
	
		
	***** Version 1.49 Release Occurred Here ********
	
6/10/2003

	*	Completely reorganized the windows header files (only a single
		w.hhf header file rather than multiple header files). Reorganized
		the LINUX header files. Added @fast option to most header files
		containing namespaces.	
		
	*	Eliminated the win32.hhf header file from the Include directory
		(placed a copy in only those subdirectories where it was absolutely
		needed). The intent is to phase out this header file over time.
		
	*	Eliminated several junk files from the Include subdirectory.
	
	*	Made several changes to the Iczelion files and other example code
		that reflects the changes made to the header files.
		
	*	Changed the values in the hla.hhf header file to reflect changes
		in the enums.h header file.
		
6/12/2003
	*	Corrected a defect in the scanning of string constants that contain
		a quote character (doubled-up quote).
		
	*	Continued changes to the code generator.
	
	*** versions 1.50..1.54 occurred here ****
	
8/12/2003
	*	Corrected a problem with FreeValues that was freeing the wrong
		objects when freeing arrays that were fields of a structure.
	*	Corrected a code generation problem for arrays that were fields
		of a structure.
		
	*** Version 1.55 occurred here ***
	
8/14/2003
	*	Corrected a defect in static class procedures - was not cleaning
		up the symbol table properly before leaving.
		
8/20/2003
	*	Fixed a defect in the cs.unionstr2 stdlib procedure.
	*	Fixed a defect in the cs.removestr2 stdlib procedure.
	*	Fixed a defect in the date.datePlusMonths stdlib procedure.
	*	Fixed a defect in the date.daysbetween stdlib procedure.
	
8/22/2003
	*	Fixed a big defect in the date.datePlusDays procedure.
	
9/3/2003
	*	Corrected a bug in the conv.e80ToStr function.
	*	Made several additional changes to support the ability to
		call HLA Standard Library routines from MASM32.
		
	*** Version 1.56 occurred here ***
	
10/3/2003

	*	Corrected a defect in the processing of #ID and #RW.
	*	Added memory-mapped file support to the standard library

		
	*** Version 1.56 occurred here ***
	
10/6/2003
	
	*	Added support for ex.InPageError and ex.NoMemory in
		excepts.hhf. Corrected lack of checking for several
		Win32 exception values in hwExcept.masm	
		
10/7/2003

	*	Corrected the prototype for w.ScreenToClient in
		the w.hhf header file.
		
	*** Version 1.57 occurred here ***
	
10/13/2003
	
	*	Corrected a problem with the args module (BuildArgs under Linux)
		It was not correctly finding zero terminate strings in the cmdLn 
		string (ECX value was bad).
		
10/15/2003

	*	Corrected a problem with the Julian Date conversion in the date
		module.
		
		
	*** Version 1.58 occurred here ***
	
10/17/2003

	*	Modified OutputVMT to emit "externdef" (or comparable) statements
		for each of the entries in the VMT. This allows some class to
		inherit fields from some other class whose methods and iterators
		are not defined in the current source module.
		
10/21/2003

	*	Corrected a problem with forward reference pointers that referred
		to a class type.
		
	*	Corrected a problem with the -I option (for Linux).
	
	*	Corrected a couple of places where the EXIT statement emitted
		Windows-specific code (even under Linux).

	*	Corrected a defect in the constant-type conversion functions.
	
10/25/2003

	*	Added the "-r:responseFile" command-line option.
	*	Corrected a defect with "extern" output for VMTs in classes.
		
		
		
	*** Version 1.59 was released here ***
	
10/30/2003

	*	Fixed #write so that if an error occurs the error message is
		written to "MsgOut" rather than to the file to which #write
		is writing data.
		
	*	Modified the "-v" option to send all output to the standard
		output (rather than the default of stderr).
		
	*	Fixed a problem with the parsing of response file lines to
		eliminate leading and trailing whitespace from each response
		line.
		
	*	Eliminated a cascading error that occurs when you have an
		undefined object in a #print or #write statement.
		
	*	Modified #print error messages to include #write in the
		error messages (as #write uses the same code).
		
11/18/2003

	*	Added the ability to print array and record constants with #print.
	
11/24/2003

	*	Corrected a problem in args.hla stdlib code. Wasn't handling
		'"' correctly on the command line.
		
11/25/2003

	*	Corrected the definition for w.INFINITE in the w.hhf file.
	*	Corrected a defect in FreeValue affecting unions containing array
		constants.
	*	Corrected defects in the str.ne and str.eq functions.
	
12/1/2003

	*	Added "::" label declarations to create global labels (e.g.,
		lbl:: ).
		
12/3/2003
	
	*	Added support for FASM's new ALIGN directive.
	

	*** Version 1.60 was released here ***

12/29/2003

	* Modified all the stdlib .hhf files to avoid a small error
	  due to the use of FLEX (added a ';' after the initial #if( @defined(-))
	  statement).
	  
1/5/2004

	* Slight improvement to code generation for passing a local variable
	  or parameter by reference to some other procedure.
	  
1/14/2003

	* Fixed a problem with the use of the '&' static address operator
	  in record constants and when outputting static string constants.
	  
1/23/2004

	* Fixed a defect in the str.ieq function.
	
1/25/2004

	* Fixed a defect dealing with the use of the VAL parameter override
	  prefix and string/dword actual parameters.
	  
2/1/2004

	* Fixed a #include header file problem as required by Linux builds.
	  
2/2/2004

	* Added fileio.exists to the HLA Standard Library.
	* Corrected the spelling of several SSE instructions.
	
	*** Version 1.61 was released here ***

3/3/2004

	* Modified #include and #includeonce so that they would look for
	  an include file in the same directory as the .HLA file if the
	  include file was not found (this is done *before* looking in
	  the hlainc path).
	  
	* Added lots of code to support the freeHLA project.
	
	* Modified "usage" screen in HLA.C to display information
	  appropriate to build.
	  
3/4/2004

	* Fixed a minor code generator bug for FASM output (was emitting
	  "XLAT", FASM wants "XLATB"). Also tweaked the code output to
	  stop putting out the "codeAlign" macro (as FASM v1.51 and later
	  supports a true align directive).
	  
	* Modified HLA.C to run FASM/POLINK/PORC for the "freeHLA"
	  version of the system.
	  
	*** Version 1.63 was released here ***

5/20/2004
	
	* Fixed a problem with several of the SIMD instructions that didn't allow
	  register operands for both operands.

	*** Versions 1.64-1.65 were released here ***
	
6/18/2004
	* Added code to use the path to HLAPARSE.EXE as the default
	  root directories for the hlalib and hlainc environment variables
	  if these environment variables are undefined.
	  
	* Modified HLA to allow the use of @here as conditional jump
	  operands.
	  
	* Added an @external option to the VMT declaration to allow
	  external access to the VMT for a class.
	  
	* Corrected a defect that prevented HLA from recognizing
	  nested records when one of the nested fields was an
	  array of records.	
	  
	*** Version 1.66 was released here ***
	
6/18/2004
	* Corrected a defect in str.substr that generated an
	  exception if the destination string was at least as
	  long as the source string (only needs to be as long
	  as the substring will be).
	  
6/24/2004
	* Added "-x:filename" option to Windows version of HLA.EXE
	* Modified HLA under Linux to produce .o files and treat
	  .a files as library files.

	*** Version 1.67 was released here ***
	
7/3/2004
	* Corrected a problem with the "&" (address-of) operator
	  not recognizing symbols defined in the forward symbol
	  list (i.e., declared in a LABEL section).
	  
7/6/2004
	* Added arg.a_v, arg.a_cmdLn, arg.destroy, and arg.args to
	  the HLA standard library.
	* Corrected a defect in arg.delete (wasn't freeing storage).
	* Fixed an error in the date.toString macro in the datetime.hhf
	  header file.
	  
7/10/2004
	* Redid the fileio.eof function for Windows in yet another
	  attempt to get it right.
	  
7/12/2004
	* Fixed a problem with class methods and iterators emitting
	  an "extrn" directive in the extpub file, even though they
	  were defined in the current source file.
	  
7/20/2004
	* Modified code generator for FASM to emit "xlatb" rather
	  that "xlat" for the xlat instruction.
	
7/22/2004
	* Corrected a defect dealing with constant/val objects appearing
	  in records. They are counted as a field and in record constants
	  the field count didn't match.	
	  
7/24/2004
	* Corrected the definition of "nl" in stdio.hhf to use #$a for
	  Linux and #$d #$a for Windows
	* Fixed a bug that crashed HLA if you had a comma without a last
	  parameter in a macro parameter list.
	  

	*** Version 1.68 was released here ***
	
8/16/2004
	* Corrected a defect that crashed HLA when using a second
	  occurrence of a namespace with the @fast option.
	  
	* Rewrote the memory allocation routines for both Linux
	  and Windows in the HLA stdlib.
	  
8/17/2004
	* Added several new exceptions to the system (dealing with
	  memory management).
	
	* Added several new memory management routines, including
	  mem.zalloc, mem.stat, mem.newref, mem.getref, str.newref,
	  and str.getref.	
	  
	* Changed the behavior of mem.isInHeap. It now returns NULL
	  or the pointer to the start of the block in the heap rather
	  than just true/false.
	  
	* Modified the str.talloc macro so it could be used with
	  instruction composition.

	*** Version 1.69 was released here ***
	
8/18/2004
	* Fixed bugs in str.free and str.realloc.
	
	* strToFlt wasn't preserving EAX, fixed this.
	
8/30/2004
	* Added "FORWARD" declaration option to statement labels.
	* Fixed the use of "hlatmp" environment variable by HLAPARSE.
	

9/14/2004
	* Corrected a defect in mem.alloc (wasn't preserving EDX and ECX
	  across a call to w.VirtualAlloc).
	* Modified HLA.C to use the same environment variable for the
	  HLA temporary directory as HLAPARSE.C (hlatmp).
	* Cleaned up some linux installation documentation.	
	
	*** Version 1.70 was released here ***
	
9/20/2004
	* Corrected a syntax error in the arrays.hhf header file
	  (extra parentheses occuring in the test for floating-point
	   types)
	   
9/24/2004
	* Fixed a problem with the indexing into REAL80 arrays in
	  the arrays.hla module in the standard library.
	  
9/26/2004
	* Fixed a problem with the mem.isInHeap function.
	
10/18/2004
	* Changed FASM output to use conditional assembly to
	  "protect" extrn symbols in case the symbols weren't
	  accessed in the file.
	  
	*** Version 1.71 was released here ***
	
10/21/2004
	* Modified symbol table initialization to properly
	  include REAL80 type in the search.
	  
	* Modified several of the zstring routines in the
	  Standard Library to correct problems with access
	  bytes beyond the end of a source string (when
	  doing dword operations).
	  
	* Fixed several code generation bugs in movdq2q,
	  movss, movapd, movaps, movdqa, movdqu, movupd,
	  movups, movntdq, movntpd, movntps, cvtpd2pi, movnti,
	  and most of the other SSE/2 instructions.
	  
	* Added GLOBAL and GLOBAL2 macros to FASM output to
	  correct some duplicate symbol problems.
	  
	*** Version 1.72 was released here ***
	
12/06/2004
	* Corrected problems in error reporting for Linux versions
	  of fileio.{write, puts, putssize, putc, and putcsize}
	  
12/07/2004
	* Removed a couple of debug print statements from the lexer
	  that didn't belong in the production code.
	  
12/08/2004
	* Modified the list.itemInList iterator to preserve ESI across
	  the FOREACH loop.
	  
	* Corrected several NULL pointer problems in the compiler, particularly
	  in sections dealing with an unexpected number of parameters.
	  
	* Removed the "@fast" option from the str namespace because this
	  namespace gets manipulated in several header files (incompatible
	  with @fast operation).
	  
	* Modified the fileio.{putc, putcsize, puts, putssize, and write} routines
	  to include additional error checking (under Windows and Linux)
	  
	*** Version 1.73 was released here ***
	
01/10/2005
	* Corrected a problem in parameter parsing. Added a call to SavePosn
	  to fix problem with function calls appearing in ELSEIF generating
	  bad code.
	  
01/11/2005
	* Corrected a problem with HLA code generation for STDARG (and CDECL)
	  parameters (good old SavePosn bug).
	  
	* Fixed a problem with the Linux version of openNew (added o_trunc
	  option to clean up an existing file).
	  
01/15/2005
	* Replaced all occurrences of "malloc" with "malloc2" and eliminated
	  redundant asserts.
	  
	* Corrected a defect that allocated zero bytes when processing
	  a macros variable parameter list (allocation of zero bytes
	  returns NULL, which messed up the code).
	  
	* Replaced all occurrences of "free" with "free2"
	
	* Modified malloc2 and free2 to track heap usage, and only do an
	  actual free operation if the object passed to free2 is truly
	  on the heap.
	  
	* Cleaned up code that back-tracked the output file (for things
	  like handling boolean expressions and parameter lists). Converted
	  a ton of "cut&paste" code to subroutine calls so there was only
	  one point in the code where the backtracking needs to be maintained.
	  
	* Modified HLA.C "usage" function to request user input in the middle
	  of the output if the output is headed to the standard error device.
	  (To keep the number of lines down to a small screenful.)
	  
	* Modified the pushw and pushd instructions to emit "push word ..."
	  and "push dword ..." for constants when emitting FASM code.
	  
	*** Version 1.74 was released here ***
	
01/25/2005
	* Fixed a defect in the computation of the size of an anonymous record
	  inside an anonymous union, inside an actual record (wasn't computing
	  the record size properly).
	  
03/01/2005
	*	Fixed a defect in the case insensitive string comparisons routines
		(wrote a new stricmp routine for the HLA stdlib).
	  
03/23/2005
	*	Corrected a problem with fileio.putl. It was not preserving EBX.
	*	Modified rchpos2 so that it properly backed up one character
		before the index supplied before beginning the scan.
		
3/24/2005
	*	Fixed a problem with intmul (didn't allow 32-bit constant operands).
	*	Fixed a problem with overrides in inherited records (didn't work,
		wasn't properly inheriting the fields from the ancestor record).
	*	Cleaned up the AddFwdPtr function.
	*	Corrected the fact that PUSHD didn't allow pointer constants (&lbl).
	
4/24/2005
	*	Fixed a problem with the fileio.truncate routine under Linux
	    (had to swap parameters in a linux.lseek call).
	
	*** Version 1.76 was released here ***
	
5/7/2005
	*	Fixed a bug that allowed any size except byte objects (e.g., qword)
		in a memory-to-memory MOV instruction.
			
7/31/2005
	*	Fixed a bug in the Linux version of the BuildArgv routines (args
		module) that caused a crash because ESI was not initialized properly.
		
9/30/2005
	*	Made a quick correction to the code that outputs CDECL and STDCALL
		parameters to the ASM file to handle a recurring problem with that code.
		
		
	*** Version 1.77 was released here ***
	
10/8/2005
	*	Added @sort compile-time function.
	*	Removed ';' after several #if statements in the HLA stdlib header files
	*	Added HLA.lookupTable macro to the HLA.HHF header file
	*	Added QSDemo.hla program to examples directory
	*	Modified the switch/endswitch macro to use the new @sort function.
	
10/9/2005
	*	Modified SWITCH macro to allow use of bubble sort (for large
		case statements that have [nearly] sorted cases).
	*	Moved lookupTable macro from HLA to ARRAYs module.
		
		
	*** Version 1.78 was released here ***
	
10/31/2005
	*	Modified code generation for method calls to avoid an instruction
		of the form "lea esi, [esi+0]" whenever invoking a method indirectly
		via the ESI register.
	*	Fixed a problem with accessing static fields of a class that themselves
		have fields (e.g., static record objects within a class).
	*	Corrected a problem with the w.getWindowText and GetDlgItemText
		macros in w.hhf. 
		
11/1/2005
	*	Fixed a memory allocation bug associated with PUSHD( &symbol );
	*	Added missing VMTs to the font.hla example in the WPA folder.	
		

	*** Version 1.79 was released here ***

11/2/2005
	*	Fixed a problem with pat.oneOrMorePat in patterns.hhf
	*	Fixed a problem with tut23.hla in the Iczelion tutorials.
	*	Fixed a problem with the stdout.put macro in the stdlib.
	
11/07/2005
	*	Tweaked @ptype to return the exact ptype of an object
	*	Added @baseptype function to return the base type of an object
	*	Tweaked @typename to produce better output.	

11/09/2005
	*	Fixed rawLookup in symbol.c to properly search for field names
		of a class, record, or union within a Namespace (doesn't use only
		the hash of the global name). Previously, all identical field names
		hashed to the same symbol table entry rather than the one specific
		to the record, class, or union.

11/10/2005
	*	Added mem.realloc2 to the HLA Standard Library

11/16/2005
	*	Corrected a field in the w.hhf header file INPUT_RECORD type
		declaration (EventType must be a dword).

11/17/2005
	*	Created Windows versions of readkey, testkey, and peekKey.

1/18/3006-
	*	Fixed a bug in conv.dToStr
	*	Modified str.strRec fields to be dword rather than int32.

1/19/2006
	*	Eliminated semicolons after #includeonce in patterns.hhf,
		dtClass.hhf, and arrays.hhf

		

	*** Version 1.80 was released here ***

3/7/2006
	*	Major rewrite of the @ptype, @typename, and @baseptype functions.
	*	Cleaned up stdout.put/fileio.put macro to reflect changes to @ptype.
	*	Added @basetype function.
	*	Fixed several bugs dealing with coerced types in stdout.put and
		fileio.put.
	*	Modified @name to return an empty string for an invalid name object
		(previously, this generated an error).
	*	Create the hla._put_ and hla.put macros to support user-written
		put macros
	*	Rewrote stdout.put and fileio.put macros using the new hla.XXX macros.

3/8/2006
	*	Rewrote all the str.catXXXX routines to make the dest parameter
		the first parameter (for use by str.put)
	*	Rewrote the str.put macro. Fixed the fact that it did an
		append rather than a store.
	*	Added the str.put2 macro (appends)
	*	Fixed several bugs in various str.catXXX routines
	*	Added str.catu128, catu128Size, cati128, cati128Size, catl, and
		catlSize routines to the standard library.
	*	Added str.catr32pad, catr64pad, and catr80pad to the stdlib.
		Modified existing catr32, catr64, and catr80 functions to use
		a space as the default padding character.
	*	Modified tons of example code to compile with the new changes.


	*** Version 1.81 was released here ***

4/11/2006
	*	Corrected code generation for pusha and popa.

4/29/2006-4/30/2006
	*	Corrected code generation for pushw (signed constants outside
	    the range 0..$ffff).
	*	Modified the grammar to reject ESP as an index register.
	*	Corrected a defect in the type checking associated with sldt.
	*	Corrected a defect in the type checking associated with lsl.
	*	Swapped the operands of the  cmpXXss, cmpXXpd, cmpXXps, cmpss,
		cmppd, and cmpps instructions in order to match the syntax of 
		other HLA compare instructions.
	*	Added type checking to cmpXXss, cmpXXpd, and cmpXXps.
	*	Cleaned up grammar for the following instructions:
			movq, pshufw, cmpXXss, cmpXXpd, cmpXXps, cmpps, cmppd, cmpss
	*	Modified the following to support anonymous memory addresses:
			fbst, fbld, arpl, invlpg, lar, lds, les, lfs, lgs, lss,
			lgdt, lidt, sgdt, sidt, lldt, sldt, lsl, ltreg, streg,
			verr, verw, cmovXX, cmpxchg8b, fstcw
	*	Added support for the following instructions (including manually
		encoding the opcodes):
			fldenv, fstenv, fnstenv, fsave, fnsave, frstor, pshufd, 
			shufpd, shufps, psrldq, fisttp
	*	Manually encoded the following instructions to support MASM6:
			cmpXXpd, cmpXXps, cmpss, cmppd, cmpps, psllw, pslld, psllq,
			psrlw, psrld, psrlq, psraw, psrad

	*	Added standard support for the following instructions:
			smsw, lmsw
			
5/1/2006-5/6/2006
	*	Complete refactoring of the AnonMem and IndexAdrsMode productions
	*	Generalized the addressing modes.
	*	Refactored internal representation of registers.
	*	Improved handling of instruction composition for MMX, XXM, and
		segment registers.
	*	Corrected several minor bugs as encountered.
	*	Increased the maximum allowable stack size (link option).
	*	Modified CombineAddresses to swap the index and base registers
		if the index register is ESP, the scale is 1, and the base
		register is not ESP.
	*	Added support for LSL( reg32, reg32 );

5/7/2006
	*	Rearranged register translation table to match register encodings
	*	Worked on generic instructoin test program

5/9/2006
	*	Fixed a bug in the str.put macro (removed extra push).
	*	Modified HLA to emit the constant of "intmul( const, mem, reg);"
		as a signed integer string rather than unsigned (caused overflow
		with 16-bit operands if emitted as unsigned).

5/10/2006
	*	Modified code generator to not put out "*1" after an index register
		if the person didn't specify this in the HLA source code. This was
		done because MASM takes liberties with base/index register definitions
		if you don't explicitly provide a scale and this made testing HLA
		output difficult.

	*	Reversed the operands on the xadd instruction (they were backwards)
	
5/11/2006
	*	Fixed several $<returns>$ defects (instruction composition) appearing
		in the code.
		
	*	Added a kludge to convert 32-bit register operands for the LSL
		instruction to 16-bit registers when compiling output for FASM.

5/16/2006
	*	Modified LSL instruction to emit object code directly because of
		problems with MASM and FASM.

	*	Modified RET to allow usage without parenthesis (e.g., ret; ).

	*	Modified conditional jump instructions to allow parentheses around
		their operands (optionally).
		
5/17/2006
	*	Modified PUSHW and PUSHD to emit pushw and pushd under FASM.
	*	Cleaned up code for CALL and JMP instructions.
	*	Fixed a code generation bug in the MMX instructions with a 32-bit memory
		operand.
		
5/18/2006
	*	Added support for (or improved support for) addpd, addps, addsd, 
		addss, addsubpd, addsubps, andpd, andps, andnpd, andnps, clflush,
		prefetcht0, prefetcht1, prefetcht2, and prefetchnta. This included
		direct encoding to support MASM6.	
	*	Fixed CMPSD so it works for SSE as well as strings. Eliminated old
		cmpsdp hack (which wasn't really used).
	*	Binary encoded comisd and comiss for MASM6.
	*	Implemented (and encoded) the following conversions:
			cvtdq2pd, cvtdq2ps, cvtpd2dq, cvtpd2pi, cvtpd2ps, cvtpi2pd,
			cvtpi2ps, cvtps2dq, cvtps2pd, cvtps2pi, cvtsd2si, cvtsd2ss,
			cvtsi2sd, cvtsi2ss, cvtss2sd, cvtss2si, cvttpd2pi, cvttpd2dq,
			cvttps2dq, cvttps2pi, cvttsd2si, cvttss2si
	*	Implemented and binary encoded divss, divsd, divps, and divpd.
	*	Implemented and binary encoded haddpd, haddps, hsubpd, hsubps, lddqu,
			monitor, pause, syscall, sysenter, sysexit, sysreturn, maskmovdqu,
			movhlps, movlhps, xorpd, ucomisd, sqrtsd, subsd, unpckhpd,
			and unpcklpd.
	*	Added rsqrtps reserved word to lexer.
	*	Corrected LAR syntax to correspond to Intel's. Fixed LSL to match LAR.
	*	Fixed MOVD instruction.

5/19/2006
	*	Added support for the cmpXXsd instructions (including binary encoding)
	*	Fixed problems with MOVD and MOVQ instructions.
	*	Fixed minps.
	
5/20/2006
	*	Tracked down a memory allocation bug in boolean expressions.
	*	Cleaned up a lot of bad pointer references in the code.
	*	Fixed JMP instruction to allow all the same targets as CALL (e.g.,
		made it possible to jump to a procedure declared in a namespace).
	*	Corrected a defect with the code generation for 16-byte records,
		classes, and other 16-byte data objects.
	*	Corrected a bad pointer reference in the classification routines.

5/21/2006-5/26/2006
	*	Fixed numerous encoding problems in the new code based on the
		results from the HLA test program.

5/26/2006
	*	Fixed @global:identifier to allow dotted names.
	
6/1/2006
	*	Optimized the xxxx.put macro to speed it up considerably.
	
6/10/2006
	*	Fixed environment variable stuff under Windows to search for
		hlalib.lib and include (correctly) if the HLAINC and HLALIB
		variables are not specified.
	*	Fixed a couple of problems with the hlalibsrc/strings/makefile.linux
		makefile.
	*	Took HLA off of Visual Source Safe and placed it under Subversion
		source code control.
		
6/11/2006
	*	Modified output to not emit a displacement value of zero in
		memory addressing modes because GAS will actually emit a zero
		displacement byte if you do this.
		
6/20/2006
	*	Modified HLA to use "dword ptr" rather than "fword ptr" when emitting
	    lgdt instructions, and the like, to GAS.
	*	For various floating-point instructions output to GAS, deleted the
	    XXXX ptr operand before memory operands.

	*** Version 1.82 was released here ***
	
6/26/2006
	*	Corrected a bug in the #FOR loop. It was not properly clearing the
		upper 96 bits of the loop control variable.

	*** Version 1.83 was released here ***
	
6/28/2006
	*	Corrected a defect in the code generation of the  "[reg*scale+disp]" 
		addressing mode.
		

	*** Version 1.84 was released here ***
	
7/1/2006
	*	Corrected a but in the be_reg code that handled boolean expressions
		consisting of a single register emitted by instruction composition.

	*** Version 1.85 was released here ***
	
7/4/2006
	*	Corrected a defect in the fileio.exists function. It needed to be
		opened with sharing enabled for read/write.
		
7/10/2006
	*	Fixed a defect in the HLA.PUT macro (wasn't reporting type mismatch
	    errors properly).
		
7/12/2006
	*	Rewrote str.a_catz (it was never actually written before, it was
		just the code for str.catz).
	
7/13/2006
	*	Added instrumention to malloc/free/realloc to track down memory-related
		bugs in the HLA compiler.
		
	*	Corrected a bug where HLA was freeing some storage that was never
		allocated when processing register operands.
		
7/14/2006
	*	Corrected an issue with semicolons following #endmacro (removed the
		test for this and eliminated a "pushBackStr" call that wound up pushing
		a lot of extra junk onto the input stream.
		
	*	Eliminated an extra #endif from the end of the arrays.hhf include file.
	
	*	Corrected some memory allocation related bugs.
	
7/15/2006
	*	Completely rewrote the way macro parameters are handled.
	*	Rewrote the way macros are recorded.
	*	Eliminated several free2 calls on static storage that was not allocated
		via malloc2.
	

	*** Version 1.86 was released here ***
	
		
1/20/2007
	*	Added @system function.
	*	Added @env function.
	*	Modified -Dxxx command-line parameter to support the syntax
		-Dxxxx=yyyy to set a symbol to a string value.
	*	Added the -lib:<path> command-line parameter and fixed a problem
		with the -i:<path> command-line parameter
	  		
1/21/2007
	*	Fixed a type checking problem with the @ptype function.
	*	Added support for ZStrings throughout the code.
	*	Fixed several bugs in the w.hhf header file.
	
1/27/2007
	*	Fixed a problem with error reporting. Errors occuring in macros
		that were defined in include files weren't properly displaying
		the filename when unstacking the macro stack.
	*	Modified assembler to handle "push( edx:eax );" and "push( dx:ax );"
		(which emit two push instructions, each).
	*	Added "string <id>" option to macro parameter list.	
	*	Modified movsx and movzx to return destination register as the
		@returns value rather than the source operand.
		
1/28/2007
	*	Added support for "mov( mem64, edx:eax );", "mov( edx:eax, mem64);", and
	    "mov( constant64, edx:eax );" pseudo-instructions (these emit two mov
		instructions, each).
		
1/29/2007
	*	Improved code generation for parameter passing in the case where
		an actual parameter is a register passed as a parameter from the
		another procedure.
	*	Added the ability to pass edx:eax and dx:ax as parameters to functions.
	
2/6/2007
	*	Added the ability to specify string constants inside a cset constant
		(to streamline cset constant syntax).
		
2/12/2007
	*	Added the -level=x command-line parameter to support different language
	    levels (high, medium, low, and very low).
		
2/25/2007
	*	Added #regex macros.
	*	Added tons of pattern matching functions for use in #regex macros.
	*	Added @match and @match2 function to support pattern matching with
	    #regex macros.
	*	Added #string..#endstring block.
	*	Added #match..#endmatch block.
		
	

	*** Version 1.87 was released here ***
	
2/27/2007
	*	Corrected stricmp/strnicmp under Linux (replaced code with call
		to stdlib strcasecmp and strncasecmp functions).
		
	*	Corrected problems with @matchString and @matchiString functions
		in the regular expression interpreter.
	

	*** Version 1.88 was released here ***
	
3/1/2007
	*	Eliminated #:id feature inside #asm..#endasm block (#asm is going
		away soon, too).
		
3/2/2007
	*	Cleaned up USAGE message output for HLAPARSE.
	*	Modified HLAPARSE to default to -level=high.
	*	Fixed a problem with the -p:path command-line option.
	*	Added -LICENSE command line option (and text)
	*	Corrected a problem with the -level command-line option (HLA.EXE)
	
3/5/2007
	*	Fixed a code generation for parameters when passing the address of
		a static object in a register.
	*	Fixed a code generation bug that caused a type mismatch when emitting
	    an array of primitive types (e.g., bytes).
		
3/6/2007
	*	Modified HLAPARSE so that it no longer automatically writes a .link
		file on each compile (will create the file if it does not exist or
		if the -@@ command-line option is specified).
		
	*	Added the -@@ command line option to HLA and HLAPARSE to force the
		creation of a new .link file, even if one already exists.


	*** Version 1.89 was (sort of) released here ***
	
3/13/2007
	*	Corrected OutValue so that it would properly emit TBYTE array constants.
	
3/16/2007
	*	Fixed a problem with TASM code output. Wasn't generating code to push
	    static addresses properly.
	
	*	Changed "flat" to "FLAT" in TASM skeletal output code to prevent '/ml'
		option from generating errors.	


	*** Version 1.89 was officially released here ***
	
3/23/2007
	*	Added support for segment prefixes
	
3/24/2007
	*	Cleaned up compiler code to reduce the amount of conditional
		assembly (used run-time variables instead), so as to better
		support using the internal FASM under Windows.
		
	*	Fixed a FASM code generation bug that occured when using constants
		with floating-point instructions (e.g., fmul(2.0)).
		
3/27/2007
	*	Fixed definition of CanBeType in enums.h that broke when new types
	 	(e.g., zstring) were added.
		
3/28/2007
	*	Fixed a problem with the initialization of array element types
		for VAL objects.
		
	*	Modified FASM code generation for Linux to output correct section
		headers.
		
3/31/2007
	*	Finished off use of Internal FASM version to generate object files
		directly.
		
	*	Added -co, -cf, -cm, -ct, and -cg command-line parameters.
	


	*** Version 1.90 was released here ***
	
4/4/2007
	*	Modified doArrayList to allow an extra comma at the end of an
		array constant (cleans up a lot of array initialization using
		#for loops).
	*	Fixed an assertion when MakeCompat was called with CSET operands.
	
4/6/2007
	*	Added code to force a "/" or "\" at the end if a temporary
		path specified on the HLAPARSE command line (so HLAPARSE no longer
		requires the trailing directory suffix character).
		
	*	Cleaned up some directory separator code in HLA.EXE.
	
4/7/2007
	*	Fixed a defect in the path generation for the -obj: command-line
		parameter (didn't work right when using the internal version of
		FASM).
		
	*	Added the hlalink environment variable.
	


	*** Version 1.91 was released here ***
	
4/22/2007
	*	Corrected several defects related to #xx character 
		constants in HLA.FLX (wasn't indexing into yytext properly).
		
	*	Fixed a filename problem with HLA.C that prevented it from passing
		object file names to the linker under Linux.
	
	
	*** Version 1.92 was released here ***
	
4/27/2007
	*	Fixed a code generation problem with hybrid parameters (wasn't
	    emitting parameter code in the proper place -- wasn't properly
		restoring the start of each line after processing the hybrid
		parameter).
		
	*	Fixed a problem with the HLAPARSE -P and -OBJ parameters (couldn't
		handle command-line parameters with spaces in the paths).
		
4/28/2007
	*	Added support for wildcard characters in filenames (windows only,
		Linux has always supported this).
	
	
	*** Version 1.92 was released here ***
	
5/2/2007
	*	Fixed a problem with the default ".hla" extension in Windows (new wildcard
		code was not defaulting to ".hla" if no suffix was present).	

	
	*** Version 1.93 was released here ***
	
5/5/2007
	*	Fixed some problems with the HLAPARSE -OBJ command-line parameter
	*	Fixed some problems with the HLAPARSE -P command-line parameter.
	
5/6/2007
	*	Tracked down several bugs in hFASM (internal FASM version).
	*	Refactored some hFASM code.
	
5/7/2007
	*	Corrected a defect in hFASM (at "InstructionAssembled" label -- bad code
		appeared there).
	*	Modified the output of the public, external, and equ outputs in FASM
		in order to reduce the number of sections in the OBJ file. 
		
5/8/2007
	*	Tracked down several additional details with the "InstructionAssembled"
		problem.
	*	Fixed a problem with the HLA wildcard expansion -- passed along filenames
		that FindFirstFile couldn't expand properly (e.g., .lib files that
		don't appear in the current directory).
	*	Fixed a problem with conditional jump ranges in hFASM.	
	*	Converted a jcxz instruction to jeczx in the a_cat standard library
		routine.

	
	*** Version 1.94 was released here ***
	
5/9/2007
	*	Fixed a problem with "code" section in internal FASM under Linux.
	
	
	
	*** Version 1.94 for Linux was re-released here ***
	
	
5/11/2007
	*	Fixed several FASM code generation problems (sections).
	*	Added statement composition capabilities to many memory operands.	
		

	*** Version 1.95 was released here ***
	
5/18/2007
	*	Fixed several problems related to passing paths around on HLA
		and HLAPARSE command lines.
	*	Fixed some problems associated with internal FASM and the
		production of OBJ files rather than ASM files.
	*	Added the ability to specify full pathnames as HLA filenames.	

		

	*** Version 1.96 was released here ***
	
5/23/2007
	*	Corrected a defect in the HLAPARSE outPath variable (was freeing
		storage that was not malloc'd).
			
7/25/2007
	*	Added HLAstdlibVersion constant to hla.hhf
	
7/26/2007
	*	Corrected a defect in the "classes" table used by setClassification.
		Brought it into sync with the SymClass data type in enums.h
	
	*	Modified setClassification to properly return the symbol classification
		of a dotted name sequence.
	
	*	Modified the CoercedMemory production in hlaparse.bsn to handle
		several additional address expressions involving record/union/class
		fields and indexed expressions.
		
	*	Added "NULL" as a valid constant value for the classify production.
	
7/27/2007
	*	Added support for "@-functions" to the classify code. This allows
		testing of @pointer, @byte, @word, etc., in compile-time functions
		like @isconst and so on.
		
7/29/2007
	*	Modified PrintString in output.c so that it output string literals
		with a maximum of 64 characters per statement (MASM was complaining
		about statements being too long when outputing 256 character
		strings).
		
8/9/2007
	*	Modified PrintString in output.c to handle the case where a
		64-character string was followed by a non-graphical char
		(which resulted in a MASM syntax error when HLA emitted an empty string).
		
8/14/2007
	*	Fixed an indexing problem with the @uppercase and @lowercase CTL functions.

8/16/2007
	*	Fixed a default path problem with header files including other header files
		when the header files appear in a directory other than the cwd.
		
	*	Fixed a problem with nested coerced memory operands appearing in
		compile-time expressions.
		
	*	Fixed a bad pointer problem that occured when reassigning data to an
		array VAL object.
		
	*	Added "-code1st" command-line option and code to support it (to put the
		machine instructions before the read-only data in the source output file).
		
8/30/2007
	*	Improved code generation for certain byte parameters passed to procedures.
		If the parameter being passed was a byte parameter in an enclosing
		procedure, the code now just pushes a dword rather than going through
		the gymnastics to push a byte.
	*	Did the same thing for word parameters being passed as parameters to
		another procedure.
		
8/31/2007
	*	Corrected a code generation problem when passing a tbyte constant
		as a value parameter (was only pushing 4 bytes previously).	
		
9/10/2007
	*	Added support for classes and namespaces to @localsyms.

		

	*** Version 1.97 was released here ***
	
9/17/2007
	*	Added support for enums to @localsyms.
	
9/19/2007
	*	Corrected a defect in the classify function that prevented HLA
		from recognizing -1 or !1 as constant expressions.
		
9/21/2007
	*	Modified "PrintString" in output.c to use unsigned chars rather
		than (signed) chars, to avoid sign extension of character values
		greater than $7f.
		
9/24/2007
	*	Modified how _argv is saved under Linux.
	
9/29/2007
	*	Fixed a problem with processing record constants for objects that
		were really unions.


	*** Version 1.98 was released here ***
	
10/28/2007
	*	Corrected a problem with the output of 64-bit values to a
		GAS assembly language file.
	*	Corrected a segmentation fault occuring in strcpylc when
		it reached the end of a page.
	*	Corrected a type checking problem with enum values.
	

	*** Version 1.99 was released here ***
	
1/10/2008
	*	Fixed a problem with strcpylc accessing data beyond a
		page boundary.
	

*/

