/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.scheduler;

import groovyx.gpars.scheduler.Pool;
import groovyx.gpars.util.PoolUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultPool
implements Pool {
    private final ThreadPoolExecutor pool;
    private static final long SHUTDOWN_TIMEOUT = 30L;
    private static final AtomicLong threadCount = new AtomicLong(0L);

    public DefaultPool() {
        this(true);
    }

    public DefaultPool(boolean daemon) {
        this(daemon, PoolUtils.retrieveDefaultPoolSize());
    }

    public DefaultPool(boolean daemon, int poolSize) {
        PoolUtils.checkValidPoolSize(poolSize);
        this.pool = DefaultPool.createPool(daemon, poolSize);
    }

    public DefaultPool(ThreadPoolExecutor pool) {
        this.pool = pool;
    }

    private static ThreadPoolExecutor createPool(final boolean daemon, int poolSize) {
        assert (poolSize > 0);
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(poolSize, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, DefaultPool.createThreadName());
                thread.setDaemon(daemon);
                thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    public void uncaughtException(Thread t, Throwable e) {
                        System.err.println("Uncaught exception occurred in actor pool " + t.getName());
                        e.printStackTrace(System.err);
                    }
                });
                return thread;
            }
        });
    }

    protected static String createThreadName() {
        return "Actor Thread " + threadCount.incrementAndGet();
    }

    public final void resize(int poolSize) {
        PoolUtils.checkValidPoolSize(poolSize);
        this.pool.setCorePoolSize(poolSize);
    }

    public final void resetDefaultSize() {
        this.resize(PoolUtils.retrieveDefaultPoolSize());
    }

    public int getPoolSize() {
        return this.pool.getPoolSize();
    }

    public final void execute(Runnable task) {
        this.pool.execute(task);
    }

    public final ExecutorService getExecutorService() {
        return this.pool;
    }

    public final void shutdown() {
        this.pool.shutdown();
        try {
            this.pool.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }
}

