/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.remote;

import groovyx.gpars.remote.LocalHost;
import groovyx.gpars.remote.LocalNode;
import groovyx.gpars.remote.RemoteConnection;
import groovyx.gpars.remote.message.NodeConnectedMsg;
import groovyx.gpars.remote.message.NodeDisconnectedMsg;
import groovyx.gpars.serial.SerialContext;
import groovyx.gpars.serial.SerialMsg;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;

public final class RemoteHost
extends SerialContext {
    private final ArrayList<RemoteConnection> connections = new ArrayList();

    public RemoteHost(LocalHost localHost, UUID hostId) {
        super(localHost, hostId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(RemoteConnection connection) {
        ArrayList<RemoteConnection> arrayList = this.connections;
        synchronized (arrayList) {
            boolean wasConnected = this.isConnected();
            this.connections.add(connection);
            if (wasConnected != this.isConnected()) {
                Map<UUID, LocalNode> localNodes;
                Map<UUID, LocalNode> map = localNodes = ((LocalHost)this.localHost).localNodes;
                synchronized (map) {
                    for (LocalNode localNode : localNodes.values()) {
                        connection.write(new NodeConnectedMsg(localNode));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(RemoteConnection connection) {
        ArrayList<RemoteConnection> arrayList = this.connections;
        synchronized (arrayList) {
            boolean wasConnected = this.isConnected();
            this.connections.remove(connection);
            if (wasConnected != this.isConnected()) {
                // empty if block
            }
        }
    }

    public void disconnect() {
        for (RemoteConnection connection : this.connections) {
            connection.disconnect();
        }
    }

    public boolean isConnected() {
        return !this.connections.isEmpty();
    }

    public void write(SerialMsg msg) {
        msg.hostId = this.getLocalHost().getId();
        this.getConnection().write(msg);
    }

    public RemoteConnection getConnection() {
        return this.connections.get(0);
    }

    public void connect(LocalNode node) {
        this.write(new NodeConnectedMsg(node));
    }

    public void disconnect(LocalNode node) {
        this.write(new NodeDisconnectedMsg(node));
    }

    public LocalHost getLocalHost() {
        return (LocalHost)this.localHost;
    }
}

