/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.stream;

import groovy.lang.Closure;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.SyncDataflowVariable;
import groovyx.gpars.dataflow.stream.FList;
import groovyx.gpars.dataflow.stream.StreamCore;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SyncDataflowStream<T>
extends StreamCore<T> {
    private int parties;

    public SyncDataflowStream(int parties) {
        super(new SyncDataflowVariable(parties));
        this.parties = parties;
    }

    public SyncDataflowStream(int parties, Closure toBeApplied) {
        super(new SyncDataflowVariable(parties), toBeApplied);
        this.parties = parties;
    }

    private SyncDataflowStream(int parties, Collection<MessageStream> wheneverBoundListeners) {
        super(new SyncDataflowVariable(parties), wheneverBoundListeners);
        this.parties = parties;
    }

    @Override
    public FList<T> getRest() {
        if (this.rest.get() == null) {
            this.rest.compareAndSet(null, new SyncDataflowStream<T>(this.parties, (Collection<MessageStream>)this.wheneverBoundListeners));
        }
        return (FList)this.rest.get();
    }

    @Override
    protected StreamCore<T> createNewStream() {
        return new SyncDataflowStream<T>(this.parties);
    }

    @Override
    public String appendingString() {
        if (!this.first.isBound()) {
            return ", ?";
        }
        if (this.isEmptyWithRespectToSync()) {
            return "";
        }
        return ", " + this.getFirst() + this.getRest().appendingString();
    }

    public String toString() {
        if (!this.first.isBound()) {
            return "SyncDataflowStream[?]";
        }
        if (this.isEmptyWithRespectToSync()) {
            return "SyncDataflowStream[]";
        }
        return "SyncDataflowStream[" + this.getFirst() + this.getRest().appendingString() + ']';
    }

    private boolean isEmptyWithRespectToSync() {
        try {
            Object val = this.getFirstDFV().getVal(0L, TimeUnit.MILLISECONDS);
            return val == SyncDataflowStream.eos() || val == null;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted while checking the oes.", e);
        }
    }

    @Override
    public synchronized void incrementParties() {
        ++this.parties;
        ((SyncDataflowVariable)this.first).incrementParties();
    }

    @Override
    public synchronized void decrementParties() {
        if (this.parties == 0) {
            throw new IllegalArgumentException("Cannot decrease the number of parties. Already at zero.");
        }
        --this.parties;
        ((SyncDataflowVariable)this.first).decrementParties();
    }
}

