/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.expression;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import groovyx.gpars.MessagingRunnable;
import groovyx.gpars.actor.Actors;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.DataCallback;
import groovyx.gpars.dataflow.DataCallbackWithPool;
import groovyx.gpars.dataflow.Dataflow;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.dataflow.Promise;
import groovyx.gpars.dataflow.expression.DataflowComplexExpression;
import groovyx.gpars.dataflow.expression.DataflowGetPropertyExpression;
import groovyx.gpars.dataflow.expression.DataflowInvocationExpression;
import groovyx.gpars.dataflow.impl.ThenMessagingRunnable;
import groovyx.gpars.dataflow.operator.BinaryChoiceClosure;
import groovyx.gpars.dataflow.operator.ChainWithClosure;
import groovyx.gpars.dataflow.operator.ChoiceClosure;
import groovyx.gpars.dataflow.operator.FilterClosure;
import groovyx.gpars.dataflow.operator.SeparationClosure;
import groovyx.gpars.group.DefaultPGroup;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.remote.RemoteConnection;
import groovyx.gpars.remote.RemoteHost;
import groovyx.gpars.scheduler.Pool;
import groovyx.gpars.serial.SerialContext;
import groovyx.gpars.serial.SerialHandle;
import groovyx.gpars.serial.SerialMsg;
import groovyx.gpars.serial.WithSerialId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.codehaus.groovy.runtime.InvokerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataflowExpression<T>
extends WithSerialId
implements GroovyObject,
DataflowReadChannel<T> {
    private static final String ATTACHMENT = "attachment";
    private static final String RESULT = "result";
    private static final long serialVersionUID = 8961916630562820109L;
    private MetaClass metaClass = InvokerHelper.getMetaClass(this.getClass());
    protected volatile T value;
    protected final AtomicInteger state = new AtomicInteger();
    private final AtomicReference<WaitingThread> waiting = new AtomicReference();
    protected static final int S_NOT_INITIALIZED = 0;
    protected static final int S_INITIALIZING = 1;
    protected static final int S_INITIALIZED = 2;
    private static final WaitingThread dummyWaitingThread = new WaitingThread(null, null, null, null);

    protected DataflowExpression() {
        this.state.set(0);
    }

    @Override
    public final boolean isBound() {
        return this.state.get() == 2;
    }

    @Override
    public final int length() {
        return this.isBound() ? 1 : 0;
    }

    @Override
    public final void getValAsync(MessageStream callback) {
        this.getValAsync(null, callback);
    }

    @Override
    public final void getValAsync(Object attachment, MessageStream callback) {
        if (callback == null) {
            throw new NullPointerException();
        }
        WaitingThread newWaiting = null;
        while (this.state.get() != 2) {
            WaitingThread previous;
            if (newWaiting == null) {
                newWaiting = new WaitingThread(null, null, attachment, callback);
            }
            if ((previous = this.waiting.get()) == dummyWaitingThread) break;
            newWaiting.previous = previous;
            if (!this.waiting.compareAndSet(previous, newWaiting)) continue;
            return;
        }
        this.scheduleCallback(attachment, callback);
    }

    public final void join() throws InterruptedException {
        this.getVal();
    }

    public final void join(long timeout, TimeUnit units) throws InterruptedException {
        this.getVal(timeout, units);
    }

    @Override
    public T getVal() throws InterruptedException {
        WaitingThread newWaiting = null;
        while (this.state.get() != 2) {
            WaitingThread previous;
            if (newWaiting == null) {
                newWaiting = new WaitingThread(Thread.currentThread(), null, null, null);
            }
            if ((previous = this.waiting.get()) == dummyWaitingThread) break;
            newWaiting.previous = previous;
            if (!this.waiting.compareAndSet(previous, newWaiting)) continue;
            while (this.state.get() != 2) {
                LockSupport.park();
                if (!Thread.currentThread().isInterrupted()) continue;
                DataflowExpression.handleInterruption(newWaiting);
            }
            break block0;
        }
        return this.value;
    }

    @Override
    public T getVal(long timeout, TimeUnit units) throws InterruptedException {
        long endNano = System.nanoTime() + units.toNanos(timeout);
        WaitingThread newWaiting = null;
        while (this.state.get() != 2) {
            WaitingThread previous;
            if (newWaiting == null) {
                newWaiting = new WaitingThread(Thread.currentThread(), null, null, null);
            }
            if ((previous = this.waiting.get()) == dummyWaitingThread) break;
            newWaiting.previous = previous;
            if (!this.waiting.compareAndSet(previous, newWaiting)) continue;
            while (this.state.get() != 2) {
                long toWait = endNano - System.nanoTime();
                if (toWait <= 0L) {
                    newWaiting.set(true);
                    return null;
                }
                LockSupport.parkNanos(toWait);
                if (!Thread.currentThread().isInterrupted()) continue;
                DataflowExpression.handleInterruption(newWaiting);
            }
            break block0;
        }
        return this.value;
    }

    @Override
    public final DataflowExpression<T> poll() {
        if (this.isBound()) {
            return this;
        }
        return null;
    }

    private static void handleInterruption(AtomicBoolean newWaiting) throws InterruptedException {
        newWaiting.set(true);
        throw new InterruptedException();
    }

    public final void bindSafely(T value) {
        if (!this.state.compareAndSet(0, 1)) {
            return;
        }
        this.doBind(value);
    }

    public final void bind(T value) {
        if (!this.state.compareAndSet(0, 1)) {
            try {
                T boundValue = this.getVal();
                if (value == null && boundValue == null) {
                    return;
                }
                if (value != null && value.equals(boundValue)) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new IllegalStateException("A DataflowVariable can only be assigned once. Only re-assignments to an equal value are allowed.");
        }
        this.doBind(value);
    }

    public final void bindUnique(T value) {
        if (!this.state.compareAndSet(0, 1)) {
            throw new IllegalStateException("A DataflowVariable can only be assigned once. Use bind() to allow for equal values to be passed into already-bound variables.");
        }
        this.doBind(value);
    }

    private void doBind(T value) {
        this.doBindImpl(value);
        this.notifyRemote(null);
    }

    protected void doBindImpl(T value) {
        WaitingThread waitingQueue;
        this.value = value;
        this.state.set(2);
        WaitingThread currentWaiting = waitingQueue = this.waiting.getAndSet(dummyWaitingThread);
        while (currentWaiting != null) {
            if (currentWaiting.compareAndSet(false, true)) {
                if (currentWaiting.thread != null) {
                    LockSupport.unpark(currentWaiting.thread);
                } else if (currentWaiting.callback != null) {
                    this.scheduleCallback(currentWaiting.attachment, currentWaiting.callback);
                }
            }
            currentWaiting = currentWaiting.previous;
        }
    }

    public final void doBindRemote(UUID hostId, T message) {
        this.doBindImpl(message);
        this.notifyRemote(hostId);
    }

    private void notifyRemote(final UUID hostId) {
        if (this.serialHandle != null) {
            Actors.defaultActorPGroup.getThreadPool().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object sub = DataflowExpression.this.serialHandle.getSubscribers();
                    if (sub instanceof RemoteHost) {
                        RemoteHost host = (RemoteHost)sub;
                        if (hostId == null || !host.getHostId().equals(hostId)) {
                            host.write(new BindDataflow(DataflowExpression.this, DataflowExpression.this.value, host.getLocalHost().getId()));
                        }
                    }
                    if (sub instanceof List) {
                        SerialHandle serialHandle = DataflowExpression.this.serialHandle;
                        synchronized (serialHandle) {
                            for (SerialContext host : (List)sub) {
                                if (hostId != null && host.getHostId().equals(hostId)) continue;
                                host.write(new BindDataflow(DataflowExpression.this, DataflowExpression.this.value, host.getLocalHostId()));
                            }
                        }
                    }
                }
            });
        }
    }

    protected void scheduleCallback(Object attachment, MessageStream callback) {
        if (attachment == null) {
            callback.send(this.value);
        } else {
            HashMap<String, Object> message = new HashMap<String, Object>(2);
            message.put(ATTACHMENT, attachment);
            message.put(RESULT, this.value);
            callback.send(message);
        }
    }

    @Override
    public final <V> Promise<V> rightShift(Closure<V> closure) {
        return this.then(closure);
    }

    @Override
    public final <V> void whenBound(Closure<V> closure) {
        this.getValAsync(new DataCallback(closure, Dataflow.retrieveCurrentDFPGroup()));
    }

    @Override
    public <V> void whenBound(Pool pool, Closure<V> closure) {
        this.getValAsync(new DataCallbackWithPool(pool, closure));
    }

    @Override
    public final <V> void whenBound(PGroup group, Closure<V> closure) {
        this.getValAsync(new DataCallback(closure, group));
    }

    @Override
    public final void whenBound(MessageStream stream) {
        this.getValAsync(stream);
    }

    @Override
    public final <V> Promise<V> then(Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        this.whenBound(new ThenMessagingRunnable(result, closure));
        return result;
    }

    @Override
    public <V> Promise<V> then(Pool pool, Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        this.whenBound(pool, new ThenMessagingRunnable(result, closure));
        return result;
    }

    @Override
    public <V> Promise<V> then(PGroup group, Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        this.whenBound(group, new ThenMessagingRunnable(result, closure));
        return result;
    }

    @Override
    public final <V> void wheneverBound(Closure<V> closure) {
        this.whenBound(closure);
    }

    @Override
    public final void wheneverBound(MessageStream stream) {
        this.whenBound(stream);
    }

    @Override
    public final <V> DataflowReadChannel<V> chainWith(Closure<V> closure) {
        return this.chainWith(Dataflow.retrieveCurrentDFPGroup(), closure);
    }

    @Override
    public final <V> DataflowReadChannel<V> chainWith(Pool pool, Closure<V> closure) {
        return this.chainWith(new DefaultPGroup(pool), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> chainWith(PGroup group, Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        this.whenBound(group, new ThenMessagingRunnable(result, closure));
        return result;
    }

    @Override
    public <V> DataflowReadChannel<V> or(Closure<V> closure) {
        return this.chainWith(closure);
    }

    @Override
    public DataflowReadChannel<T> filter(Closure<Boolean> closure) {
        return this.chainWith(new FilterClosure(closure));
    }

    @Override
    public DataflowReadChannel<T> filter(Pool pool, Closure<Boolean> closure) {
        return this.chainWith(pool, new FilterClosure(closure));
    }

    @Override
    public DataflowReadChannel<T> filter(PGroup group, Closure<Boolean> closure) {
        return this.chainWith(group, new FilterClosure(closure));
    }

    @Override
    public void into(DataflowWriteChannel<T> target) {
        this.into(Dataflow.retrieveCurrentDFPGroup(), target);
    }

    @Override
    public void into(Pool pool, DataflowWriteChannel<T> target) {
        this.into(new DefaultPGroup(pool), target);
    }

    @Override
    public void into(PGroup group, final DataflowWriteChannel<T> target) {
        this.whenBound(new MessagingRunnable<T>(){

            @Override
            protected void doRun(T argument) {
                target.leftShift(argument);
            }
        });
    }

    @Override
    public void or(DataflowWriteChannel<T> target) {
        this.into(target);
    }

    @Override
    public void split(DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(Dataflow.retrieveCurrentDFPGroup(), target1, target2);
    }

    @Override
    public void split(Pool pool, DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(new DefaultPGroup(pool), target1, target2);
    }

    @Override
    public void split(PGroup group, DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(group, Arrays.asList(target1, target2));
    }

    @Override
    public void split(List<DataflowWriteChannel<T>> targets) {
        this.split(Dataflow.retrieveCurrentDFPGroup(), targets);
    }

    @Override
    public void split(Pool pool, List<DataflowWriteChannel<T>> targets) {
        this.split(new DefaultPGroup(pool), targets);
    }

    @Override
    public void split(PGroup group, final List<DataflowWriteChannel<T>> targets) {
        this.whenBound(new MessagingRunnable<T>(){

            @Override
            protected void doRun(T argument) {
                for (DataflowWriteChannel target : targets) {
                    target.leftShift(argument);
                }
            }
        });
    }

    @Override
    public DataflowReadChannel<T> tap(DataflowWriteChannel<T> target) {
        return this.tap(Dataflow.retrieveCurrentDFPGroup(), target);
    }

    @Override
    public DataflowReadChannel<T> tap(Pool pool, DataflowWriteChannel<T> target) {
        return this.tap(new DefaultPGroup(pool), target);
    }

    @Override
    public DataflowReadChannel<T> tap(PGroup group, final DataflowWriteChannel<T> target) {
        final DataflowVariable result = new DataflowVariable();
        this.whenBound(new MessagingRunnable<T>(){

            @Override
            protected void doRun(T argument) {
                result.leftShift(argument);
                target.leftShift(argument);
            }
        });
        return result;
    }

    @Override
    public <V> DataflowReadChannel<V> merge(DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Pool pool, DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(pool, Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(PGroup group, DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(group, Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        return this.merge(Dataflow.retrieveCurrentDFPGroup(), others, closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Pool pool, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        return this.merge((PGroup)new DefaultPGroup(pool), others, closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(PGroup group, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        ArrayList<DataflowReadChannel<Object>> inputs = new ArrayList<DataflowReadChannel<Object>>();
        inputs.add(this);
        inputs.addAll(others);
        group.operator(inputs, Arrays.asList(result), new ChainWithClosure(closure));
        return result;
    }

    @Override
    public void binaryChoice(DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        this.binaryChoice(Dataflow.retrieveCurrentDFPGroup(), trueBranch, falseBranch, code);
    }

    @Override
    public void binaryChoice(Pool pool, DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        this.binaryChoice(new DefaultPGroup(pool), trueBranch, falseBranch, code);
    }

    @Override
    public void binaryChoice(PGroup group, DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        group.operator(Arrays.asList(this), Arrays.asList(trueBranch, falseBranch), (Closure)new BinaryChoiceClosure(code));
    }

    @Override
    public void choice(List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        this.choice(Dataflow.retrieveCurrentDFPGroup(), outputs, code);
    }

    @Override
    public void choice(Pool pool, List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        this.choice(new DefaultPGroup(pool), outputs, code);
    }

    @Override
    public void choice(PGroup group, List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        group.operator(Arrays.asList(this), outputs, (Closure)new ChoiceClosure(code));
    }

    @Override
    public void separate(List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        this.separate(Dataflow.retrieveCurrentDFPGroup(), outputs, code);
    }

    @Override
    public void separate(Pool pool, List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        this.separate(new DefaultPGroup(pool), outputs, code);
    }

    @Override
    public void separate(PGroup group, List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        group.operator(Arrays.asList(this), outputs, (Closure)new SeparationClosure(code));
    }

    public static <V> DataflowExpression<V> transform(Object another, Closure closure) {
        int pnum = closure.getMaximumNumberOfParameters();
        if (pnum == 0) {
            throw new IllegalArgumentException("Closure should have parameters");
        }
        if (pnum == 1) {
            return new TransformOne(another, closure);
        }
        if (another instanceof Collection) {
            Collection collection = (Collection)another;
            if (collection.size() != pnum) {
                throw new IllegalArgumentException("Closure parameters don't match the # of arguments");
            }
            return new TransformMany(collection, closure);
        }
        throw new IllegalArgumentException("Collection expected");
    }

    protected final void subscribe() {
        DataflowExpressionsCollector listener = new DataflowExpressionsCollector();
        this.subscribe(listener);
        listener.start();
    }

    protected T evaluate() {
        return this.value;
    }

    protected void subscribe(DataflowExpressionsCollector listener) {
        listener.subscribe(this);
    }

    public final Object invokeMethod(String name, Object args) {
        if (this.getMetaClass().respondsTo((Object)this, name).isEmpty()) {
            return new DataflowInvocationExpression((Object)this, name, (Object[])args);
        }
        return InvokerHelper.invokeMethod((Object)this, (String)name, (Object)args);
    }

    public final Object getProperty(String propertyName) {
        MetaProperty metaProperty = this.getMetaClass().hasProperty((Object)this, propertyName);
        if (metaProperty != null) {
            return metaProperty.getProperty((Object)this);
        }
        return new DataflowGetPropertyExpression(this, propertyName);
    }

    public final void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public final void setProperty(String propertyName, Object newValue) {
        this.metaClass.setProperty((Object)this, propertyName, newValue);
    }

    public final MetaClass getMetaClass() {
        return this.metaClass;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(value=" + this.value + ')';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BindDataflow<T>
    extends SerialMsg {
        private static final long serialVersionUID = -8674023870562062769L;
        private final DataflowExpression<T> expr;
        private final T message;

        public BindDataflow(DataflowExpression<T> expr, T message, UUID hostId) {
            super(hostId);
            this.expr = expr;
            this.message = message;
        }

        @Override
        public void execute(RemoteConnection conn) {
            this.expr.doBindRemote(this.hostId, this.message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformMany<V>
    extends DataflowComplexExpression<V> {
        private static final long serialVersionUID = 4115456542358280855L;
        private final Closure closure;

        private TransformMany(Collection<?> collection, Closure closure) {
            super(collection.toArray());
            this.closure = closure;
            this.subscribe();
        }

        @Override
        protected V evaluate() {
            super.evaluate();
            return (V)this.closure.call(this.args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformOne<V>
    extends DataflowExpression<V> {
        private static final long serialVersionUID = 6701886501249351047L;
        Object arg;
        private final Closure closure;

        private TransformOne(Object another, Closure closure) {
            this.closure = closure;
            this.arg = another;
        }

        @Override
        protected V evaluate() {
            return (V)this.closure.call(this.arg instanceof DataflowExpression ? ((DataflowExpression)this.arg).value : this.arg);
        }

        @Override
        protected void subscribe(DataflowExpressionsCollector listener) {
            this.arg = listener.subscribe(this.arg);
        }
    }

    final class DataflowExpressionsCollector
    extends MessageStream {
        private static final long serialVersionUID = 3414942165521113575L;
        private final AtomicInteger count = new AtomicInteger(1);

        DataflowExpressionsCollector() {
        }

        public MessageStream send(Object message) {
            if (this.count.decrementAndGet() == 0) {
                DataflowExpression.this.bind(DataflowExpression.this.evaluate());
            }
            return this;
        }

        Object subscribe(Object element) {
            if (!(element instanceof DataflowExpression)) {
                return element;
            }
            DataflowExpression dataflowExpression = (DataflowExpression)element;
            if (dataflowExpression.state.get() == 2) {
                return dataflowExpression.value;
            }
            this.count.incrementAndGet();
            dataflowExpression.getValAsync(this);
            return element;
        }

        void start() {
            if (this.count.decrementAndGet() == 0) {
                DataflowExpression.this.doBind(DataflowExpression.this.evaluate());
            }
        }
    }

    private static final class WaitingThread
    extends AtomicBoolean {
        private static final long serialVersionUID = 8909974768784947460L;
        private final Thread thread;
        private volatile WaitingThread previous;
        private final MessageStream callback;
        private final Object attachment;

        private WaitingThread(Thread thread, WaitingThread previous, Object attachment, MessageStream callback) {
            this.callback = callback;
            this.attachment = attachment;
            this.thread = thread;
            this.previous = previous;
        }
    }
}

