/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow;

import groovy.lang.Closure;
import groovyx.gpars.MessagingRunnable;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.DataCallback;
import groovyx.gpars.dataflow.Dataflow;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.dataflow.impl.ResizeableCountDownLatch;
import groovyx.gpars.dataflow.operator.ChainWithClosure;
import groovyx.gpars.dataflow.operator.CopyChannelsClosure;
import groovyx.gpars.group.PGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SyncDataflowVariable<T>
extends DataflowVariable<T> {
    private static final String ERROR_READING_A_SYNCHRONOUS_CHANNEL = "Error reading a synchronous channel.";
    private final ResizeableCountDownLatch parties;

    public SyncDataflowVariable() {
        this(0);
    }

    public SyncDataflowVariable(int parties) {
        this.parties = new ResizeableCountDownLatch(parties);
    }

    @Override
    protected void doBindImpl(T value) {
        super.doBindImpl(value);
        this.awaitParties();
    }

    @Override
    public T getVal() throws InterruptedException {
        Object val = super.getVal();
        this.readerIsReady();
        return val;
    }

    @Override
    public T getVal(long timeout, TimeUnit units) throws InterruptedException {
        long start = System.nanoTime();
        long duration = units.toNanos(timeout);
        Object result = super.getVal(timeout, units);
        if (result == null) {
            if (!this.isBound()) {
                return null;
            }
            if (this.readerIsReady(duration - (System.nanoTime() - start))) {
                return this.getVal();
            }
            return null;
        }
        if (this.readerIsReady(duration - (System.nanoTime() - start))) {
            return result;
        }
        return null;
    }

    @Override
    boolean shouldThrowTimeout() {
        return super.shouldThrowTimeout() || this.awaitingParties();
    }

    public boolean awaitingParties() {
        return !this.parties.isReleasedFlag();
    }

    @Override
    public <V> DataflowReadChannel<V> chainWith(PGroup group, Closure<V> closure) {
        SyncDataflowVariable<T> result = new SyncDataflowVariable<T>();
        group.operator(this, result, new ChainWithClosure(closure));
        return result;
    }

    @Override
    public DataflowReadChannel<T> tap(PGroup group, DataflowWriteChannel<T> target) {
        SyncDataflowVariable<T> result = new SyncDataflowVariable<T>();
        group.operator(Arrays.asList(this), Arrays.asList(result, target), new ChainWithClosure(new CopyChannelsClosure()));
        return result;
    }

    @Override
    public <V> DataflowReadChannel<V> merge(PGroup group, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        SyncDataflowVariable<T> result = new SyncDataflowVariable<T>();
        ArrayList<DataflowReadChannel<Object>> inputs = new ArrayList<DataflowReadChannel<Object>>();
        inputs.add(this);
        inputs.addAll(others);
        group.operator(inputs, Arrays.asList(result), new ChainWithClosure(closure));
        return result;
    }

    @Override
    protected void scheduleCallback(Object attachment, final MessageStream callback) {
        super.scheduleCallback(attachment, new DataCallback(new MessagingRunnable(){

            protected void doRun(Object argument) {
                SyncDataflowVariable.this.readerIsReady();
                callback.send(argument);
            }
        }, Dataflow.retrieveCurrentDFPGroup()));
    }

    private void readerIsReady() {
        this.parties.countDown();
        this.awaitParties();
    }

    private void awaitParties() {
        try {
            this.parties.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(ERROR_READING_A_SYNCHRONOUS_CHANNEL, e);
        }
    }

    private boolean readerIsReady(long timeout) {
        this.parties.countDown();
        try {
            return this.parties.attemptToCountDownAndAwait(timeout);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("The thread has been interrupted while waiting.", e);
        }
    }

    public void incrementParties() {
        this.parties.increaseCount();
    }

    public void decrementParties() {
        this.parties.decreaseCount();
    }
}

