/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.actor.impl;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovyx.gpars.actor.BlockingActor;
import java.util.Arrays;
import org.codehaus.groovy.runtime.GroovyCategorySupport;
import org.codehaus.groovy.runtime.InvokerHelper;

public class RunnableBackedBlockingActor
extends BlockingActor {
    private static final long serialVersionUID = 8992135845484038961L;
    private Runnable action;

    public RunnableBackedBlockingActor(Runnable handler) {
        this.setAction(handler);
    }

    protected final void setAction(Runnable handler) {
        if (handler == null) {
            this.action = null;
        } else if (handler instanceof Closure) {
            Closure cloned = (Closure)((Closure)handler).clone();
            if (cloned.getOwner() == cloned.getDelegate()) {
                cloned.setDelegate((Object)this);
                cloned.setResolveStrategy(1);
            } else {
                cloned.setDelegate((Object)new RunnableBackedPooledActorDelegate(cloned.getDelegate(), this));
            }
            this.action = cloned;
        } else {
            this.action = handler;
        }
    }

    protected final void act() {
        if (this.action != null) {
            if (this.action instanceof Closure) {
                GroovyCategorySupport.use(Arrays.asList(new Class[0]), (Closure)((Closure)this.action));
            } else {
                this.action.run();
            }
        }
    }

    private static final class RunnableBackedPooledActorDelegate
    extends GroovyObjectSupport {
        private final Object first;
        private final Object second;

        RunnableBackedPooledActorDelegate(Object first, Object second) {
            this.first = first;
            this.second = second;
        }

        public Object invokeMethod(String name, Object args) {
            try {
                return InvokerHelper.invokeMethod((Object)this.first, (String)name, (Object)args);
            }
            catch (MissingMethodException ignore) {
                return InvokerHelper.invokeMethod((Object)this.second, (String)name, (Object)args);
            }
        }

        public Object getProperty(String property) {
            try {
                return InvokerHelper.getProperty((Object)this.first, (String)property);
            }
            catch (MissingPropertyException ignore) {
                return InvokerHelper.getProperty((Object)this.second, (String)property);
            }
        }

        public void setProperty(String property, Object newValue) {
            try {
                InvokerHelper.setProperty((Object)this.first, (String)property, (Object)newValue);
            }
            catch (MissingPropertyException ignore) {
                InvokerHelper.setProperty((Object)this.second, (String)property, (Object)newValue);
            }
        }
    }
}

