/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.actor;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.time.BaseDuration;
import groovyx.gpars.GParsConfig;
import groovyx.gpars.MessagingRunnable;
import groovyx.gpars.actor.ActorMessage;
import groovyx.gpars.actor.Actors;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.DataCallback;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.Promise;
import groovyx.gpars.dataflow.expression.DataflowExpression;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.remote.RemoteConnection;
import groovyx.gpars.remote.RemoteHost;
import groovyx.gpars.serial.DefaultRemoteHandle;
import groovyx.gpars.serial.RemoteHandle;
import groovyx.gpars.serial.RemoteSerialized;
import groovyx.gpars.serial.SerialContext;
import groovyx.gpars.serial.SerialHandle;
import groovyx.gpars.serial.SerialMsg;
import groovyx.gpars.serial.WithSerialId;
import groovyx.gpars.util.GeneralTimer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.runtime.InvokerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Actor
extends MessageStream {
    private static final ThreadLocal<Actor> currentActorPerThread = new ThreadLocal();
    private static final long serialVersionUID = -3491276479442857422L;
    public static final String CANNOT_SEND_REPLIES_NO_SENDER_HAS_BEEN_REGISTERED = "Cannot send replies. No sender has been registered.";
    private final DataflowExpression<Object> joinLatch;
    protected volatile PGroup parallelGroup;
    protected static final ActorMessage START_MESSAGE = new ActorMessage("Start", null);
    protected static final ActorMessage STOP_MESSAGE = new ActorMessage("STOP_MESSAGE", null);
    protected static final ActorMessage TERMINATE_MESSAGE = new ActorMessage("TERMINATE_MESSAGE", null);
    private static final String AFTER_START = "afterStart";
    private static final String RESPONDS_TO = "respondsTo";
    private static final String ON_DELIVERY_ERROR = "onDeliveryError";
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];
    public static final String TIMEOUT = "TIMEOUT";
    protected static final ActorMessage TIMEOUT_MESSAGE = new ActorMessage("TIMEOUT", null);
    private volatile Closure onStop = null;
    protected volatile Thread currentThread;
    protected static final String ACTOR_HAS_ALREADY_BEEN_STARTED = "Actor has already been started.";
    protected static final GeneralTimer timer = GParsConfig.retrieveDefaultTimer("GPars Actor Timer", true);

    protected Actor() {
        this(new DataflowVariable<Object>());
    }

    protected Actor(DataflowExpression<Object> joinLatch) {
        this(joinLatch, Actors.defaultActorPGroup);
    }

    protected Actor(DataflowExpression<Object> joinLatch, PGroup parallelGroup) {
        this.joinLatch = joinLatch;
        this.parallelGroup = parallelGroup;
    }

    public final PGroup getParallelGroup() {
        return this.parallelGroup;
    }

    public void setParallelGroup(PGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Cannot set actor's group to null.");
        }
        this.parallelGroup = group;
    }

    public final <T> MessageStream sendAndContinue(T message, Closure closure) {
        closure = (Closure)closure.clone();
        closure.setDelegate((Object)this);
        closure.setResolveStrategy(1);
        return this.send(message, new DataCallback(closure, this.parallelGroup));
    }

    public final <T> Promise<Object> sendAndPromise(T message) {
        final DataflowVariable<Object> result = new DataflowVariable<Object>();
        this.sendAndContinue(message, new MessagingRunnable<Object>(){

            @Override
            protected void doRun(Object argument) {
                result.leftShift(argument);
            }
        });
        return result;
    }

    public abstract Actor silentStart();

    public abstract Actor start();

    public abstract Actor stop();

    public abstract Actor terminate();

    public abstract boolean isActive();

    public final void join() throws InterruptedException {
        this.joinLatch.getVal();
    }

    public final void join(MessageStream listener) {
        this.joinLatch.getValAsync(listener);
    }

    public final void join(long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout > 0L) {
            this.joinLatch.getVal(timeout, unit);
        } else {
            this.joinLatch.getVal();
        }
    }

    public final void join(BaseDuration duration) throws InterruptedException {
        this.join(duration.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public DataflowExpression<Object> getJoinLatch() {
        return this.joinLatch;
    }

    protected static void registerCurrentActorWithThread(Actor currentActor) {
        currentActorPerThread.set(currentActor);
    }

    protected static void deregisterCurrentActorWithThread() {
        currentActorPerThread.set(null);
    }

    public static Actor threadBoundActor() {
        return currentActorPerThread.get();
    }

    protected final ActorMessage createActorMessage(Object message) {
        if (this.hasBeenStopped() && message != TERMINATE_MESSAGE && message != STOP_MESSAGE) {
            throw new IllegalStateException("The actor cannot accept messages at this point.");
        }
        ActorMessage actorMessage = message instanceof ActorMessage ? (ActorMessage)message : ActorMessage.build(message);
        return actorMessage;
    }

    protected abstract boolean hasBeenStopped();

    @Override
    protected RemoteHandle createRemoteHandle(SerialHandle handle, SerialContext host) {
        return new MyRemoteHandle(handle, host, this.joinLatch);
    }

    protected void handleStart() {
        Object list = InvokerHelper.invokeMethod((Object)this, (String)RESPONDS_TO, (Object)new Object[]{AFTER_START});
        if (list != null && !((Collection)list).isEmpty()) {
            InvokerHelper.invokeMethod((Object)this, (String)AFTER_START, (Object)EMPTY_ARGUMENTS);
        }
    }

    protected void handleTermination() {
        List<ActorMessage> queue = this.sweepQueue();
        if (this.onStop != null) {
            this.onStop.call(queue);
        }
        this.callDynamic("afterStop", new Object[]{queue});
    }

    public final void onStop(Closure onStop) {
        if (onStop != null) {
            this.onStop = (Closure)onStop.clone();
            this.onStop.setDelegate((Object)this);
            this.onStop.setResolveStrategy(1);
        }
    }

    protected void handleException(Throwable exception) {
        if (!this.callDynamic("onException", new Object[]{exception})) {
            System.err.println("An exception occurred in the Actor thread " + Thread.currentThread().getName());
            exception.printStackTrace(System.err);
        }
    }

    protected void handleInterrupt(InterruptedException exception) {
        Thread.interrupted();
        if (!this.callDynamic("onInterrupt", new Object[]{exception}) && !this.hasBeenStopped()) {
            System.err.println("The actor processing thread has been interrupted " + Thread.currentThread().getName());
            exception.printStackTrace(System.err);
        }
    }

    protected void handleTimeout() {
        this.callDynamic("onTimeout", EMPTY_ARGUMENTS);
    }

    private boolean callDynamic(String method, Object[] args) {
        MetaClass metaClass = InvokerHelper.getMetaClass((Object)this);
        List list = metaClass.respondsTo((Object)this, method);
        if (list != null && !list.isEmpty()) {
            boolean hasArgs = false;
            for (MetaMethod metaMethod : list) {
                if (metaMethod.getParameterTypes().length <= 0) continue;
                hasArgs = true;
            }
            if (hasArgs) {
                InvokerHelper.invokeMethod((Object)this, (String)method, (Object)args);
            } else {
                InvokerHelper.invokeMethod((Object)this, (String)method, (Object)EMPTY_ARGUMENTS);
            }
            return true;
        }
        return false;
    }

    protected abstract ActorMessage sweepNextMessage();

    final List<ActorMessage> sweepQueue() {
        ArrayList<ActorMessage> messages = new ArrayList<ActorMessage>();
        ActorMessage message = this.sweepNextMessage();
        while (message != null && message != STOP_MESSAGE) {
            Object senderMethodList = InvokerHelper.invokeMethod((Object)message.getSender(), (String)RESPONDS_TO, (Object)new Object[]{ON_DELIVERY_ERROR});
            if (senderMethodList != null && !((Collection)senderMethodList).isEmpty()) {
                InvokerHelper.invokeMethod((Object)message.getSender(), (String)ON_DELIVERY_ERROR, (Object)message.getPayLoad());
            } else {
                Object payloadMethodList = InvokerHelper.invokeMethod((Object)message.getPayLoad(), (String)RESPONDS_TO, (Object)new Object[]{ON_DELIVERY_ERROR});
                if (payloadMethodList != null && !((Collection)payloadMethodList).isEmpty()) {
                    InvokerHelper.invokeMethod((Object)message.getPayLoad(), (String)ON_DELIVERY_ERROR, (Object)EMPTY_ARGUMENTS);
                }
            }
            messages.add(message);
            message = this.sweepNextMessage();
        }
        return messages;
    }

    public final boolean isActorThread() {
        return Thread.currentThread() == this.currentThread;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoteActor
    extends Actor
    implements RemoteSerialized {
        private final RemoteHost remoteHost;
        private static final long serialVersionUID = -1375776678860848278L;

        public RemoteActor(SerialContext host, DataflowExpression<Object> jointLatch) {
            super(jointLatch);
            this.remoteHost = (RemoteHost)host;
        }

        @Override
        public Actor silentStart() {
            return null;
        }

        @Override
        public Actor start() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Actor stop() {
            this.remoteHost.write(new StopActorMsg(this));
            return this;
        }

        @Override
        public Actor terminate() {
            this.remoteHost.write(new TerminateActorMsg(this));
            return this;
        }

        @Override
        public boolean isActive() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected boolean hasBeenStopped() {
            return false;
        }

        @Override
        protected ActorMessage sweepNextMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageStream send(Object message) {
            if (!(message instanceof ActorMessage)) {
                message = new ActorMessage(message, Actor.threadBoundActor());
            }
            this.remoteHost.write(new MessageStream.SendTo(this, (ActorMessage)message));
            return this;
        }

        public static class TerminateActorMsg
        extends SerialMsg {
            private final Actor actor;
            private static final long serialVersionUID = -839334644951906974L;

            public TerminateActorMsg(RemoteActor remoteActor) {
                this.actor = remoteActor;
            }

            public void execute(RemoteConnection conn) {
                this.actor.terminate();
            }
        }

        public static class StopActorMsg
        extends SerialMsg {
            private final Actor actor;
            private static final long serialVersionUID = -927785591952534581L;

            public StopActorMsg(RemoteActor remoteActor) {
                this.actor = remoteActor;
            }

            public void execute(RemoteConnection conn) {
                this.actor.stop();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyRemoteHandle
    extends DefaultRemoteHandle {
        private final DataflowExpression<Object> joinLatch;
        private static final long serialVersionUID = 3721849638877039035L;

        public MyRemoteHandle(SerialHandle handle, SerialContext host, DataflowExpression<Object> joinLatch) {
            super(handle.getSerialId(), host.getHostId(), RemoteActor.class);
            this.joinLatch = joinLatch;
        }

        @Override
        protected WithSerialId createObject(SerialContext context) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            return new RemoteActor(context, this.joinLatch);
        }
    }
}

