/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.vmplugin.v7;

import groovy.lang.GString;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.vmplugin.v7.TypeHelper;

public class TypeTransformers {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle TO_STRING;
    private static final MethodHandle TO_BYTE;
    private static final MethodHandle TO_INT;
    private static final MethodHandle TO_LONG;
    private static final MethodHandle TO_SHORT;
    private static final MethodHandle TO_FLOAT;
    private static final MethodHandle TO_DOUBLE;
    private static final MethodHandle TO_BIG_INT;
    private static final MethodHandle TO_BIG_DEC;

    protected static MethodHandle addTransformer(MethodHandle handle, int pos, Object arg, Class parameter) {
        MethodHandle transformer = null;
        if (arg instanceof GString) {
            transformer = TO_STRING;
        } else if (Number.class.isAssignableFrom(parameter)) {
            transformer = TypeTransformers.selectNumberTransformer(parameter, arg);
        }
        if (transformer == null) {
            throw new GroovyBugError("Unknown transformation for argument " + arg + " at position " + pos + " with " + arg.getClass() + " for parameter of type " + parameter);
        }
        return TypeTransformers.applyUnsharpFilter(handle, pos, transformer);
    }

    public static MethodHandle applyUnsharpFilter(MethodHandle handle, int pos, MethodHandle transformer) {
        MethodType type = transformer.type();
        TypeDescriptor.OfField given = handle.type().parameterType(pos);
        if (type.returnType() != given || type.parameterType(0) != given) {
            transformer = transformer.asType(MethodType.methodType(given, type.parameterType(0)));
        }
        return MethodHandles.filterArguments(handle, pos, transformer);
    }

    private static MethodHandle selectNumberTransformer(Class param, Object arg) {
        if ((param = TypeHelper.getWrapperClass(param)) == Byte.class) {
            return TO_BYTE;
        }
        if (param == Character.class || param == Integer.class) {
            return TO_INT;
        }
        if (param == Long.class) {
            return TO_LONG;
        }
        if (param == Float.class) {
            return TO_FLOAT;
        }
        if (param == Double.class) {
            return TO_DOUBLE;
        }
        if (param == BigInteger.class) {
            return TO_BIG_INT;
        }
        if (param == BigDecimal.class) {
            return TO_BIG_DEC;
        }
        if (param == Short.class) {
            return TO_SHORT;
        }
        return null;
    }

    static {
        try {
            TO_STRING = LOOKUP.findVirtual(Object.class, "toString", MethodType.methodType(String.class));
            TO_BYTE = LOOKUP.findVirtual(Number.class, "byteValue", MethodType.methodType(Byte.TYPE));
            TO_SHORT = LOOKUP.findVirtual(Number.class, "shortValue", MethodType.methodType(Short.TYPE));
            TO_INT = LOOKUP.findVirtual(Number.class, "intValue", MethodType.methodType(Integer.TYPE));
            TO_LONG = LOOKUP.findVirtual(Number.class, "longValue", MethodType.methodType(Long.TYPE));
            TO_FLOAT = LOOKUP.findVirtual(Number.class, "floatValue", MethodType.methodType(Float.TYPE));
            TO_DOUBLE = LOOKUP.findVirtual(Number.class, "doubleValue", MethodType.methodType(Double.TYPE));
            MethodHandle tmp = LOOKUP.findConstructor(BigDecimal.class, MethodType.methodType(Void.TYPE, Double.TYPE));
            TO_BIG_DEC = MethodHandles.filterReturnValue(TO_DOUBLE, tmp);
            tmp = LOOKUP.findConstructor(BigInteger.class, MethodType.methodType(Void.TYPE, String.class));
            TO_BIG_INT = MethodHandles.filterReturnValue(TO_STRING, tmp);
        }
        catch (Exception e) {
            throw new GroovyBugError(e);
        }
    }
}

