/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.vmplugin.v7;

import groovy.lang.AdaptingMetaClass;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaClassRegistryChangeEvent;
import groovy.lang.MetaClassRegistryChangeEventListener;
import groovy.lang.MetaMethod;
import groovy.lang.MetaObjectProtocol;
import groovy.lang.MissingMethodException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.SwitchPoint;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.runtime.GroovyCategorySupport;
import org.codehaus.groovy.runtime.NullObject;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMetaMethod;
import org.codehaus.groovy.runtime.metaclass.MetaClassRegistryImpl;
import org.codehaus.groovy.runtime.metaclass.MissingMethodExecutionFailed;
import org.codehaus.groovy.runtime.metaclass.NewInstanceMetaMethod;
import org.codehaus.groovy.runtime.metaclass.ReflectionMetaMethod;
import org.codehaus.groovy.runtime.wrappers.Wrapper;
import org.codehaus.groovy.vmplugin.v7.CallInfo;
import org.codehaus.groovy.vmplugin.v7.IndyMath;
import org.codehaus.groovy.vmplugin.v7.TypeHelper;
import org.codehaus.groovy.vmplugin.v7.TypeTransformers;

public class IndyInterface {
    private static final Logger LOG = Logger.getLogger(IndyInterface.class.getName());
    private static final boolean LOG_ENABLED;
    private static final MethodHandles.Lookup LOOKUP;
    private static final MethodHandle SELECT_METHOD;
    private static final MethodType GENERAL_INVOKER_SIGNATURE;
    private static final MethodType INVOKE_METHOD_SIGNATURE;
    private static final MethodType O2O;
    private static final MethodHandle UNWRAP_METHOD;
    private static final MethodHandle SAME_MC;
    private static final MethodHandle IS_NULL;
    private static final MethodHandle IS_NOT_NULL;
    private static final MethodHandle UNWRAP_EXCEPTION;
    private static final MethodHandle SAME_CLASS;
    private static final MethodHandle META_METHOD_INVOKER;
    private static final MethodHandle GROOVY_OBJECT_INVOKER;
    private static final MethodHandle HAS_CATEGORY_IN_CURRENT_THREAD_GUARD;
    private static final MethodHandle NEGATE_BOOL;
    private static final MethodHandle NULL_REF;
    private static SwitchPoint switchPoint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void invalidateSwitchPoints() {
        if (LOG_ENABLED) {
            LOG.info("invalidating switch point");
        }
        SwitchPoint old = switchPoint;
        switchPoint = new SwitchPoint();
        Class<IndyInterface> clazz = IndyInterface.class;
        synchronized (IndyInterface.class) {
            SwitchPoint.invalidateAll(new SwitchPoint[]{old});
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static CallSite bootstrapCurrent(MethodHandles.Lookup caller, String name, MethodType type) {
        return IndyInterface.realBootstrap(caller, name, type, false, true);
    }

    public static CallSite bootstrapCurrentSafe(MethodHandles.Lookup caller, String name, MethodType type) {
        return IndyInterface.realBootstrap(caller, name, type, true, true);
    }

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type) {
        return IndyInterface.realBootstrap(caller, name, type, false, false);
    }

    public static CallSite bootstrapSafe(MethodHandles.Lookup caller, String name, MethodType type) {
        return IndyInterface.realBootstrap(caller, name, type, true, false);
    }

    private static CallSite realBootstrap(MethodHandles.Lookup caller, String name, MethodType type, boolean safe, boolean thisCall) {
        MutableCallSite mc = new MutableCallSite(type);
        MethodHandle mh = IndyInterface.makeFallBack(mc, caller.lookupClass(), name, type, safe, thisCall);
        mc.setTarget(mh);
        return mc;
    }

    private static MethodHandle makeFallBack(MutableCallSite mc, Class<?> sender, String name, MethodType type, boolean safeNavigation, boolean thisCall) {
        MethodHandle mh = MethodHandles.insertArguments(SELECT_METHOD, 0, mc, sender, name, safeNavigation, thisCall, 1);
        mh = mh.asCollector(Object[].class, type.parameterCount()).asType(type);
        return mh;
    }

    private static MetaClass getMetaClass(Object receiver) {
        if (receiver == null) {
            return NullObject.getNullObject().getMetaClass();
        }
        if (receiver instanceof GroovyObject) {
            return ((GroovyObject)receiver).getMetaClass();
        }
        return ((MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry()).getMetaClass(receiver);
    }

    private static boolean isStatic(Method m) {
        int mods = m.getModifiers();
        return (mods & 8) != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setHandleForMetaMethod(CallInfo info) {
        MetaMethod metaMethod = info.method;
        if (metaMethod instanceof NumberNumberMetaMethod) {
            if (LOG_ENABLED) {
                LOG.info("meta method is number method");
            }
            info.catchException = false;
            if (IndyMath.chooseMathMethod(info, metaMethod)) {
                if (!LOG_ENABLED) return;
                LOG.info("indy math successfull");
                return;
            }
        }
        boolean isCategoryTypeMethod = metaMethod instanceof NewInstanceMetaMethod;
        if (LOG_ENABLED) {
            LOG.info("meta method is category type method: " + isCategoryTypeMethod);
        }
        if (metaMethod instanceof ReflectionMetaMethod) {
            if (LOG_ENABLED) {
                LOG.info("meta method is reflective method");
            }
            ReflectionMetaMethod rmm = (ReflectionMetaMethod)metaMethod;
            metaMethod = rmm.getCachedMethod();
        }
        if (metaMethod instanceof CachedMethod) {
            if (LOG_ENABLED) {
                LOG.info("meta method is CachedMethod instance");
            }
            CachedMethod cm = (CachedMethod)metaMethod;
            info.isVargs = cm.isVargsMethod();
            try {
                Method m = cm.getCachedMethod();
                info.handle = LOOKUP.unreflect(m);
                if (LOG_ENABLED) {
                    LOG.info("successfully unreflected");
                }
                if (isCategoryTypeMethod || !IndyInterface.isStatic(m)) return;
                info.handle = MethodHandles.dropArguments(info.handle, 0, new Class[]{Class.class});
                return;
            }
            catch (IllegalAccessException e) {
                throw new GroovyBugError(e);
            }
        } else {
            if (info.method == null) return;
            if (LOG_ENABLED) {
                LOG.info("meta method is dgm helper");
            }
            info.handle = META_METHOD_INVOKER;
            info.handle = info.handle.bindTo(info.method);
            if (LOG_ENABLED) {
                LOG.info("bound method name to META_METHOD_INVOKER");
            }
            if (info.method.getNativeParameterTypes().length == 1 && info.args.length == 1) {
                info.handle = MethodHandles.insertArguments(info.handle, 1, new Object[]{new Object[]{null}});
                if (!LOG_ENABLED) return;
                LOG.info("null argument expansion");
                return;
            } else if (info.method.isVargsMethod()) {
                info.handle = info.handle.asCollector(Object[].class, 1);
                info.handle = info.handle.asCollector(Object[].class, info.targetType.parameterCount() - 1);
                info.currentType = MethodType.methodType(info.method.getReturnType(), info.method.getNativeParameterTypes());
                info.currentType = info.currentType.insertParameterTypes(0, info.method.getDeclaringClass().getTheClass());
                if (!LOG_ENABLED) return;
                LOG.info("wrapping vargs for dgm helper");
                return;
            } else {
                info.handle = info.handle.asCollector(Object[].class, info.targetType.parameterCount() - 1);
                info.currentType = MethodType.methodType(info.method.getReturnType(), info.method.getNativeParameterTypes());
                info.currentType = info.currentType.insertParameterTypes(0, info.method.getDeclaringClass().getTheClass());
                if (!LOG_ENABLED) return;
                LOG.info("normal dgm helper wrapping");
            }
        }
    }

    private static void chooseMethod(MetaClass mc, CallInfo ci) {
        if (!(mc instanceof MetaClassImpl) || mc instanceof AdaptingMetaClass) {
            if (LOG_ENABLED) {
                LOG.info("meta class is neither MetaClassImpl nor AdoptingMetaClass, normal method selection path disabled.");
            }
            return;
        }
        if (LOG_ENABLED) {
            LOG.info("meta class is a MetaClassImpl");
        }
        MetaClassImpl mci = (MetaClassImpl)mc;
        Object receiver = ci.args[0];
        if (receiver == null) {
            if (LOG_ENABLED) {
                LOG.info("receiver is null");
            }
            receiver = NullObject.getNullObject();
        }
        if (receiver instanceof Class) {
            if (LOG_ENABLED) {
                LOG.info("receiver is a class");
            }
            ci.method = mci.retrieveStaticMethod(ci.name, IndyInterface.removeRealReceiver(ci.args));
        } else {
            ci.method = mci.getMethodWithCaching(ci.selector, ci.name, IndyInterface.removeRealReceiver(ci.args), false);
        }
        if (LOG_ENABLED) {
            LOG.info("retrieved method from meta class: " + ci.method);
        }
    }

    private static void setMetaClassCallHandleIfNedded(MetaClass mc, CallInfo ci) {
        if (ci.handle != null) {
            return;
        }
        try {
            Object receiver;
            ci.useMetaClass = true;
            if (LOG_ENABLED) {
                LOG.info("set meta class invocation path");
            }
            if ((receiver = ci.args[0]) instanceof Class) {
                ci.handle = LOOKUP.findVirtual(mc.getClass(), "invokeStaticMethod", MethodType.methodType(Object.class, Object.class, String.class, Object[].class));
                ci.handle = ci.handle.bindTo(mc);
                if (LOG_ENABLED) {
                    LOG.info("use invokeStaticMethod with bound meta class");
                }
            } else {
                boolean useShortForm = mc instanceof AdaptingMetaClass;
                if (useShortForm) {
                    ci.handle = LOOKUP.findVirtual(MetaObjectProtocol.class, "invokeMethod", MethodType.methodType(Object.class, Object.class, String.class, Object[].class));
                } else {
                    ci.handle = LOOKUP.findVirtual(MetaClass.class, "invokeMethod", INVOKE_METHOD_SIGNATURE);
                    ci.handle = MethodHandles.insertArguments(ci.handle, ci.handle.type().parameterCount() - 2, false, true);
                }
                ci.handle = ci.handle.bindTo(mc);
                if (!useShortForm) {
                    ci.handle = ci.handle.bindTo(ci.selector);
                }
                if (LOG_ENABLED) {
                    LOG.info("use invokeMethod with bound meta class");
                }
                if (receiver instanceof GroovyObject) {
                    if (LOG_ENABLED) {
                        LOG.info("add MissingMethod handler for GrooObject#invokeMethod fallback path");
                    }
                    ci.handle = MethodHandles.catchException(ci.handle, MissingMethodException.class, GROOVY_OBJECT_INVOKER);
                }
            }
            ci.handle = MethodHandles.insertArguments(ci.handle, 1, ci.name);
            ci.handle = ci.handle.asCollector(Object[].class, ci.targetType.parameterCount() - 1);
            if (LOG_ENABLED) {
                LOG.info("bind method name and create collector for arguments");
            }
        }
        catch (Exception e) {
            throw new GroovyBugError(e);
        }
    }

    public static Object invokeGroovyObjectInvoker(MissingMethodException e, Object receiver, String name, Object[] args) {
        if (e instanceof MissingMethodExecutionFailed) {
            throw (MissingMethodException)e.getCause();
        }
        if (receiver.getClass() == e.getType() && e.getMethod().equals(name)) {
            return ((GroovyObject)receiver).invokeMethod(name, args);
        }
        throw e;
    }

    public static Object unwrap(GroovyRuntimeException gre) throws Throwable {
        throw ScriptBytecodeAdapter.unwrap(gre);
    }

    public static boolean isSameMetaClass(MetaClass mc, Object receiver) {
        return receiver instanceof GroovyObject && mc == ((GroovyObject)receiver).getMetaClass();
    }

    public static Object unwrap(Object o) {
        Wrapper w = (Wrapper)o;
        return w.unwrap();
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isNotNull(Object o) {
        return o != null;
    }

    public static boolean negateBool(boolean b) {
        return !b;
    }

    public static boolean sameClass(Class c, Object o) {
        if (o == null) {
            return false;
        }
        return o.getClass() == c;
    }

    private static void correctWrapping(CallInfo ci) {
        if (ci.useMetaClass) {
            return;
        }
        Class<?>[] pt = ci.handle.type().parameterArray();
        if (ci.currentType != null) {
            pt = ci.currentType.parameterArray();
        }
        for (int i = 1; i < ci.args.length; ++i) {
            if (!(ci.args[i] instanceof Wrapper)) continue;
            Class<?> type = pt[i];
            MethodType mt = MethodType.methodType(type, Object.class);
            ci.handle = MethodHandles.filterArguments(ci.handle, i, UNWRAP_METHOD.asType(mt));
            if (!LOG_ENABLED) continue;
            LOG.info("added filter for Wrapper for argument at pos " + i);
        }
    }

    private static void correctCoerce(CallInfo ci) {
        if (ci.useMetaClass) {
            return;
        }
        Class<?>[] parameters = ci.handle.type().parameterArray();
        if (ci.currentType != null) {
            parameters = ci.currentType.parameterArray();
        }
        if (ci.args.length != parameters.length) {
            throw new GroovyBugError("At this point argument array length and parameter array length should be the same");
        }
        for (int i = 0; i < ci.args.length; ++i) {
            Class wrappedPara;
            Class<?> got;
            Object arg;
            if (parameters[i] == Object.class || (arg = ci.args[i]) == null || (got = arg.getClass()) == parameters[i] || (wrappedPara = TypeHelper.getWrapperClass(parameters[i])) == got || parameters[i].isAssignableFrom(got) || IndyInterface.isPrimitiveOrWrapper(parameters[i]) && IndyInterface.isPrimitiveOrWrapper(got)) continue;
            ci.handle = TypeTransformers.addTransformer(ci.handle, i, arg, wrappedPara);
            if (!LOG_ENABLED) continue;
            LOG.info("added transformer at pos " + i + " for type " + got + " to type " + wrappedPara);
        }
    }

    private static boolean isPrimitiveOrWrapper(Class c) {
        return c == Byte.TYPE || c == Byte.class || c == Integer.TYPE || c == Integer.class || c == Long.TYPE || c == Long.class || c == Float.TYPE || c == Float.class || c == Double.TYPE || c == Double.class || c == Short.TYPE || c == Short.class || c == Boolean.TYPE || c == Boolean.class || c == Character.TYPE || c == Character.class;
    }

    private static void correctNullReceiver(CallInfo ci) {
        if (ci.args[0] != null) {
            return;
        }
        ci.handle = ci.handle.bindTo(NullObject.getNullObject());
        ci.handle = MethodHandles.dropArguments(ci.handle, 0, new Class[]{ci.targetType.parameterType(0)});
        if (LOG_ENABLED) {
            LOG.info("binding null object receiver and dropping old receiver");
        }
    }

    private static void setGuards(CallInfo ci, Object receiver) {
        if (ci.handle == null) {
            return;
        }
        MethodHandle fallback = IndyInterface.makeFallBack(ci.callSite, ci.sender, ci.name, ci.targetType, ci.safeNavigationOrig, ci.thisCall);
        if (receiver instanceof GroovyObject) {
            GroovyObject go = (GroovyObject)receiver;
            MetaClass mc = go.getMetaClass();
            MethodHandle test = SAME_MC.bindTo(mc);
            test = test.asType(MethodType.methodType(Boolean.TYPE, ci.targetType.parameterType(0)));
            ci.handle = MethodHandles.guardWithTest(test, ci.handle, fallback);
            if (LOG_ENABLED) {
                LOG.info("added meta class equality check");
            }
        }
        if (!ci.useMetaClass && ci.method instanceof NewInstanceMetaMethod) {
            ci.handle = MethodHandles.guardWithTest(HAS_CATEGORY_IN_CURRENT_THREAD_GUARD, ci.handle, fallback);
            if (LOG_ENABLED) {
                LOG.info("added category-in-current-thread-guard for category method");
            }
        }
        ci.handle = switchPoint.guardWithTest(ci.handle, fallback);
        if (LOG_ENABLED) {
            LOG.info("added switch point guard");
        }
        Class<?>[] pt = ci.handle.type().parameterArray();
        for (int i = 0; i < ci.args.length; ++i) {
            Object arg = ci.args[i];
            MethodHandle test = null;
            if (arg == null) {
                test = IS_NULL.asType(MethodType.methodType(Boolean.TYPE, pt[i]));
                if (LOG_ENABLED) {
                    LOG.info("added null argument check at pos " + i);
                }
            } else {
                Class<?> argClass = arg.getClass();
                if (Modifier.isFinal(argClass.getModifiers()) && TypeHelper.argumentClassIsParameterClass(argClass, pt[i])) continue;
                test = SAME_CLASS.bindTo(argClass).asType(MethodType.methodType(Boolean.TYPE, pt[i]));
                if (LOG_ENABLED) {
                    LOG.info("added same class check at pos " + i);
                }
            }
            Class[] drops = new Class[i];
            for (int j = 0; j < drops.length; ++j) {
                drops[j] = pt[j];
            }
            test = MethodHandles.dropArguments(test, 0, drops);
            ci.handle = MethodHandles.guardWithTest(test, ci.handle, fallback);
        }
    }

    private static void correctParameterLength(CallInfo info) {
        Class<?>[] params = info.handle.type().parameterArray();
        if (info.handle == null) {
            return;
        }
        if (!info.isVargs) {
            if (params.length != info.args.length) {
                // empty if block
            }
            return;
        }
        Class<?> lastParam = params[params.length - 1];
        Object lastArg = info.args[info.args.length - 1];
        if (params.length == info.args.length) {
            if (lastParam == lastArg || lastArg == null) {
                return;
            }
            if (lastParam.isInstance(lastArg)) {
                return;
            }
            info.handle = info.handle.asCollector(lastParam, 1);
        } else if (params.length > info.args.length) {
            info.handle = MethodHandles.insertArguments(info.handle, params.length - 1, Array.newInstance(lastParam.getComponentType(), 0));
            if (LOG_ENABLED) {
                LOG.info("added empty array for missing vargs part");
            }
        } else {
            info.handle = info.handle.asCollector(lastParam, info.args.length - params.length + 1);
            if (LOG_ENABLED) {
                LOG.info("changed surplus arguments to be collected for vargs call");
            }
        }
    }

    private static void addExceptionHandler(CallInfo info) {
        if (info.handle == null || !info.catchException) {
            return;
        }
        TypeDescriptor.OfField returnType = info.handle.type().returnType();
        if (returnType != Object.class) {
            MethodType mtype = MethodType.methodType(returnType, GroovyRuntimeException.class);
            info.handle = MethodHandles.catchException(info.handle, GroovyRuntimeException.class, UNWRAP_EXCEPTION.asType(mtype));
        } else {
            info.handle = MethodHandles.catchException(info.handle, GroovyRuntimeException.class, UNWRAP_EXCEPTION);
        }
        if (LOG_ENABLED) {
            LOG.info("added GroovyRuntimeException unwrapper");
        }
    }

    private static boolean setNullForSafeNavigation(CallInfo info) {
        if (!info.safeNavigation) {
            return false;
        }
        info.handle = MethodHandles.dropArguments(NULL_REF, 0, info.targetType.parameterArray());
        if (LOG_ENABLED) {
            LOG.info("set null returning handle for safe navigation");
        }
        return true;
    }

    private static void setMethodSelectionBase(CallInfo ci, MetaClass mc) {
        ci.selector = ci.thisCall ? ci.sender : (ci.args[0] == null ? NullObject.class : mc.getTheClass());
        if (LOG_ENABLED) {
            LOG.info("method selection base set to " + ci.selector);
        }
    }

    public static Object selectMethod(MutableCallSite callSite, Class sender, String methodName, Boolean safeNavigation, Boolean thisCall, Object dummyReceiver, Object[] arguments) throws Throwable {
        CallInfo callInfo = new CallInfo();
        callInfo.targetType = callSite.type();
        callInfo.name = methodName;
        callInfo.args = arguments;
        callInfo.callSite = callSite;
        callInfo.sender = sender;
        callInfo.safeNavigationOrig = safeNavigation;
        callInfo.safeNavigation = safeNavigation != false && arguments[0] == null;
        callInfo.thisCall = thisCall;
        if (LOG_ENABLED) {
            String msg = "----------------------------------------------------\n\t\tinvocation of method '" + methodName + "'" + "\n\t\tsender: " + sender + "\n\t\ttargetType: " + callInfo.targetType + "\n\t\tsafe navigation: " + safeNavigation + "\n\t\tthisCall: " + thisCall + "\n\t\twith " + arguments.length + " arguments";
            for (int i = 0; i < arguments.length; ++i) {
                msg = msg + "\n\t\t\targument[" + i + "] = " + arguments[i];
            }
            LOG.info(msg);
        }
        if (!IndyInterface.setNullForSafeNavigation(callInfo)) {
            MetaClass mc = IndyInterface.getMetaClass(callInfo.args[0]);
            if (LOG_ENABLED) {
                LOG.info("meta class is " + mc);
            }
            IndyInterface.setMethodSelectionBase(callInfo, mc);
            IndyInterface.chooseMethod(mc, callInfo);
            IndyInterface.setHandleForMetaMethod(callInfo);
            IndyInterface.setMetaClassCallHandleIfNedded(mc, callInfo);
            IndyInterface.correctWrapping(callInfo);
            IndyInterface.correctParameterLength(callInfo);
            IndyInterface.correctCoerce(callInfo);
            IndyInterface.correctNullReceiver(callInfo);
            if (LOG_ENABLED) {
                LOG.info("casting explicit from " + callInfo.handle.type() + " to " + callInfo.targetType);
            }
            callInfo.handle = MethodHandles.explicitCastArguments(callInfo.handle, callInfo.targetType);
            IndyInterface.addExceptionHandler(callInfo);
        }
        IndyInterface.setGuards(callInfo, callInfo.args[0]);
        callSite.setTarget(callInfo.handle);
        if (LOG_ENABLED) {
            LOG.info("call site target set, preparing outside invocation");
        }
        MethodHandle call = callInfo.handle.asSpreader(Object[].class, callInfo.args.length);
        call = call.asType(MethodType.methodType(Object.class, Object[].class));
        return call.invokeExact(callInfo.args);
    }

    private static Object[] removeRealReceiver(Object[] args) {
        Object[] ar = new Object[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            ar[i - 1] = args[i];
        }
        return ar;
    }

    static {
        if (System.getProperty("groovy.indy.logging") != null) {
            LOG.setLevel(Level.ALL);
            LOG_ENABLED = true;
        } else {
            LOG_ENABLED = false;
        }
        LOOKUP = MethodHandles.lookup();
        MethodType mt = MethodType.methodType(Object.class, MutableCallSite.class, Class.class, String.class, Boolean.class, Boolean.class, Object.class, Object[].class);
        try {
            SELECT_METHOD = LOOKUP.findStatic(IndyInterface.class, "selectMethod", mt);
        }
        catch (Exception e) {
            throw new GroovyBugError(e);
        }
        GENERAL_INVOKER_SIGNATURE = MethodType.methodType(Object.class, Object.class, Object[].class);
        INVOKE_METHOD_SIGNATURE = MethodType.methodType(Object.class, Class.class, Object.class, String.class, Object[].class, Boolean.TYPE, Boolean.TYPE);
        O2O = MethodType.methodType(Object.class, Object.class);
        try {
            UNWRAP_METHOD = LOOKUP.findStatic(IndyInterface.class, "unwrap", O2O);
            SAME_MC = LOOKUP.findStatic(IndyInterface.class, "isSameMetaClass", MethodType.methodType(Boolean.TYPE, MetaClass.class, Object.class));
            IS_NULL = LOOKUP.findStatic(IndyInterface.class, "isNull", MethodType.methodType(Boolean.TYPE, Object.class));
            IS_NOT_NULL = LOOKUP.findStatic(IndyInterface.class, "isNotNull", MethodType.methodType(Boolean.TYPE, Object.class));
            UNWRAP_EXCEPTION = LOOKUP.findStatic(IndyInterface.class, "unwrap", MethodType.methodType(Object.class, GroovyRuntimeException.class));
            SAME_CLASS = LOOKUP.findStatic(IndyInterface.class, "sameClass", MethodType.methodType(Boolean.TYPE, Class.class, Object.class));
            META_METHOD_INVOKER = LOOKUP.findVirtual(MetaMethod.class, "invoke", GENERAL_INVOKER_SIGNATURE);
            GROOVY_OBJECT_INVOKER = LOOKUP.findStatic(IndyInterface.class, "invokeGroovyObjectInvoker", MethodType.methodType(Object.class, MissingMethodException.class, Object.class, String.class, Object[].class));
            HAS_CATEGORY_IN_CURRENT_THREAD_GUARD = LOOKUP.findStatic(GroovyCategorySupport.class, "hasCategoryInCurrentThread", MethodType.methodType(Boolean.TYPE));
            NEGATE_BOOL = LOOKUP.findStatic(IndyInterface.class, "negateBool", MethodType.methodType(Boolean.TYPE, Boolean.TYPE));
        }
        catch (Exception e) {
            throw new GroovyBugError(e);
        }
        NULL_REF = MethodHandles.constant(Object.class, null);
        switchPoint = new SwitchPoint();
        GroovySystem.getMetaClassRegistry().addMetaClassRegistryChangeEventListener(new MetaClassRegistryChangeEventListener(){

            @Override
            public void updateConstantMetaClass(MetaClassRegistryChangeEvent cmcu) {
                IndyInterface.invalidateSwitchPoints();
            }
        });
    }
}

