/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.AbstractASTTransformUtil;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.objectweb.asm.Opcodes;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class LazyASTTransformation
implements ASTTransformation,
Opcodes {
    private static final ClassNode SOFT_REF = ClassHelper.makeWithoutCaching(SoftReference.class, false);
    private static final Expression NULL_EXPR = ConstantExpression.NULL;
    private static final Token ASSIGN = Token.newSymbol("=", -1, -1);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new GroovyBugError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.asList(nodes));
        }
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (parent instanceof FieldNode) {
            FieldNode fieldNode = (FieldNode)parent;
            Expression soft = node.getMember("soft");
            Expression init = this.getInitExpr(fieldNode);
            fieldNode.rename("$" + fieldNode.getName());
            fieldNode.setModifiers(2 | fieldNode.getModifiers() & 0xFFFFFFFA);
            if (soft instanceof ConstantExpression && ((ConstantExpression)soft).getValue().equals(true)) {
                this.createSoft(fieldNode, init);
            } else {
                this.create(fieldNode, init);
                if (ClassHelper.isPrimitiveType(fieldNode.getType())) {
                    fieldNode.setType(ClassHelper.getWrapper(fieldNode.getType()));
                }
            }
        }
    }

    private void create(FieldNode fieldNode, Expression initExpr) {
        BlockStatement body = new BlockStatement();
        if (fieldNode.isStatic()) {
            this.addHolderClassIdiomBody(body, fieldNode, initExpr);
        } else if (fieldNode.isVolatile()) {
            this.addDoubleCheckedLockingBody(body, fieldNode, initExpr);
        } else {
            this.addNonThreadSafeBody(body, fieldNode, initExpr);
        }
        this.addMethod(fieldNode, body, fieldNode.getType());
    }

    private void addHolderClassIdiomBody(BlockStatement body, FieldNode fieldNode, Expression initExpr) {
        ClassNode declaringClass = fieldNode.getDeclaringClass();
        ClassNode fieldType = fieldNode.getType();
        int visibility = 10;
        String fullName = declaringClass.getName() + "$" + fieldType.getNameWithoutPackage() + "Holder_" + fieldNode.getName().substring(1);
        InnerClassNode holderClass = new InnerClassNode(declaringClass, fullName, 10, ClassHelper.OBJECT_TYPE);
        String innerFieldName = "INSTANCE";
        holderClass.addField("INSTANCE", 26, fieldType, initExpr);
        PropertyExpression innerField = new PropertyExpression((Expression)new ClassExpression(holderClass), "INSTANCE");
        declaringClass.getModule().addClass(holderClass);
        body.addStatement(new ReturnStatement(innerField));
    }

    private void addDoubleCheckedLockingBody(BlockStatement body, FieldNode fieldNode, Expression initExpr) {
        VariableExpression fieldExpr = new VariableExpression(fieldNode);
        VariableExpression localVar = new VariableExpression(fieldNode.getName() + "_local");
        body.addStatement(AbstractASTTransformUtil.declStatement(localVar, fieldExpr));
        body.addStatement(new IfStatement(AbstractASTTransformUtil.notNullExpr(localVar), new ReturnStatement(localVar), new SynchronizedStatement(this.syncTarget(fieldNode), new IfStatement(AbstractASTTransformUtil.notNullExpr(fieldExpr), new ReturnStatement(fieldExpr), new ReturnStatement(new BinaryExpression(fieldExpr, ASSIGN, initExpr))))));
    }

    private void addNonThreadSafeBody(BlockStatement body, FieldNode fieldNode, Expression initExpr) {
        VariableExpression fieldExpr = new VariableExpression(fieldNode);
        body.addStatement(new IfStatement(AbstractASTTransformUtil.notNullExpr(fieldExpr), new ExpressionStatement(fieldExpr), AbstractASTTransformUtil.assignStatement(fieldExpr, initExpr)));
    }

    private void addMethod(FieldNode fieldNode, BlockStatement body, ClassNode type) {
        int visibility = 1;
        if (fieldNode.isStatic()) {
            visibility |= 8;
        }
        String name = "get" + MetaClassHelper.capitalize(fieldNode.getName().substring(1));
        fieldNode.getDeclaringClass().addMethod(name, visibility, type, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body);
    }

    private void createSoft(FieldNode fieldNode, Expression initExpr) {
        ClassNode type = fieldNode.getType();
        fieldNode.setType(SOFT_REF);
        this.createSoftGetter(fieldNode, initExpr, type);
        this.createSoftSetter(fieldNode, type);
    }

    private void createSoftGetter(FieldNode fieldNode, Expression initExpr, ClassNode type) {
        BlockStatement body = new BlockStatement();
        VariableExpression fieldExpr = new VariableExpression(fieldNode);
        VariableExpression resExpr = new VariableExpression("res", type);
        MethodCallExpression callExpression = new MethodCallExpression((Expression)fieldExpr, "get", (Expression)new ArgumentListExpression());
        callExpression.setSafe(true);
        body.addStatement(AbstractASTTransformUtil.declStatement(resExpr, callExpression));
        BlockStatement elseBlock = new BlockStatement();
        elseBlock.addStatement(AbstractASTTransformUtil.assignStatement(resExpr, initExpr));
        elseBlock.addStatement(AbstractASTTransformUtil.assignStatement(fieldExpr, new ConstructorCallExpression(SOFT_REF, resExpr)));
        elseBlock.addStatement(new ExpressionStatement(resExpr));
        IfStatement mainIf = new IfStatement(AbstractASTTransformUtil.notNullExpr(resExpr), new ExpressionStatement(resExpr), elseBlock);
        if (fieldNode.isVolatile()) {
            body.addStatement(new IfStatement(AbstractASTTransformUtil.notNullExpr(resExpr), new ExpressionStatement(resExpr), new SynchronizedStatement(this.syncTarget(fieldNode), mainIf)));
        } else {
            body.addStatement(mainIf);
        }
        this.addMethod(fieldNode, body, type);
    }

    private void createSoftSetter(FieldNode fieldNode, ClassNode type) {
        BlockStatement body = new BlockStatement();
        VariableExpression fieldExpr = new VariableExpression(fieldNode);
        String name = "set" + MetaClassHelper.capitalize(fieldNode.getName().substring(1));
        Parameter parameter = new Parameter(type, "value");
        VariableExpression paramExpr = new VariableExpression(parameter);
        body.addStatement(new IfStatement(AbstractASTTransformUtil.notNullExpr(paramExpr), AbstractASTTransformUtil.assignStatement(fieldExpr, new ConstructorCallExpression(SOFT_REF, paramExpr)), AbstractASTTransformUtil.assignStatement(fieldExpr, NULL_EXPR)));
        int visibility = 1;
        if (fieldNode.isStatic()) {
            visibility |= 8;
        }
        fieldNode.getDeclaringClass().addMethod(name, visibility, ClassHelper.VOID_TYPE, new Parameter[]{parameter}, ClassNode.EMPTY_ARRAY, body);
    }

    private Expression syncTarget(FieldNode fieldNode) {
        return fieldNode.isStatic() ? new ClassExpression(fieldNode.getDeclaringClass()) : VariableExpression.THIS_EXPRESSION;
    }

    private Expression getInitExpr(FieldNode fieldNode) {
        Expression initExpr = fieldNode.getInitialValueExpression();
        fieldNode.setInitialValueExpression(null);
        if (initExpr == null) {
            initExpr = new ConstructorCallExpression(fieldNode.getType(), new ArgumentListExpression());
        }
        return initExpr;
    }
}

