/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.context;

import java.lang.reflect.Constructor;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsBootstrapClass;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.spring.GrailsRuntimeConfigurator;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.support.PersistenceContextInterceptor;
import org.codehaus.groovy.grails.web.context.ServletContextHolder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;

public class GrailsConfigUtils {
    private static final Log LOG = LogFactory.getLog(GrailsConfigUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeGrailsBootstraps(GrailsApplication application, WebApplicationContext webContext, ServletContext servletContext) {
        PersistenceContextInterceptor interceptor = null;
        String[] beanNames = webContext.getBeanNamesForType(PersistenceContextInterceptor.class);
        if (beanNames.length > 0) {
            interceptor = (PersistenceContextInterceptor)webContext.getBean(beanNames[0]);
        }
        if (interceptor != null) {
            interceptor.init();
        }
        try {
            GrailsClass[] bootstraps;
            for (GrailsClass bootstrap : bootstraps = application.getArtefacts("Bootstrap")) {
                GrailsBootstrapClass bootstrapClass = (GrailsBootstrapClass)bootstrap;
                Object instance = bootstrapClass.getReferenceInstance();
                webContext.getAutowireCapableBeanFactory().autowireBeanProperties(instance, 1, false);
                bootstrapClass.callInit(servletContext);
            }
            if (interceptor != null) {
                interceptor.flush();
            }
        }
        finally {
            if (interceptor != null) {
                interceptor.destroy();
            }
        }
    }

    public static WebApplicationContext configureWebApplicationContext(ServletContext servletContext, WebApplicationContext parent) {
        GrailsPluginManager pluginManager;
        GrailsApplication application = (GrailsApplication)parent.getBean("grailsApplication");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"[GrailsContextLoader] Configurating Grails Application");
        }
        if (application.getParentContext() == null) {
            application.setApplicationContext((ApplicationContext)parent);
        }
        GrailsRuntimeConfigurator configurator = null;
        configurator = parent.containsBean("grailsConfigurator") ? (GrailsRuntimeConfigurator)parent.getBean("grailsConfigurator") : GrailsConfigUtils.determineGrailsRuntimeConfiguratorFromServletContext(application, servletContext, (ApplicationContext)parent);
        if (configurator == null) {
            configurator = new GrailsRuntimeConfigurator(application, (ApplicationContext)parent);
            if (parent.containsBean("pluginManager")) {
                pluginManager = (GrailsPluginManager)parent.getBean("pluginManager");
                configurator.setPluginManager(pluginManager);
            }
        }
        pluginManager = configurator.getPluginManager();
        WebApplicationContext webContext = configurator.configure(servletContext);
        pluginManager.setApplicationContext((ApplicationContext)webContext);
        GrailsConfigUtils.configureServletContextAttributes(servletContext, application, pluginManager, webContext);
        LOG.info((Object)"[GrailsContextLoader] Grails application loaded.");
        return webContext;
    }

    public static void configureServletContextAttributes(ServletContext servletContext, GrailsApplication application, GrailsPluginManager pluginManager, WebApplicationContext webContext) {
        ServletContextHolder.setServletContext(servletContext);
        servletContext.setAttribute("org.codehaus.groovy.grails.GRAILS_PLUGIN_MANAGER", (Object)pluginManager);
        servletContext.setAttribute("org.codehaus.groovy.grails.PARENT_APPLICATION_CONTEXT", (Object)webContext.getParent());
        servletContext.setAttribute("grailsApplication", (Object)application);
        servletContext.setAttribute("org.codehaus.groovy.grails.APPLICATION_CONTEXT", (Object)webContext);
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)webContext);
    }

    public static GrailsRuntimeConfigurator determineGrailsRuntimeConfiguratorFromServletContext(GrailsApplication application, ServletContext servletContext, ApplicationContext parent) {
        GrailsRuntimeConfigurator configurator = null;
        if (servletContext.getInitParameter("grailsConfiguratorClass") != null) {
            String configuratorClassName = servletContext.getInitParameter("grailsConfiguratorClass").toString();
            Class configuratorClass = null;
            try {
                configuratorClass = ClassUtils.forName((String)configuratorClassName, (ClassLoader)application.getClassLoader());
            }
            catch (Exception e) {
                String msg = "failed to create Grails runtime configurator as specified in web.xml: " + configuratorClassName;
                LOG.error((Object)("[GrailsContextLoader] " + msg), (Throwable)e);
                throw new IllegalArgumentException(msg);
            }
            if (!GrailsRuntimeConfigurator.class.isAssignableFrom(configuratorClass)) {
                throw new IllegalArgumentException("class " + configuratorClassName + " is not assignable to " + GrailsRuntimeConfigurator.class.getName());
            }
            Constructor constr = ClassUtils.getConstructorIfAvailable((Class)configuratorClass, (Class[])new Class[]{GrailsApplication.class, ApplicationContext.class});
            configurator = (GrailsRuntimeConfigurator)BeanUtils.instantiateClass((Constructor)constr, (Object[])new Object[]{application, parent});
        }
        return configurator;
    }

    public static boolean isConfigTrue(GrailsApplication application, String propertyName) {
        return application != null && application.getFlatConfig() != null && DefaultTypeTransformation.castToBoolean(application.getFlatConfig().get(propertyName)) || Boolean.getBoolean(propertyName);
    }

    public static boolean isConfigTrue(Object application, String propertyName) {
        return false;
    }
}

