/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import groovyx.gpars.actor.Actors;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.DataCallback;
import groovyx.gpars.dataflow.DataFlowComplexExpression;
import groovyx.gpars.dataflow.DataFlowGetPropertyExpression;
import groovyx.gpars.dataflow.DataFlowInvocationExpression;
import groovyx.gpars.remote.RemoteConnection;
import groovyx.gpars.remote.RemoteHost;
import groovyx.gpars.serial.SerialContext;
import groovyx.gpars.serial.SerialHandle;
import groovyx.gpars.serial.SerialMsg;
import groovyx.gpars.serial.WithSerialId;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.codehaus.groovy.runtime.InvokerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataFlowExpression<T>
extends WithSerialId
implements GroovyObject {
    protected static final AtomicIntegerFieldUpdater<DataFlowExpression> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(DataFlowExpression.class, "state");
    protected static final AtomicReferenceFieldUpdater<DataFlowExpression, WaitingThread> waitingUpdater = AtomicReferenceFieldUpdater.newUpdater(DataFlowExpression.class, WaitingThread.class, "waiting");
    private MetaClass metaClass = InvokerHelper.getMetaClass(this.getClass());
    protected volatile T value;
    protected volatile int state = 0;
    private volatile WaitingThread<T> waiting;
    protected static final int S_NOT_INITIALIZED = 0;
    protected static final int S_INITIALIZING = 1;
    protected static final int S_INITIALIZED = 2;
    private static final WaitingThread dummyWaitingThread = new WaitingThread(null, null, null, null);

    protected DataFlowExpression() {
    }

    public boolean isBound() {
        return this.state == 2;
    }

    public void getValAsync(MessageStream callback) {
        this.getValAsync(null, callback);
    }

    void getValAsync(Object attachment, MessageStream callback) {
        if (callback == null) {
            throw new NullPointerException();
        }
        WaitingThread newWaiting = null;
        while (this.state != 2) {
            WaitingThread<T> previous;
            if (newWaiting == null) {
                newWaiting = new WaitingThread(null, null, attachment, callback);
            }
            if ((previous = this.waiting) == dummyWaitingThread) break;
            newWaiting.previous = (WaitingThread)previous;
            if (!waitingUpdater.compareAndSet(this, previous, newWaiting)) continue;
            return;
        }
        this.scheduleCallback(attachment, callback);
    }

    public T getVal() throws InterruptedException {
        WaitingThread newWaiting = null;
        while (this.state != 2) {
            WaitingThread<T> previous;
            if (newWaiting == null) {
                newWaiting = new WaitingThread(Thread.currentThread(), null, null, null);
            }
            if ((previous = this.waiting) == dummyWaitingThread) break;
            newWaiting.previous = (WaitingThread)previous;
            if (!waitingUpdater.compareAndSet(this, previous, newWaiting)) continue;
            while (this.state != 2) {
                LockSupport.park();
                if (!Thread.currentThread().isInterrupted()) continue;
                newWaiting.set(true);
                throw new InterruptedException();
            }
            break block0;
        }
        return this.value;
    }

    public T getVal(long timeout, TimeUnit units) throws InterruptedException {
        long endNano = System.nanoTime() + units.toNanos(timeout);
        WaitingThread newWaiting = null;
        while (this.state != 2) {
            WaitingThread<T> previous;
            if (newWaiting == null) {
                newWaiting = new WaitingThread(Thread.currentThread(), null, null, null);
            }
            if ((previous = this.waiting) == dummyWaitingThread) break;
            newWaiting.previous = (WaitingThread)previous;
            if (!waitingUpdater.compareAndSet(this, previous, newWaiting)) continue;
            while (this.state != 2) {
                long toWait = endNano - System.nanoTime();
                if (toWait <= 0L) {
                    newWaiting.set(true);
                    return null;
                }
                LockSupport.parkNanos(toWait);
                if (!Thread.currentThread().isInterrupted()) continue;
                newWaiting.set(true);
                throw new InterruptedException();
            }
            break block0;
        }
        return this.value;
    }

    public void bindSafely(T value) {
        if (!stateUpdater.compareAndSet(this, 0, 1)) {
            return;
        }
        this.doBind(value);
    }

    public void bind(T value) {
        if (!stateUpdater.compareAndSet(this, 0, 1)) {
            throw new IllegalStateException("A DataFlowVariable can only be assigned once.");
        }
        this.doBind(value);
    }

    private void doBind(T value) {
        this.doBindImpl(value);
        this.notifyRemote(null);
    }

    private void doBindImpl(T value) {
        WaitingThread waitingQueue;
        this.value = value;
        this.state = 2;
        WaitingThread currentWaiting = waitingQueue = waitingUpdater.getAndSet(this, dummyWaitingThread);
        while (currentWaiting != null) {
            if (currentWaiting.compareAndSet(false, true)) {
                if (currentWaiting.thread != null) {
                    LockSupport.unpark(currentWaiting.thread);
                } else if (currentWaiting.callback != null) {
                    this.scheduleCallback(currentWaiting.attachment, currentWaiting.callback);
                }
            }
            currentWaiting = currentWaiting.previous;
        }
    }

    public void doBindRemote(UUID hostId, T message) {
        this.doBindImpl(message);
        this.notifyRemote(hostId);
    }

    private void notifyRemote(final UUID hostId) {
        if (this.serialHandle != null) {
            Actors.defaultPooledActorGroup.getThreadPool().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object sub = DataFlowExpression.this.serialHandle.getSubscribers();
                    if (sub instanceof RemoteHost) {
                        RemoteHost host = (RemoteHost)sub;
                        if (hostId == null || !host.getHostId().equals(hostId)) {
                            host.write(new BindDataFlow(DataFlowExpression.this, DataFlowExpression.this.value, host.getLocalHost().getId()));
                        }
                    }
                    if (sub instanceof List) {
                        SerialHandle serialHandle = DataFlowExpression.this.serialHandle;
                        synchronized (serialHandle) {
                            for (SerialContext host : (List)sub) {
                                if (hostId != null && host.getHostId().equals(hostId)) continue;
                                host.write(new BindDataFlow(DataFlowExpression.this, DataFlowExpression.this.value, host.getLocalHostId()));
                            }
                        }
                    }
                }
            });
        }
    }

    private void scheduleCallback(Object attachment, MessageStream callback) {
        if (attachment == null) {
            callback.send(this.value);
        } else {
            HashMap<String, Object> message = new HashMap<String, Object>(2);
            message.put("attachment", attachment);
            message.put("result", this.value);
            callback.send(message);
        }
    }

    public void rightShift(Closure closure) {
        this.whenBound(closure);
    }

    public void whenBound(Closure closure) {
        this.getValAsync(new DataCallback(closure));
    }

    public void whenBound(MessageStream stream) {
        this.getValAsync(stream);
    }

    public static <V> DataFlowExpression<V> transform(Object another, Closure closure) {
        int pnum = closure.getMaximumNumberOfParameters();
        if (pnum == 0) {
            throw new IllegalArgumentException("Closure should have parameters");
        }
        if (pnum == 1) {
            return new TransformOne(another, closure);
        }
        if (another instanceof Collection) {
            Collection collection = (Collection)another;
            if (collection.size() != pnum) {
                throw new IllegalArgumentException("Closure parameters don't match #of arguments");
            }
            return new TransformMany(collection, closure);
        }
        throw new IllegalArgumentException("Collection expected");
    }

    protected final void subscribe() {
        DataFlowExpressionsCollector listener = new DataFlowExpressionsCollector();
        this.subscribe(listener);
        listener.start();
    }

    protected T evaluate() {
        return this.value;
    }

    protected void subscribe(DataFlowExpressionsCollector listener) {
        listener.subscribe(this);
    }

    public Object invokeMethod(String name, Object args) {
        if (this.getMetaClass().respondsTo((Object)this, name).isEmpty()) {
            return new DataFlowInvocationExpression((Object)this, name, (Object[])args);
        }
        return InvokerHelper.invokeMethod((Object)this, (String)name, (Object)args);
    }

    public Object getProperty(String propertyName) {
        MetaProperty metaProperty = this.getMetaClass().hasProperty((Object)this, propertyName);
        if (metaProperty != null) {
            return metaProperty.getProperty((Object)this);
        }
        return new DataFlowGetPropertyExpression(this, propertyName);
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public void setProperty(String propertyName, Object newValue) {
        this.metaClass.setProperty((Object)this, propertyName, newValue);
    }

    public MetaClass getMetaClass() {
        return this.metaClass;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(value=" + this.value + ')';
    }

    public static class BindDataFlow
    extends SerialMsg {
        private static final long serialVersionUID = -8674023870562062769L;
        private final DataFlowExpression expr;
        private final Object message;

        public BindDataFlow(DataFlowExpression expr, Object message, UUID hostId) {
            super(hostId);
            this.expr = expr;
            this.message = message;
        }

        public void execute(RemoteConnection conn) {
            this.expr.doBindRemote(this.hostId, this.message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformMany<V>
    extends DataFlowComplexExpression<V> {
        private static final long serialVersionUID = 4115456542358280855L;
        private final Closure closure;

        private TransformMany(Collection collection, Closure closure) {
            super(collection.toArray());
            this.closure = closure;
            this.subscribe();
        }

        @Override
        protected V evaluate() {
            super.evaluate();
            return (V)this.closure.call(this.args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformOne<V>
    extends DataFlowExpression<V> {
        private static final long serialVersionUID = 6701886501249351047L;
        Object arg;
        private final Closure closure;

        private TransformOne(Object another, Closure closure) {
            this.closure = closure;
            this.arg = another;
        }

        @Override
        protected V evaluate() {
            return (V)this.closure.call(this.arg instanceof DataFlowExpression ? ((DataFlowExpression)this.arg).value : this.arg);
        }

        @Override
        protected void subscribe(DataFlowExpressionsCollector listener) {
            this.arg = listener.subscribe(this.arg);
        }
    }

    final class DataFlowExpressionsCollector
    extends MessageStream {
        private static final long serialVersionUID = 3414942165521113575L;
        private final AtomicInteger count = new AtomicInteger(1);

        DataFlowExpressionsCollector() {
        }

        public MessageStream send(Object message) {
            if (this.count.decrementAndGet() == 0) {
                DataFlowExpression.this.bind(DataFlowExpression.this.evaluate());
            }
            return this;
        }

        Object subscribe(Object element) {
            if (!(element instanceof DataFlowExpression)) {
                return element;
            }
            DataFlowExpression dataFlowExpression = (DataFlowExpression)element;
            if (dataFlowExpression.state == 2) {
                return dataFlowExpression.value;
            }
            this.count.incrementAndGet();
            dataFlowExpression.getValAsync(this);
            return element;
        }

        void start() {
            if (this.count.decrementAndGet() == 0) {
                DataFlowExpression.this.doBind(DataFlowExpression.this.evaluate());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WaitingThread<V>
    extends AtomicBoolean {
        private static final long serialVersionUID = 8909974768784947460L;
        private final Thread thread;
        private volatile WaitingThread<V> previous;
        private final MessageStream callback;
        private final Object attachment;

        private WaitingThread(Thread thread, WaitingThread<V> previous, Object attachment, MessageStream callback) {
            this.callback = callback;
            this.attachment = attachment;
            this.thread = thread;
            this.previous = previous;
        }
    }
}

