/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.validation;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.codehaus.groovy.grails.validation.GrailsDomainClassValidator;
import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.validation.Errors;

public class HibernateDomainClassValidator
extends GrailsDomainClassValidator
implements ApplicationContextAware {
    private static ThreadLocal<ArrayList<Object>> validatedInstances = new ThreadLocal<ArrayList<Object>>(){

        @Override
        protected ArrayList<Object> initialValue() {
            return new ArrayList<Object>();
        }
    };
    private ApplicationContext applicationContext;
    private SessionFactory sessionFactory;

    protected GrailsDomainClass getAssociatedDomainClassFromApplication(Object associatedObject) {
        String associatedObjectType = associatedObject.getClass().getName();
        if (associatedObject instanceof HibernateProxy) {
            associatedObjectType = ((HibernateProxy)associatedObject).getHibernateLazyInitializer().getEntityName();
        }
        return (GrailsDomainClass)this.grailsApplication.getArtefact("Domain", associatedObjectType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(Object obj, Errors errors, boolean cascade) {
        Session session = this.sessionFactory.getCurrentSession();
        FlushMode previousMode = null;
        try {
            if (session != null) {
                previousMode = session.getFlushMode();
                session.setFlushMode(FlushMode.MANUAL);
            }
            super.validate(obj, errors, cascade);
            Object var7_6 = null;
            if (session == null) return;
            if (previousMode == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (session == null || previousMode == null) throw throwable;
            session.setFlushMode(previousMode);
            throw throwable;
        }
        session.setFlushMode(previousMode);
    }

    protected void cascadeValidationToMany(Errors errors, BeanWrapper bean, GrailsDomainClassProperty persistentProperty, String propertyName) {
        Object collection = bean.getPropertyValue(propertyName);
        if (collection == null) {
            return;
        }
        if (collection instanceof PersistentCollection) {
            PersistentCollection persistentCollection = (PersistentCollection)collection;
            if (persistentCollection.wasInitialized()) {
                super.cascadeValidationToMany(errors, bean, persistentProperty, propertyName);
            }
        } else {
            super.cascadeValidationToMany(errors, bean, persistentProperty, propertyName);
        }
    }

    protected void cascadeValidationToOne(Errors errors, BeanWrapper bean, Object associatedObject, GrailsDomainClassProperty persistentProperty, String propertyName) {
        List validatedInstancesList = validatedInstances.get();
        validatedInstancesList.add(associatedObject);
        super.cascadeValidationToOne(errors, bean, associatedObject, persistentProperty, propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postValidate(Object obj, Errors errors) {
        if (this.applicationContext == null || !this.applicationContext.containsBean("sessionFactory")) {
            return;
        }
        try {
            SessionFactory sf = (SessionFactory)this.applicationContext.getBean("sessionFactory");
            if (errors.hasErrors()) {
                GrailsHibernateUtil.setObjectToReadyOnly(obj, sf);
                List invalidInstances = validatedInstances.get();
                for (Object instance : invalidInstances) {
                    GrailsHibernateUtil.setObjectToReadyOnly(instance, sf);
                }
            } else {
                GrailsHibernateUtil.setObjectToReadWrite(obj, sf);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            List validatedInstancesList = validatedInstances.get();
            if (validatedInstancesList != null) {
                validatedInstancesList.clear();
            }
            throw throwable;
        }
        List validatedInstancesList = validatedInstances.get();
        if (validatedInstancesList != null) {
            validatedInstancesList.clear();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (applicationContext == null) {
            return;
        }
        try {
            this.sessionFactory = (SessionFactory)applicationContext.getBean("sessionFactory", SessionFactory.class);
        }
        catch (BeansException beansException) {
            // empty catch block
        }
    }
}

