/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.proxy;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.plugins.orm.hibernate.HibernatePluginSupport;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.pojo.BasicLazyInitializer;
import org.hibernate.proxy.pojo.javassist.SerializableProxy;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyAwareJavassistLazyInitializer
extends BasicLazyInitializer
implements MethodHandler {
    private static final String WRITE_CLASSES_DIRECTORY = System.getProperty("javassist.writeDirectory");
    private static final Set<String> GROOVY_METHODS = new HashSet<String>(Arrays.asList("invokeMethod", "getMetaClass", "setMetaClass", "metaClass", "getProperty", "setProperty", "$getStaticMetaClass"));
    private static final MethodFilter METHOD_FILTERS = new MethodFilter(){

        public boolean isHandled(Method m) {
            return m.getName().indexOf("super$") == -1 && !GROOVY_METHODS.contains(m.getName()) && (m.getParameterTypes().length != 0 || !m.getName().equals("finalize"));
        }
    };
    private Class<?>[] interfaces;
    private boolean constructed = false;

    private GroovyAwareJavassistLazyInitializer(String entityName, Class<?> persistentClass, Class<?>[] interfaces, Serializable id, Method getIdentifierMethod, Method setIdentifierMethod, AbstractComponentType componentIdType, SessionImplementor session) {
        super(entityName, persistentClass, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session);
        this.interfaces = interfaces;
    }

    public static HibernateProxy getProxy(String entityName, Class<?> persistentClass, Class<?>[] interfaces, Method getIdentifierMethod, Method setIdentifierMethod, AbstractComponentType componentIdType, Serializable id, SessionImplementor session) throws HibernateException {
        try {
            GroovyAwareJavassistLazyInitializer instance = new GroovyAwareJavassistLazyInitializer(entityName, persistentClass, interfaces, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session);
            ProxyFactory factory = GroovyAwareJavassistLazyInitializer.createProxyFactory(persistentClass, interfaces);
            Class proxyClass = factory.createClass();
            HibernatePluginSupport.enhanceProxyClass(proxyClass);
            HibernateProxy proxy = (HibernateProxy)proxyClass.newInstance();
            ((ProxyObject)proxy).setHandler((MethodHandler)instance);
            HibernatePluginSupport.enhanceProxy(proxy);
            instance.constructed = true;
            return proxy;
        }
        catch (Throwable t) {
            LogFactory.getLog(BasicLazyInitializer.class).error((Object)("Javassist Enhancement failed: " + entityName), t);
            throw new HibernateException("Javassist Enhancement failed: " + entityName, t);
        }
    }

    public static HibernateProxy getProxy(Class<?> factory, String entityName, Class<?> persistentClass, Class<?>[] interfaces, Method getIdentifierMethod, Method setIdentifierMethod, AbstractComponentType componentIdType, Serializable id, SessionImplementor session) throws HibernateException {
        HibernateProxy proxy;
        GroovyAwareJavassistLazyInitializer instance = new GroovyAwareJavassistLazyInitializer(entityName, persistentClass, interfaces, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session);
        try {
            proxy = (HibernateProxy)factory.newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Javassist Enhancement failed: " + persistentClass.getName(), (Throwable)e);
        }
        ((ProxyObject)proxy).setHandler((MethodHandler)instance);
        instance.constructed = true;
        HibernatePluginSupport.enhanceProxy(proxy);
        HibernatePluginSupport.initializeDomain(persistentClass);
        return proxy;
    }

    public static Class<?> getProxyFactory(Class<?> persistentClass, Class<?>[] interfaces) throws HibernateException {
        try {
            ProxyFactory factory = GroovyAwareJavassistLazyInitializer.createProxyFactory(persistentClass, interfaces);
            Class proxyClass = factory.createClass();
            HibernatePluginSupport.enhanceProxyClass(proxyClass);
            return proxyClass;
        }
        catch (Throwable t) {
            LogFactory.getLog(BasicLazyInitializer.class).error((Object)("Javassist Enhancement failed: " + persistentClass.getName()), t);
            throw new HibernateException("Javassist Enhancement failed: " + persistentClass.getName(), t);
        }
    }

    private static ProxyFactory createProxyFactory(Class<?> persistentClass, Class<?>[] interfaces) {
        ProxyFactory factory = new ProxyFactory();
        factory.setSuperclass(interfaces.length == 1 ? persistentClass : null);
        factory.setInterfaces((Class[])interfaces);
        factory.setFilter(METHOD_FILTERS);
        if (WRITE_CLASSES_DIRECTORY != null) {
            factory.writeDirectory = WRITE_CLASSES_DIRECTORY;
        }
        return factory;
    }

    public Object invoke(Object proxy, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        if (this.constructed) {
            Object result;
            try {
                result = this.invoke(thisMethod, args, proxy);
            }
            catch (Throwable t) {
                throw new Exception(t.getCause());
            }
            if (result == INVOKE_IMPLEMENTATION) {
                Object target = this.getImplementation();
                try {
                    Object returnValue;
                    if (ReflectHelper.isPublic((Class)this.persistentClass, (Member)thisMethod)) {
                        if (!thisMethod.getDeclaringClass().isInstance(target)) {
                            throw new ClassCastException(target.getClass().getName());
                        }
                        returnValue = thisMethod.invoke(target, args);
                    } else {
                        if (!thisMethod.isAccessible()) {
                            thisMethod.setAccessible(true);
                        }
                        returnValue = thisMethod.invoke(target, args);
                    }
                    return returnValue == target ? proxy : returnValue;
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
            return result;
        }
        if (thisMethod.getName().equals("getHibernateLazyInitializer")) {
            return this;
        }
        return proceed.invoke(proxy, args);
    }

    protected Object serializableProxy() {
        return new SerializableProxy(this.getEntityName(), this.persistentClass, (Class[])this.interfaces, this.getIdentifier(), this.getIdentifierMethod, this.setIdentifierMethod, this.componentIdType);
    }
}

