/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import java.sql.SQLException;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractSavePersistentMethod;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;

public class SavePersistentMethod
extends AbstractSavePersistentMethod {
    public static final String METHOD_SIGNATURE = "save";
    public static final Pattern METHOD_PATTERN = Pattern.compile("^save$");

    public SavePersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application) {
        super(METHOD_PATTERN, sessionFactory, classLoader, application);
    }

    public SavePersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application, GrailsDomainClass domainClass) {
        super(METHOD_PATTERN, sessionFactory, classLoader, application, domainClass);
    }

    protected Object performSave(final Object target, final boolean flush) {
        return this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.saveOrUpdate(target);
                if (flush) {
                    try {
                        SavePersistentMethod.this.getHibernateTemplate().flush();
                    }
                    catch (DataAccessException e) {
                        SavePersistentMethod.this.getHibernateTemplate().setFlushMode(0);
                        throw e;
                    }
                }
                return target;
            }
        });
    }

    protected Object performInsert(final Object target, final boolean shouldFlush) {
        return this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.save(target);
                if (shouldFlush) {
                    try {
                        SavePersistentMethod.this.getHibernateTemplate().flush();
                    }
                    catch (DataAccessException e) {
                        SavePersistentMethod.this.getHibernateTemplate().setFlushMode(0);
                        throw e;
                    }
                }
                return target;
            }
        });
    }
}

