/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.cfg;

import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ApplicationHolder;
import org.codehaus.groovy.grails.commons.ArtefactHandler;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.commons.DomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.orm.hibernate.GrailsHibernateDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.codehaus.groovy.grails.orm.hibernate.cfg.Mapping;
import org.codehaus.groovy.grails.orm.hibernate.proxy.GroovyAwareJavassistProxyFactory;
import org.codehaus.groovy.grails.orm.hibernate.proxy.HibernateProxyHandler;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Order;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.AbstractComponentType;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsHibernateUtil {
    private static final Log LOG = LogFactory.getLog(GrailsHibernateUtil.class);
    private static final String DYNAMIC_FILTER_ENABLER = "dynamicFilterEnabler";
    public static SimpleTypeConverter converter = new SimpleTypeConverter();
    public static final String ARGUMENT_MAX = "max";
    public static final String ARGUMENT_OFFSET = "offset";
    public static final String ARGUMENT_ORDER = "order";
    public static final String ARGUMENT_SORT = "sort";
    public static final String ORDER_DESC = "desc";
    public static final String ORDER_ASC = "asc";
    public static final String ARGUMENT_FETCH = "fetch";
    public static final String ARGUMENT_IGNORE_CASE = "ignoreCase";
    public static final String ARGUMENT_CACHE = "cache";
    public static final String ARGUMENT_LOCK = "lock";
    public static final String CONFIG_PROPERTY_CACHE_QUERIES = "grails.hibernate.cache.queries";
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static HibernateProxyHandler proxyHandler = new HibernateProxyHandler();

    public static void enableDynamicFilterEnablerIfPresent(SessionFactory sessionFactory, org.hibernate.Session session) {
        Set definedFilterNames;
        if (sessionFactory != null && session != null && (definedFilterNames = sessionFactory.getDefinedFilterNames()) != null && definedFilterNames.contains(DYNAMIC_FILTER_ENABLER)) {
            session.enableFilter(DYNAMIC_FILTER_ENABLER);
        }
    }

    public static void configureHibernateDomainClasses(SessionFactory sessionFactory, GrailsApplication application) {
        Map map;
        HashMap<String, GrailsDomainClass> hibernateDomainClassMap = new HashMap<String, GrailsDomainClass>();
        ArtefactHandler artefactHandler = application.getArtefactHandler("Domain");
        Map defaultContraints = Collections.emptyMap();
        if (artefactHandler instanceof DomainClassArtefactHandler && (map = ((DomainClassArtefactHandler)artefactHandler).getDefaultConstraints()) != null) {
            defaultContraints = map;
        }
        for (Object o : sessionFactory.getAllClassMetadata().values()) {
            ClassMetadata classMetadata = (ClassMetadata)o;
            GrailsHibernateUtil.configureDomainClass(sessionFactory, application, classMetadata, classMetadata.getMappedClass(EntityMode.POJO), hibernateDomainClassMap, defaultContraints);
        }
        GrailsHibernateUtil.configureInheritanceMappings(hibernateDomainClassMap);
    }

    public static void configureInheritanceMappings(Map hibernateDomainClassMap) {
        block0: for (Object o : hibernateDomainClassMap.values()) {
            GrailsDomainClass baseClass = (GrailsDomainClass)o;
            if (baseClass.isRoot()) continue;
            Class superClass = baseClass.getClazz().getSuperclass();
            while (!superClass.equals(Object.class) && !superClass.equals(GroovyObject.class)) {
                GrailsDomainClass gdc = (GrailsDomainClass)hibernateDomainClassMap.get(superClass.getName());
                if (gdc == null || gdc.getSubClasses() == null) {
                    LOG.debug((Object)"did not find superclass names when mapping inheritance....");
                    continue block0;
                }
                gdc.getSubClasses().add(baseClass);
                superClass = superClass.getSuperclass();
            }
        }
    }

    private static void configureDomainClass(SessionFactory sessionFactory, GrailsApplication application, ClassMetadata cmd, Class<?> persistentClass, Map<String, GrailsDomainClass> hibernateDomainClassMap, Map defaultContraints) {
        if (Modifier.isAbstract(persistentClass.getModifiers())) {
            return;
        }
        LOG.trace((Object)("Configuring domain class [" + persistentClass + "]"));
        GrailsDomainClass dc = (GrailsDomainClass)application.getArtefact("Domain", persistentClass.getName());
        if (dc == null) {
            GrailsHibernateDomainClass ghdc = new GrailsHibernateDomainClass(persistentClass, sessionFactory, application, cmd, defaultContraints);
            hibernateDomainClassMap.put(persistentClass.getName(), (GrailsDomainClass)ghdc);
            dc = (GrailsDomainClass)application.addArtefact("Domain", (GrailsClass)ghdc);
        }
    }

    public static void populateArgumentsForCriteria(Class<?> targetClass, Criteria c, Map argMap) {
        int offset;
        Integer maxParam = null;
        Integer offsetParam = null;
        if (argMap.containsKey(ARGUMENT_MAX)) {
            maxParam = (Integer)converter.convertIfNecessary(argMap.get(ARGUMENT_MAX), Integer.class);
        }
        if (argMap.containsKey(ARGUMENT_OFFSET)) {
            offsetParam = (Integer)converter.convertIfNecessary(argMap.get(ARGUMENT_OFFSET), Integer.class);
        }
        String orderParam = (String)argMap.get(ARGUMENT_ORDER);
        Object fetchObj = argMap.get(ARGUMENT_FETCH);
        if (fetchObj instanceof Map) {
            Map fetch = (Map)fetchObj;
            for (Object o : fetch.keySet()) {
                String associationName = (String)o;
                c.setFetchMode(associationName, GrailsHibernateUtil.getFetchMode(fetch.get(associationName)));
            }
        }
        String sort = (String)argMap.get(ARGUMENT_SORT);
        String order = ORDER_DESC.equalsIgnoreCase(orderParam) ? ORDER_DESC : ORDER_ASC;
        int max = maxParam == null ? -1 : maxParam;
        int n = offset = offsetParam == null ? -1 : offsetParam;
        if (max > -1) {
            c.setMaxResults(max);
        }
        if (offset > -1) {
            c.setFirstResult(offset);
        }
        if (GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_CACHE, (Map)argMap)) {
            c.setCacheable(true);
        }
        if (GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_LOCK, (Map)argMap)) {
            c.setLockMode(LockMode.UPGRADE);
        } else if (argMap.get(ARGUMENT_CACHE) == null) {
            GrailsHibernateUtil.cacheCriteriaByMapping(targetClass, c);
        }
        if (sort != null) {
            boolean ignoreCase = true;
            Object caseArg = argMap.get(ARGUMENT_IGNORE_CASE);
            if (caseArg instanceof Boolean) {
                ignoreCase = (Boolean)caseArg;
            }
            GrailsHibernateUtil.addOrderPossiblyNested(c, targetClass, sort, order, ignoreCase);
        } else {
            Mapping m = GrailsDomainBinder.getMapping(targetClass);
            if (m != null && !StringUtils.isBlank((String)m.getSort())) {
                if (ORDER_DESC.equalsIgnoreCase(m.getOrder())) {
                    c.addOrder(Order.desc((String)m.getSort()));
                } else {
                    c.addOrder(Order.asc((String)m.getSort()));
                }
            }
        }
    }

    private static void addOrderPossiblyNested(Criteria c, Class<?> targetClass, String sort, String order, boolean ignoreCase) {
        int firstDotPos = sort.indexOf(".");
        if (firstDotPos == -1) {
            GrailsHibernateUtil.addOrder(c, sort, order, ignoreCase);
        } else {
            String sortHead = sort.substring(0, firstDotPos);
            String sortTail = sort.substring(firstDotPos + 1);
            GrailsDomainClassProperty property = GrailsHibernateUtil.getGrailsDomainClassProperty(targetClass, sortHead);
            if (property.isEmbedded()) {
                GrailsHibernateUtil.addOrder(c, sort, order, ignoreCase);
            } else {
                Criteria subCriteria = c.createCriteria(sortHead);
                Class propertyTargetClass = property.getReferencedDomainClass().getClazz();
                GrailsHibernateUtil.addOrderPossiblyNested(subCriteria, propertyTargetClass, sortTail, order, ignoreCase);
            }
        }
    }

    private static void addOrder(Criteria c, String sort, String order, boolean ignoreCase) {
        if (ORDER_DESC.equals(order)) {
            c.addOrder(ignoreCase ? Order.desc((String)sort).ignoreCase() : Order.desc((String)sort));
        } else {
            c.addOrder(ignoreCase ? Order.asc((String)sort).ignoreCase() : Order.asc((String)sort));
        }
    }

    private static GrailsDomainClassProperty getGrailsDomainClassProperty(Class<?> targetClass, String propertyName) {
        GrailsClass grailsClass = ApplicationHolder.getApplication().getArtefact("Domain", targetClass.getName());
        if (!(grailsClass instanceof GrailsDomainClass)) {
            throw new IllegalArgumentException("Unexpected: class is not a domain class:" + targetClass.getName());
        }
        GrailsDomainClass domainClass = (GrailsDomainClass)grailsClass;
        return domainClass.getPropertyByName(propertyName);
    }

    public static void cacheCriteriaByMapping(Class<?> targetClass, Criteria criteria) {
        Mapping m = GrailsDomainBinder.getMapping(targetClass);
        if (m != null && m.getCache() != null && m.getCache().getEnabled()) {
            criteria.setCacheable(true);
        }
    }

    public static void populateArgumentsForCriteria(Criteria c, Map argMap) {
        GrailsHibernateUtil.populateArgumentsForCriteria(null, c, argMap);
    }

    public static FetchMode getFetchMode(Object object) {
        String name;
        String string = name = object != null ? object.toString() : "default";
        if (name.equalsIgnoreCase(FetchMode.JOIN.toString()) || name.equalsIgnoreCase("eager")) {
            return FetchMode.JOIN;
        }
        if (name.equalsIgnoreCase(FetchMode.SELECT.toString()) || name.equalsIgnoreCase("lazy")) {
            return FetchMode.SELECT;
        }
        return FetchMode.DEFAULT;
    }

    public static void setObjectToReadyOnly(Object target, SessionFactory sessionFactory) {
        Session session = sessionFactory.getCurrentSession();
        if (GrailsHibernateUtil.canModifyReadWriteState((org.hibernate.Session)session, target)) {
            if (target instanceof HibernateProxy) {
                target = ((HibernateProxy)target).getHibernateLazyInitializer().getImplementation();
            }
            session.setReadOnly(target, true);
            session.setFlushMode(FlushMode.MANUAL);
        }
    }

    private static boolean canModifyReadWriteState(org.hibernate.Session session, Object target) {
        return session.contains(target) && Hibernate.isInitialized((Object)target);
    }

    public static void setObjectToReadWrite(final Object target, SessionFactory sessionFactory) {
        HibernateTemplate template = new HibernateTemplate(sessionFactory);
        template.setExposeNativeSession(true);
        template.execute((HibernateCallback)new HibernateCallback<Void>(){

            public Void doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                SessionImplementor sessionImpl;
                EntityEntry ee;
                if (GrailsHibernateUtil.canModifyReadWriteState(session, target) && (ee = (sessionImpl = (SessionImplementor)session).getPersistenceContext().getEntry(target)) != null && ee.getStatus() == Status.READ_ONLY) {
                    Object actualTarget = target;
                    if (target instanceof HibernateProxy) {
                        actualTarget = ((HibernateProxy)target).getHibernateLazyInitializer().getImplementation();
                    }
                    session.setReadOnly(actualTarget, false);
                    session.setFlushMode(FlushMode.AUTO);
                    GrailsHibernateUtil.incrementVersion(target);
                }
                return null;
            }
        });
    }

    public static void incrementVersion(Object target) {
        Object version;
        MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
        if (metaClass.hasProperty(target, "version") != null && (version = metaClass.getProperty(target, "version")) instanceof Long) {
            Long newVersion = (Long)version + 1L;
            metaClass.setProperty(target, "version", (Object)newVersion);
        }
    }

    public static void ensureCorrectGroovyMetaClass(Object target, Class<?> persistentClass) {
        GroovyObject go;
        if (target instanceof GroovyObject && !(go = (GroovyObject)target).getMetaClass().getTheClass().equals(persistentClass)) {
            go.setMetaClass(GroovySystem.getMetaClassRegistry().getMetaClass(persistentClass));
        }
    }

    public static Object unwrapProxy(HibernateProxy proxy) {
        return proxyHandler.unwrapProxy(proxy);
    }

    public static HibernateProxy getAssociationProxy(Object obj, String associationName) {
        return proxyHandler.getAssociationProxy(obj, associationName);
    }

    public static boolean isInitialized(Object obj, String associationName) {
        return proxyHandler.isInitialized(obj, associationName);
    }

    public static boolean isCacheQueriesByDefault() {
        Object o = ConfigurationHolder.getFlatConfig().get(CONFIG_PROPERTY_CACHE_QUERIES);
        return o != null && o instanceof Boolean ? (Boolean)o : false;
    }

    public static GroovyAwareJavassistProxyFactory buildProxyFactory(PersistentClass persistentClass) {
        Setter idSetter;
        GroovyAwareJavassistProxyFactory proxyFactory = new GroovyAwareJavassistProxyFactory();
        HashSet proxyInterfaces = new HashSet<Class<?>>(){
            {
                this.add(HibernateProxy.class);
            }
        };
        Class javaClass = persistentClass.getMappedClass();
        Property identifierProperty = persistentClass.getIdentifierProperty();
        Getter idGetter = identifierProperty != null ? identifierProperty.getGetter(javaClass) : null;
        Setter setter = idSetter = identifierProperty != null ? identifierProperty.getSetter(javaClass) : null;
        if (idGetter == null || idSetter == null) {
            return null;
        }
        try {
            proxyFactory.postInstantiate(persistentClass.getEntityName(), javaClass, proxyInterfaces, idGetter.getMethod(), idSetter.getMethod(), persistentClass.hasEmbeddedIdentifier() ? (AbstractComponentType)persistentClass.getIdentifier().getType() : null);
        }
        catch (HibernateException e) {
            LOG.warn((Object)("Cannot instantiate proxy factory: " + e.getMessage()));
            return null;
        }
        return proxyFactory;
    }

    public static Object unwrapIfProxy(Object instance) {
        return proxyHandler.unwrapIfProxy(instance);
    }
}

