/*
 * Decompiled with CFR 0.152.
 */
package grails.orm;

import grails.orm.PagedResultList;
import grails.orm.RlikeExpression;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MissingMethodException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.AggregateProjection;
import org.hibernate.criterion.CountProjection;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyProjection;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateCriteriaBuilder
extends GroovyObjectSupport {
    public static final String AND = "and";
    public static final String IS_NULL = "isNull";
    public static final String IS_NOT_NULL = "isNotNull";
    public static final String NOT = "not";
    public static final String OR = "or";
    public static final String ID_EQUALS = "idEq";
    public static final String IS_EMPTY = "isEmpty";
    public static final String IS_NOT_EMPTY = "isNotEmpty";
    public static final String RLIKE = "rlike";
    public static final String BETWEEN = "between";
    public static final String EQUALS = "eq";
    public static final String EQUALS_PROPERTY = "eqProperty";
    public static final String GREATER_THAN = "gt";
    public static final String GREATER_THAN_PROPERTY = "gtProperty";
    public static final String GREATER_THAN_OR_EQUAL = "ge";
    public static final String GREATER_THAN_OR_EQUAL_PROPERTY = "geProperty";
    public static final String ILIKE = "ilike";
    public static final String IN = "in";
    public static final String LESS_THAN = "lt";
    public static final String LESS_THAN_PROPERTY = "ltProperty";
    public static final String LESS_THAN_OR_EQUAL = "le";
    public static final String LESS_THAN_OR_EQUAL_PROPERTY = "leProperty";
    public static final String LIKE = "like";
    public static final String NOT_EQUAL = "ne";
    public static final String NOT_EQUAL_PROPERTY = "neProperty";
    public static final String SIZE_EQUALS = "sizeEq";
    public static final String ORDER_DESCENDING = "desc";
    public static final String ORDER_ASCENDING = "asc";
    private static final String ROOT_DO_CALL = "doCall";
    private static final String ROOT_CALL = "call";
    private static final String LIST_CALL = "list";
    private static final String LIST_DISTINCT_CALL = "listDistinct";
    private static final String COUNT_CALL = "count";
    private static final String GET_CALL = "get";
    private static final String SCROLL_CALL = "scroll";
    private static final String SET_RESULT_TRANSFORMER_CALL = "setResultTransformer";
    private static final String PROJECTIONS = "projections";
    private SessionFactory sessionFactory;
    private Session hibernateSession;
    private Class<?> targetClass;
    private Criteria criteria;
    private MetaClass criteriaMetaClass;
    private boolean uniqueResult = false;
    private List<LogicalExpression> logicalExpressionStack = new ArrayList<LogicalExpression>();
    private List<String> associationStack = new ArrayList<String>();
    private boolean participate;
    private boolean scroll;
    private boolean count;
    private ProjectionList projectionList = Projections.projectionList();
    private BeanWrapper targetBean;
    private List<String> aliasStack = new ArrayList<String>();
    private List<Criteria> aliasInstanceStack = new ArrayList<Criteria>();
    private Map<String, String> aliasMap = new HashMap<String, String>();
    private static final String ALIAS = "_alias";
    private ResultTransformer resultTransformer;
    private int aliasCount;
    private boolean paginationEnabledList = false;
    private List<Order> orderEntries;

    public HibernateCriteriaBuilder(Class targetClass, SessionFactory sessionFactory) {
        this.targetClass = targetClass;
        this.targetBean = new BeanWrapperImpl(BeanUtils.instantiateClass((Class)targetClass));
        this.sessionFactory = sessionFactory;
    }

    public HibernateCriteriaBuilder(Class targetClass, SessionFactory sessionFactory, boolean uniqueResult) {
        this.targetClass = targetClass;
        this.sessionFactory = sessionFactory;
        this.uniqueResult = uniqueResult;
    }

    public Criteria getInstance() {
        return this.criteria;
    }

    public void setUniqueResult(boolean uniqueResult) {
        this.uniqueResult = uniqueResult;
    }

    public void property(String propertyName) {
        this.property(propertyName, null);
    }

    public void property(String propertyName, String alias) {
        PropertyProjection propertyProjection = Projections.property((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)propertyProjection, alias);
    }

    protected void addProjectionToList(Projection propertyProjection, String alias) {
        if (alias != null) {
            this.projectionList.add(propertyProjection, alias);
        } else {
            this.projectionList.add(propertyProjection);
        }
    }

    public void distinct(String propertyName) {
        this.distinct(propertyName, null);
    }

    public void distinct(String propertyName, String alias) {
        Projection proj = Projections.distinct((Projection)Projections.property((String)this.calculatePropertyName(propertyName)));
        this.addProjectionToList(proj, alias);
    }

    public void distinct(Collection propertyNames) {
        this.distinct(propertyNames, null);
    }

    public void distinct(Collection propertyNames, String alias) {
        ProjectionList list = Projections.projectionList();
        for (Object o : propertyNames) {
            list.add((Projection)Projections.property((String)this.calculatePropertyName(o.toString())));
        }
        Projection proj = Projections.distinct((Projection)list);
        this.addProjectionToList(proj, alias);
    }

    public void avg(String propertyName) {
        this.avg(propertyName, null);
    }

    public void avg(String propertyName, String alias) {
        AggregateProjection aggregateProjection = Projections.avg((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)aggregateProjection, alias);
    }

    public void join(String associationPath) {
        this.criteria.setFetchMode(this.calculatePropertyName(associationPath), FetchMode.JOIN);
    }

    public void lock(boolean shouldLock) {
        String lastAlias = this.getLastAlias();
        if (shouldLock) {
            if (lastAlias != null) {
                this.criteria.setLockMode(lastAlias, LockMode.UPGRADE);
            } else {
                this.criteria.setLockMode(LockMode.UPGRADE);
            }
        } else if (lastAlias != null) {
            this.criteria.setLockMode(lastAlias, LockMode.NONE);
        } else {
            this.criteria.setLockMode(LockMode.NONE);
        }
    }

    public void select(String associationPath) {
        this.criteria.setFetchMode(this.calculatePropertyName(associationPath), FetchMode.SELECT);
    }

    public void cache(boolean shouldCache) {
        this.criteria.setCacheable(shouldCache);
    }

    private String calculatePropertyName(String propertyName) {
        String lastAlias = this.getLastAlias();
        if (lastAlias != null) {
            return lastAlias + '.' + propertyName;
        }
        return propertyName;
    }

    private String getLastAlias() {
        if (this.aliasStack.size() > 0) {
            return this.aliasStack.get(this.aliasStack.size() - 1).toString();
        }
        return null;
    }

    private Object calculatePropertyValue(Object propertyValue) {
        if (propertyValue instanceof CharSequence) {
            return propertyValue.toString();
        }
        return propertyValue;
    }

    public void count(String propertyName) {
        this.count(propertyName, null);
    }

    public void count(String propertyName, String alias) {
        CountProjection proj = Projections.count((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)proj, alias);
    }

    public void countDistinct(String propertyName) {
        this.countDistinct(propertyName, null);
    }

    public void countDistinct(String propertyName, String alias) {
        CountProjection proj = Projections.countDistinct((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)proj, alias);
    }

    public void groupProperty(String propertyName) {
        this.groupProperty(propertyName, null);
    }

    public void groupProperty(String propertyName, String alias) {
        PropertyProjection proj = Projections.groupProperty((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)proj, alias);
    }

    public void max(String propertyName) {
        this.max(propertyName, null);
    }

    public void max(String propertyName, String alias) {
        AggregateProjection proj = Projections.max((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)proj, alias);
    }

    public void min(String propertyName) {
        this.min(propertyName, null);
    }

    public void min(String propertyName, String alias) {
        AggregateProjection aggregateProjection = Projections.min((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)aggregateProjection, alias);
    }

    public void rowCount() {
        this.rowCount(null);
    }

    public void rowCount(String alias) {
        Projection proj = Projections.rowCount();
        this.addProjectionToList(proj, alias);
    }

    public void sum(String propertyName) {
        this.sum(propertyName, null);
    }

    public void sum(String propertyName, String alias) {
        AggregateProjection proj = Projections.sum((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)proj, alias);
    }

    public void fetchMode(String associationPath, FetchMode fetchMode) {
        if (this.criteria != null) {
            this.criteria.setFetchMode(associationPath, fetchMode);
        }
    }

    public void resultTransformer(ResultTransformer transformer) {
        if (this.criteria == null) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [resultTransformer] not supported here"));
        }
        this.resultTransformer = transformer;
    }

    public Object eqProperty(String propertyName, String otherPropertyName) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [eqProperty] with propertyName [" + propertyName + "] and other property name [" + otherPropertyName + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        otherPropertyName = this.calculatePropertyName(otherPropertyName);
        return this.addToCriteria((Criterion)Restrictions.eqProperty((String)propertyName, (String)otherPropertyName));
    }

    public Object neProperty(String propertyName, String otherPropertyName) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [neProperty] with propertyName [" + propertyName + "] and other property name [" + otherPropertyName + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        otherPropertyName = this.calculatePropertyName(otherPropertyName);
        return this.addToCriteria((Criterion)Restrictions.neProperty((String)propertyName, (String)otherPropertyName));
    }

    public Object gtProperty(String propertyName, String otherPropertyName) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [gtProperty] with propertyName [" + propertyName + "] and other property name [" + otherPropertyName + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        otherPropertyName = this.calculatePropertyName(otherPropertyName);
        return this.addToCriteria((Criterion)Restrictions.gtProperty((String)propertyName, (String)otherPropertyName));
    }

    public Object geProperty(String propertyName, String otherPropertyName) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [geProperty] with propertyName [" + propertyName + "] and other property name [" + otherPropertyName + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        otherPropertyName = this.calculatePropertyName(otherPropertyName);
        return this.addToCriteria((Criterion)Restrictions.geProperty((String)propertyName, (String)otherPropertyName));
    }

    public Object ltProperty(String propertyName, String otherPropertyName) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [ltProperty] with propertyName [" + propertyName + "] and other property name [" + otherPropertyName + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        otherPropertyName = this.calculatePropertyName(otherPropertyName);
        return this.addToCriteria((Criterion)Restrictions.ltProperty((String)propertyName, (String)otherPropertyName));
    }

    public Object leProperty(String propertyName, String otherPropertyName) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [leProperty] with propertyName [" + propertyName + "] and other property name [" + otherPropertyName + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        otherPropertyName = this.calculatePropertyName(otherPropertyName);
        return this.addToCriteria((Criterion)Restrictions.leProperty((String)propertyName, (String)otherPropertyName));
    }

    public Object gt(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [gt] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        propertyValue = this.calculatePropertyValue(propertyValue);
        return this.addToCriteria((Criterion)Restrictions.gt((String)propertyName, (Object)propertyValue));
    }

    public Object ge(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [ge] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        propertyValue = this.calculatePropertyValue(propertyValue);
        return this.addToCriteria((Criterion)Restrictions.ge((String)propertyName, (Object)propertyValue));
    }

    public Object lt(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [lt] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        propertyValue = this.calculatePropertyValue(propertyValue);
        return this.addToCriteria((Criterion)Restrictions.lt((String)propertyName, (Object)propertyValue));
    }

    public Object le(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [le] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        propertyValue = this.calculatePropertyValue(propertyValue);
        return this.addToCriteria((Criterion)Restrictions.le((String)propertyName, (Object)propertyValue));
    }

    public Object eq(String propertyName, Object propertyValue) {
        return this.eq(propertyName, propertyValue, Collections.emptyMap());
    }

    public Object eq(Map params, String propertyName, Object propertyValue) {
        return this.eq(propertyName, propertyValue, params);
    }

    public Object eq(String propertyName, Object propertyValue, Map params) {
        Object ignoreCase;
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [eq] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        propertyValue = this.calculatePropertyValue(propertyValue);
        SimpleExpression eq = Restrictions.eq((String)propertyName, (Object)propertyValue);
        if (params != null && (ignoreCase = params.get("ignoreCase")) instanceof Boolean && ((Boolean)ignoreCase).booleanValue()) {
            eq = eq.ignoreCase();
        }
        return this.addToCriteria((Criterion)eq);
    }

    public Object sqlRestriction(String sqlRestriction) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [sqlRestriction] with value [" + sqlRestriction + "] not allowed here."));
        }
        return this.addToCriteria(Restrictions.sqlRestriction((String)sqlRestriction));
    }

    public Object like(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [like] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        propertyValue = this.calculatePropertyValue(propertyValue);
        return this.addToCriteria((Criterion)Restrictions.like((String)propertyName, (Object)propertyValue));
    }

    public Object rlike(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [rlike] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        propertyValue = this.calculatePropertyValue(propertyValue);
        return this.addToCriteria(new RlikeExpression(propertyName, propertyValue));
    }

    public Object ilike(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [ilike] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        propertyValue = this.calculatePropertyValue(propertyValue);
        return this.addToCriteria(Restrictions.ilike((String)propertyName, (Object)propertyValue));
    }

    public Object in(String propertyName, Collection values) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [in] with propertyName [" + propertyName + "] and values [" + values + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        return this.addToCriteria(Restrictions.in((String)propertyName, (Collection)values));
    }

    public Object inList(String propertyName, Collection values) {
        return this.in(propertyName, values);
    }

    public Object inList(String propertyName, Object[] values) {
        return this.in(propertyName, values);
    }

    public Object in(String propertyName, Object[] values) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [in] with propertyName [" + propertyName + "] and values [" + values + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        return this.addToCriteria(Restrictions.in((String)propertyName, (Object[])values));
    }

    public Object order(String propertyName) {
        if (this.criteria == null) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [order] with propertyName [" + propertyName + "]not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        Order o = Order.asc((String)propertyName);
        if (this.paginationEnabledList) {
            this.orderEntries.add(o);
        } else {
            this.criteria.addOrder(o);
        }
        return o;
    }

    public Object order(String propertyName, String direction) {
        if (this.criteria == null) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [order] with propertyName [" + propertyName + "]not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        Order o = direction.equals(ORDER_DESCENDING) ? Order.desc((String)propertyName) : Order.asc((String)propertyName);
        if (this.paginationEnabledList) {
            this.orderEntries.add(o);
        } else {
            this.criteria.addOrder(o);
        }
        return o;
    }

    public Object sizeEq(String propertyName, int size) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [sizeEq] with propertyName [" + propertyName + "] and size [" + size + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        return this.addToCriteria(Restrictions.sizeEq((String)propertyName, (int)size));
    }

    public Object sizeGt(String propertyName, int size) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [sizeGt] with propertyName [" + propertyName + "] and size [" + size + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        return this.addToCriteria(Restrictions.sizeGt((String)propertyName, (int)size));
    }

    public Object sizeGe(String propertyName, int size) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [sizeGe] with propertyName [" + propertyName + "] and size [" + size + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        return this.addToCriteria(Restrictions.sizeGe((String)propertyName, (int)size));
    }

    public Object sizeLe(String propertyName, int size) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [sizeLe] with propertyName [" + propertyName + "] and size [" + size + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        return this.addToCriteria(Restrictions.sizeLe((String)propertyName, (int)size));
    }

    public Object sizeLt(String propertyName, int size) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [sizeLt] with propertyName [" + propertyName + "] and size [" + size + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        return this.addToCriteria(Restrictions.sizeLt((String)propertyName, (int)size));
    }

    public Object sizeNe(String propertyName, int size) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [sizeNe] with propertyName [" + propertyName + "] and size [" + size + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        return this.addToCriteria(Restrictions.sizeNe((String)propertyName, (int)size));
    }

    public Object ne(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [ne] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        propertyValue = this.calculatePropertyValue(propertyValue);
        return this.addToCriteria((Criterion)Restrictions.ne((String)propertyName, (Object)propertyValue));
    }

    public Object notEqual(String propertyName, Object propertyValue) {
        return this.ne(propertyName, propertyValue);
    }

    public Object between(String propertyName, Object lo, Object hi) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [between] with propertyName [" + propertyName + "]  not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        return this.addToCriteria(Restrictions.between((String)propertyName, (Object)lo, (Object)hi));
    }

    private boolean validateSimpleExpression() {
        return this.criteria != null;
    }

    public Object invokeMethod(String name, Object obj) {
        MetaMethod metaMethod;
        Object[] objectArray;
        if (obj.getClass().isArray()) {
            objectArray = (Object[])obj;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = obj;
        }
        Object[] args = objectArray;
        if (this.paginationEnabledList && SET_RESULT_TRANSFORMER_CALL.equals(name) && args.length == 1 && args[0] instanceof ResultTransformer) {
            this.resultTransformer = (ResultTransformer)args[0];
            return null;
        }
        if (this.isCriteriaConstructionMethod(name, args)) {
            Object result;
            if (this.criteria != null) {
                this.throwRuntimeException(new IllegalArgumentException("call to [" + name + "] not supported here"));
            }
            if (name.equals(GET_CALL)) {
                this.uniqueResult = true;
            } else if (name.equals(SCROLL_CALL)) {
                this.scroll = true;
            } else if (name.equals(COUNT_CALL)) {
                this.count = true;
            } else if (name.equals(LIST_DISTINCT_CALL)) {
                this.resultTransformer = CriteriaSpecification.DISTINCT_ROOT_ENTITY;
            }
            this.createCriteriaInstance();
            if (name.equals(LIST_CALL) && args.length == 2) {
                this.paginationEnabledList = true;
                this.orderEntries = new ArrayList<Order>();
                this.invokeClosureNode(args[1]);
            } else {
                this.invokeClosureNode(args[0]);
            }
            if (this.resultTransformer != null) {
                this.criteria.setResultTransformer(this.resultTransformer);
            }
            if (!this.uniqueResult) {
                if (this.scroll) {
                    result = this.criteria.scroll();
                } else if (this.count) {
                    this.criteria.setProjection(Projections.rowCount());
                    result = this.criteria.uniqueResult();
                } else if (this.paginationEnabledList) {
                    this.criteria.setFirstResult(0);
                    this.criteria.setMaxResults(Integer.MAX_VALUE);
                    this.criteria.setProjection(Projections.rowCount());
                    int totalCount = (Integer)this.criteria.uniqueResult();
                    this.criteria.setProjection(null);
                    Iterator<Order> it = this.orderEntries.iterator();
                    while (it.hasNext()) {
                        this.criteria.addOrder(it.next());
                    }
                    if (this.resultTransformer == null) {
                        this.criteria.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
                    } else if (this.paginationEnabledList) {
                        this.criteria.setResultTransformer(this.resultTransformer);
                    }
                    GrailsHibernateUtil.populateArgumentsForCriteria(this.targetClass, this.criteria, (Map)args[0]);
                    PagedResultList pagedRes = new PagedResultList(this.criteria.list());
                    pagedRes.setTotalCount(totalCount);
                    result = pagedRes;
                } else {
                    result = this.criteria.list();
                }
            } else {
                result = GrailsHibernateUtil.unwrapIfProxy(this.criteria.uniqueResult());
            }
            if (!this.participate) {
                this.hibernateSession.close();
            }
            return result;
        }
        if (this.criteria == null) {
            this.createCriteriaInstance();
        }
        if ((metaMethod = this.getMetaClass().getMetaMethod(name, args)) != null) {
            return metaMethod.invoke((Object)this, args);
        }
        metaMethod = this.criteriaMetaClass.getMetaMethod(name, args);
        if (metaMethod != null) {
            return metaMethod.invoke((Object)this.criteria, args);
        }
        metaMethod = this.criteriaMetaClass.getMetaMethod(GrailsClassUtils.getSetterName((String)name), args);
        if (metaMethod != null) {
            return metaMethod.invoke((Object)this.criteria, args);
        }
        if (args.length == 1 && args[0] instanceof Closure) {
            ClassMetadata meta;
            Type type;
            if (name.equals(AND) || name.equals(OR) || name.equals(NOT)) {
                if (this.criteria == null) {
                    this.throwRuntimeException(new IllegalArgumentException("call to [" + name + "] not supported here"));
                }
                this.logicalExpressionStack.add(new LogicalExpression(name));
                this.invokeClosureNode(args[0]);
                LogicalExpression logicalExpression = this.logicalExpressionStack.remove(this.logicalExpressionStack.size() - 1);
                this.addToCriteria(logicalExpression.toCriterion());
                return name;
            }
            if (name.equals(PROJECTIONS) && args.length == 1 && args[0] instanceof Closure) {
                if (this.criteria == null) {
                    this.throwRuntimeException(new IllegalArgumentException("call to [" + name + "] not supported here"));
                }
                this.projectionList = Projections.projectionList();
                this.invokeClosureNode(args[0]);
                if (this.projectionList != null && this.projectionList.getLength() > 0) {
                    this.criteria.setProjection((Projection)this.projectionList);
                }
                return name;
            }
            if (this.targetBean.isReadableProperty(name.toString()) && (type = (meta = this.sessionFactory.getClassMetadata(this.targetBean.getWrappedClass())).getPropertyType(name.toString())).isAssociationType()) {
                String otherSideEntityName = ((AssociationType)type).getAssociatedEntityName((SessionFactoryImplementor)this.sessionFactory);
                Class<?> oldTargetClass = this.targetClass;
                this.targetClass = this.sessionFactory.getClassMetadata(otherSideEntityName).getMappedClass(EntityMode.POJO);
                BeanWrapper oldTargetBean = this.targetBean;
                this.targetBean = new BeanWrapperImpl(BeanUtils.instantiateClass(this.targetClass));
                this.associationStack.add(name.toString());
                String associationPath = this.getAssociationPath();
                this.createAliasIfNeccessary(name, associationPath);
                this.logicalExpressionStack.add(new LogicalExpression(AND));
                this.invokeClosureNode(args[0]);
                this.aliasStack.remove(this.aliasStack.size() - 1);
                if (!this.aliasInstanceStack.isEmpty()) {
                    this.aliasInstanceStack.remove(this.aliasInstanceStack.size() - 1);
                }
                LogicalExpression logicalExpression = this.logicalExpressionStack.remove(this.logicalExpressionStack.size() - 1);
                if (!logicalExpression.args.isEmpty()) {
                    this.addToCriteria(logicalExpression.toCriterion());
                }
                this.associationStack.remove(this.associationStack.size() - 1);
                this.targetClass = oldTargetClass;
                this.targetBean = oldTargetBean;
                return name;
            }
        } else if (args.length == 1 && args[0] != null) {
            if (this.criteria == null) {
                this.throwRuntimeException(new IllegalArgumentException("call to [" + name + "] not supported here"));
            }
            Object value = args[0];
            Criterion c = null;
            if (name.equals(ID_EQUALS)) {
                return this.eq("id", value);
            }
            if (name.equals(IS_NULL) || name.equals(IS_NOT_NULL) || name.equals(IS_EMPTY) || name.equals(IS_NOT_EMPTY)) {
                if (!(value instanceof String)) {
                    this.throwRuntimeException(new IllegalArgumentException("call to [" + name + "] with value [" + value + "] requires a String value."));
                }
                String propertyName = this.calculatePropertyName((String)value);
                if (name.equals(IS_NULL)) {
                    c = Restrictions.isNull((String)propertyName);
                } else if (name.equals(IS_NOT_NULL)) {
                    c = Restrictions.isNotNull((String)propertyName);
                } else if (name.equals(IS_EMPTY)) {
                    c = Restrictions.isEmpty((String)propertyName);
                } else if (name.equals(IS_NOT_EMPTY)) {
                    c = Restrictions.isNotEmpty((String)propertyName);
                }
            }
            if (c != null) {
                return this.addToCriteria(c);
            }
        }
        throw new MissingMethodException(name, ((Object)((Object)this)).getClass(), args);
    }

    private void addToCurrentOrAliasedCriteria(Criterion criterion) {
        if (!this.aliasInstanceStack.isEmpty()) {
            Criteria c = this.aliasInstanceStack.get(this.aliasInstanceStack.size() - 1);
            c.add(criterion);
        } else {
            this.criteria.add(criterion);
        }
    }

    private void createAliasIfNeccessary(String associationName, String associationPath) {
        String newAlias;
        if (this.aliasMap.containsKey(associationPath)) {
            newAlias = this.aliasMap.get(associationPath);
        } else {
            ++this.aliasCount;
            newAlias = associationName + ALIAS + this.aliasCount;
            this.aliasMap.put(associationPath, newAlias);
            this.aliasInstanceStack.add(this.criteria.createAlias(associationPath, newAlias, 1));
        }
        this.aliasStack.add(newAlias);
    }

    private String getAssociationPath() {
        StringBuilder fullPath = new StringBuilder();
        Iterator<String> i$ = this.associationStack.iterator();
        while (i$.hasNext()) {
            String anAssociationStack;
            String propertyName = anAssociationStack = i$.next();
            if (fullPath.length() > 0) {
                fullPath.append(".");
            }
            fullPath.append(propertyName);
        }
        String associationPath = fullPath.toString();
        return associationPath;
    }

    private boolean isCriteriaConstructionMethod(String name, Object[] args) {
        return name.equals(LIST_CALL) && args.length == 2 && args[0] instanceof Map && args[1] instanceof Closure || name.equals(ROOT_CALL) || name.equals(ROOT_DO_CALL) || name.equals(LIST_CALL) || name.equals(LIST_DISTINCT_CALL) || name.equals(GET_CALL) || name.equals(COUNT_CALL) || name.equals(SCROLL_CALL) && args.length == 1 && args[0] instanceof Closure;
    }

    public Criteria buildCriteria(Closure criteriaClosure) {
        this.createCriteriaInstance();
        criteriaClosure.setDelegate((Object)this);
        criteriaClosure.call();
        return this.criteria;
    }

    private void createCriteriaInstance() {
        if (TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
            this.participate = true;
            this.hibernateSession = ((SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory)).getSession();
        } else {
            this.hibernateSession = this.sessionFactory.openSession();
        }
        this.criteria = this.hibernateSession.createCriteria(this.targetClass);
        GrailsHibernateUtil.cacheCriteriaByMapping(this.targetClass, this.criteria);
        this.criteriaMetaClass = GroovySystem.getMetaClassRegistry().getMetaClass(this.criteria.getClass());
    }

    private void invokeClosureNode(Object args) {
        Closure callable = (Closure)args;
        callable.setDelegate((Object)this);
        callable.setResolveStrategy(1);
        callable.call();
    }

    private void throwRuntimeException(RuntimeException t) {
        this.closeSessionFollowingException();
        throw t;
    }

    private void closeSessionFollowingException() {
        if (this.hibernateSession != null && this.hibernateSession.isOpen() && !this.participate) {
            this.hibernateSession.close();
        }
        this.criteria = null;
    }

    private Criterion addToCriteria(Criterion c) {
        if (!this.logicalExpressionStack.isEmpty()) {
            this.logicalExpressionStack.get((int)(this.logicalExpressionStack.size() - 1)).args.add(c);
        } else {
            this.criteria.add(c);
        }
        return c;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogicalExpression {
        final Object name;
        final List<Criterion> args = new ArrayList<Criterion>();

        LogicalExpression(Object name) {
            this.name = name;
        }

        Criterion toCriterion() {
            if (this.name.equals(HibernateCriteriaBuilder.NOT)) {
                switch (this.args.size()) {
                    case 0: {
                        HibernateCriteriaBuilder.this.throwRuntimeException(new IllegalArgumentException("Logical expression [not] must contain at least 1 expression"));
                        return null;
                    }
                    case 1: {
                        return Restrictions.not((Criterion)this.args.get(0));
                    }
                }
                return Restrictions.not((Criterion)this.buildJunction((Junction)Restrictions.disjunction(), this.args));
            }
            if (this.name.equals(HibernateCriteriaBuilder.AND)) {
                return this.buildJunction((Junction)Restrictions.conjunction(), this.args);
            }
            if (this.name.equals(HibernateCriteriaBuilder.OR)) {
                return this.buildJunction((Junction)Restrictions.disjunction(), this.args);
            }
            HibernateCriteriaBuilder.this.throwRuntimeException(new IllegalStateException("Logical expression [" + this.name + "] not handled!"));
            return null;
        }

        Junction buildJunction(Junction junction, List<Criterion> criterions) {
            for (Criterion c : criterions) {
                junction.add(c);
            }
            return junction;
        }
    }
}

