/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.sitemesh;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.factory.DefaultFactory;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.ContentProcessor;
import com.opensymphony.sitemesh.Decorator;
import com.opensymphony.sitemesh.DecoratorSelector;
import com.opensymphony.sitemesh.SiteMeshContext;
import com.opensymphony.sitemesh.compatability.Content2HTMLPage;
import com.opensymphony.sitemesh.compatability.DecoratorMapper2DecoratorSelector;
import com.opensymphony.sitemesh.compatability.OldDecorator2NewDecorator;
import com.opensymphony.sitemesh.webapp.ContainerTweaks;
import com.opensymphony.sitemesh.webapp.SiteMeshFilter;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.support.NullPersistentContextInterceptor;
import org.codehaus.groovy.grails.support.PersistenceContextInterceptor;
import org.codehaus.groovy.grails.web.sitemesh.FactoryHolder;
import org.codehaus.groovy.grails.web.sitemesh.GSPSitemeshPage;
import org.codehaus.groovy.grails.web.sitemesh.GrailsContentBufferingResponse;
import org.codehaus.groovy.grails.web.sitemesh.GrailsNoDecorator;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.util.UrlPathHelper;

public class GrailsPageFilter
extends SiteMeshFilter {
    private static final String ALREADY_APPLIED_KEY = "com.opensymphony.sitemesh.APPLIED_ONCE";
    private static final String HTML_EXT = ".html";
    private static final String UTF_8_ENCODING = "UTF-8";
    private static final String CONFIG_OPTION_GSP_ENCODING = "grails.views.gsp.encoding";
    public static final String GSP_SITEMESH_PAGE = GrailsPageFilter.class.getName() + ".GSP_SITEMESH_PAGE";
    private FilterConfig filterConfig;
    private ContainerTweaks containerTweaks;
    private WebApplicationContext applicationContext;
    private PersistenceContextInterceptor persistenceInterceptor = new NullPersistentContextInterceptor();

    public void init(FilterConfig fc) {
        super.init(fc);
        this.filterConfig = fc;
        this.containerTweaks = new ContainerTweaks();
        Config config = new Config(fc);
        DefaultFactory defaultFactory = new DefaultFactory(config);
        config.getServletContext().setAttribute("sitemesh.factory", (Object)defaultFactory);
        defaultFactory.refresh();
        FactoryHolder.setFactory((Factory)defaultFactory);
        this.applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)fc.getServletContext());
        Map interceptors = this.applicationContext.getBeansOfType(PersistenceContextInterceptor.class);
        if (!interceptors.isEmpty()) {
            this.persistenceInterceptor = (PersistenceContextInterceptor)interceptors.values().iterator().next();
        }
    }

    public void destroy() {
        super.destroy();
        FactoryHolder.setFactory(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest rq, ServletResponse rs, FilterChain chain) throws IOException, ServletException {
        block13: {
            block12: {
                HttpServletRequest request = (HttpServletRequest)rq;
                HttpServletResponse response = (HttpServletResponse)rs;
                ServletContext servletContext = this.filterConfig.getServletContext();
                SiteMeshWebAppContext webAppContext = new SiteMeshWebAppContext(request, response, servletContext);
                ContentProcessor contentProcessor = this.initContentProcessor(webAppContext);
                DecoratorSelector decoratorSelector = this.initDecoratorSelector(webAppContext);
                if (this.filterAlreadyAppliedForRequest(request)) {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                if (!contentProcessor.handles((SiteMeshContext)webAppContext)) {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                if (this.containerTweaks.shouldAutoCreateSession()) {
                    request.getSession(true);
                }
                try {
                    try {
                        Content content = this.obtainContent(contentProcessor, webAppContext, request, response, chain);
                        if (content == null) {
                            Object var13_14 = null;
                            break block12;
                        }
                        this.detectContentTypeFromPage(content, response);
                        Decorator decorator = decoratorSelector.selectDecorator(content, (SiteMeshContext)webAppContext);
                        this.persistenceInterceptor.reconnect();
                        decorator.render(content, (SiteMeshContext)webAppContext);
                        break block13;
                    }
                    catch (IllegalStateException e) {
                        if (!this.containerTweaks.shouldIgnoreIllegalStateExceptionOnErrorPage()) {
                            throw e;
                        }
                        Object var13_16 = null;
                        if (!this.persistenceInterceptor.isOpen()) return;
                        this.persistenceInterceptor.destroy();
                        return;
                    }
                    catch (RuntimeException e) {
                        if (!this.containerTweaks.shouldLogUnhandledExceptions()) throw e;
                        servletContext.log("Unhandled exception occurred whilst decorating page", (Throwable)e);
                        throw e;
                    }
                    catch (ServletException e) {
                        request.setAttribute(ALREADY_APPLIED_KEY, null);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_17 = null;
                    if (!this.persistenceInterceptor.isOpen()) throw throwable;
                    this.persistenceInterceptor.destroy();
                    throw throwable;
                }
            }
            if (!this.persistenceInterceptor.isOpen()) return;
            this.persistenceInterceptor.destroy();
            return;
        }
        Object var13_15 = null;
        if (!this.persistenceInterceptor.isOpen()) return;
        this.persistenceInterceptor.destroy();
    }

    private HTMLPage content2htmlPage(Content content) {
        Object htmlPage = null;
        htmlPage = content instanceof HTMLPage ? (HTMLPage)content : new Content2HTMLPage(content);
        return htmlPage;
    }

    protected DecoratorSelector initDecoratorSelector(SiteMeshWebAppContext webAppContext) {
        final Factory factory = Factory.getInstance((Config)new Config(this.filterConfig));
        factory.refresh();
        return new DecoratorMapper2DecoratorSelector(factory.getDecoratorMapper()){

            public Decorator selectDecorator(Content content, SiteMeshContext context) {
                SiteMeshWebAppContext siteMeshWebAppContext = (SiteMeshWebAppContext)context;
                final com.opensymphony.module.sitemesh.Decorator decorator = factory.getDecoratorMapper().getDecorator(siteMeshWebAppContext.getRequest(), (Page)GrailsPageFilter.this.content2htmlPage(content));
                if (decorator == null || decorator.getPage() == null) {
                    return new GrailsNoDecorator();
                }
                return new OldDecorator2NewDecorator(decorator){

                    protected void render(Content content, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, SiteMeshWebAppContext webAppContext) throws IOException, ServletException {
                        HTMLPage htmlPage = GrailsPageFilter.this.content2htmlPage(content);
                        request.setAttribute("__sitemesh__page", (Object)htmlPage);
                        if (decorator.getURIPath() != null && servletContext.getContext(decorator.getURIPath()) != null) {
                            servletContext = servletContext.getContext(decorator.getURIPath());
                        }
                        RequestDispatcher dispatcher = servletContext.getRequestDispatcher(decorator.getPage());
                        if (response.isCommitted()) {
                            dispatcher.include((ServletRequest)request, (ServletResponse)response);
                        } else {
                            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                        }
                        request.removeAttribute("__sitemesh__page");
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Content obtainContent(ContentProcessor contentProcessor, SiteMeshWebAppContext webAppContext, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Content content;
        block2: {
            Object oldGspSiteMeshPage = request.getAttribute(GSP_SITEMESH_PAGE);
            try {
                request.setAttribute(GSP_SITEMESH_PAGE, (Object)new GSPSitemeshPage());
                GrailsContentBufferingResponse contentBufferingResponse = new GrailsContentBufferingResponse(response, contentProcessor, webAppContext);
                this.setDefaultConfiguredEncoding(request, contentBufferingResponse);
                chain.doFilter((ServletRequest)request, (ServletResponse)contentBufferingResponse);
                webAppContext.setUsingStream(contentBufferingResponse.isUsingStream());
                content = contentBufferingResponse.getContent();
                Object var10_9 = null;
                if (oldGspSiteMeshPage == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var10_10 = null;
                    if (oldGspSiteMeshPage == null) break block3;
                    request.setAttribute(GSP_SITEMESH_PAGE, oldGspSiteMeshPage);
                }
                throw throwable;
            }
            request.setAttribute(GSP_SITEMESH_PAGE, oldGspSiteMeshPage);
        }
        return content;
    }

    private void setDefaultConfiguredEncoding(HttpServletRequest request, GrailsContentBufferingResponse contentBufferingResponse) {
        UrlPathHelper urlHelper = new UrlPathHelper();
        String requestURI = urlHelper.getOriginatingRequestUri(request);
        if (requestURI.endsWith(HTML_EXT)) {
            String encoding = (String)ConfigurationHolder.getFlatConfig().get(CONFIG_OPTION_GSP_ENCODING);
            if (encoding == null) {
                encoding = UTF_8_ENCODING;
            }
            contentBufferingResponse.setContentType("text/html;charset=" + encoding);
        }
    }

    private boolean filterAlreadyAppliedForRequest(HttpServletRequest request) {
        if (request.getAttribute(ALREADY_APPLIED_KEY) == Boolean.TRUE) {
            return true;
        }
        request.setAttribute(ALREADY_APPLIED_KEY, (Object)Boolean.TRUE);
        return false;
    }

    private void detectContentTypeFromPage(Content page, HttpServletResponse response) {
        String contentType = page.getProperty("meta.http-equiv.Content-Type");
        if (contentType != null && "text/html".equals(response.getContentType())) {
            response.setContentType(contentType);
        }
    }
}

