/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping.filter;

import grails.util.GrailsUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.compiler.GrailsClassLoader;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.codehaus.groovy.grails.web.mapping.exceptions.UrlMappingException;
import org.codehaus.groovy.grails.web.mime.MimeType;
import org.codehaus.groovy.grails.web.servlet.WrappedResponseHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.util.UrlPathHelper;

public class UrlMappingsFilter
extends OncePerRequestFilter {
    private UrlPathHelper urlHelper = new UrlPathHelper();
    private static final Log LOG = LogFactory.getLog(UrlMappingsFilter.class);
    private static final String GSP_SUFFIX = ".gsp";
    private static final String JSP_SUFFIX = ".jsp";
    private HandlerInterceptor[] handlerInterceptors = new HandlerInterceptor[0];
    private GrailsApplication application;
    private ViewResolver viewResolver;

    protected void initFilterBean() throws ServletException {
        super.initFilterBean();
        this.urlHelper.setUrlDecode(false);
        ServletContext servletContext = this.getServletContext();
        this.handlerInterceptors = WebUtils.lookupHandlerInterceptors(servletContext);
        this.application = WebUtils.lookupApplication(servletContext);
        this.viewResolver = WebUtils.lookupViewResolver(servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String format;
        UrlMappingsHolder holder = WebUtils.lookupUrlMappings(this.getServletContext());
        GrailsWebRequest webRequest = (GrailsWebRequest)request.getAttribute("org.codehaus.groovy.grails.WEB_REQUEST");
        List excludePatterns = holder.getExcludePatterns();
        String uri = this.urlHelper.getPathWithinApplication(request);
        this.checkForCompilationErrors();
        GrailsClass[] controllers = this.application.getArtefacts("Controller");
        if (!(controllers != null && controllers.length != 0 && holder != null || "/".equals(uri))) {
            this.processFilterChain(request, response, filterChain);
            return;
        }
        if (excludePatterns != null && excludePatterns.size() > 0) {
            for (String excludePattern : excludePatterns) {
                if (!uri.equals(excludePattern) && (!excludePattern.endsWith("*") || !excludePattern.substring(0, excludePattern.length() - 1).regionMatches(0, uri, 0, excludePattern.length() - 1))) continue;
                this.processFilterChain(request, response, filterChain);
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing URL mapping filter...");
            LOG.debug((Object)holder);
        }
        if (WebUtils.areFileExtensionsEnabled() && (format = WebUtils.getFormatFromURI(uri)) != null) {
            MimeType[] configuredMimes;
            for (MimeType configuredMime : configuredMimes = MimeType.getConfiguredMimeTypes()) {
                if (!configuredMime.getExtension().equals(format)) continue;
                request.setAttribute("org.codehaus.groovy.grails.CONTENT_FORMAT", (Object)format);
                uri = uri.substring(0, uri.length() - format.length() - 1);
                break;
            }
        }
        UrlMappingInfo[] urlInfos = holder.matchAll(uri);
        WrappedResponseHolder.setWrappedResponse(response);
        boolean dispatched = false;
        try {
            Map backupParameters;
            try {
                backupParameters = new HashMap(webRequest.getParams());
            }
            catch (Exception e) {
                GrailsUtil.deepSanitize(e);
                LOG.error((Object)("Error creating params object: " + e.getMessage()), (Throwable)e);
                backupParameters = Collections.EMPTY_MAP;
            }
            for (UrlMappingInfo info : urlInfos) {
                String viewName;
                block23: {
                    if (info == null) continue;
                    webRequest.getParams().clear();
                    webRequest.getParams().putAll(backupParameters);
                    try {
                        info.configure(webRequest);
                        String action = info.getActionName() == null ? "" : info.getActionName();
                        viewName = info.getViewName();
                        if (viewName != null || info.getURI() != null) break block23;
                        String controllerName = info.getControllerName();
                        GrailsClass controller = this.application.getArtefactForFeature("Controller", (Object)('/' + controllerName + '/' + action));
                        if (controller == null) {
                        }
                        break block23;
                    }
                    catch (Exception e) {
                        GrailsUtil.deepSanitize(e);
                        if (e instanceof MultipartException) {
                            throw (MultipartException)e;
                        }
                        LOG.error((Object)("Error when matching URL mapping [" + info + "]:" + e.getMessage()), (Throwable)e);
                    }
                    continue;
                }
                dispatched = true;
                request = this.checkMultipart(request);
                if (viewName == null || viewName.endsWith(GSP_SUFFIX) || viewName.endsWith(JSP_SUFFIX)) {
                    if (info.isParsingRequest()) {
                        webRequest.informParameterCreationListeners();
                    }
                    String forwardUrl = WebUtils.forwardRequestForUrlMappingInfo(request, response, info);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Matched URI [" + uri + "] to URL mapping [" + info + "], forwarding to [" + forwardUrl + "] with response [" + response.getClass() + "]"));
                    }
                } else if (!this.renderViewForUrlMappingInfo(request, response, info, viewName)) {
                    dispatched = false;
                }
                break;
            }
        }
        finally {
            WrappedResponseHolder.setWrappedResponse(null);
        }
        if (!dispatched) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No match found, processing remaining filter chain.");
            }
            this.processFilterChain(request, response, filterChain);
        }
    }

    private void checkForCompilationErrors() {
        GrailsClassLoader gcl;
        if (this.application.isWarDeployed()) {
            return;
        }
        ClassLoader classLoader = this.application.getClassLoader();
        if (classLoader instanceof GrailsClassLoader && (gcl = (GrailsClassLoader)classLoader).hasCompilationErrors()) {
            throw gcl.getCompilationError();
        }
    }

    protected HttpServletRequest checkMultipart(HttpServletRequest request) throws MultipartException {
        HttpServletRequest resolvedRequest = (HttpServletRequest)request.getAttribute(MultipartHttpServletRequest.class.getName());
        if (resolvedRequest != null) {
            return resolvedRequest;
        }
        return request;
    }

    private boolean renderViewForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, String viewName) {
        if (this.viewResolver != null) {
            try {
                for (HandlerInterceptor handlerInterceptor : this.handlerInterceptors) {
                    if (handlerInterceptor.preHandle(request, response, (Object)this)) continue;
                    return false;
                }
                ModelAndView modelAndView = new ModelAndView(viewName);
                for (HandlerInterceptor handlerInterceptor : this.handlerInterceptors) {
                    handlerInterceptor.postHandle(request, response, (Object)this, modelAndView);
                }
                View v = WebUtils.resolveView(request, info, modelAndView.getViewName(), this.viewResolver);
                v.render(modelAndView.getModel(), request, response);
                for (HandlerInterceptor handlerInterceptor : this.handlerInterceptors) {
                    handlerInterceptor.afterCompletion(request, response, (Object)this, null);
                }
            }
            catch (Exception e) {
                GrailsUtil.deepSanitize(e);
                for (HandlerInterceptor handlerInterceptor : this.handlerInterceptors) {
                    try {
                        handlerInterceptor.afterCompletion(request, response, (Object)this, e);
                    }
                    catch (Exception e1) {
                        throw new UrlMappingException("Error executing filter after view error: " + e1.getMessage() + ". Original error: " + e.getMessage(), e1);
                    }
                }
                throw new UrlMappingException("Error mapping onto view [" + viewName + "]: " + e.getMessage(), e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFilterChain(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            WrappedResponseHolder.setWrappedResponse(response);
            if (filterChain != null) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        finally {
            WrappedResponseHolder.setWrappedResponse(null);
        }
    }
}

