/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.actor.impl;

import groovy.lang.Closure;
import groovy.time.Duration;
import groovyx.gpars.actor.Actor;
import groovyx.gpars.actor.ActorMessage;
import groovyx.gpars.dataflow.DataCallback;
import groovyx.gpars.remote.RemoteConnection;
import groovyx.gpars.remote.RemoteHost;
import groovyx.gpars.serial.RemoteSerialized;
import groovyx.gpars.serial.SerialMsg;
import groovyx.gpars.serial.WithSerialId;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageStream
extends WithSerialId {
    public abstract MessageStream send(Object var1);

    public MessageStream send() {
        return this.send(new Object());
    }

    public final <T> MessageStream send(T message, MessageStream replyTo) {
        return this.send(new ActorMessage<T>(message, replyTo));
    }

    public final <T> MessageStream leftShift(T message) {
        return this.send(message);
    }

    public final <T, V> V sendAndWait(T message) throws InterruptedException {
        ResultWaiter to = new ResultWaiter();
        this.send(new ActorMessage<T>(message, to));
        return to.getResult();
    }

    public final <T> MessageStream sendAndContinue(T message, Closure closure) throws InterruptedException {
        closure = (Closure)closure.clone();
        closure.setDelegate((Object)this);
        closure.setResolveStrategy(1);
        return this.send(message, new DataCallback(closure));
    }

    public final <T> Object sendAndWait(T message, long timeout, TimeUnit units) throws InterruptedException {
        ResultWaiter to = new ResultWaiter();
        this.send(new ActorMessage<T>(message, to));
        return to.getResult(timeout, units);
    }

    public final <T> Object sendAndWait(T message, Duration duration) throws InterruptedException {
        return this.sendAndWait(message, duration.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public Class<RemoteMessageStream> getRemoteClass() {
        return RemoteMessageStream.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SendTo<T>
    extends SerialMsg {
        private static final long serialVersionUID = 1989120447646342520L;
        private final MessageStream to;
        private final ActorMessage<T> message;

        public SendTo(MessageStream to, ActorMessage<T> message) {
            this.to = to;
            this.message = message;
        }

        public MessageStream getTo() {
            return this.to;
        }

        public ActorMessage<T> getMessage() {
            return this.message;
        }

        @Override
        public void execute(RemoteConnection conn) {
            this.to.send(this.message);
        }
    }

    public static class RemoteMessageStream
    extends MessageStream
    implements RemoteSerialized {
        private static final long serialVersionUID = 3936054469565089659L;
        private final RemoteHost remoteHost;

        public RemoteMessageStream(RemoteHost host) {
            this.remoteHost = host;
        }

        public MessageStream send(Object message) {
            if (!(message instanceof ActorMessage)) {
                message = new ActorMessage<Object>(message, Actor.threadBoundActor());
            }
            this.remoteHost.write(new SendTo<Object>(this, message));
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultWaiter<V>
    extends MessageStream {
        private static final long serialVersionUID = 6512046150496489148L;
        private volatile Object value = Thread.currentThread();
        private volatile boolean isSet;

        private ResultWaiter() {
        }

        @Override
        public MessageStream send(Object message) {
            Thread thread = (Thread)this.value;
            this.value = message instanceof ActorMessage ? ((ActorMessage)message).getPayLoad() : message;
            this.isSet = true;
            LockSupport.unpark(thread);
            return this;
        }

        public V getResult() throws InterruptedException {
            while (!this.isSet) {
                LockSupport.park();
                Thread thread = Thread.currentThread();
                if (!thread.isInterrupted()) continue;
                throw new InterruptedException();
            }
            this.rethrowException();
            return (V)this.value;
        }

        public Object getResult(long timeout, TimeUnit units) throws InterruptedException {
            long endNano = System.nanoTime() + units.toNanos(timeout);
            while (!this.isSet) {
                long toWait = endNano - System.nanoTime();
                if (toWait <= 0L) {
                    return null;
                }
                LockSupport.parkNanos(toWait);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException();
            }
            this.rethrowException();
            return this.value;
        }

        private void rethrowException() {
            if (this.value instanceof Throwable) {
                if (this.value instanceof RuntimeException) {
                    throw (RuntimeException)this.value;
                }
                throw new RuntimeException((Throwable)this.value);
            }
        }

        public void onDeliveryError() {
            this.send(new IllegalStateException("Delivery error. Maybe target actor is not active"));
        }
    }
}

