/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars;

import groovyx.gpars.dataflow.DataFlowVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jsr166y.forkjoin.RecursiveAction;
import jsr166y.forkjoin.TaskBarrier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractForkJoinWorker<T>
extends RecursiveAction {
    private final DataFlowVariable<T> value = new DataFlowVariable();
    private TaskBarrier taskBarrier;
    private final TaskBarrier childTaskBarrier = new TaskBarrier(1);
    private final List<AbstractForkJoinWorker<T>> children = new ArrayList<AbstractForkJoinWorker<T>>();

    protected AbstractForkJoinWorker() {
    }

    final void setTaskBarrier(TaskBarrier taskBarrier) {
        if (taskBarrier == null) {
            return;
        }
        this.taskBarrier = taskBarrier;
        this.taskBarrier.register();
    }

    public final T getResult() throws InterruptedException {
        return this.value.getVal();
    }

    protected final void setResult(T value) {
        this.value.bind(value);
        this.taskBarrier.arriveAndDeregister();
    }

    protected final void awaitChildren() {
        this.childTaskBarrier.arriveAndAwait();
    }

    protected final void forkOffChild(AbstractForkJoinWorker<T> child) {
        this.children.add(child);
        assert (this.taskBarrier != null);
        child.setTaskBarrier(this.childTaskBarrier);
        child.fork();
    }

    protected final List<AbstractForkJoinWorker<T>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    protected final List<T> getChildrenResults() throws InterruptedException {
        this.awaitChildren();
        ArrayList<T> results = new ArrayList<T>();
        for (AbstractForkJoinWorker<T> worker : this.getChildren()) {
            results.add(worker.getResult());
        }
        return results;
    }
}

