/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.Environment;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.grails.commons.ArtefactHandlerAdapter;
import org.codehaus.groovy.grails.commons.ArtefactInfo;
import org.codehaus.groovy.grails.commons.DefaultGrailsControllerClass;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;

public class ControllerArtefactHandler
extends ArtefactHandlerAdapter {
    public static final String TYPE = "Controller";
    public static final String PLUGIN_NAME = "controllers";
    private ConcurrentHashMap<String, GrailsClass> uriToControllerClassCache;
    private ArtefactInfo artefactInfo;

    public ControllerArtefactHandler() {
        super(TYPE, GrailsControllerClass.class, DefaultGrailsControllerClass.class, TYPE, false);
    }

    public void initialize(ArtefactInfo artefacts) {
        this.uriToControllerClassCache = new ConcurrentHashMap();
        this.artefactInfo = artefacts;
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public GrailsClass getArtefactForFeature(Object feature) {
        if (this.artefactInfo == null) {
            return null;
        }
        String uri = feature.toString();
        GrailsClass controllerClass = this.uriToControllerClassCache.get(uri);
        if (controllerClass == null) {
            GrailsClass[] controllerClasses = this.artefactInfo.getGrailsClasses();
            for (int i = controllerClasses.length - 1; i >= 0; --i) {
                GrailsClass c = controllerClasses[i];
                if (!((GrailsControllerClass)c).mapsToURI(uri)) continue;
                controllerClass = c;
                break;
            }
            if (controllerClass != null && Environment.getCurrent() != Environment.DEVELOPMENT) {
                this.uriToControllerClassCache.putIfAbsent(uri, controllerClass);
            }
        }
        return controllerClass;
    }
}

