/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.util.Environment;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Writable;
import groovy.util.slurpersupport.GPathResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.DefaultGrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.spring.GrailsRuntimeConfigurator;
import org.codehaus.groovy.grails.support.MockApplicationContext;
import org.codehaus.groovy.grails.support.MockResourceLoader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsUtil {
    private static final Log LOG;
    private static final Log STACK_LOG;
    private static final String GRAILS_IMPLEMENTATION_TITLE = "Grails";
    private static final String GRAILS_VERSION;
    private static final String[] GRAILS_PACKAGES;

    public static ApplicationContext bootstrapGrailsFromClassPath() {
        LOG.info((Object)"Loading Grails environment");
        ClassPathXmlApplicationContext parent = new ClassPathXmlApplicationContext("applicationContext.xml");
        DefaultGrailsApplication application = (DefaultGrailsApplication)parent.getBean("grailsApplication", DefaultGrailsApplication.class);
        return GrailsUtil.createGrailsApplicationContext((ApplicationContext)parent, application);
    }

    private static ApplicationContext createGrailsApplicationContext(ApplicationContext parent, GrailsApplication application) {
        GrailsRuntimeConfigurator config = new GrailsRuntimeConfigurator(application, parent);
        MockServletContext servletContext = new MockServletContext((ResourceLoader)new MockResourceLoader());
        ConfigurableApplicationContext appCtx = (ConfigurableApplicationContext)config.configure((ServletContext)servletContext);
        servletContext.setAttribute("org.codehaus.groovy.grails.APPLICATION_CONTEXT", (Object)appCtx);
        Assert.notNull((Object)appCtx);
        return appCtx;
    }

    public static ApplicationContext bootstrapGrailsFromApplication(GrailsApplication application) {
        MockApplicationContext parent = new MockApplicationContext();
        parent.registerMockBean("grailsApplication", application);
        return GrailsUtil.createGrailsApplicationContext((ApplicationContext)parent, application);
    }

    public static ApplicationContext bootstrapGrailsFromParentContext(ApplicationContext parent) {
        DefaultGrailsApplication application = (DefaultGrailsApplication)parent.getBean("grailsApplication", DefaultGrailsApplication.class);
        return GrailsUtil.createGrailsApplicationContext(parent, application);
    }

    @Deprecated
    public static String getEnvironment() {
        return Environment.getCurrent().getName();
    }

    public static boolean isDevelopmentEnv() {
        return Environment.getCurrent().equals((Object)Environment.DEVELOPMENT);
    }

    public static String getGrailsVersion() {
        return GRAILS_VERSION;
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static void deprecated(Class<?> clazz, String methodOrPropName) {
        GrailsUtil.deprecated(clazz, methodOrPropName, GrailsUtil.getGrailsVersion());
    }

    public static void deprecated(Class<?> clazz, String methodOrPropName, String version) {
        GrailsUtil.deprecated("Property or method [" + methodOrPropName + "] of class [" + clazz.getName() + "] is deprecated in [" + version + "] and will be removed in future releases");
    }

    public static void deprecated(String message) {
        LOG.warn((Object)("[DEPRECATED] " + message));
    }

    public static void warn(String message) {
        LOG.warn((Object)("[WARNING] " + message));
    }

    public static Throwable sanitize(Throwable t) {
        if (!Boolean.valueOf(System.getProperty("grails.full.stacktrace")).booleanValue()) {
            StackTraceElement[] trace = t.getStackTrace();
            ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
            for (int i = 0; i < trace.length; ++i) {
                StackTraceElement stackTraceElement = trace[i];
                if (!GrailsUtil.isApplicationClass(stackTraceElement.getClassName())) continue;
                newTrace.add(stackTraceElement);
            }
            if (newTrace.size() > 0) {
                STACK_LOG.error((Object)"Sanitizing stacktrace:", t);
                StackTraceElement[] clean = new StackTraceElement[newTrace.size()];
                newTrace.toArray(clean);
                t.setStackTrace(clean);
            }
        }
        return t;
    }

    public static void printSanitizedStackTrace(Throwable t, PrintWriter p) {
        t = GrailsUtil.sanitize(t);
        StackTraceElement[] trace = t.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            StackTraceElement stackTraceElement = trace[i];
            p.println("at " + stackTraceElement.getClassName() + "(" + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber() + ")");
        }
    }

    public static void printSanitizedStackTrace(Throwable t) {
        GrailsUtil.printSanitizedStackTrace(t, new PrintWriter(System.err));
    }

    public static boolean isApplicationClass(String className) {
        for (int i = 0; i < GRAILS_PACKAGES.length; ++i) {
            String grailsPackage = GRAILS_PACKAGES[i];
            if (!className.startsWith(grailsPackage)) continue;
            return false;
        }
        return true;
    }

    public static Throwable extractRootCause(Throwable t) {
        Throwable result = t;
        while (result.getCause() != null) {
            result = result.getCause();
        }
        return result;
    }

    public static Throwable sanitizeRootCause(Throwable t) {
        return GrailsUtil.sanitize(GrailsUtil.extractRootCause(t));
    }

    public static Throwable deepSanitize(Throwable t) {
        Throwable current = t;
        while (current.getCause() != null) {
            current = GrailsUtil.sanitize(current.getCause());
        }
        return GrailsUtil.sanitize(t);
    }

    @Deprecated
    public static void writeSlurperResult(GPathResult result, Writer output) throws IOException {
        Binding b = new Binding();
        b.setVariable("node", (Object)result);
        Writable w = (Writable)new GroovyShell(b).evaluate("new groovy.xml.StreamingMarkupBuilder().bind { mkp.declareNamespace(\"\":  \"http://java.sun.com/xml/ns/j2ee\"); mkp.yield node}");
        w.writeTo(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String version;
        LOG = LogFactory.getLog(GrailsUtil.class);
        STACK_LOG = LogFactory.getLog((String)"StackTrace");
        GRAILS_PACKAGES = new String[]{"org.codehaus.groovy.grails.", "org.codehaus.groovy.runtime.", "org.codehaus.groovy.reflection.", "org.codehaus.groovy.ast.", "org.codehaus.gant.", "groovy.", "org.mortbay.", "org.apache.catalina.", "org.apache.coyote.", "org.apache.tomcat.", "sun.", "java.lang.reflect.", "org.springframework.", "com.opensymphony.", "org.hibernate.", "javax.servlet."};
        Package p = GrailsUtil.class.getPackage();
        String string = version = p != null ? p.getImplementationVersion() : null;
        if (version == null || GrailsUtil.isBlank(version)) {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            try {
                Resource[] manifests = resolver.getResources("classpath*:META-INF/MANIFEST.MF");
                Manifest grailsManifest = null;
                for (int i = 0; i < manifests.length; ++i) {
                    Resource r = manifests[i];
                    InputStream inputStream = null;
                    Manifest mf = null;
                    try {
                        inputStream = r.getInputStream();
                        mf = new Manifest(inputStream);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)inputStream);
                    }
                    String implTitle = mf.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    if (GrailsUtil.isBlank(implTitle) || !implTitle.equals(GRAILS_IMPLEMENTATION_TITLE)) continue;
                    grailsManifest = mf;
                    break;
                }
                if (grailsManifest != null) {
                    version = grailsManifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                }
                if (GrailsUtil.isBlank(version)) {
                    LOG.error((Object)"Unable to read Grails version from MANIFEST.MF. Are you sure the grails-core jar is on the classpath? ");
                    version = "Unknown";
                }
            }
            catch (Exception e) {
                version = "Unknown";
                LOG.error((Object)("Unable to read Grails version from MANIFEST.MF. Are you sure it the grails-core jar is on the classpath? " + e.getMessage()), (Throwable)e);
            }
        }
        GRAILS_VERSION = version;
    }
}

