/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.support.PersistenceContextInterceptor;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernatePersistenceContextInterceptor
implements PersistenceContextInterceptor {
    private static final Log LOG = LogFactory.getLog(HibernatePersistenceContextInterceptor.class);
    private SessionFactory sessionFactory;
    private boolean participate;

    public void destroy() {
        if (this.participate) {
            return;
        }
        SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        LOG.debug((Object)"Closing single Hibernate session in GrailsDispatcherServlet");
        try {
            Session session = holder.getSession();
            SessionFactoryUtils.closeSession((Session)session);
        }
        catch (RuntimeException ex) {
            LOG.error((Object)"Unexpected exception on closing Hibernate Session", (Throwable)ex);
        }
    }

    public void disconnect() {
        try {
            this.getSession(false).disconnect();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void reconnect() {
        this.getSession().reconnect();
    }

    public void flush() {
        this.getSession().flush();
    }

    public void clear() {
        this.getSession().clear();
    }

    public void setReadOnly() {
        this.getSession().setFlushMode(FlushMode.MANUAL);
    }

    public void setReadWrite() {
        this.getSession().setFlushMode(FlushMode.AUTO);
    }

    public boolean isOpen() {
        try {
            return this.getSession(false).isOpen();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public void init() {
        if (TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
            this.participate = true;
        } else {
            LOG.debug((Object)"Opening single Hibernate session in HibernatePersistenceContextInterceptor");
            Session session = this.getSession();
            session.setFlushMode(FlushMode.AUTO);
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)new SessionHolder(session));
        }
    }

    private Session getSession() {
        return this.getSession(true);
    }

    private Session getSession(boolean allowCreate) {
        return SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)allowCreate);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

