/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.proxy;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.codehaus.groovy.grails.support.proxy.ProxyHandler;
import org.hibernate.Hibernate;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class HibernateProxyHandler
implements ProxyHandler {
    public boolean isInitialized(Object o) {
        if (o instanceof HibernateProxy) {
            return !((HibernateProxy)o).getHibernateLazyInitializer().isUninitialized();
        }
        if (o instanceof PersistentCollection) {
            return ((PersistentCollection)o).wasInitialized();
        }
        return true;
    }

    public boolean isInitialized(Object obj, String associationName) {
        try {
            Object proxy = PropertyUtils.getProperty((Object)obj, (String)associationName);
            return Hibernate.isInitialized((Object)proxy);
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public Object unwrapIfProxy(Object instance) {
        if (instance instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)instance;
            return this.unwrapProxy(proxy);
        }
        if (instance instanceof AbstractPersistentCollection) {
            this.initialize(instance);
            return instance;
        }
        return instance;
    }

    public Object unwrapProxy(HibernateProxy proxy) {
        Object obj;
        LazyInitializer lazyInitializer = proxy.getHibernateLazyInitializer();
        if (lazyInitializer.isUninitialized()) {
            lazyInitializer.initialize();
        }
        if ((obj = lazyInitializer.getImplementation()) != null) {
            GrailsHibernateUtil.ensureCorrectGroovyMetaClass(obj, obj.getClass());
        }
        return obj;
    }

    public HibernateProxy getAssociationProxy(Object obj, String associationName) {
        try {
            Object proxy = PropertyUtils.getProperty((Object)obj, (String)associationName);
            if (proxy instanceof HibernateProxy) {
                return (HibernateProxy)proxy;
            }
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public boolean isProxy(Object o) {
        return o instanceof HibernateProxy || o instanceof AbstractPersistentCollection;
    }

    public void initialize(Object o) {
        AbstractPersistentCollection col;
        if (o instanceof HibernateProxy) {
            LazyInitializer hibernateLazyInitializer = ((HibernateProxy)o).getHibernateLazyInitializer();
            if (hibernateLazyInitializer.isUninitialized()) {
                hibernateLazyInitializer.initialize();
            }
        } else if (o instanceof AbstractPersistentCollection && !(col = (AbstractPersistentCollection)o).wasInitialized()) {
            col.forceInitialization();
        }
    }
}

