/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import grails.validation.ValidationException;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractDynamicPersistentMethod;
import org.codehaus.groovy.grails.validation.CascadingValidator;
import org.hibernate.SessionFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public abstract class AbstractSavePersistentMethod
extends AbstractDynamicPersistentMethod {
    private GrailsApplication application;
    private static final String ARGUMENT_VALIDATE = "validate";
    private static final String ARGUMENT_DEEP_VALIDATE = "deepValidate";
    private static final String ARGUMENT_FLUSH = "flush";
    private static final String ARGUMENT_INSERT = "insert";
    private static final String ARGUMENT_FAIL_ON_ERROR = "failOnError";
    private static final String FAIL_ON_ERROR_CONFIG_PROPERTY = "grails.gorm.failOnError";
    private static final String AUTO_FLUSH_CONFIG_PROPERTY = "grails.gorm.autoFlush";
    private static ThreadLocal<Object> disableAutoValidationFor = new ThreadLocal();
    private boolean shouldFail;

    public static boolean isAutoValidationDisabled(Object obj) {
        return obj != null && obj == disableAutoValidationFor.get();
    }

    public AbstractSavePersistentMethod(Pattern pattern, SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application, GrailsDomainClass domainClass) {
        super(pattern, sessionFactory, classLoader);
        Assert.notNull((Object)application, (String)"Constructor argument 'application' cannot be null");
        this.application = application;
        this.shouldFail = false;
        Map config = application.getConfig().flatten();
        if (config.containsKey(FAIL_ON_ERROR_CONFIG_PROPERTY)) {
            Object configProperty = config.get(FAIL_ON_ERROR_CONFIG_PROPERTY);
            if (configProperty instanceof Boolean) {
                this.shouldFail = Boolean.TRUE == configProperty;
            } else if (configProperty instanceof List && domainClass != null) {
                Class theClass = domainClass.getClazz();
                List packageList = (List)configProperty;
                this.shouldFail = GrailsClassUtils.isClassBelowPackage((Class)theClass, (List)packageList);
            }
        }
    }

    public AbstractSavePersistentMethod(Pattern pattern, SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application) {
        this(pattern, sessionFactory, classLoader, application, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doInvokeInternal(Object target, Object[] arguments) {
        GrailsDomainClass domainClass = (GrailsDomainClass)this.application.getArtefact("Domain", target.getClass().getName());
        boolean shouldFlush = this.shouldFlush(arguments);
        boolean shouldValidate = this.shouldValidate(arguments, domainClass);
        if (shouldValidate) {
            Validator validator = domainClass.getValidator();
            Errors errors = this.setupErrorsProperty(target);
            if (validator != null) {
                boolean deepValidate = true;
                Map argsMap = null;
                if (arguments.length > 0 && arguments[0] instanceof Map) {
                    argsMap = (Map)arguments[0];
                }
                if (argsMap != null && argsMap.containsKey(ARGUMENT_DEEP_VALIDATE)) {
                    deepValidate = GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_DEEP_VALIDATE, (Map)argsMap);
                }
                if (deepValidate && validator instanceof CascadingValidator) {
                    ((CascadingValidator)validator).validate(target, errors, deepValidate);
                } else {
                    validator.validate(target, errors);
                }
                if (errors.hasErrors()) {
                    this.handleValidationError(target, errors);
                    boolean shouldFail = this.shouldFail;
                    if (argsMap != null && argsMap.containsKey(ARGUMENT_FAIL_ON_ERROR)) {
                        shouldFail = GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_FAIL_ON_ERROR, (Map)argsMap);
                    }
                    if (shouldFail) {
                        throw new ValidationException("Validation Error(s) occurred during save()", errors);
                    }
                    return null;
                }
                this.setObjectToReadWrite(target);
            }
        } else {
            shouldFlush = true;
        }
        if (domainClass != null) {
            this.autoRetrieveAssocations(domainClass, target);
        }
        try {
            Object object;
            if (!shouldValidate) {
                disableAutoValidationFor.set(target);
            }
            if (this.shouldInsert(arguments)) {
                object = this.performInsert(target, shouldFlush);
                return object;
            }
            object = this.performSave(target, shouldFlush);
            return object;
        }
        finally {
            if (!shouldValidate) {
                disableAutoValidationFor.remove();
            }
        }
    }

    private boolean shouldInsert(Object[] arguments) {
        return arguments.length > 0 && arguments[0] instanceof Map && GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_INSERT, (Map)((Map)arguments[0]));
    }

    private boolean shouldFlush(Object[] arguments) {
        Map config;
        boolean shouldFlush = arguments.length > 0 && arguments[0] instanceof Boolean ? (Boolean)arguments[0] : (arguments.length > 0 && arguments[0] instanceof Map && ((Map)arguments[0]).containsKey(ARGUMENT_FLUSH) ? GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_FLUSH, (Map)((Map)arguments[0])) : Boolean.TRUE == (config = ConfigurationHolder.getFlatConfig()).get(AUTO_FLUSH_CONFIG_PROPERTY));
        return shouldFlush;
    }

    private void autoRetrieveAssocations(GrailsDomainClass domainClass, Object target) {
        BeanWrapperImpl bean = new BeanWrapperImpl(target);
        HibernateTemplate t = this.getHibernateTemplate();
        GrailsDomainClassProperty[] props = domainClass.getPersistentProperties();
        for (int i = 0; i < props.length; ++i) {
            GrailsDomainClass otherSide;
            Object propValue;
            GrailsDomainClassProperty prop = props[i];
            if (!prop.isManyToOne() && !prop.isOneToOne() || (propValue = bean.getPropertyValue(prop.getName())) == null || t.contains(propValue) || (otherSide = (GrailsDomainClass)this.application.getArtefact("Domain", prop.getType().getName())) == null) continue;
            BeanWrapperImpl propBean = new BeanWrapperImpl(propValue);
            try {
                Object propVal;
                Serializable id = (Serializable)propBean.getPropertyValue(otherSide.getIdentifier().getName());
                if (id == null || (propVal = t.get(prop.getType(), id)) == null) continue;
                bean.setPropertyValue(prop.getName(), propVal);
                continue;
            }
            catch (InvalidPropertyException ipe) {
                // empty catch block
            }
        }
    }

    protected Object handleValidationError(Object target, Errors errors) {
        this.setObjectToReadOnly(target);
        this.setErrorsOnInstance(target, errors);
        return null;
    }

    protected void setErrorsOnInstance(Object target, Errors errors) {
        if (target instanceof GroovyObject) {
            ((GroovyObject)target).setProperty("errors", (Object)errors);
        } else {
            MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
            metaClass.setProperty(target.getClass(), target, "errors", (Object)errors, false, false);
        }
    }

    private boolean shouldValidate(Object[] arguments, GrailsDomainClass domainClass) {
        if (domainClass == null) {
            return false;
        }
        if (arguments.length == 0) {
            return true;
        }
        if (arguments[0] instanceof Boolean) {
            return (Boolean)arguments[0];
        }
        if (arguments[0] instanceof Map) {
            Map argsMap = (Map)arguments[0];
            if (argsMap.containsKey(ARGUMENT_VALIDATE)) {
                return GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_VALIDATE, (Map)argsMap);
            }
            return true;
        }
        return true;
    }

    protected abstract Object performSave(Object var1, boolean var2);

    protected abstract Object performInsert(Object var1, boolean var2);
}

