/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.portlet;

import java.util.Iterator;
import javax.portlet.PortletRequest;
import org.springframework.binding.collection.CompositeIterator;
import org.springframework.binding.collection.StringKeyedMapAdapter;
import org.springframework.util.Assert;
import org.springframework.web.portlet.multipart.MultipartActionRequest;
import org.springframework.webflow.core.collection.CollectionUtils;

public class PortletRequestParameterMap
extends StringKeyedMapAdapter {
    private PortletRequest request;

    public PortletRequestParameterMap(PortletRequest request) {
        Assert.notNull((Object)request, (String)"The portlet request is required");
        this.request = request;
    }

    protected Object getAttribute(String key) {
        MultipartActionRequest multipartRequest;
        Object data;
        if (this.request instanceof MultipartActionRequest && (data = (multipartRequest = (MultipartActionRequest)this.request).getFileMap().get(key)) != null) {
            return data;
        }
        String[] parameters = this.request.getParameterValues(key);
        if (parameters == null) {
            return null;
        }
        if (parameters.length == 1) {
            return parameters[0];
        }
        return parameters;
    }

    protected void setAttribute(String key, Object value) {
        throw new UnsupportedOperationException("PortletRequest parameter maps are immutable");
    }

    protected void removeAttribute(String key) {
        throw new UnsupportedOperationException("PortletRequest parameter maps are immutable");
    }

    protected Iterator getAttributeNames() {
        if (this.request instanceof MultipartActionRequest) {
            MultipartActionRequest multipartRequest = (MultipartActionRequest)this.request;
            CompositeIterator iterator = new CompositeIterator();
            iterator.add(multipartRequest.getFileMap().keySet().iterator());
            iterator.add(CollectionUtils.toIterator(this.request.getParameterNames()));
            return iterator;
        }
        return CollectionUtils.toIterator(this.request.getParameterNames());
    }
}

