/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.Altitude;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.RecentFile;
import tim.prune.data.TrackInfo;
import tim.prune.gui.DialogCloser;
import tim.prune.load.GenericFileFilter;
import tim.prune.save.PointTypeSelector;
import tim.prune.save.xml.GpxCacherList;
import tim.prune.save.xml.XmlUtils;

public class GpxExporter
extends GenericFunction
implements Runnable {
    private TrackInfo _trackInfo = null;
    private JDialog _dialog = null;
    private JTextField _nameField = null;
    private JTextField _descriptionField = null;
    private PointTypeSelector _pointTypeSelector = null;
    private JCheckBox _timestampsCheckbox = null;
    private JCheckBox _copySourceCheckbox = null;
    private JPanel _encodingsPanel = null;
    private JRadioButton _useSystemRadio = null;
    private JRadioButton _forceUtf8Radio = null;
    private File _exportFile = null;
    private static String _systemEncoding = null;
    private static final String GPX_CREATOR = "GpsPrune v14 activityworkshop.net";

    public GpxExporter(App app) {
        super(app);
        this._trackInfo = app.getTrackInfo();
    }

    public String getNameKey() {
        return "function.exportgpx";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            _systemEncoding = GpxExporter.getSystemEncoding();
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._pointTypeSelector.init(this._app.getTrackInfo());
        this._encodingsPanel.setVisible(!GpxExporter.isSystemUtf8());
        if (!GpxExporter.isSystemUtf8()) {
            this._useSystemRadio.setText(String.valueOf(I18nManager.getText("dialog.exportgpx.encoding.system")) + " (" + (_systemEncoding == null ? "unknown" : _systemEncoding) + ")");
        }
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        Serializable serializable;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 2));
        jPanel4.add(new JLabel(I18nManager.getText("dialog.exportgpx.name")));
        this._nameField = new JTextField(10);
        jPanel4.add(this._nameField);
        jPanel4.add(new JLabel(I18nManager.getText("dialog.exportgpx.desc")));
        this._descriptionField = new JTextField(10);
        jPanel4.add(this._descriptionField);
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createVerticalStrut(5));
        this._pointTypeSelector = new PointTypeSelector();
        jPanel3.add(this._pointTypeSelector);
        JPanel jPanel5 = new JPanel();
        this._timestampsCheckbox = new JCheckBox(I18nManager.getText("dialog.exportgpx.includetimestamps"));
        this._timestampsCheckbox.setSelected(true);
        jPanel5.add(this._timestampsCheckbox);
        this._copySourceCheckbox = new JCheckBox(I18nManager.getText("dialog.exportgpx.copysource"));
        this._copySourceCheckbox.setSelected(true);
        jPanel5.add(this._copySourceCheckbox);
        jPanel3.add(jPanel5);
        this._encodingsPanel = new JPanel();
        if (!GpxExporter.isSystemUtf8()) {
            this._encodingsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            this._encodingsPanel.setLayout(new BorderLayout());
            this._encodingsPanel.add((Component)new JLabel(I18nManager.getText("dialog.exportgpx.encoding")), "North");
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout());
            serializable = new ButtonGroup();
            this._useSystemRadio = new JRadioButton(I18nManager.getText("dialog.exportgpx.encoding.system"));
            this._forceUtf8Radio = new JRadioButton(I18nManager.getText("dialog.exportgpx.encoding.utf8"));
            ((ButtonGroup)serializable).add(this._useSystemRadio);
            ((ButtonGroup)serializable).add(this._forceUtf8Radio);
            jPanel.add(this._useSystemRadio);
            jPanel.add(this._forceUtf8Radio);
            this._useSystemRadio.setSelected(true);
            this._encodingsPanel.add((Component)jPanel, "Center");
            jPanel3.add(this._encodingsPanel);
        }
        jPanel2.add((Component)jPanel3, "Center");
        this._nameField.addKeyListener(new DialogCloser(this._dialog));
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        serializable = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GpxExporter.this.startExport();
            }
        };
        ((AbstractButton)serializable).addActionListener(actionListener);
        this._descriptionField.addActionListener(actionListener);
        jPanel.add((Component)serializable);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GpxExporter.this._dialog.dispose();
            }
        });
        jPanel.add(jButton);
        jPanel2.add((Component)jPanel, "South");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel2;
    }

    private void startExport() {
        if (!this._pointTypeSelector.getAnythingSelected()) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.save.notypesselected"), I18nManager.getText("dialog.saveoptions.title"), 2);
            return;
        }
        File file = GpxExporter.chooseGpxFile(this._parentFrame);
        if (file != null) {
            this._exportFile = file;
            new Thread(this).start();
        }
    }

    public static File chooseGpxFile(JFrame jFrame) {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setFileFilter(new GenericFileFilter("filetype.gpx", new String[]{"gpx"}));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        String string = Config.getConfigString("prune.trackdirectory");
        if (string != null) {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        boolean bl = false;
        do {
            bl = false;
            if (jFileChooser.showSaveDialog(jFrame) != 0) continue;
            File file2 = jFileChooser.getSelectedFile();
            if (!file2.getName().toLowerCase().endsWith(".gpx")) {
                file2 = new File(String.valueOf(file2.getAbsolutePath()) + ".gpx");
            }
            Object[] objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file2.exists() || JOptionPane.showOptionDialog(jFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                file = file2;
                continue;
            }
            bl = true;
        } while (bl);
        return file;
    }

    public void run() {
        GpxCacherList gpxCacherList = null;
        if (this._copySourceCheckbox.isSelected()) {
            gpxCacherList = new GpxCacherList(this._trackInfo.getFileInfo());
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = this._forceUtf8Radio != null && this._forceUtf8Radio.isSelected() ? new OutputStreamWriter((OutputStream)new FileOutputStream(this._exportFile), "UTF-8") : new OutputStreamWriter(new FileOutputStream(this._exportFile));
            boolean[] blArray = new boolean[]{this._pointTypeSelector.getTrackpointsSelected(), this._pointTypeSelector.getWaypointsSelected(), this._pointTypeSelector.getPhotopointsSelected(), this._pointTypeSelector.getAudiopointsSelected(), this._pointTypeSelector.getJustSelection(), this._timestampsCheckbox.isSelected()};
            int n = GpxExporter.exportData(outputStreamWriter, this._trackInfo, this._nameField.getText(), this._descriptionField.getText(), blArray, gpxCacherList);
            outputStreamWriter.close();
            Config.setConfigString("prune.trackdirectory", this._exportFile.getParentFile().getAbsolutePath());
            Config.getRecentFileList().addFile(new RecentFile(this._exportFile, true));
            UpdateMessageBroker.informSubscribers();
            UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("confirm.save.ok1")) + " " + n + " " + I18nManager.getText("confirm.save.ok2") + " " + this._exportFile.getAbsolutePath());
            this._dialog.dispose();
            return;
        }
        catch (IOException iOException) {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException2) {}
            JOptionPane.showMessageDialog(this._parentFrame, String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage(), I18nManager.getText("error.save.dialogtitle"), 0);
            this.startExport();
            return;
        }
    }

    public static int exportData(OutputStreamWriter outputStreamWriter, TrackInfo trackInfo, String string, String string2, boolean[] blArray, GpxCacherList gpxCacherList) throws IOException {
        String string3;
        outputStreamWriter.write(GpxExporter.getXmlHeaderString(outputStreamWriter));
        String string4 = GpxExporter.getGpxHeaderString(gpxCacherList);
        boolean bl = string4.toUpperCase().indexOf("GPX/1/1") > 0;
        outputStreamWriter.write(string4);
        String string5 = string != null && !string.equals("") ? string : "GpsPruneTrack";
        GpxExporter.writeNameAndDescription(outputStreamWriter, string, string2, bl);
        int n = 0;
        DataPoint dataPoint = null;
        boolean bl2 = blArray[0];
        boolean bl3 = blArray[1];
        boolean bl4 = blArray[2];
        boolean bl5 = blArray[3];
        boolean bl6 = blArray[4];
        boolean bl7 = blArray[5];
        int n2 = -1;
        int n3 = -1;
        if (bl6) {
            n2 = trackInfo.getSelection().getStart();
            n3 = trackInfo.getSelection().getEnd();
        }
        int n4 = trackInfo.getTrack().getNumPoints();
        int n5 = 0;
        n = 0;
        while (n < n4) {
            dataPoint = trackInfo.getTrack().getPoint(n);
            if ((!bl6 || n >= n2 && n <= n3) && dataPoint.isWaypoint() && bl3) {
                String string6 = string3 = gpxCacherList == null ? null : GpxExporter.getPointSource(gpxCacherList, dataPoint);
                if (string3 != null) {
                    if (!bl7) {
                        string3 = GpxExporter.stripTime(string3);
                    }
                    outputStreamWriter.write(string3);
                    outputStreamWriter.write(10);
                } else {
                    GpxExporter.exportWaypoint(dataPoint, outputStreamWriter, bl7, bl4, bl5);
                }
                ++n5;
            }
            ++n;
        }
        if (bl2 || bl4 || bl5) {
            n5 += GpxExporter.writeTrackPoints(outputStreamWriter, trackInfo, bl6, bl2, bl4, bl5, bl7, true, gpxCacherList, "<rtept", "\t<rte><number>1</number>\n", null, "\t</rte>\n");
            string3 = "\t<trk><name>" + string5 + "</name><number>1</number><trkseg>\n";
            n5 += GpxExporter.writeTrackPoints(outputStreamWriter, trackInfo, bl6, bl2, bl4, bl5, bl7, false, gpxCacherList, "<trkpt", string3, "\t</trkseg>\n\t<trkseg>\n", "\t</trkseg></trk>\n");
        }
        outputStreamWriter.write("</gpx>\n");
        return n5;
    }

    private static void writeNameAndDescription(OutputStreamWriter outputStreamWriter, String string, String string2, boolean bl) throws IOException {
        String string3;
        String string4 = string3 = string2 != null && !string2.equals("") ? string2 : "Export from GpsPrune";
        if (bl) {
            outputStreamWriter.write("\t<metadata>\n");
        }
        if (string != null && !string.equals("")) {
            outputStreamWriter.write("\t\t<name>");
            outputStreamWriter.write(string);
            outputStreamWriter.write("</name>\n");
        }
        outputStreamWriter.write("\t\t<desc>");
        outputStreamWriter.write(string3);
        outputStreamWriter.write("</desc>\n");
        if (bl) {
            outputStreamWriter.write("\t</metadata>\n");
        }
    }

    private static int writeTrackPoints(OutputStreamWriter outputStreamWriter, TrackInfo trackInfo, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, GpxCacherList gpxCacherList, String string, String string2, String string3, String string4) throws IOException {
        int n = trackInfo.getTrack().getNumPoints();
        int n2 = trackInfo.getSelection().getStart();
        int n3 = trackInfo.getSelection().getEnd();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            DataPoint dataPoint = trackInfo.getTrack().getPoint(n5);
            if ((!bl || n5 >= n2 && n5 <= n3) && !dataPoint.isWaypoint() && (dataPoint.getPhoto() == null && bl2 || dataPoint.getPhoto() != null && bl3 || dataPoint.getAudio() != null && bl4)) {
                String string5 = GpxExporter.getPointSource(gpxCacherList, dataPoint);
                if (string5 != null && !string5.toLowerCase().startsWith(string)) {
                    string5 = null;
                }
                if (string5 != null || !bl6) {
                    if (n4 > 0 && dataPoint.getSegmentStart() && string3 != null) {
                        outputStreamWriter.write(string3);
                    }
                    if (n4 == 0) {
                        outputStreamWriter.write(string2);
                    }
                    if (string5 != null) {
                        if (!bl5) {
                            string5 = GpxExporter.stripTime(string5);
                        }
                        outputStreamWriter.write(string5);
                        outputStreamWriter.write(10);
                    } else if (!bl6) {
                        GpxExporter.exportTrackpoint(dataPoint, outputStreamWriter, bl5, bl3, bl4);
                    }
                    ++n4;
                }
            }
            ++n5;
        }
        if (n4 > 0) {
            outputStreamWriter.write(string4);
        }
        return n4;
    }

    private static String getPointSource(GpxCacherList gpxCacherList, DataPoint dataPoint) {
        if (gpxCacherList == null || dataPoint == null) {
            return null;
        }
        String string = gpxCacherList.getSourceString(dataPoint);
        if (string == null || !dataPoint.isModified()) {
            return string;
        }
        string = GpxExporter.replaceGpxTags(string, "lat=\"", "\"", dataPoint.getLatitude().output(17));
        string = GpxExporter.replaceGpxTags(string, "lon=\"", "\"", dataPoint.getLongitude().output(17));
        string = GpxExporter.replaceGpxTags(string, "<ele>", "</ele>", dataPoint.getAltitude().getStringValue(Altitude.Format.METRES));
        string = GpxExporter.replaceGpxTags(string, "<time>", "</time>", dataPoint.getTimestamp().getText(2));
        if (dataPoint.isWaypoint()) {
            string = GpxExporter.replaceGpxTags(string, "<name>", "</name>", dataPoint.getWaypointName());
            string = GpxExporter.replaceGpxTags(string, "<description>", "</description>", XmlUtils.fixCdata(dataPoint.getFieldValue(Field.DESCRIPTION)));
        }
        if (string != null && (dataPoint.hasMedia() || string.indexOf("</link>") > 0)) {
            string = GpxExporter.replaceMediaLinks(string, GpxExporter.makeMediaLink(dataPoint));
        }
        return string;
    }

    private static String replaceGpxTags(String string, String string2, String string3, String string4) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(string2);
        int n2 = string.indexOf(string3, n + string2.length());
        if (n > 0 && n2 > 0) {
            String string5 = string.substring(n + string2.length(), n2);
            if (string4 != null && string5.equals(string4)) {
                return string;
            }
            if (string4 == null || string4.equals("")) {
                return String.valueOf(string.substring(0, n)) + string.substring(n2 + string3.length());
            }
            return String.valueOf(string.substring(0, n + string2.length())) + string4 + string.substring(n2);
        }
        if (string4 == null || string4.equals("")) {
            return string;
        }
        return null;
    }

    private static String replaceMediaLinks(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("<link");
        int n2 = string.lastIndexOf("</link>");
        if (n > 0 && n2 > 0) {
            String string3 = string.substring(n, n2 + "</link>".length());
            if (string2 != null && string3.equals(string2)) {
                return string;
            }
            if (string2 == null || string2.equals("")) {
                return String.valueOf(string.substring(0, n)) + string.substring(n2 + "</link>".length());
            }
            return String.valueOf(string.substring(0, n)) + string2 + string.substring(n2 + "</link>".length());
        }
        if (string2 == null || string2.equals("")) {
            return string;
        }
        return null;
    }

    private static String getXmlHeaderString(OutputStreamWriter outputStreamWriter) {
        return "<?xml version=\"1.0\" encoding=\"" + GpxExporter.getEncoding(outputStreamWriter) + "\"?>\n";
    }

    private static String getEncoding(OutputStreamWriter outputStreamWriter) {
        String string = outputStreamWriter.getEncoding();
        try {
            string = Charset.forName(string).name();
        }
        catch (Exception exception) {}
        return string;
    }

    private static String getSystemEncoding() {
        File file = null;
        String string = null;
        try {
            file = File.createTempFile("prune", null);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
            string = GpxExporter.getEncoding(outputStreamWriter);
            outputStreamWriter.close();
        }
        catch (IOException iOException) {}
        if (file != null && file.exists() && !file.delete()) {
            System.err.println("Cannot delete temp file: " + file.getAbsolutePath());
        }
        if (string == null) {
            string = Charset.defaultCharset().name();
        }
        return string;
    }

    private static boolean isSystemUtf8() {
        if (_systemEncoding == null) {
            _systemEncoding = GpxExporter.getSystemEncoding();
        }
        return _systemEncoding != null && _systemEncoding.toUpperCase().equals("UTF-8");
    }

    private static String getGpxHeaderString(GpxCacherList gpxCacherList) {
        String string = null;
        if (gpxCacherList != null) {
            string = gpxCacherList.getFirstHeader();
        }
        if (string == null || string.length() < 5) {
            string = "<gpx version=\"1.0\" creator=\"GpsPrune v14 activityworkshop.net\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns=\"http://www.topografix.com/GPX/1/0\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/0 http://www.topografix.com/GPX/1/0/gpx.xsd\">\n";
        }
        return String.valueOf(string) + "\n";
    }

    private static void exportWaypoint(DataPoint dataPoint, Writer writer, boolean bl, boolean bl2, boolean bl3) throws IOException {
        String string;
        writer.write("\t<wpt lat=\"");
        writer.write(dataPoint.getLatitude().output(17));
        writer.write("\" lon=\"");
        writer.write(dataPoint.getLongitude().output(17));
        writer.write("\">\n");
        if (dataPoint.hasAltitude()) {
            writer.write("\t\t<ele>");
            writer.write(dataPoint.getAltitude().getStringValue(Altitude.Format.METRES));
            writer.write("</ele>\n");
        }
        if (dataPoint.hasTimestamp() && bl) {
            writer.write("\t\t<time>");
            writer.write(dataPoint.getTimestamp().getText(2));
            writer.write("</time>\n");
        }
        writer.write("\t\t<name>");
        writer.write(dataPoint.getWaypointName().trim());
        writer.write("</name>\n");
        String string2 = XmlUtils.fixCdata(dataPoint.getFieldValue(Field.DESCRIPTION));
        if (string2 != null && !string2.equals("")) {
            writer.write("\t\t<description>");
            writer.write(string2);
            writer.write("</description>\n");
        }
        if (bl2 && dataPoint.getPhoto() != null) {
            writer.write("\t\t");
            writer.write(GpxExporter.makeMediaLink(dataPoint.getPhoto()));
            writer.write(10);
        }
        if (bl3 && dataPoint.getAudio() != null) {
            writer.write("\t\t");
            writer.write(GpxExporter.makeMediaLink(dataPoint.getAudio()));
            writer.write(10);
        }
        if ((string = dataPoint.getFieldValue(Field.WAYPT_TYPE)) != null && !(string = string.trim()).equals("")) {
            writer.write("\t\t<type>");
            writer.write(string);
            writer.write("</type>\n");
        }
        writer.write("\t</wpt>\n");
    }

    private static void exportTrackpoint(DataPoint dataPoint, Writer writer, boolean bl, boolean bl2, boolean bl3) throws IOException {
        writer.write("\t\t<trkpt lat=\"");
        writer.write(dataPoint.getLatitude().output(17));
        writer.write("\" lon=\"");
        writer.write(dataPoint.getLongitude().output(17));
        writer.write("\">");
        if (dataPoint.hasAltitude()) {
            writer.write("<ele>");
            writer.write(dataPoint.getAltitude().getStringValue(Altitude.Format.METRES));
            writer.write("</ele>");
        }
        if (dataPoint.hasTimestamp() && bl) {
            writer.write("<time>");
            writer.write(dataPoint.getTimestamp().getText(2));
            writer.write("</time>");
        }
        if (dataPoint.getPhoto() != null && bl2) {
            writer.write(GpxExporter.makeMediaLink(dataPoint.getPhoto()));
        }
        if (dataPoint.getAudio() != null && bl3) {
            writer.write(GpxExporter.makeMediaLink(dataPoint.getAudio()));
        }
        writer.write("</trkpt>\n");
    }

    private static String makeMediaLink(DataPoint dataPoint) {
        Photo photo = dataPoint.getPhoto();
        AudioClip audioClip = dataPoint.getAudio();
        if (photo == null && audioClip == null) {
            return null;
        }
        String string = "";
        if (photo != null) {
            string = GpxExporter.makeMediaLink(photo);
        }
        if (audioClip != null) {
            string = String.valueOf(string) + GpxExporter.makeMediaLink(audioClip);
        }
        return string;
    }

    private static String makeMediaLink(MediaObject mediaObject) {
        if (mediaObject.getFile() != null) {
            return "<link href=\"" + mediaObject.getFile().getAbsolutePath() + "\"><text>" + mediaObject.getName() + "</text></link>";
        }
        if (mediaObject.getUrl() != null) {
            return "<link href=\"" + mediaObject.getUrl() + "\"><text>" + mediaObject.getName() + "</text></link>";
        }
        return "";
    }

    private static String stripTime(String string) {
        return string.replaceAll("<time>.*?</time>", "");
    }
}

