/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.xml;

import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import tim.prune.data.Field;
import tim.prune.load.xml.XmlHandler;

public class KmlHandler
extends XmlHandler {
    private boolean _insideCoordinates = false;
    private String _value = null;
    private String _name = null;
    private String _desc = null;
    private String _imgLink = null;
    private StringBuffer _coordinates = null;
    private ArrayList<String> _coordinateList = null;
    private ArrayList<String[]> _pointList = new ArrayList();
    private ArrayList<String> _linkList = new ArrayList();
    private ArrayList<String> _whenList = new ArrayList();
    private ArrayList<String> _whereList = new ArrayList();

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if (string4 == null || string4.equals("")) {
            string4 = string3;
        }
        if (string4.equalsIgnoreCase("Placemark")) {
            this._coordinateList = new ArrayList();
        } else if (string4.equalsIgnoreCase("coordinates")) {
            this._insideCoordinates = true;
            this._coordinates = null;
        }
        this._value = null;
        super.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string2;
        if (string4 == null || string4.equals("")) {
            string4 = string3;
        }
        if (string4.equalsIgnoreCase("Placemark")) {
            this.processPlacemark();
            this._imgLink = null;
            this._desc = null;
            this._name = null;
        } else if (string4.equalsIgnoreCase("coordinates")) {
            this._insideCoordinates = false;
            if (this._coordinates != null) {
                this._coordinateList.add(this._coordinates.toString().trim());
            }
        } else if (string4.equalsIgnoreCase("name")) {
            this._name = this._value;
        } else if (string4.equalsIgnoreCase("description")) {
            this._desc = this._value;
            this._imgLink = KmlHandler.getImgLink(this._desc);
        } else if (string4.equalsIgnoreCase("when")) {
            this._whenList.add(this._value);
        } else if (string4.equalsIgnoreCase("gx:coord")) {
            this._whereList.add(this._value);
        } else if (string4.equalsIgnoreCase("gx:Track")) {
            this.processGxTrack();
        }
        super.endElement(string, string2, string3);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this._insideCoordinates) {
            if (this._coordinates == null) {
                this._coordinates = new StringBuffer();
            }
            this._coordinates.append(string);
        } else {
            this._value = this._value == null ? string : String.valueOf(this._value) + string;
        }
        super.characters(cArray, n, n2);
    }

    private void processPlacemark() {
        if (this._coordinateList == null || this._coordinateList.isEmpty()) {
            return;
        }
        boolean bl = this._coordinateList.size() == 1;
        for (String string : this._coordinateList) {
            String[] stringArray = string.split("[ \n]");
            int n = stringArray.length;
            if (n == 1) {
                String string2 = bl ? this._name : null;
                this._pointList.add(KmlHandler.makeStringArray(string, string2, this._desc));
                this._linkList.add(this._imgLink);
                continue;
            }
            if (n <= 1) continue;
            boolean bl2 = true;
            int n2 = 0;
            while (n2 < n) {
                if (stringArray[n2] != null && stringArray[n2].trim().length() > 3) {
                    String[] stringArray2 = KmlHandler.makeStringArray(stringArray[n2], null, null);
                    if (bl2) {
                        stringArray2[5] = "1";
                    }
                    bl2 = false;
                    this._pointList.add(stringArray2);
                }
                this._linkList.add(null);
                ++n2;
            }
        }
    }

    private void processGxTrack() {
        if (this._whenList.size() > 0 && this._whenList.size() == this._whereList.size()) {
            boolean bl = true;
            int n = this._whenList.size();
            int n2 = 0;
            while (n2 < n) {
                String[] stringArray;
                String string = this._whenList.get(n2);
                String string2 = this._whereList.get(n2);
                if (string2 != null && (stringArray = string2.split(" ")).length == 3) {
                    String[] stringArray2 = new String[7];
                    stringArray2[0] = stringArray[0];
                    stringArray2[1] = stringArray[1];
                    stringArray2[2] = stringArray[2];
                    if (bl) {
                        stringArray2[5] = "1";
                    }
                    bl = false;
                    stringArray2[6] = string;
                    this._pointList.add(stringArray2);
                }
                this._linkList.add(null);
                ++n2;
            }
        }
        this._whenList.clear();
        this._whereList.clear();
    }

    private static String getImgLink(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        int n = string.indexOf("<img");
        int n2 = string.indexOf(62, n + 10);
        if (n < 0 || n2 < 0) {
            return null;
        }
        String string2 = string.substring(n + 4, n2);
        int n3 = string2.toLowerCase().indexOf("src=");
        if (n3 < 0) {
            return null;
        }
        char c = string2.charAt(n3 + 4);
        int n4 = string2.indexOf(c, n3 + 7);
        if (n4 < 0) {
            return null;
        }
        return string2.substring(n3 + 5, n4);
    }

    private static String[] makeStringArray(String string, String string2, String string3) {
        String[] stringArray = new String[7];
        String[] stringArray2 = string.split(",");
        int n = stringArray2.length;
        if (n == 3 || n == 2) {
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
        }
        stringArray[3] = string2;
        stringArray[4] = string3;
        return stringArray;
    }

    public Field[] getFieldArray() {
        Field[] fieldArray = new Field[]{Field.LONGITUDE, Field.LATITUDE, Field.ALTITUDE, Field.WAYPT_NAME, Field.DESCRIPTION, Field.NEW_SEGMENT, Field.TIMESTAMP};
        return fieldArray;
    }

    public String[][] getDataArray() {
        int n = this._pointList.size();
        String[][] stringArray = new String[n][];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this._pointList.get(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getLinkArray() {
        int n = this._linkList.size();
        boolean bl = false;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this._linkList.get(n2);
            if (stringArray[n2] != null) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            stringArray = null;
        }
        return stringArray;
    }
}

