/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.util.ArrayList;
import tim.prune.config.Config;
import tim.prune.gui.map.CloudmadeMapSource;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.MffMapSource;
import tim.prune.gui.map.OsmMapSource;

public abstract class MapSourceLibrary {
    private static ArrayList<MapSource> _sourceList = null;
    private static int _numFixedSources = 0;

    static {
        _sourceList = new ArrayList();
        MapSourceLibrary.addFixedSources();
        _numFixedSources = _sourceList.size();
        MapSourceLibrary.addConfigSources();
    }

    private MapSourceLibrary() {
    }

    public static int getNumFixedSources() {
        return _numFixedSources;
    }

    private static void addFixedSources() {
        _sourceList.add(new OsmMapSource("Mapnik", "http://[abc].tile.openstreetmap.org/"));
        _sourceList.add(new OsmMapSource("Cyclemap", "http://[abc].tile.opencyclemap.org/cycle/"));
        _sourceList.add(new OsmMapSource("Reitkarte", "http://wanderreitkarte.de/hills/", "http://topo2.wanderreitkarte.de/topo/", 18));
        _sourceList.add(new MffMapSource("Mapsforfree", "http://maps-for-free.com/layer/relief/", "jpg", "http://maps-for-free.com/layer/water/", "gif", 11));
        _sourceList.add(new OsmMapSource("Hikebikemap", "http://toolserver.org/tiles/hikebike/", "http://toolserver.org/~cmarqu/hill/", 18));
        _sourceList.add(new OsmMapSource("Openseamap", "http://tile.openstreetmap.org/", "http://tiles.openseamap.org/seamark/", 18));
        _sourceList.add(new CloudmadeMapSource("Pale Dawn", "998", 18));
    }

    private static void addConfigSources() {
        String string = Config.getConfigString("prune.mapsourcelist");
        if (string != null && string.length() > 10) {
            int n = string.indexOf(124);
            while (n > 0) {
                String string2 = string.substring(0, n);
                OsmMapSource osmMapSource = OsmMapSource.fromConfig(string2);
                if (osmMapSource == null) {
                    osmMapSource = CloudmadeMapSource.fromConfig(string2);
                }
                if (osmMapSource != null) {
                    _sourceList.add(osmMapSource);
                }
                string = string.substring(n + 1);
                n = string.indexOf(124);
            }
        }
    }

    public static int getNumSources() {
        return _sourceList.size();
    }

    public static void addSource(MapSource mapSource) {
        _sourceList.add(mapSource);
    }

    public static void editSource(MapSource mapSource, MapSource mapSource2) {
        int n = _sourceList.indexOf(mapSource);
        if (n < 0) {
            MapSourceLibrary.addSource(mapSource2);
        } else {
            _sourceList.set(n, mapSource2);
        }
    }

    public static MapSource getSource(int n) {
        if (n < 0 || n >= _sourceList.size()) {
            return null;
        }
        return _sourceList.get(n);
    }

    public static void deleteSource(int n) {
        if (n >= _numFixedSources) {
            _sourceList.remove(n);
        }
    }

    public static boolean hasSourceName(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase().trim();
        int n = 0;
        while (n < MapSourceLibrary.getNumSources()) {
            String string3 = MapSourceLibrary.getSource(n).getName().toLowerCase();
            if (string3.equals(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String getConfigString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = MapSourceLibrary.getNumFixedSources();
        while (n < MapSourceLibrary.getNumSources()) {
            stringBuilder.append(MapSourceLibrary.getSource(n).getConfigString()).append('|');
            ++n;
        }
        return stringBuilder.toString();
    }
}

