/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.distance;

import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Unit;
import tim.prune.function.distance.GenericTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistanceTableModel
extends GenericTableModel {
    private double[] _distances = null;
    private static final String _toColLabel = I18nManager.getText("dialog.distances.column.to");
    private String _distanceLabel = null;

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.getPointName(n);
        }
        if (this._distances == null) {
            return 0.0;
        }
        return new Double(this._distances[n]);
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return _toColLabel;
        }
        return this._distanceLabel;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        return Double.class;
    }

    public void recalculate(int n) {
        Unit unit = Config.getUnitSet().getDistanceUnit();
        this._distanceLabel = String.valueOf(I18nManager.getText("fieldname.distance")) + " (" + I18nManager.getText(unit.getShortnameKey()) + ")";
        int n2 = this.getRowCount();
        if (this._distances == null || this._distances.length != n2) {
            this._distances = new double[n2];
        }
        DataPoint dataPoint = (DataPoint)this._pointList.get(n);
        int n3 = 0;
        while (n3 < n2) {
            if (n3 == n) {
                this._distances[n3] = 0.0;
            } else {
                double d = DataPoint.calculateRadiansBetween(dataPoint, (DataPoint)this._pointList.get(n3));
                this._distances[n3] = Distance.convertRadiansToDistance(d);
            }
            ++n3;
        }
        this.fireTableStructureChanged();
    }
}

