/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.function.PhotoComparer;
import tim.prune.undo.UndoRearrangePhotos;

public class RearrangePhotosFunction
extends GenericFunction {
    private JDialog _dialog = null;
    private JRadioButton[] _positionRadios = null;
    private JRadioButton[] _sortRadios = null;

    public RearrangePhotosFunction(App app) {
        super(app);
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._dialog.setVisible(true);
    }

    public String getNameKey() {
        return "function.rearrangephotos";
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.rearrangephotos.desc")), "North");
        this._positionRadios = new JRadioButton[2];
        String[] stringArray = new String[]{"tostart", "toend"};
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        int n = 0;
        while (n < 2) {
            this._positionRadios[n] = new JRadioButton(I18nManager.getText("dialog.rearrangephotos." + stringArray[n]));
            buttonGroup.add(this._positionRadios[n]);
            jPanel2.add(this._positionRadios[n]);
            ++n;
        }
        this._positionRadios[0].setSelected(true);
        this._sortRadios = new JRadioButton[3];
        String[] stringArray2 = new String[]{"nosort", "sortbyfilename", "sortbytime"};
        ButtonGroup buttonGroup2 = new ButtonGroup();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1));
        int n2 = 0;
        while (n2 < 3) {
            this._sortRadios[n2] = new JRadioButton(I18nManager.getText("dialog.rearrangephotos." + stringArray2[n2]));
            buttonGroup2.add(this._sortRadios[n2]);
            jPanel3.add(this._sortRadios[n2]);
            ++n2;
        }
        this._sortRadios[0].setSelected(true);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        jPanel.add((Component)jPanel4, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RearrangePhotosFunction.this.finish();
                RearrangePhotosFunction.this._dialog.dispose();
            }
        });
        jPanel5.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RearrangePhotosFunction.this._dialog.dispose();
            }
        });
        jPanel5.add(jButton2);
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    private void finish() {
        Track track = this._app.getTrackInfo().getTrack();
        UndoRearrangePhotos undoRearrangePhotos = new UndoRearrangePhotos(track);
        int n = track.getNumPoints();
        DataPoint[] dataPointArray = new DataPoint[n];
        DataPoint[] dataPointArray2 = new DataPoint[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            DataPoint dataPoint = track.getPoint(n4);
            if (dataPoint.getPhoto() != null) {
                dataPointArray2[n3] = dataPoint;
                ++n3;
            } else {
                dataPointArray[n2] = dataPoint;
                ++n2;
            }
            ++n4;
        }
        if (!this._sortRadios[0].isSelected() && n3 > 1) {
            RearrangePhotosFunction.sortPhotos(dataPointArray2, this._sortRadios[1].isSelected());
        }
        DataPoint[] dataPointArray3 = new DataPoint[n];
        if (this._positionRadios[0].isSelected()) {
            System.arraycopy(dataPointArray2, 0, dataPointArray3, 0, n3);
            System.arraycopy(dataPointArray, 0, dataPointArray3, n3, n2);
        } else {
            System.arraycopy(dataPointArray, 0, dataPointArray3, 0, n2);
            System.arraycopy(dataPointArray2, 0, dataPointArray3, n2, n3);
        }
        if (track.replaceContents(dataPointArray3)) {
            this._app.getTrackInfo().getSelection().clearAll();
            this._app.completeFunction(undoRearrangePhotos, I18nManager.getText("confirm.rearrangephotos"));
        } else {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("error.rearrange.noop"), I18nManager.getText("error.function.noop.title"), 2);
        }
    }

    private static void sortPhotos(DataPoint[] dataPointArray, boolean bl) {
        PhotoComparer photoComparer = new PhotoComparer(bl ? PhotoComparer.SortMode.SORTBY_NAME : PhotoComparer.SortMode.SORTBY_TIME);
        Arrays.sort(dataPointArray, photoComparer);
    }
}

